#!/bin/sh
export PATH='/usr/lib/distcc/bin:/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
echo 'name: cprng-aes
version: 0.6.1
id: cprng-aes-0.6.1-GcaP9wURaXL7GyeygwRVK6
key: cprng-aes-0.6.1-GcaP9wURaXL7GyeygwRVK6
license: BSD3
copyright: Vincent Hanquez <vincent@snarc.org>
maintainer: Vincent Hanquez <vincent@snarc.org>
stability: experimental
homepage: http://github.com/vincenthz/hs-cprng-aes
synopsis: Crypto Pseudo Random Number Generator using AES in counter mode.
description:
    Simple crypto pseudo-random-number-generator with really good randomness property.
    .
    Using ent, a randomness property maker on one 1Mb sample:
    Entropy = 7.999837 bits per byte.
    Optimum compression would reduce the size of this 1048576 byte file by 0 percent.
    Chi square distribution for 1048576 samples is 237.02
    Arithmetic mean value of data bytes is 127.3422 (127.5 = random)
    Monte Carlo value for Pi is 3.143589568 (error 0.06 percent)
    .
    Compared to urandom with the same sampling:
    Entropy = 7.999831 bits per byte.
    Optimum compression would reduce the size of this 1048576 byte file by 0 percent.
    Chi square distribution for 1048576 samples is 246.63
    Arithmetic mean value of data bytes is 127.6347 (127.5 = random).
    Monte Carlo value for Pi is 3.132465868 (error 0.29 percent).
category: Cryptography
author: Vincent Hanquez <vincent@snarc.org>
exposed: True
exposed-modules:
    Crypto.Random.AESCtr
hidden-modules: Crypto.Random.AESCtr.Internal
abi: 67beccb1c170ebe49c74cc21d6042521
trusted: False
import-dirs: /usr/lib/ghc-8.0.1/site-local/cprng-aes-0.6.1
library-dirs: /usr/lib/ghc-8.0.1/site-local/cprng-aes-0.6.1
data-dir: /usr/share/arm-linux-ghc-8.0.1/cprng-aes-0.6.1
hs-libraries: HScprng-aes-0.6.1-GcaP9wURaXL7GyeygwRVK6
depends:
    base-4.9.0.0 byteable-0.1.1-15aIBCArSOBEnGxArzrDTM
    bytestring-0.10.8.1 cipher-aes-0.2.11-LLSBhLuxmvfL9DRWXRoxA9
    crypto-random-0.0.9-DWV3dcrdJbJH1ghEKFtuv9
haddock-interfaces: /usr/share/doc/haskell-cprng-aes/html/cprng-aes.haddock
haddock-html: /usr/share/doc/haskell-cprng-aes/html
' | '/usr/bin/ghc-pkg' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"
