/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.symmetry;

import java.util.Arrays;
import java.util.Hashtable;
import java.util.Map;
import javajs.util.Lst;
import javajs.util.Measure;
import javajs.util.P3;
import javajs.util.P4;
import javajs.util.PT;
import javajs.util.T3;
import javajs.util.V3;
import org.jmol.java.BS;
import org.jmol.util.BSUtil;
import org.jmol.util.Edge;
import org.jmol.util.Logger;
import org.jmol.util.Node;
import org.jmol.viewer.JC;

public class CIPChirality {
    static final int NO_CHIRALITY = 0;
    static final int TIED = 0;
    static final int B_WINS = 1;
    static final int A_WINS = -1;
    static final int DIASTEREOMERIC = Integer.MAX_VALUE;
    static final int IGNORE = Integer.MIN_VALUE;
    static final int NOT_RELEVANT = Integer.MIN_VALUE;
    static final int STEREO_SAME = Integer.MAX_VALUE;
    static final int STEREO_UNDETERMINED = -1;
    static final int STEREO_RS = -1;
    static final int STEREO_EZ = -2;
    static final int STEREO_ALLENE = -3;
    static final int STEREO_R = 1;
    static final int STEREO_S = 2;
    static final int STEREO_M = 33;
    static final int STEREO_P = 34;
    static final int STEREO_Z = 8;
    static final int STEREO_E = 16;
    static final int STEREO_BOTH_RS = 3;
    static final int STEREO_BOTH_EZ = 24;
    static final int RULE_1a = 1;
    static final int RULE_1b = 2;
    static final int RULE_2 = 3;
    static final int RULE_3 = 4;
    static final int RULE_4 = 5;
    static final int RULE_5 = 6;
    static final int PRIORITY_12_MASK = 0x7FFFF000;
    static final int PRIORITY_1b_MASK = 0xF00000;
    static final int[] PRIORITY_SHIFT = new int[]{-1, 24, 20, 12, 9, 6, 3, 0};
    static final float TRIGONALITY_MIN = 0.2f;
    int ptID;
    CIPAtom root;
    int currentRule = 1;
    Lst<BS> lstSmallRings = new Lst();
    int nPriorityMax;
    BS bsAtropisomeric;
    BS bsAromatic;
    BS bsAzacyclic;
    V3 vNorm = new V3();
    V3 vNorm2 = new V3();
    V3 vTemp = new V3();

    public String getRuleName() {
        switch (this.currentRule) {
            case 1: {
                return "1a";
            }
            case 2: {
                return "1b";
            }
        }
        return "" + (this.currentRule - 1);
    }

    private void init() {
        this.ptID = 0;
        this.nPriorityMax = 0;
        this.lstSmallRings.clear();
    }

    public void getChiralityForAtoms(Node[] atoms, BS bsAtoms, BS bsAtropisomeric) {
        if (bsAtoms.isEmpty()) {
            return;
        }
        this.bsAtropisomeric = bsAtropisomeric;
        this.init();
        BS bs = BSUtil.copy((BS)bsAtoms);
        while (!bs.isEmpty()) {
            this.getSmallRings(atoms[bs.nextSetBit(0)], bs);
        }
        this.bsAromatic = this.getAromaticity(atoms);
        this.bsAzacyclic = this.getAzacyclic(atoms, bsAtoms);
        BS bsToDo = BSUtil.copy((BS)bsAtoms);
        boolean haveAlkenes = this.preFilterAtomList(atoms, bsToDo);
        int i = bsToDo.nextSetBit(0);
        while (i >= 0) {
            Node atom = atoms[i];
            String c = atom.getCIPChirality(false);
            if (c.length() > 0) {
                bsToDo.clear(i);
            } else {
                this.ptID = 0;
                atom.setCIPChirality(this.getAtomChiralityLimited(atom, null, null, 4));
            }
            i = bsToDo.nextSetBit(i + 1);
        }
        Lst lstEZ = new Lst();
        if (haveAlkenes) {
            int i2 = bsToDo.nextSetBit(0);
            while (i2 >= 0) {
                this.getAtomBondChirality(atoms[i2], false, 4, (Lst<int[]>)lstEZ, bsToDo);
                i2 = bsToDo.nextSetBit(i2 + 1);
            }
        }
        int i3 = bsToDo.nextSetBit(0);
        while (i3 >= 0) {
            Node a = atoms[i3];
            a.setCIPChirality(0);
            a.setCIPChirality(this.getAtomChiralityLimited(a, null, null, 6));
            i3 = bsToDo.nextSetBit(i3 + 1);
        }
        if (haveAlkenes) {
            i3 = bsToDo.nextSetBit(0);
            while (i3 >= 0) {
                this.getAtomBondChirality(atoms[i3], false, 6, (Lst<int[]>)lstEZ, bsToDo);
                i3 = bsToDo.nextSetBit(i3 + 1);
            }
            if (this.lstSmallRings.size() > 0 && lstEZ.size() > 0) {
                this.clearSmallRingEZ(atoms, (Lst<int[]>)lstEZ);
            }
        }
    }

    private BS getAzacyclic(Node[] atoms, BS bsAtoms) {
        BS bsAza = null;
        int i = bsAtoms.nextSetBit(0);
        while (i >= 0) {
            Node atom = atoms[i];
            if (!(atom.getElementNumber() != 7 || atom.getCovalentBondCount() != 3 || this.bsAromatic != null && this.bsAromatic.get(i))) {
                int nr = 0;
                int j = this.lstSmallRings.size();
                while (--j >= 0) {
                    BS bsRing = (BS)this.lstSmallRings.get(j);
                    if (!bsRing.get(i)) continue;
                    ++nr;
                }
                if (nr == 3) {
                    if (bsAza == null) {
                        bsAza = new BS();
                    }
                    bsAza.set(i);
                }
            }
            i = bsAtoms.nextSetBit(i + 1);
        }
        return bsAza;
    }

    private boolean preFilterAtomList(Node[] atoms, BS bsToDo) {
        boolean haveAlkenes = false;
        int i = bsToDo.nextSetBit(0);
        while (i >= 0) {
            if (!this.couldBeChiralAtom(atoms[i])) {
                bsToDo.clear(i);
            } else if (!haveAlkenes && this.couldBeChiralAlkene(atoms[i], null) != -1) {
                haveAlkenes = true;
            }
            i = bsToDo.nextSetBit(i + 1);
        }
        return haveAlkenes;
    }

    private boolean couldBeChiralAtom(Node a) {
        boolean planar;
        boolean mustBePlanar = false;
        block0 : switch (a.getCovalentBondCount()) {
            default: {
                System.out.println("???? too many bonds! " + a);
                return false;
            }
            case 0: {
                return false;
            }
            case 1: {
                return false;
            }
            case 2: {
                return a.getElementNumber() == 7;
            }
            case 3: {
                switch (a.getElementNumber()) {
                    case 7: {
                        if (this.bsAzacyclic != null && this.bsAzacyclic.get(a.getIndex())) break block0;
                        return false;
                    }
                    case 6: {
                        mustBePlanar = true;
                        break block0;
                    }
                    case 15: 
                    case 16: 
                    case 33: 
                    case 34: 
                    case 51: 
                    case 52: 
                    case 83: 
                    case 84: {
                        break block0;
                    }
                    case 4: {
                        break block0;
                    }
                    default: {
                        return false;
                    }
                }
            }
            case 4: 
        }
        Edge[] edges = a.getEdges();
        int nH = 0;
        int j = a.getBondCount();
        while (--j >= 0) {
            if (edges[j].getOtherAtomNode(a).getAtomicAndIsotopeNumber() != 1 || ++nH != 2) continue;
            return false;
        }
        float d = this.getTrigonality(a, this.vNorm);
        boolean bl = planar = Math.abs(d) < 0.2f;
        if (planar == mustBePlanar) {
            return true;
        }
        System.out.println("??????? planar=" + planar + "??" + a);
        return false;
    }

    private int couldBeChiralAlkene(Node a, Node b) {
        switch (a.getCovalentBondCount()) {
            default: {
                return -1;
            }
            case 2: {
                if (a.getElementNumber() == 7) break;
                return -1;
            }
            case 3: {
                if (this.isFirstRow(a)) break;
                return -1;
            }
        }
        Edge[] bonds = a.getEdges();
        int n = 0;
        int i = bonds.length;
        while (--i >= 0) {
            if (bonds[i].getCovalentOrder() != 2) continue;
            if (++n > 1) {
                return -3;
            }
            Node other = bonds[i].getOtherAtomNode(a);
            if (!this.isFirstRow(other)) {
                return -1;
            }
            if (b == null || other == b && b.getCovalentBondCount() != 1) continue;
            return -1;
        }
        return -2;
    }

    boolean isFirstRow(Node a) {
        int n = a.getElementNumber();
        return n > 2 && n <= 10;
    }

    private void getSmallRings(Node atom, BS bs) {
        this.lstSmallRings = new Lst();
        this.root = new CIPAtom().create(atom, null, false, false);
        this.addSmallRings(this.root, bs);
    }

    private BS getAromaticity(Node[] atoms) {
        BS bsAromatic = new BS();
        int i = this.lstSmallRings.size();
        while (--i >= 0) {
            BS bsRing = (BS)this.lstSmallRings.get(i);
            boolean isAromatic = true;
            int j = bsRing.nextSetBit(0);
            while (j >= 0) {
                switch (atoms[j].getCovalentBondCount()) {
                    case 2: 
                    case 3: {
                        break;
                    }
                    default: {
                        isAromatic = false;
                    }
                }
                j = bsRing.nextSetBit(j + 1);
            }
            if (!isAromatic) continue;
            bsAromatic.or(bsRing);
        }
        return bsAromatic.isEmpty() ? null : bsAromatic;
    }

    private void addSmallRings(CIPAtom a, BS bs) {
        if (a == null || a.atom == null) {
            return;
        }
        if (bs != null) {
            bs.clear(a.atom.getIndex());
        }
        if (a.isTerminal || a.isDuplicate || a.atom.getCovalentBondCount() > 4) {
            return;
        }
        Edge[] bonds = a.atom.getEdges();
        int pt = 0;
        int i = bonds.length;
        while (--i >= 0) {
            Node atom2;
            Edge bond = bonds[i];
            if (bond == null || !bond.isCovalent() || (atom2 = bond.getOtherAtomNode(a.atom)).getCovalentBondCount() == 1 || a.parent != null && atom2 == a.parent.atom) continue;
            CIPAtom r = a.addAtom(pt++, atom2, false, false);
            if (!r.isRingDuplicate) continue;
            r.updateRingList();
        }
        for (i = 0; i < pt; ++i) {
            this.addSmallRings(a.atoms[i], bs);
        }
    }

    private void clearSmallRingEZ(Node[] atoms, Lst<int[]> lstEZ) {
        int j = this.lstSmallRings.size();
        while (--j >= 0) {
            ((BS)this.lstSmallRings.get(j)).andNot(this.bsAtropisomeric);
        }
        int i = lstEZ.size();
        while (--i >= 0) {
            int[] ab = (int[])lstEZ.get(i);
            int j2 = this.lstSmallRings.size();
            while (--j2 >= 0) {
                BS ring = (BS)this.lstSmallRings.get(j2);
                if (!ring.get(ab[0]) || !ring.get(ab[1])) continue;
                atoms[ab[0]].setCIPChirality(3);
                atoms[ab[1]].setCIPChirality(3);
            }
        }
    }

    float getTrigonality(Node a, V3 vNorm) {
        P3[] pts = new P3[3];
        Edge[] bonds = a.getEdges();
        int i = bonds.length;
        int pt = 0;
        while (--i >= 0 && pt < 3) {
            if (!bonds[i].isCovalent()) continue;
            pts[pt++] = bonds[i].getOtherAtomNode(a).getXYZ();
        }
        P4 plane = Measure.getPlaneThroughPoints((T3)pts[0], (T3)pts[1], (T3)pts[2], (V3)vNorm, (V3)this.vTemp, (P4)new P4());
        return Measure.distanceToPlane((P4)plane, (T3)a.getXYZ());
    }

    public int getAtomChirality(Node atom) {
        this.init();
        return this.getAtomChiralityLimited(atom, null, null, 4);
    }

    public int getBondChirality(Edge bond) {
        this.init();
        this.getSmallRings(bond.getOtherAtomNode(null), null);
        return bond.getCovalentOrder() == 2 ? this.getBondChiralityLimited(bond, null, 4) : 0;
    }

    private void getAtomBondChirality(Node atom, boolean allBonds, int ruleMax, Lst<int[]> lstEZ, BS bsToDo) {
        int index = atom.getIndex();
        Edge[] bonds = atom.getEdges();
        int c = 0;
        boolean isAtropic = this.bsAtropisomeric.get(index);
        int j = bonds.length;
        while (--j >= 0) {
            int index1;
            Node atom1;
            Edge bond = bonds[j];
            if (isAtropic) {
                atom1 = bonds[j].getOtherAtomNode(atom);
                index1 = atom1.getIndex();
                if (!this.bsAtropisomeric.get(index1)) continue;
                c = this.getAxialOrEZChirality(atom, atom1, atom, atom1, true, ruleMax);
            } else {
                if (bond.getCovalentOrder() != 2) continue;
                atom1 = this.getLastCumuleneAtom(bond, atom, null, null);
                index1 = atom1.getIndex();
                if (!allBonds && index1 < index) continue;
                c = this.getBondChiralityLimited(bond, atom, ruleMax);
            }
            if (c != 0) {
                if (!isAtropic) {
                    lstEZ.addLast((Object)new int[]{index, index1});
                }
                bsToDo.clear(index);
                bsToDo.clear(index1);
            }
            if (!isAtropic) continue;
            break;
        }
    }

    private Node getLastCumuleneAtom(Edge bond, Node atom, int[] nSP2, Node[] parents) {
        Node atom2 = bond.getOtherAtomNode(atom);
        if (parents != null) {
            parents[0] = atom2;
            parents[1] = atom;
        }
        if (nSP2 != null) {
            nSP2[0] = 2;
        }
        boolean ppt = false;
        block0: while (atom2.getCovalentBondCount() == 2) {
            Node atom3;
            Edge[] edges = atom2.getEdges();
            int i = edges.length;
            do {
                if (--i < 0) continue block0;
            } while ((atom3 = (bond = edges[i]).getOtherAtomNode(atom2)) == atom);
            if (bond.getCovalentOrder() != 2) {
                return atom2;
            }
            if (parents != null) {
                if (!ppt) {
                    parents[0] = atom2;
                    ppt = true;
                }
                parents[1] = atom2;
            }
            if (nSP2 != null) {
                nSP2[0] = nSP2[0] + 1;
            }
            atom = atom2;
            atom2 = atom3;
        }
        return atom2;
    }

    private int getAtomChiralityLimited(Node atom, CIPAtom cipAtom, CIPAtom parent, int ruleMax) {
        int rs = 0;
        boolean isChiral = false;
        boolean isAlkene = false;
        try {
            if (cipAtom == null) {
                cipAtom = new CIPAtom().create(atom, null, false, isAlkene);
                int nSubs = atom.getCovalentBondCount();
                int elemNo = atom.getElementNumber();
                isAlkene = nSubs == 3 && elemNo <= 10 && cipAtom.lonePair == null;
                if (nSubs != (parent == null ? 4 : 3) - (nSubs == 3 && !isAlkene ? 1 : 0)) {
                    return rs;
                }
            } else {
                atom = cipAtom.atom;
                isAlkene = cipAtom.isAlkene;
            }
            this.root = cipAtom;
            cipAtom.parent = parent;
            if (parent != null) {
                cipAtom.htPathPoints = parent.htPathPoints;
            }
            this.currentRule = 1;
            if (cipAtom.set()) {
                this.currentRule = 1;
                while (this.currentRule <= ruleMax) {
                    int i;
                    if (Logger.debugging) {
                        Logger.info((String)("-Rule " + this.getRuleName() + " CIPChirality for " + cipAtom + "-----"));
                    }
                    if (this.currentRule == 5) {
                        cipAtom.createAuxiliaryRSCenters(null, null);
                    }
                    isChiral = false;
                    cipAtom.sortSubstituents();
                    isChiral = true;
                    if (Logger.debugging) {
                        Logger.info((String)(this.currentRule + ">>>>" + cipAtom));
                        for (i = 0; i < cipAtom.bondCount; ++i) {
                            if (cipAtom.atoms[i] == null) continue;
                            Logger.info((String)(cipAtom.atoms[i] + " " + Integer.toHexString(cipAtom.prevPriorities[i])));
                        }
                    }
                    if (cipAtom.achiral) {
                        isChiral = false;
                        break;
                    }
                    for (i = 0; i < cipAtom.bondCount - 1; ++i) {
                        if (cipAtom.prevPriorities[i] != cipAtom.prevPriorities[i + 1]) continue;
                        isChiral = false;
                        break;
                    }
                    if (this.currentRule == 6) {
                        cipAtom.isPseudo = cipAtom.canBePseudo;
                    }
                    if (isChiral) {
                        int n = !isAlkene ? cipAtom.checkHandedness() : (rs = cipAtom.atoms[0].isDuplicate ? 2 : 1);
                        if (isAlkene || !cipAtom.isPseudo || !cipAtom.canBePseudo) break;
                        rs |= 4;
                        break;
                    }
                    ++this.currentRule;
                }
                if (Logger.debugging) {
                    Logger.info((String)(atom + " " + rs + "\n----------------------------------"));
                }
            }
        }
        catch (Throwable e) {
            System.out.println(e + " in CIPChirality");
            e.printStackTrace();
            return 3;
        }
        return rs;
    }

    private int getBondChiralityLimited(Edge bond, Node a, int ruleMax) {
        Node b;
        if (Logger.debugging) {
            Logger.info((String)("get Bond Chirality " + bond));
        }
        if (a == null) {
            a = bond.getOtherAtomNode(null);
        }
        if (this.couldBeChiralAlkene(a, b = bond.getOtherAtomNode(a)) == -1) {
            return 0;
        }
        int[] nSP2 = new int[1];
        Node[] parents = new Node[2];
        b = this.getLastCumuleneAtom(bond, a, nSP2, parents);
        boolean isCumulene = nSP2[0] > 2;
        boolean isAxial = isCumulene && nSP2[0] % 2 == 1;
        return this.getAxialOrEZChirality(a, parents[0], parents[1], b, isAxial, ruleMax);
    }

    private int getAxialOrEZChirality(Node a, Node pa, Node pb, Node b, boolean isAxial, int ruleMax) {
        CIPAtom a1 = new CIPAtom().create(a, null, false, true);
        CIPAtom b1 = new CIPAtom().create(pa, null, false, true);
        a1.canBePseudo = a1.isOddCumulene = isAxial;
        int atop = this.getAtomChiralityLimited(a, a1, b1, ruleMax) - 1;
        CIPAtom a2 = new CIPAtom().create(pb, null, false, true);
        CIPAtom b2 = new CIPAtom().create(b, null, false, true);
        b2.canBePseudo = b2.isOddCumulene = isAxial;
        int btop = this.getAtomChiralityLimited(b, b2, a2, ruleMax) - 1;
        int c = 0;
        if (atop >= 0 && btop >= 0) {
            if (isAxial) {
                c = this.isPos(b2.atoms[btop], b2, a1, a1.atoms[atop]) ? 34 : 33;
                if (a1.ties == null != (b2.ties == null)) {
                    c |= 4;
                }
            } else {
                int n = c = this.isCis(b2.atoms[btop], b2, a1, a1.atoms[atop]) ? 8 : 16;
            }
        }
        if (c != 0 && (isAxial || !this.isAtropisomeric(a) && !this.isAtropisomeric(b))) {
            a.setCIPChirality(c);
            b.setCIPChirality(c);
            if (Logger.debugging) {
                Logger.info((String)(a + "-" + b + " " + JC.getCIPChiralityName((int)c)));
            }
        }
        return c;
    }

    private boolean isAtropisomeric(Node a) {
        return this.bsAtropisomeric != null && this.bsAtropisomeric.get(a.getIndex());
    }

    boolean isCis(CIPAtom a, CIPAtom b, CIPAtom c, CIPAtom d) {
        Measure.getNormalThroughPoints((T3)a.atom.getXYZ(), (T3)b.atom.getXYZ(), (T3)c.atom.getXYZ(), (T3)this.vNorm, (T3)this.vTemp);
        V3 vNorm2 = new V3();
        Measure.getNormalThroughPoints((T3)b.atom.getXYZ(), (T3)c.atom.getXYZ(), (T3)d.atom.getXYZ(), (T3)vNorm2, (T3)this.vTemp);
        return this.vNorm.dot((T3)vNorm2) > 0.0f;
    }

    boolean isPos(CIPAtom a, CIPAtom b, CIPAtom c, CIPAtom d) {
        float angle = Measure.computeTorsion((T3)a.atom.getXYZ(), (T3)b.atom.getXYZ(), (T3)c.atom.getXYZ(), (T3)d.atom.getXYZ(), (boolean)true);
        return angle > 0.0f;
    }

    public int sign(int score) {
        return score < 0 ? -1 : (score > 0 ? 1 : 0);
    }

    private class CIPAtom
    implements Comparable<CIPAtom>,
    Cloneable {
        Node atom;
        private int id;
        CIPAtom parent;
        private CIPAtom rootSubstituent;
        int elemNo;
        int massNo;
        private int sphere;
        BS bsPath;
        private String myPath = "";
        private int rootDistance;
        private int nAtoms;
        private int nPriorities;
        private int h1Count;
        private String knownAtomChirality = "~";
        private boolean isSet;
        boolean isDuplicate = true;
        boolean isTerminal;
        boolean isAlkene;
        CIPAtom alkeneParent;
        CIPAtom alkeneChild;
        private boolean isAlkeneAtom2;
        boolean doCheckPseudo;
        public boolean isPseudo;
        boolean achiral;
        public int bondCount;
        CIPAtom[] atoms = new CIPAtom[4];
        private int[] priorities = new int[4];
        int[] prevPriorities = new int[]{-1, -1, -1, -1};
        private String[] rule4List;
        P3 lonePair;
        private int atomIndex;
        private int auxEZ = -1;
        private CIPAtom auxParentReversed;
        private CIPAtom auxPseudo;
        boolean canBePseudo = true;
        Lst<int[]> ties;
        boolean isOddCumulene;
        private CIPAtom nextSP2;
        private CIPAtom nextChiralBranch;
        private int[] rule4Count;
        private int priority;
        Map<String, Integer> htPathPoints;
        private boolean isTrigonalPyramidal;
        boolean isRingDuplicate;

        CIPAtom() {
        }

        CIPAtom create(Node atom, CIPAtom parent, boolean isDuplicate, boolean isAlkene) {
            this.id = ++CIPChirality.this.ptID;
            this.parent = parent;
            if (atom == null) {
                return this;
            }
            this.isAlkene = isAlkene;
            this.atom = atom;
            this.elemNo = atom.getElementNumber();
            this.massNo = atom.getNominalMass();
            this.atomIndex = atom.getIndex();
            this.bondCount = atom.getCovalentBondCount();
            boolean bl = this.isTrigonalPyramidal = this.bondCount == 3 && !isAlkene && (this.elemNo > 10 || CIPChirality.this.bsAzacyclic != null && CIPChirality.this.bsAzacyclic.get(this.atomIndex));
            if (this.isTrigonalPyramidal) {
                this.getLonePair();
            }
            this.canBePseudo = this.bondCount == 4 || this.isTrigonalPyramidal;
            String c = atom.getCIPChirality(false);
            if (c.equals("") || c.equals("r") || c.equals("s")) {
                c = "~";
            }
            this.knownAtomChirality = c;
            if (parent != null) {
                this.sphere = parent.sphere + 1;
            }
            if (this.sphere == 1) {
                this.rootSubstituent = this;
                this.htPathPoints = new Hashtable<String, Integer>();
            } else if (parent != null) {
                this.rootSubstituent = parent.rootSubstituent;
                this.htPathPoints = this.rootSubstituent.htPathPoints;
            }
            this.bsPath = parent == null ? new BS() : BSUtil.copy((BS)parent.bsPath);
            boolean wasDuplicate = isDuplicate;
            if (parent == null) {
                this.bsPath.set(this.atomIndex);
                this.rootDistance = 0;
            } else if (wasDuplicate && CIPChirality.this.bsAromatic != null && CIPChirality.this.bsAromatic.get(this.atomIndex)) {
                this.rootDistance = parent.rootDistance;
            } else if (atom == CIPChirality.this.root.atom) {
                this.rootDistance = 0;
                isDuplicate = true;
            } else if (this.bsPath.get(this.atomIndex)) {
                isDuplicate = true;
                this.rootDistance = this.rootSubstituent.htPathPoints.get(atom.toString());
            } else {
                this.bsPath.set(this.atomIndex);
                this.rootDistance = parent.rootDistance + 1;
                this.rootSubstituent.htPathPoints.put(atom.toString(), new Integer(this.rootDistance));
            }
            this.isDuplicate = isDuplicate;
            this.myPath = (parent != null ? parent.myPath + "-" : "") + this;
            if (Logger.debugging) {
                Logger.info((String)("new CIPAtom " + this.myPath));
            }
            this.isRingDuplicate = isDuplicate && !wasDuplicate;
            return this;
        }

        private void getLonePair() {
            float d = CIPChirality.this.getTrigonality(this.atom, CIPChirality.this.vNorm);
            if (Math.abs(d) > 0.2f) {
                this.lonePair = new P3();
                CIPChirality.this.vNorm.scale(d);
                this.lonePair.add2((T3)this.atom.getXYZ(), (T3)CIPChirality.this.vNorm);
            }
        }

        private void updateRingList() {
            BS bsRing = BSUtil.newAndSetBit((int)this.atomIndex);
            CIPAtom p = this;
            int index = -1;
            while ((p = p.parent) != null && index != this.atomIndex) {
                index = p.atomIndex;
                bsRing.set(index);
            }
            if (bsRing.cardinality() < 8) {
                int i = CIPChirality.this.lstSmallRings.size();
                while (--i >= 0) {
                    if (!((BS)CIPChirality.this.lstSmallRings.get(i)).equals((Object)bsRing)) continue;
                    return;
                }
                CIPChirality.this.lstSmallRings.addLast((Object)bsRing);
            }
        }

        boolean set() {
            if (this.isSet) {
                return true;
            }
            this.isSet = true;
            if (this.isDuplicate) {
                return true;
            }
            int nBonds = this.atom.getBondCount();
            Edge[] bonds = this.atom.getEdges();
            if (Logger.debuggingHigh) {
                Logger.info((String)("set " + this));
            }
            int pt = 0;
            block5: for (int i = 0; i < nBonds; ++i) {
                Edge bond = bonds[i];
                if (!bond.isCovalent()) continue;
                Node other = bond.getOtherAtomNode(this.atom);
                boolean isParentBond = this.parent != null && this.parent.atom == other;
                int order = bond.getCovalentOrder();
                if (order == 2) {
                    if (this.elemNo > 10 || !CIPChirality.this.isFirstRow(other)) {
                        order = 1;
                    } else {
                        this.isAlkene = true;
                        if (isParentBond) {
                            this.knownAtomChirality = bond.getCIPChirality(false);
                            if (this.knownAtomChirality.equals("")) {
                                this.knownAtomChirality = "~";
                            }
                            if (this.atom.getCovalentBondCount() == 2 && this.atom.getValence() == 4) {
                                this.parent.isAlkeneAtom2 = false;
                            } else {
                                this.isAlkeneAtom2 = true;
                            }
                            this.parent.alkeneChild = null;
                            this.alkeneParent = this.parent.alkeneParent == null ? this.parent : this.parent.alkeneParent;
                            this.alkeneParent.alkeneChild = this;
                            if (this.parent.alkeneParent == null) {
                                this.parent.nextSP2 = this;
                            }
                        }
                    }
                }
                if (nBonds == 1 && order == 1 && isParentBond) {
                    this.isTerminal = true;
                    return true;
                }
                switch (order) {
                    case 3: {
                        if (this.addAtom(pt++, other, isParentBond, false) == null) {
                            this.isTerminal = true;
                            return false;
                        }
                    }
                    case 2: {
                        if (this.addAtom(pt++, other, order != 2 || isParentBond, order == 2) == null) {
                            this.isTerminal = true;
                            return false;
                        }
                    }
                    case 1: {
                        if (isParentBond || this.addAtom(pt++, other, order != 1 && this.elemNo <= 10, false) != null) continue block5;
                        this.isTerminal = true;
                        return false;
                    }
                    default: {
                        this.isTerminal = true;
                        return false;
                    }
                }
            }
            this.isTerminal = pt == 0;
            this.nAtoms = pt;
            while (pt < this.atoms.length) {
                this.atoms[pt] = new CIPAtom().create(null, this, true, false);
                ++pt;
            }
            int ruleNow = CIPChirality.this.currentRule;
            CIPChirality.this.currentRule = 1;
            Arrays.sort(this.atoms);
            CIPChirality.this.currentRule = ruleNow;
            if (this.isTerminal) {
                System.out.println("????");
            }
            return !this.isTerminal;
        }

        CIPAtom addAtom(int i, Node other, boolean isDuplicate, boolean isAlkene) {
            int atomIsotope;
            if (i >= this.atoms.length) {
                if (Logger.debugging) {
                    Logger.info((String)(" too many bonds on " + this.atom));
                }
                return null;
            }
            if (this.parent == null && (atomIsotope = other.getAtomicAndIsotopeNumber()) == 1 && ++this.h1Count > 1) {
                if (Logger.debuggingHigh) {
                    Logger.info((String)(" second H atom found on " + this.atom));
                }
                return null;
            }
            this.atoms[i] = new CIPAtom().create(other, this, isDuplicate, isAlkene);
            if (CIPChirality.this.currentRule > 3) {
                this.prevPriorities[i] = this.atoms[i].getBasePriority(true);
            }
            return this.atoms[i];
        }

        /*
         * Enabled aggressive block sorting
         */
        void sortSubstituents() {
            int i;
            int[] indices = new int[4];
            this.ties = null;
            for (i = 0; i < 4; ++i) {
                this.priorities[i] = 0;
                if (this.prevPriorities[i] != -1 || CIPChirality.this.currentRule <= 3) continue;
                this.prevPriorities[i] = this.atoms[i].getBasePriority(true);
            }
            if (Logger.debugging) {
                Logger.info((String)(CIPChirality.this.root + "---sortSubstituents---" + this));
                for (i = 0; i < 4; ++i) {
                    Logger.info((String)(CIPChirality.this.getRuleName() + ": " + this + "[" + i + "]=" + this.atoms[i].myPath + " " + Integer.toHexString(this.prevPriorities[i])));
                }
                Logger.info((String)"---");
            }
            boolean checkRule4List = CIPChirality.this.currentRule > 4 && this.rule4List != null;
            int i2 = 0;
            while (true) {
                CIPAtom a;
                if (i2 < 4) {
                    a = this.atoms[i2];
                } else {
                    int i3;
                    CIPAtom[] newAtoms = new CIPAtom[4];
                    int[] newPriorities = new int[4];
                    int[] newPrevPriorities = new int[4];
                    BS bs = new BS();
                    int shift = PRIORITY_SHIFT[CIPChirality.this.currentRule];
                    for (i3 = 0; i3 < 4; ++i3) {
                        int p;
                        int pt = indices[i3];
                        CIPAtom a2 = newAtoms[pt] = this.atoms[i3];
                        newPriorities[pt] = p = this.priorities[i3];
                        int pp = this.prevPriorities[i3];
                        if (pp < 0) {
                            pp = 0;
                        }
                        newPrevPriorities[pt] = pp |= p << shift;
                        if (a2.atom == null) continue;
                        bs.set(this.priorities[i3]);
                    }
                    this.atoms = newAtoms;
                    this.priorities = newPriorities;
                    this.prevPriorities = newPrevPriorities;
                    this.nPriorities = bs.cardinality();
                    if (this.nPriorities > CIPChirality.this.nPriorityMax) {
                        CIPChirality.this.nPriorityMax = this.nPriorities;
                    }
                    if (this.ties != null && !this.isOddCumulene) {
                        block11 : switch (this.ties.size()) {
                            case 1: {
                                switch (this.checkPseudoHandedness((int[])this.ties.get(0), indices)) {
                                    case 1: 
                                    case 2: {
                                        this.isPseudo = this.canBePseudo;
                                        break block11;
                                    }
                                }
                                break;
                            }
                            case 2: {
                                this.canBePseudo = false;
                                break;
                            }
                        }
                    }
                    if (Logger.debugging) {
                        Logger.info((String)(this.dots() + this.atom + " nPriorities = " + this.nPriorities));
                        for (i3 = 0; i3 < 4; ++i3) {
                            Logger.info((String)(this.dots() + this.myPath + "[" + i3 + "]=" + this.atoms[i3] + " " + this.priorities[i3] + " " + Integer.toHexString(this.prevPriorities[i3]) + " new"));
                        }
                        Logger.info((String)(this.dots() + "-------"));
                    }
                    return;
                }
                for (int j = i2 + 1; j < 4; ++j) {
                    int score;
                    boolean Logger_debugHigh;
                    CIPAtom b = this.atoms[j];
                    boolean bl = Logger_debugHigh = Logger.debuggingHigh && b.isHeavy() && a.isHeavy();
                    int n = a.atom == null ? 1 : (b.atom == null ? -1 : (this.prevPriorities[i2] == this.prevPriorities[j] ? 0 : (score = this.prevPriorities[j] < this.prevPriorities[i2] ? 1 : -1)));
                    if (score == 0) {
                        int n2 = score = checkRule4List ? this.checkRule4And5(i2, j) : a.compareTo(b);
                    }
                    if (Logger_debugHigh) {
                        Logger.info((String)(this.dots() + "ordering " + this.id + "." + i2 + "." + j + " " + this + "-" + a + " vs " + b + " = " + score));
                    }
                    switch (score) {
                        case -2147483648: {
                            if (checkRule4List && this.sphere == 0) {
                                this.achiral = true;
                            }
                            int n3 = i2;
                            indices[n3] = indices[n3] + 1;
                            if (!Logger_debugHigh) break;
                            Logger.info((String)(this.dots() + this.atom + "." + b + " ends up with tie with " + a));
                            break;
                        }
                        case 1: {
                            int n4 = i2;
                            indices[n4] = indices[n4] + 1;
                            int n5 = i2;
                            this.priorities[n5] = this.priorities[n5] + 1;
                            if (!Logger_debugHigh) break;
                            Logger.info((String)(this.dots() + this + "." + b + " B-beats " + a));
                            break;
                        }
                        case -1: {
                            int n6 = j;
                            indices[n6] = indices[n6] + 1;
                            int n7 = j;
                            this.priorities[n7] = this.priorities[n7] + 1;
                            if (!Logger_debugHigh) break;
                            Logger.info((String)(this.dots() + this + "." + a + " A-beats " + b));
                            break;
                        }
                        case 0: {
                            score = a.breakTie(b);
                            switch (CIPChirality.this.sign(score)) {
                                case 0: {
                                    int n8 = i2;
                                    indices[n8] = indices[n8] + 1;
                                    if (!Logger_debugHigh) break;
                                    Logger.info((String)(this.dots() + this + "." + b + " ends up with tie with " + a));
                                    break;
                                }
                                case 1: {
                                    int n9 = i2;
                                    indices[n9] = indices[n9] + 1;
                                    int n10 = i2;
                                    this.priorities[n10] = this.priorities[n10] + 1;
                                    if (!Logger_debugHigh) break;
                                    Logger.info((String)(this.dots() + this + "." + b + " wins in tie with " + a));
                                    break;
                                }
                                case -1: {
                                    int n11 = j;
                                    indices[n11] = indices[n11] + 1;
                                    int n12 = j;
                                    this.priorities[n12] = this.priorities[n12] + 1;
                                    if (!Logger_debugHigh) break;
                                    Logger.info((String)(this.dots() + this + "." + a + " wins in tie with " + b));
                                }
                            }
                            break;
                        }
                    }
                    if (!this.doCheckPseudo) continue;
                    this.doCheckPseudo = false;
                    if (this.ties == null) {
                        this.ties = new Lst();
                    }
                    this.ties.addLast((Object)new int[]{i2, j});
                }
                ++i2;
            }
        }

        private String dots() {
            return ".....................".substring(0, Math.min(20, this.sphere));
        }

        private int breakTie(CIPAtom b) {
            if (Logger.debugging && this.isHeavy() && b.isHeavy()) {
                Logger.info((String)(this.dots() + "tie for " + this + " and " + b + " at sphere " + this.sphere));
            }
            if (this.isDuplicate && b.isDuplicate && this.atom == b.atom && this.rootDistance == b.rootDistance) {
                return 0;
            }
            int score = this.checkNoSubs(b);
            if (score != 0) {
                return score * (this.sphere + 1);
            }
            if (!this.set() || !b.set() || this.isTerminal && b.isTerminal || this.isDuplicate && b.isDuplicate) {
                return 0;
            }
            if (this.isTerminal != b.isTerminal) {
                return (this.isTerminal ? 1 : -1) * (this.sphere + 1);
            }
            if (CIPChirality.this.currentRule == 2) {
                this.preSortRule1b();
                b.preSortRule1b();
            }
            if ((score = this.compareShallowly(b)) != 0) {
                return score;
            }
            this.sortSubstituents();
            b.sortSubstituents();
            return this.compareDeeply(b);
        }

        private void preSortRule1b() {
            for (int i = 0; i < 3; ++i) {
                CIPAtom a1 = this.atoms[i];
                if (!a1.isDuplicate) continue;
                for (int j = i + 1; j < 4; ++j) {
                    CIPAtom a2 = this.atoms[j];
                    if (!a2.isDuplicate || a1.elemNo != a2.elemNo || a1.rootDistance <= a2.rootDistance) continue;
                    this.atoms[i] = a2;
                    this.atoms[j] = a1;
                }
            }
        }

        private boolean isHeavy() {
            return this.massNo > 1;
        }

        private int compareShallowly(CIPAtom b) {
            for (int i = 0; i < this.nAtoms; ++i) {
                CIPAtom ai = this.atoms[i];
                CIPAtom bi = b.atoms[i];
                int score = ai.checkCurrentRule(bi);
                if (score == Integer.MIN_VALUE) {
                    score = 0;
                }
                if (score == 0) continue;
                if (Logger.debugging && ai.isHeavy() && bi.isHeavy()) {
                    Logger.info((String)(ai.dots() + "compareShallow " + ai + " " + bi + ": " + score * ai.sphere));
                }
                return score * ai.sphere;
            }
            return 0;
        }

        private int compareDeeply(CIPAtom b) {
            int finalScore = this.nAtoms == 0 ? 1 : 0;
            int absScore = Integer.MAX_VALUE;
            for (int i = 0; i < this.nAtoms; ++i) {
                int score;
                CIPAtom ai = this.atoms[i];
                CIPAtom bi = b.atoms[i];
                if (Logger.debugging && ai.isHeavy() && bi.isHeavy()) {
                    Logger.info((String)(ai.dots() + "compareDeep sub " + ai + " " + bi));
                }
                if ((score = ai.breakTie(bi)) == 0) continue;
                int abs = Math.abs(score);
                if (Logger.debugging && ai.isHeavy() && bi.isHeavy()) {
                    Logger.info((String)(ai.dots() + "compareDeep sub " + ai + " " + bi + ": " + score));
                }
                if (abs >= absScore) continue;
                absScore = abs;
                finalScore = score;
            }
            if (Logger.debugging) {
                Logger.info((String)(this.dots() + "compareDeep " + this + " " + b + ": " + finalScore));
            }
            return finalScore;
        }

        @Override
        public int compareTo(CIPAtom b) {
            int score;
            int n = b == null ? -1 : (this.atom == null != (b.atom == null) ? (this.atom == null ? 1 : -1) : ((score = this.checkCurrentRule(b)) == Integer.MIN_VALUE ? 0 : (score != 0 ? score : this.checkNoSubs(b))));
            return n;
        }

        private int checkNoSubs(CIPAtom b) {
            return b.isDuplicate == this.isDuplicate ? 0 : (b.isDuplicate ? -1 : 1);
        }

        public int checkCurrentRule(CIPAtom b) {
            switch (CIPChirality.this.currentRule) {
                default: {
                    return this.checkRule1a(b);
                }
                case 2: {
                    return this.checkRule1b(b);
                }
                case 3: {
                    return this.checkRule2(b);
                }
                case 4: {
                    return this.checkRule3(b);
                }
                case 5: {
                    return 0;
                }
                case 6: 
            }
            return this.checkRule5(b);
        }

        private int checkRule1a(CIPAtom b) {
            return b.atom == this.atom ? 0 : (b.atom == null ? -1 : (this.atom == null ? 1 : (b.elemNo < this.elemNo ? -1 : (b.elemNo > this.elemNo ? 1 : 0))));
        }

        private int checkRule1b(CIPAtom b) {
            return !b.isDuplicate || !this.isDuplicate ? 0 : (b.rootDistance == this.rootDistance ? 0 : (b.rootDistance > this.rootDistance ? -1 : 1));
        }

        private int checkRule2(CIPAtom b) {
            return b.massNo < this.massNo ? -1 : (b.massNo > this.massNo ? 1 : 0);
        }

        private int checkRule3(CIPAtom b) {
            int zb;
            int za;
            return this.parent == null || !this.parent.isAlkeneAtom2 || !b.parent.isAlkeneAtom2 || this.isDuplicate || b.isDuplicate || !this.isCumulativeType(-2) || !b.isCumulativeType(-2) ? Integer.MIN_VALUE : (this.parent == b.parent ? CIPChirality.this.sign(this.breakTie(b)) : ((za = this.parent.getEZaux()) < (zb = b.parent.getEZaux()) ? -1 : (za > zb ? 1 : 0)));
        }

        private boolean isCumulativeType(int type) {
            return this.parent != null && this.parent.isAlkeneAtom2 && (this.parent.alkeneParent.sphere + this.parent.sphere) % 2 == (type == -2 ? 1 : 2);
        }

        private int getEZaux() {
            if (this.auxEZ == -1 && (this.auxEZ = this.alkeneParent.auxEZ) == -1) {
                CIPAtom winner1 = null;
                CIPAtom winner2 = null;
                CIPAtom atom1 = null;
                this.auxEZ = 24;
                this.sortSubstituents();
                winner2 = this.getTopAtom();
                if (winner2 != null) {
                    if (this.auxParentReversed == null) {
                        if (Logger.debugging) {
                            Logger.info((String)("reversing path for " + this.alkeneParent));
                        }
                        atom1 = (CIPAtom)this.alkeneParent.clone();
                        atom1.addReturnPath(this.alkeneParent.nextSP2, this.alkeneParent);
                    } else {
                        atom1 = this.auxParentReversed;
                    }
                    atom1.sortSubstituents();
                    winner1 = atom1.getTopAtom();
                    if (winner1 != null) {
                        this.auxEZ = CIPChirality.this.isCis(winner2, this, atom1, winner1) ? 8 : 16;
                    }
                }
            }
            this.alkeneParent.auxEZ = this.auxEZ;
            if (Logger.debugging) {
                Logger.info((String)("getZaux " + this.alkeneParent + " " + this.auxEZ));
            }
            return this.auxEZ;
        }

        private Lst<CIPAtom> getReturnPath(CIPAtom a) {
            Lst path = new Lst();
            while (a.parent != null && a.parent.atoms[0] != null) {
                if (Logger.debugging) {
                    Logger.info((String)("path:" + a.parent.atom + "->" + a.atom));
                }
                a = a.parent;
                path.addLast((Object)a);
            }
            path.addLast(null);
            return path;
        }

        private void addReturnPath(CIPAtom last, CIPAtom fromAtom) {
            Lst<CIPAtom> path = this.getReturnPath(fromAtom);
            CIPAtom thisAtom = this;
            int n = path.size();
            for (int i = 0; i < n; ++i) {
                CIPAtom p = (CIPAtom)path.get(i);
                if (p == null) {
                    p = new CIPAtom().create(null, this, true, this.isAlkene);
                } else {
                    int s = p.sphere;
                    p = (CIPAtom)p.clone();
                    p.sphere = s + 1;
                }
                thisAtom.replaceParentSubstituent(last, p);
                if (last == null) break;
                last = last.parent;
                thisAtom = p;
            }
        }

        int getBasePriority(boolean addMass) {
            return this.atom == null ? 0x7FFFF000 : 127 - this.elemNo << PRIORITY_SHIFT[1] | (addMass ? 255 - this.massNo << PRIORITY_SHIFT[3] : 0);
        }

        private int checkRule4And5(int i, int j) {
            if (this.rule4List[i] == null && this.rule4List[j] == null) {
                return 0;
            }
            if (this.rule4List[i] == null || this.rule4List[j] == null) {
                return this.rule4List[j] == null ? -1 : 1;
            }
            return this.compareRootMataPair(i, j);
        }

        private int compareRootMataPair(int ia, int ib) {
            String s;
            boolean isRule5 = CIPChirality.this.currentRule == 6;
            String aStr = this.rule4List[ia].substring(1);
            String bStr = this.rule4List[ib].substring(1);
            if (this.atoms[ia].nextChiralBranch != null) {
                s = this.atoms[ia].getMataList(this.getFirstRef(aStr), isRule5);
                String string = aStr = s.indexOf("|") < 0 ? aStr + s : s;
            }
            if (this.atoms[ib].nextChiralBranch != null) {
                s = this.atoms[ib].getMataList(this.getFirstRef(bStr), isRule5);
                String string = bStr = s.indexOf("|") < 0 ? bStr + s : s;
            }
            if (Logger.debugging) {
                Logger.info((String)(this.dots() + this + " comparing " + this.atoms[ia] + " " + aStr + " to " + this.atoms[ib] + " " + bStr));
            }
            if (aStr.length() != bStr.length()) {
                return 0;
            }
            if (isRule5) {
                return aStr.compareTo(bStr);
            }
            if (aStr.indexOf("|") >= 0 || bStr.indexOf("|") >= 0) {
                String[] aList = PT.split((String)aStr, (String)"|");
                String[] bList = PT.split((String)bStr, (String)"|");
                int minScore = Integer.MAX_VALUE;
                int sumScore = 0;
                aStr = aList[0];
                bStr = bList[0];
                for (int i = 0; i < 2; ++i) {
                    for (int j = 0; j < 2; ++j) {
                        int score = this.compareRule4PairStr(aList[i], bList[j], true);
                        sumScore += score;
                        if (score == 0 || Math.abs(score) > minScore) continue;
                        minScore = Math.abs(score);
                        aStr = aList[i];
                        bStr = bList[j];
                    }
                }
                if (sumScore == 0) {
                    return 0;
                }
            }
            aStr = PT.rep((String)aStr, (String)"~", (String)"");
            bStr = PT.rep((String)bStr, (String)"~", (String)"");
            if (aStr.length() == 1 && "RS".indexOf(aStr) < 0) {
                int score = this.checkEnantiomer(aStr, bStr, 0, aStr.length(), " rs");
                switch (score) {
                    case -1: 
                    case 1: {
                        this.canBePseudo = false;
                        this.doCheckPseudo = true;
                        return score;
                    }
                }
            }
            return this.compareRule4PairStr(aStr, bStr, false);
        }

        private String getFirstRef(String aStr) {
            int n = aStr.length();
            for (int i = 0; i < n; ++i) {
                char c = this.fixMataRef(aStr.charAt(i));
                switch (c) {
                    case 'R': 
                    case 'S': {
                        return "" + c;
                    }
                }
            }
            return null;
        }

        private String getMataList(String aref, boolean isRule5) {
            int n = 0;
            int i = this.rule4List.length;
            while (--i >= 0) {
                if (this.rule4List[i] == null) continue;
                ++n;
            }
            String[] listA = new String[n];
            int j = n;
            int i2 = this.rule4List.length;
            while (--i2 >= 0) {
                if (this.rule4List[i2] == null) continue;
                listA[--j] = this.rule4List[i2];
            }
            if (aref == null) {
                aref = this.getMataRef(isRule5);
            } else {
                for (int i3 = 0; i3 < n; ++i3) {
                    listA[i3] = "." + listA[i3].substring(1);
                }
            }
            switch (aref.length()) {
                default: {
                    return this.getMataSequence(listA, aref, isRule5);
                }
                case 2: 
            }
            return this.getMataSequence(listA, "R", false) + "|" + this.getMataSequence(listA, "S", false);
        }

        private String getMataRef(boolean isRule5) {
            String rs;
            String string = isRule5 ? "R" : (this.rule4Count[1] > this.rule4Count[2] ? "R" : (rs = this.rule4Count[1] < this.rule4Count[2] ? "S" : "RS"));
            if (Logger.debugging) {
                Logger.info((String)(this + "mata ref: " + rs + " Rule5?" + isRule5 + " " + PT.toJSON((String)"rule4Count", (Object)this.rule4Count)));
            }
            return rs;
        }

        private String getMataSequence(String[] lst, String chRef, boolean isRule5) {
            int n = lst.length;
            Object[] lst1 = new String[n];
            int j = n;
            int i = this.rule4List.length;
            while (--i >= 0) {
                if (this.rule4List[i] == null) continue;
                lst1[--j] = lst[j];
                if (this.atoms[i].nextChiralBranch == null) continue;
                int n2 = j;
                lst1[n2] = lst1[n2] + this.atoms[i].nextChiralBranch.getMataList(chRef, isRule5);
            }
            Object[] sorted = isRule5 ? lst1 : this.getMataSortedList((String[])lst1, chRef);
            int len = 0;
            for (int i2 = 0; i2 < n; ++i2) {
                String rs = sorted[i2];
                if (rs.length() <= len) continue;
                len = rs.length();
            }
            String mlist = "";
            for (int i3 = 1; i3 < len; ++i3) {
                Object rs;
                int j2;
                for (j2 = 0; j2 < n; ++j2) {
                    char ch;
                    rs = sorted[j2];
                    if (i3 >= ((String)rs).length() || (ch = ((String)rs).charAt(i3)) == '~' || ch == ';') continue;
                    mlist = mlist + ch;
                }
                if (!isRule5) continue;
                for (j2 = 0; j2 < n; ++j2) {
                    rs = sorted[j2];
                    if (i3 >= ((String)rs).length()) continue;
                    sorted[j2] = ((String)rs).substring(0, i3) + "~" + ((String)rs).substring(i3 + 1);
                }
                Arrays.sort(sorted);
            }
            return mlist;
        }

        private int compareRule4PairStr(String aStr, String bStr, boolean isRSTest) {
            if (Logger.debugging) {
                Logger.info((String)(this.dots() + this + " Rule 4b comparing " + aStr + " " + bStr));
            }
            this.doCheckPseudo = false;
            int n = aStr.length();
            if (n == 0 || n != bStr.length()) {
                return 0;
            }
            char aref = this.fixMataRef(aStr.charAt(0));
            char bref = this.fixMataRef(bStr.charAt(0));
            for (int c = 1; c < n; ++c) {
                boolean blike;
                boolean alike = aref == this.fixMataRef(aStr.charAt(c));
                boolean bl = blike = bref == this.fixMataRef(bStr.charAt(c));
                if (alike == blike) continue;
                return (isRSTest ? c : 1) * (alike ? -1 : 1);
            }
            if (isRSTest) {
                return 0;
            }
            if (aref == bref) {
                return Integer.MIN_VALUE;
            }
            if (!this.canBePseudo) {
                CIPChirality.this.root.canBePseudo = false;
            }
            this.doCheckPseudo = this.canBePseudo && (aref == 'R' || aref == 'S');
            return aref < bref ? -1 : 1;
        }

        private char fixMataRef(char c) {
            switch (c) {
                case 'M': 
                case 'R': 
                case 'Z': {
                    return 'R';
                }
                case 'E': 
                case 'P': 
                case 'S': {
                    return 'S';
                }
            }
            return c;
        }

        private String[] getMataSortedList(String[] lst, String aref) {
            int i;
            int n = lst.length;
            Object[] sorted = new String[n];
            for (i = 0; i < n; ++i) {
                sorted[i] = PT.rep((String)lst[i], (String)aref, (String)"A");
            }
            Arrays.sort(sorted);
            for (i = 0; i < n; ++i) {
                sorted[i] = PT.rep((String)sorted[i], (String)"A", (String)aref);
            }
            if (Logger.debuggingHigh) {
                for (i = 0; i < n; ++i) {
                    Logger.info((String)("Sorted Mata list " + i + " " + aref + ": " + (String)sorted[i]));
                }
            }
            return sorted;
        }

        String createAuxiliaryRSCenters(CIPAtom node1, CIPAtom[] ret) {
            if (this.auxParentReversed != null) {
                this.auxParentReversed.createAuxiliaryRSCenters(null, null);
            }
            if (this.auxPseudo != null) {
                this.auxPseudo.createAuxiliaryRSCenters(null, null);
            }
            int rs = -1;
            String subRS = "";
            String s = node1 == null ? "" : "~";
            boolean isBranch = false;
            if (this.atom != null) {
                this.rule4List = new String[4];
                int[] mataList = new int[4];
                int nRS = 0;
                CIPAtom[] ret1 = new CIPAtom[1];
                for (int i = 0; i < 4; ++i) {
                    CIPAtom a = this.atoms[i];
                    if (a != null) {
                        a.set();
                    }
                    if (a == null || a.isDuplicate || a.isTerminal) continue;
                    a.priority = this.priorities[i];
                    ret1[0] = null;
                    String ssub = a.createAuxiliaryRSCenters(node1 == null ? a : node1, ret1);
                    if (ret1[0] != null) {
                        a.nextChiralBranch = ret1[0];
                        if (ret != null) {
                            ret[0] = ret1[0];
                        }
                    }
                    this.rule4List[i] = a.priority + ssub;
                    if (a.nextChiralBranch != null || this.isChiralSequence(ssub)) {
                        mataList[nRS] = i;
                        ++nRS;
                        subRS = subRS + ssub;
                        continue;
                    }
                    this.rule4List[i] = null;
                }
                int adj = 0;
                switch (nRS) {
                    case 0: {
                        subRS = "";
                        break;
                    }
                    case 1: {
                        break;
                    }
                    case 2: {
                        if (node1 == null) break;
                        adj = this.compareRule4aEnantiomers(this.rule4List[mataList[0]], this.rule4List[mataList[1]]);
                        switch (adj) {
                            case 0x7FFFFFFF: {
                                isBranch = true;
                                s = "";
                                break;
                            }
                            case -2147483648: {
                                s = "";
                                isBranch = true;
                                adj = 0;
                                break;
                            }
                            case 0: {
                                isBranch = true;
                                s = "u";
                                subRS = "";
                                if (ret == null) break;
                                ret[0] = null;
                                break;
                            }
                            case -1: 
                            case 1: {
                                isBranch = true;
                                subRS = "";
                            }
                        }
                        break;
                    }
                    case 3: 
                    case 4: {
                        s = "";
                        isBranch = true;
                    }
                }
                if (isBranch) {
                    subRS = "";
                    if (ret != null && s != "u") {
                        ret[0] = this;
                    }
                }
                if (!(isBranch && adj != -1 && adj != 1 || this.isAlkene && this.alkeneChild != null || node1 == null || (this.bondCount != 4 || this.nPriorities < 3 - Math.abs(adj)) && (!this.isTrigonalPyramidal || this.nPriorities < 2 - Math.abs(adj)))) {
                    if (isBranch) {
                        switch (this.checkPseudoHandedness(mataList, null)) {
                            case 1: {
                                s = "r";
                                break;
                            }
                            case 2: {
                                s = "s";
                            }
                        }
                        subRS = "";
                        if (ret != null) {
                            ret[0] = null;
                        }
                    } else {
                        CIPAtom atom1 = (CIPAtom)this.clone();
                        if (atom1.set()) {
                            atom1.addReturnPath(null, this);
                            int thisRule = CIPChirality.this.currentRule;
                            CIPChirality.this.currentRule = 1;
                            atom1.sortSubstituents();
                            CIPChirality.this.currentRule = thisRule;
                            rs = atom1.checkHandedness();
                            s = rs == 1 ? "R" : (rs == 2 ? "S" : "~");
                            node1.addMataRef(this.sphere, this.priority, rs);
                        }
                    }
                }
            }
            s = s + subRS;
            if (Logger.debugging && !s.equals("~")) {
                Logger.info((String)("creating aux " + this.myPath + s));
            }
            return s;
        }

        private boolean isChiralSequence(String ssub) {
            return ssub.indexOf("R") >= 0 || ssub.indexOf("S") >= 0 || ssub.indexOf("r") >= 0 || ssub.indexOf("s") >= 0 || ssub.indexOf("u") >= 0;
        }

        private void addMataRef(int sphere, int priority, int rs) {
            int n;
            if (this.rule4Count == null) {
                this.rule4Count = new int[]{Integer.MAX_VALUE, 0, 0};
            }
            if ((n = sphere * 10 + priority) <= this.rule4Count[0]) {
                if (n < this.rule4Count[0]) {
                    this.rule4Count[0] = n;
                    this.rule4Count[2] = 0;
                    this.rule4Count[1] = 0;
                }
                int n2 = rs;
                this.rule4Count[n2] = this.rule4Count[n2] + 1;
            }
        }

        private int compareRule4aEnantiomers(String rs1, String rs2) {
            if (rs1.indexOf("R") < 0 && rs1.indexOf("S") < 0 || rs1.charAt(0) != rs2.charAt(0)) {
                return Integer.MIN_VALUE;
            }
            int n = rs1.length();
            if (n != rs2.length()) {
                return Integer.MIN_VALUE;
            }
            if (rs1.equals(rs2)) {
                return 0;
            }
            System.out.println("testing ~RS here with " + rs1 + " and " + rs2);
            return this.checkEnantiomer(rs1, rs2, 1, n, "~RS");
        }

        private int checkEnantiomer(String rs1, String rs2, int m, int n, String rs) {
            int finalScore = 0;
            for (int i = m; i < n; ++i) {
                int i1 = rs.indexOf(rs1.charAt(i));
                int score = i1 + rs.indexOf(rs2.charAt(i));
                if (score != 0 && score != 3) {
                    return Integer.MAX_VALUE;
                }
                if (finalScore != 0) continue;
                finalScore = i1 == 1 ? -1 : 1;
            }
            return finalScore;
        }

        private int checkPseudoHandedness(int[] iab, int[] indices) {
            CIPAtom atom1;
            int ib;
            int ia = indices == null ? iab[0] : indices[iab[0]];
            int n = ib = indices == null ? iab[1] : indices[iab[1]];
            if (this.auxPseudo == null) {
                atom1 = (CIPAtom)this.clone();
                atom1.atoms[ia] = new CIPAtom().create(null, atom1, false, this.isAlkene);
                atom1.atoms[ib] = new CIPAtom().create(null, atom1, false, this.isAlkene);
                atom1.addReturnPath(null, this);
            } else {
                atom1 = this.auxPseudo;
            }
            int thisRule = CIPChirality.this.currentRule;
            CIPChirality.this.currentRule = 1;
            atom1.sortSubstituents();
            CIPChirality.this.currentRule = thisRule;
            atom1.atoms[this.bondCount - 2] = this.atoms[Math.min(ia, ib)];
            atom1.atoms[this.bondCount - 1] = this.atoms[Math.max(ia, ib)];
            int rs = atom1.checkHandedness();
            if (Logger.debugging) {
                for (int i = 0; i < 4; ++i) {
                    Logger.info((String)("pseudo " + rs + " " + this.priorities[i] + " " + this.atoms[i].myPath));
                }
            }
            return rs;
        }

        private void replaceParentSubstituent(CIPAtom newParent, CIPAtom newSub) {
            for (int i = 0; i < 4; ++i) {
                if (this.atoms[i] != newParent && (newParent != null || this.atoms[i].atom != null)) continue;
                this.atoms[i] = newSub;
                if (Logger.debugging) {
                    Logger.info((String)("replace " + this + "[" + i + "]=" + newSub));
                }
                this.prevPriorities[i] = this.atoms[i].getBasePriority(true);
                this.parent = newParent;
                return;
            }
        }

        private CIPAtom getTopAtom() {
            int i;
            int n = i = this.atoms[0].isDuplicate ? 1 : 0;
            return this.priorities[i] == this.priorities[i + 1] ? null : (this.priorities[i] < this.priorities[i + 1] ? this.atoms[i] : this.atoms[i + 1]);
        }

        private int checkRule5(CIPAtom b) {
            int isRb;
            if (this.isTerminal || this.isDuplicate) {
                return 0;
            }
            int isRa = ";SRPMTC;".indexOf(this.knownAtomChirality);
            return isRa == (isRb = ";SRPMTC;".indexOf(b.knownAtomChirality)) ? 0 : (isRa > isRb ? -1 : 1);
        }

        int checkHandedness() {
            P3 p1 = this.atoms[0].atom.getXYZ();
            P3 p2 = this.atoms[1].atom.getXYZ();
            P3 p3 = this.atoms[2].atom.getXYZ();
            P3 p4 = this.lonePair == null ? this.atoms[3].atom.getXYZ() : this.lonePair;
            float d = Measure.getNormalThroughPoints((T3)p1, (T3)p2, (T3)p3, (T3)CIPChirality.this.vNorm, (T3)CIPChirality.this.vTemp);
            return Measure.distanceToPlaneV((V3)CIPChirality.this.vNorm, (float)d, (P3)p4) > 0.0f ? 1 : 2;
        }

        public Object clone() {
            CIPAtom a = null;
            try {
                a = (CIPAtom)super.clone();
            }
            catch (CloneNotSupportedException e) {
                // empty catch block
            }
            a.id = CIPChirality.this.ptID++;
            a.atoms = new CIPAtom[4];
            a.priorities = new int[4];
            a.prevPriorities = new int[]{-1, -1, -1, -1};
            a.htPathPoints = this.htPathPoints;
            for (int i = 0; i < 4; ++i) {
                a.priorities[i] = this.priorities[i];
                if (this.atoms[i] == null) continue;
                a.atoms[i] = this.atoms[i];
                a.prevPriorities[i] = this.atoms[i].getBasePriority(true);
            }
            if (Logger.debugging) {
                Logger.info((String)("cloning " + this + " as " + a));
            }
            return a;
        }

        public String toString() {
            return this.atom == null ? "<null>" : "[" + CIPChirality.this.currentRule + "." + this.sphere + "," + this.rootDistance + "." + this.id + "." + this.atom.getAtomName() + (this.isDuplicate ? "*" : "") + "]";
        }
    }
}

