/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.actions;

import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.actions.JosmAction;
import org.openstreetmap.josm.actions.downloadtasks.AbstractDownloadTask;
import org.openstreetmap.josm.actions.downloadtasks.DownloadGpsTask;
import org.openstreetmap.josm.actions.downloadtasks.DownloadNotesTask;
import org.openstreetmap.josm.actions.downloadtasks.DownloadOsmTask;
import org.openstreetmap.josm.actions.downloadtasks.PostDownloadHandler;
import org.openstreetmap.josm.data.Bounds;
import org.openstreetmap.josm.data.ProjectionBounds;
import org.openstreetmap.josm.data.ViewportData;
import org.openstreetmap.josm.gui.download.DownloadDialog;
import org.openstreetmap.josm.gui.help.HelpUtil;
import org.openstreetmap.josm.gui.util.GuiHelper;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.Pair;
import org.openstreetmap.josm.tools.Shortcut;

public class DownloadAction
extends JosmAction {
    public DownloadAction() {
        super(I18n.tr("Download from OSM...", new Object[0]), "download", I18n.tr("Download map data from the OSM server.", new Object[0]), Shortcut.registerShortcut("file:download", I18n.tr("File: {0}", I18n.tr("Download from OSM...", new Object[0])), 40, 5009), true);
        this.putValue("help", HelpUtil.ht("/Action/Download"));
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        DownloadDialog downloadDialog = DownloadDialog.getInstance();
        downloadDialog.restoreSettings();
        downloadDialog.setVisible(true);
        if (!downloadDialog.isCanceled()) {
            Future<?> future;
            AbstractDownloadTask abstractDownloadTask;
            downloadDialog.rememberSettings();
            Bounds bounds = downloadDialog.getSelectedDownloadArea();
            boolean bl = downloadDialog.isZoomToDownloadedDataRequired();
            ArrayList arrayList = new ArrayList();
            if (downloadDialog.isDownloadOsmData()) {
                abstractDownloadTask = new DownloadOsmTask();
                abstractDownloadTask.setZoomAfterDownload(bl && !downloadDialog.isDownloadGpxData() && !downloadDialog.isDownloadNotes());
                future = ((DownloadOsmTask)abstractDownloadTask).download(downloadDialog.isNewLayerRequired(), bounds, null);
                Main.worker.submit(new PostDownloadHandler(abstractDownloadTask, future));
                if (bl) {
                    arrayList.add(new Pair(abstractDownloadTask, future));
                }
            }
            if (downloadDialog.isDownloadGpxData()) {
                abstractDownloadTask = new DownloadGpsTask();
                abstractDownloadTask.setZoomAfterDownload(bl && !downloadDialog.isDownloadOsmData() && !downloadDialog.isDownloadNotes());
                future = ((DownloadGpsTask)abstractDownloadTask).download(downloadDialog.isNewLayerRequired(), bounds, null);
                Main.worker.submit(new PostDownloadHandler(abstractDownloadTask, future));
                if (bl) {
                    arrayList.add(new Pair(abstractDownloadTask, future));
                }
            }
            if (downloadDialog.isDownloadNotes()) {
                abstractDownloadTask = new DownloadNotesTask();
                abstractDownloadTask.setZoomAfterDownload(bl && !downloadDialog.isDownloadOsmData() && !downloadDialog.isDownloadGpxData());
                future = ((DownloadNotesTask)abstractDownloadTask).download(false, bounds, null);
                Main.worker.submit(new PostDownloadHandler(abstractDownloadTask, future));
                if (bl) {
                    arrayList.add(new Pair(abstractDownloadTask, future));
                }
            }
            if (bl && arrayList.size() > 1) {
                Main.worker.submit(() -> {
                    ProjectionBounds projectionBounds = null;
                    for (Pair pair : arrayList) {
                        try {
                            ((Future)pair.b).get();
                            ProjectionBounds projectionBounds2 = ((AbstractDownloadTask)pair.a).getDownloadProjectionBounds();
                            if (projectionBounds == null) {
                                projectionBounds = projectionBounds2;
                                continue;
                            }
                            if (projectionBounds2 == null) continue;
                            projectionBounds.extend(projectionBounds2);
                        }
                        catch (InterruptedException | ExecutionException exception) {
                            Main.warn(exception);
                        }
                    }
                    if (Main.map != null && projectionBounds != null) {
                        Iterator iterator = projectionBounds;
                        GuiHelper.runInEDTAndWait(() -> Main.map.mapView.zoomTo(new ViewportData((ProjectionBounds)((Object)iterator))));
                    }
                });
            }
        }
    }
}

