/*
 * Decompiled with CFR 0.152.
 */
package bt747.j2se_view;

import bt747.j2se_view.BT747Main;
import bt747.j2se_view.ExternalConversionDialog;
import bt747.j2se_view.ExternalToolConvert;
import bt747.j2se_view.GPSKMZFile;
import bt747.j2se_view.GpsFileProxyTemplate;
import bt747.j2se_view.J2SEAppModel;
import bt747.j2se_view.J2SEController;
import bt747.j2se_view.OsmUploadDialog;
import bt747.j2se_view.PositionTablePanel;
import bt747.model.Controller;
import bt747.model.EventPoster;
import bt747.model.Model;
import bt747.model.ModelEvent;
import bt747.sys.Generic;
import bt747.sys.I18N;
import bt747.sys.Settings;
import bt747.sys.interfaces.BT747Exception;
import bt747.sys.interfaces.BT747Vector;
import gps.GpsEvent;
import gps.log.GPSRecord;
import gps.log.TracksAndWayPoints;
import gps.log.out.AllWayPointStyles;
import gps.log.out.GPSFile;
import gps.log.out.GPSFileInterface;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Image;
import java.awt.Toolkit;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.net.URL;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.ResourceBundle;
import java.util.Vector;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.InputVerifier;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.UIDefaults;
import javax.swing.UIManager;
import javax.swing.plaf.FontUIResource;
import javax.swing.text.JTextComponent;
import net.sf.bt747.j2se.app.BT747Translation;
import net.sf.bt747.j2se.app.osm.GPSOSMUploadFile;

public final class J2SEAppController
extends J2SEController {
    private static final String CONFIG_FILE_NAME = System.getProperty("bt747_settings", System.getProperty("user.home").length() != 0 ? System.getProperty("user.home") + System.getProperty("file.separator") + "BT747SettingsJ2SE.pdb" : (platform.startsWith("Win32") || platform.startsWith("Windows") || platform.startsWith("Mac") ? "BT747SettingsJ2SE.pdb" : "/My Documents/BT747/BT747SettingsJ2SE.pdb"));
    private static Image appIcon;
    private static Image app128Icon;
    private J2SEAppModel m;
    private boolean loggerNeedsFormatQuestionAsked;
    private Controller c;
    private static String[] C_ERASE_OR_CANCEL;
    private static String[] C_YES_OR_CANCEL;
    private static String[] C_CANCEL_OR_CONFIRM_ERASE;
    private int startTimeNoOffset;
    private int endTimeNoOffset;
    private int timeOffset;
    private static ResourceBundle bundle;
    private JOptionPane mbErase;
    private static Frame rootFrame;
    private JDialog mbEraseDialog;
    private static final String[] lookAndFeels;
    private static final int C_MAC_LOOKANDFEEL_IDX;
    public static String lookAndFeelMsg;
    public static final InputVerifier IntVerifier;
    public static final InputVerifier FloatVerifier;
    private boolean changeToMap;

    public final void modelEvent(ModelEvent object) {
        super.modelEvent((ModelEvent)object);
        switch (((GpsEvent)object).getType()) {
            case 28: {
                if (this.loggerNeedsFormatQuestionAsked || !this.m.isLoggerNeedsFormat()) break;
                this.loggerNeedsFormatQuestionAsked = true;
                object = this;
                if (JOptionPane.showOptionDialog(rootFrame, J2SEAppController.getString("LOGGER_NEEDS_FORMAT_TEXT"), J2SEAppController.getString("LOGGER_NEEDS_FORMAT_TITLE"), 2, 2, null, C_ERASE_OR_CANCEL, C_ERASE_OR_CANCEL[1]) == 0) {
                    ((Controller)object).eraseLog();
                }
                return;
            }
            case 266: {
                this.loggerNeedsFormatQuestionAsked = false;
                return;
            }
            case 38: {
                J2SEAppController.notifyBT747Exception((BT747Exception)((GpsEvent)object).getArg());
                return;
            }
            case 269: {
                switch (Integer.parseInt((String)((GpsEvent)object).getArg())) {
                    case 71: {
                        this.setScale();
                    }
                }
            }
        }
    }

    public static final void notifyBT747Exception(BT747Exception bT747Exception) {
        if (bT747Exception.getMessage().equals("open")) {
            J2SEAppController.reportError(-1, bT747Exception.getCause().getMessage());
            return;
        }
        JOptionPane.showMessageDialog(rootFrame, "<html><b>" + bT747Exception.getCause() + "</b><br><p>" + bT747Exception.getMessage(), J2SEAppController.getString("OPERATION_FAILED"), 0);
    }

    public static final Locale localeFromString(String string) {
        if (string.length() != 0) {
            String string2 = "";
            String string3 = "";
            String string4 = "";
            if (string.length() >= 2) {
                string2 = string.substring(0, 2);
            }
            if (string.length() >= 5) {
                string3 = string.substring(3, 5);
            }
            if (string.length() >= 8) {
                string4 = string.substring(6);
            }
            return new Locale(string2, string3, string4);
        }
        return Locale.getDefault();
    }

    public J2SEAppController(J2SEAppModel stringArray) {
        new HashSet();
        this.changeToMap = false;
        J2SEController.setSystemProxies((Model)stringArray);
        this.m = stringArray;
        this.c = this;
        this.m.init();
        super.setModel(this.m);
        super.init();
        Locale.setDefault(J2SEAppController.localeFromString(this.m.getStringOpt(13)));
        Generic.setPoster((EventPoster)stringArray);
        I18N.setI18N(BT747Translation.getInstance());
        if (bundle == null) {
            bundle = ResourceBundle.getBundle("bt747/j2se_view/Bundle");
            stringArray = new String[]{J2SEAppController.getString("ERASE_BUTTON"), J2SEAppController.getString("CANCEL_BUTTON")};
            String[] stringArray2 = new String[]{J2SEAppController.getString("YES_BUTTON"), J2SEAppController.getString("CANCEL_BUTTON")};
            String[] stringArray3 = new String[]{J2SEAppController.getString("CANCEL_BUTTON"), J2SEAppController.getString("CONFIRM_ERASE_BUTTON")};
            C_ERASE_OR_CANCEL = stringArray;
            C_YES_OR_CANCEL = stringArray2;
            C_CANCEL_OR_CONFIRM_ERASE = stringArray3;
        }
        J2SEAppController.myLookAndFeel();
        this.c.setWayPointStyles(new AllWayPointStyles());
        this.setScale();
    }

    public final void setLogConversionParameters() {
        int n = this.timeOffset + this.startTimeNoOffset;
        int n2 = this.timeOffset + this.endTimeNoOffset;
        this.c.setFilterStartTime(n);
        this.c.setFilterEndTime(n2);
    }

    public final void convertLog(int n) {
        this.c.setUserWayPoints(this.m.getPositionData().getSortedWaypointGPSRecords());
        switch (n) {
            case 11: {
                if (this.doConvertLog(n, new GPSKMZFile(), ".kmz") == 0) break;
                J2SEAppController.reportError(this.c.getLastError(), this.c.getLastErrorInfo());
                break;
            }
            case 15: {
                OsmUploadDialog osmUploadDialog = new OsmUploadDialog(this, rootFrame);
                osmUploadDialog.setVisible(true);
                if (osmUploadDialog.getReturnStatus() != 1) break;
                if (this.m.getStringOpt(57).length() == 0 || this.m.getStringOpt(58).length() == 0) {
                    J2SEAppController.reportError(-1, J2SEAppController.getString("OSM_LOGIN_AND_PASS_SET"));
                    return;
                }
                GPSOSMUploadFile gPSOSMUploadFile = new GPSOSMUploadFile();
                gPSOSMUploadFile.getParamObject().setParam("osm-visibility", osmUploadDialog.getVisibility());
                gPSOSMUploadFile.getParamObject().setParam("osm-tags", osmUploadDialog.getTags());
                gPSOSMUploadFile.getParamObject().setParam("osm-description", osmUploadDialog.getDescription());
                if (this.doConvertLog(14, gPSOSMUploadFile, ".gpx") == 0) break;
                J2SEAppController.reportError(this.c.getLastError(), this.c.getLastErrorInfo());
                break;
            }
            case 16: {
                J2SEAppController j2SEAppController = this;
                Object object = new ExternalConversionDialog(rootFrame);
                ((ExternalConversionDialog)object).setExternalProgram(j2SEAppController.m.getStringOpt(69));
                ((ExternalConversionDialog)object).setIntermediateFormatType(j2SEAppController.m.getIntOpt(70));
                ((Dialog)object).setVisible(true);
                if (((ExternalConversionDialog)object).getReturnStatus() != 1) break;
                int n2 = ((ExternalConversionDialog)object).getIntermediateFormatType();
                object = ((ExternalConversionDialog)object).getExternalProgram();
                j2SEAppController.c.setStringOpt(69, (String)object);
                j2SEAppController.c.setIntOpt(70, n2);
                j2SEAppController.doExternalTool(n2, (String)object);
                break;
            }
            case 22: {
                this.doExternalTool(22, J2SEAppController.getString("EXT_GPS2KML_COMMAND"));
                break;
            }
            default: {
                if (this.doConvertLog(n) == 0) break;
                J2SEAppController.reportError(this.c.getLastError(), this.c.getLastErrorInfo());
            }
        }
        this.m.getPositionData().userWaypointsUpdated();
    }

    private void doExternalTool(int n, String string) {
        GPSFileInterface gPSFileInterface = this.getOutFileHandler(n);
        gPSFileInterface = new ExternalToolConvert((GPSFile)gPSFileInterface);
        ((GpsFileProxyTemplate)gPSFileInterface).getParamObject().setParam("ext-cmd", string);
        if (this.doConvertLog(n, gPSFileInterface, "_tmp" + this.getOutFileExt(n)) != 0) {
            J2SEAppController.reportError(this.c.getLastError(), this.c.getLastErrorInfo());
        }
    }

    public final TracksAndWayPoints convertLogToTrackAndWayPoints() {
        this.c.setUserWayPoints(this.m.getPositionData().getSortedWaypointGPSRecords());
        TracksAndWayPoints tracksAndWayPoints = this.c.doConvertLogToTracksAndWayPoints();
        if (tracksAndWayPoints == null) {
            J2SEAppController.reportError(this.c.getLastError(), this.c.getLastErrorInfo());
        }
        this.m.getPositionData().dataUpdated();
        return tracksAndWayPoints;
    }

    public static final String getString(String string) {
        try {
            return bundle.getString(string);
        }
        catch (Exception exception) {
            Generic.debug("No text found for \"" + string + "\"", exception);
            return string;
        }
    }

    public static final Icon getIcon(String object) {
        ImageIcon imageIcon = null;
        try {
            object = BT747Main.class.getResource("/bt747/j2se_view/resources/" + (String)object);
            imageIcon = new ImageIcon((URL)object);
        }
        catch (Exception exception) {}
        return imageIcon;
    }

    public final void recoveryErase() {
        if (JOptionPane.showOptionDialog(rootFrame, J2SEAppController.getString("ERASE_WARNING_1_TEXT"), J2SEAppController.getString("ERASE_WARNING_TITLE"), 2, 2, null, C_ERASE_OR_CANCEL, C_ERASE_OR_CANCEL[1]) == 0 && JOptionPane.showOptionDialog(rootFrame, J2SEAppController.getString("ERASE_WARNING_2_TEXT"), J2SEAppController.getString("ERASE_WARNING_TITLE"), 2, 2, null, C_CANCEL_OR_CONFIRM_ERASE, C_CANCEL_OR_CONFIRM_ERASE[0]) == 1) {
            this.c.recoveryEraseLog();
        }
    }

    public final void changeLogFormatAndErase(int n) {
        if (JOptionPane.showOptionDialog(rootFrame, J2SEAppController.getString("FORMAT_ERASE_WARNING_TEXT"), J2SEAppController.getString("ATTENTION"), 2, 2, null, C_ERASE_OR_CANCEL, C_ERASE_OR_CANCEL[1]) == 0 && JOptionPane.showOptionDialog(rootFrame, J2SEAppController.getString("FORMAT_ERASE_WARNING2_TEXT"), J2SEAppController.getString("ATTENTION"), 2, 2, null, C_CANCEL_OR_CONFIRM_ERASE, C_CANCEL_OR_CONFIRM_ERASE[0]) == 1) {
            this.c.setLogFormat(n);
            this.c.eraseLog();
        }
    }

    public final void changeLogFormat(int n) {
        if (JOptionPane.showOptionDialog(rootFrame, J2SEAppController.getString("CHANGE_LOG_FORMAT_TEXT"), J2SEAppController.getString("ATTENTION"), 2, 2, null, C_YES_OR_CANCEL, C_YES_OR_CANCEL[1]) == 0) {
            this.c.setLogFormat(n);
        }
    }

    public final void eraseLogWithDialogs() {
        if (JOptionPane.showOptionDialog(rootFrame, J2SEAppController.getString("ERASE_WARNING_1_TEXT"), J2SEAppController.getString("ERASE_WARNING_TITLE"), 2, 2, null, C_ERASE_OR_CANCEL, C_ERASE_OR_CANCEL[1]) == 0 && JOptionPane.showOptionDialog(rootFrame, J2SEAppController.getString("ERASE_WARNING_2_TEXT"), J2SEAppController.getString("ERASE_WARNING_TITLE"), 2, 2, null, C_CANCEL_OR_CONFIRM_ERASE, C_CANCEL_OR_CONFIRM_ERASE[0]) == 1) {
            this.c.eraseLog();
        }
    }

    public final void doFactoryReset() {
        if (JOptionPane.showOptionDialog(rootFrame, J2SEAppController.getString("FACT_RESET_TEXT"), J2SEAppController.getString("ATTENTION"), 2, 2, null, null, 0) == 0) {
            this.c.gpsCmd(3);
        }
    }

    public final void setFlashConfig$e5ebae1(int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9, int n10) {
        Object[] objectArray = new String[]{J2SEAppController.getString("WRITE_FLASH_BUTTON"), J2SEAppController.getString("CANCEL_BUTTON")};
        if (JOptionPane.showOptionDialog(rootFrame, J2SEAppController.getString("FLASH_LIMITED_TEXT"), J2SEAppController.getString("ATTENTION"), 2, 2, null, objectArray, objectArray[1]) == 0) {
            this.c.setFlashUserOption(false, n, n2, n3, n4, n5, n6, n7, n8, n9, n10);
        }
    }

    private static void reportError(int n, String string) {
        switch (n) {
            case -1: {
                String string2 = J2SEAppController.getString("COULD_NOT_OPEN_FILE") + string;
                Generic.debug(string2);
                JOptionPane.showMessageDialog(rootFrame, string2, J2SEAppController.getString("ERROR_TITLE"), 0);
                return;
            }
            case -2: {
                JOptionPane.showMessageDialog(rootFrame, J2SEAppController.getString("NO_FILES_CREATED"), J2SEAppController.getString("WARNING_TITLE"), 2);
                return;
            }
            case -3: {
                JOptionPane.showMessageDialog(rootFrame, J2SEAppController.getString("PROBLEM_READING") + string, J2SEAppController.getString("ERROR_TITLE"), 0);
            }
        }
    }

    public final void performOperationsAfterGPSConnect() {
        if (this.m.isConnected()) {
            if (this.m.getBooleanOpt(8)) {
                this.c.setLoggingActive(false);
                this.c.setLoggingActive(false);
            }
            super.performOperationsAfterGPSConnect();
            this.saveSettings();
        }
    }

    public static final void initAppSettings() {
        J2SEAppModel.setDefaultBaseDirPath(System.getProperty("user.home"));
        if (Settings.getAppSettings() == null || Settings.getAppSettings().length() < 100 || System.getProperty("bt747_settings") != null) {
            Settings.setAppSettings(new String(new byte[2633]));
            FileInputStream fileInputStream = null;
            try {
                fileInputStream = new FileInputStream(CONFIG_FILE_NAME);
                int n = fileInputStream.available();
                if (n >= 100) {
                    byte[] byArray = new byte[Math.max(2633, n)];
                    fileInputStream.read(byArray, 0, n);
                    Settings.setAppSettings(new String(byArray));
                }
            }
            catch (Exception exception) {}
            try {
                if (fileInputStream != null) {
                    fileInputStream.close();
                }
                return;
            }
            catch (Exception exception) {}
        }
    }

    public final void saveSettings() {
        Object object;
        Generic.debug("Attempting saving settings to " + CONFIG_FILE_NAME);
        try {
            File file;
            int n = Math.max(CONFIG_FILE_NAME.lastIndexOf(47), CONFIG_FILE_NAME.lastIndexOf(92));
            if (n != -1 && !(file = new File(CONFIG_FILE_NAME.substring(0, n))).exists()) {
                file.mkdirs();
            }
        }
        catch (Exception exception) {
            Generic.debug("Directory creation failed for " + CONFIG_FILE_NAME, exception);
        }
        try {
            object = new File(CONFIG_FILE_NAME);
            if (((File)object).exists()) {
                ((File)object).delete();
            }
        }
        catch (Exception exception) {
            Generic.debug("Deleting file failed for " + CONFIG_FILE_NAME, exception);
        }
        try {
            new File(CONFIG_FILE_NAME).createNewFile();
            object = new FileOutputStream(CONFIG_FILE_NAME);
            ((FileOutputStream)object).write(Settings.getAppSettings().getBytes(), 0, Settings.getAppSettings().length());
            ((FileOutputStream)object).close();
            Generic.debug("Writing settings success for " + CONFIG_FILE_NAME);
            return;
        }
        catch (Exception exception) {
            Generic.debug("Writing settings file failed for " + CONFIG_FILE_NAME, exception);
            return;
        }
    }

    public static void setRootFrame(Frame frame) {
        rootFrame = frame;
        rootFrame.setIconImage(appIcon);
    }

    public final void createErasePopup() {
        Object[] objectArray = new String[]{J2SEAppController.getString("CANCEL")};
        this.mbErase = new JOptionPane(J2SEAppController.getString("WAITING_ERASE_TEXT"), 2);
        this.mbErase.setOptions(objectArray);
        this.mbErase.setVisible(true);
        this.mbEraseDialog = this.mbErase.createDialog(rootFrame, J2SEAppController.getString("WAITING_ERASE_TITLE"));
        this.mbEraseDialog.setDefaultCloseOperation(0);
        this.mbErase.addPropertyChangeListener(new PropertyChangeListener(this){
            private /* synthetic */ J2SEAppController this$0;
            {
                this.this$0 = j2SEAppController;
            }

            public final void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                String string = propertyChangeEvent.getPropertyName();
                if (this.this$0.mbEraseDialog != null && this.this$0.mbEraseDialog.isVisible() && propertyChangeEvent.getSource() == this.this$0.mbErase && string.equals("value")) {
                    this.this$0.stopErase();
                    this.this$0.removeErasePopup();
                }
            }
        });
        this.mbEraseDialog.pack();
        this.mbEraseDialog.setModal(false);
        this.mbEraseDialog.setVisible(true);
    }

    public final void removeErasePopup() {
        if (this.mbEraseDialog != null) {
            this.mbEraseDialog.setVisible(false);
            this.mbEraseDialog = null;
            this.mbErase = null;
        }
    }

    public static void showAbout() {
        JOptionPane.showMessageDialog(rootFrame, "<html>BT747 V2.1.3 (22.05.2014)<br>Build: BT747_mdeweerd.3.20140522231606952<br><br>" + J2SEAppController.getString("ABOUT_TEXT"), J2SEAppController.getString("ABOUT_TITLE"), 1, new ImageIcon(app128Icon));
    }

    public static void showLicense() {
        JOptionPane.showMessageDialog(rootFrame, J2SEAppController.getString("LICENSE_TEXT"), J2SEAppController.getString("LICENSE_TITLE"), 1, new ImageIcon(app128Icon));
    }

    public static void couldNotOpenFileMessage(String string) {
        JOptionPane.showMessageDialog(rootFrame, J2SEAppController.getString("Problem_opening_file"), J2SEAppController.getString("The_application_could_not_open_") + string + J2SEAppController.getString("_check_if_loc_exists") + J2SEAppController.getString("in_case_it_is_an_output_file."), 2, null);
    }

    public static boolean getRequestToOverwriteFromDialog() {
        return JOptionPane.showOptionDialog(rootFrame, J2SEAppController.getString("OVERWRITE_DATA_QUESTION"), J2SEAppController.getString("OVERWRITING_DATA"), 0, 2, null, null, null) == 0;
    }

    private static final boolean tryLookAndFeel(String string) {
        try {
            UIManager.setLookAndFeel(string);
            lookAndFeelMsg = lookAndFeelMsg + J2SEAppController.getString("Success_") + string + "\n";
            return true;
        }
        catch (Exception exception) {
            lookAndFeelMsg = lookAndFeelMsg + J2SEAppController.getString("Fail_") + string + "\n";
            return false;
        }
    }

    private static void myLookAndFeel() {
        int n;
        int n2 = 0;
        if (System.getProperty("bt747.laf") != null) {
            n2 = J2SEAppController.tryLookAndFeel(System.getProperty("bt747.laf"));
        }
        if (System.getProperty("os.name").toLowerCase().startsWith("mac")) {
            n = 6;
            while (n2 == 0) {
                if (n >= 9) break;
                n2 = J2SEAppController.tryLookAndFeel(lookAndFeels[n]);
                ++n;
            }
        }
        n = 0;
        while (n2 == 0) {
            if (n >= 9) break;
            n2 = J2SEAppController.tryLookAndFeel(lookAndFeels[n]);
            ++n;
        }
        if (n2 == 0) {
            J2SEAppController.tryLookAndFeel(UIManager.getCrossPlatformLookAndFeelClassName());
        }
        UIManager.LookAndFeelInfo[] lookAndFeelInfoArray = UIManager.getInstalledLookAndFeels();
        for (n2 = 0; n2 < lookAndFeelInfoArray.length; ++n2) {
            lookAndFeelMsg = lookAndFeelMsg + lookAndFeelInfoArray[n2].getClassName() + "\n";
        }
    }

    private void setScale() {
        Object object;
        int n;
        int n2 = n = this.m.getIntOpt(71) & 0xFF;
        Frame frame = rootFrame;
        UIDefaults uIDefaults = UIManager.getDefaults();
        Enumeration enumeration = uIDefaults.keys();
        while (enumeration.hasMoreElements()) {
            object = enumeration.nextElement();
            Object object2 = uIDefaults.get(object);
            if (object2 == null || !(object2 instanceof Font)) continue;
            UIManager.put(object, null);
            object2 = UIManager.getFont(object);
            if (object2 == null) continue;
            float f = ((Font)object2).getSize2D() / 100.0f;
            UIManager.put(object, new FontUIResource(((Font)object2).deriveFont(f * (float)n2)));
        }
        if (frame != null) {
            object = frame.getFont();
            if (object != null) {
                float f = ((Font)object).getSize2D() / 100.0f;
                ((Component)frame).setFont(new FontUIResource(((Font)object).deriveFont(f * (float)n2)));
            }
            if (frame instanceof Frame) {
                Frame frame2 = frame;
                frame2.getLayout().layoutContainer(frame2);
            }
            if (frame.isVisible()) {
                ((Component)frame).setVisible(false);
                ((Component)frame).setVisible(true);
            }
            ((Component)frame).validate();
        }
    }

    public final void selectMapCacheDirectory() {
        File file = new File(this.m.getStringOpt(25));
        Object object = new JFileChooser(file);
        ((JFileChooser)object).setSelectedFile(file);
        ((JFileChooser)object).setFileSelectionMode(1);
        ((JComponent)object).setToolTipText(J2SEAppController.getString("SelectCacheDirectory.tooltip"));
        if (((JFileChooser)object).showDialog(rootFrame, J2SEAppController.getString("SetCacheDir.button")) == 0) {
            try {
                object = ((JFileChooser)object).getSelectedFile().getCanonicalPath();
                if (((String)object).lastIndexOf(46) == ((String)object).length() - 4) {
                    object = ((String)object).substring(0, ((String)object).length() - 4);
                }
                this.c.setStringOpt(25, (String)object);
                return;
            }
            catch (Exception exception) {
                Generic.debug(J2SEAppController.getString("CacheDirChooser"), exception);
            }
        }
    }

    public static final void enableComponentHierarchy(Component componentArray, boolean bl) {
        if (componentArray instanceof JPanel) {
            for (Component component : ((JPanel)componentArray).getComponents()) {
                component.setEnabled(bl);
                if (component.getClass() != JPanel.class) continue;
                J2SEAppController.enableComponentHierarchy((JPanel)component, bl);
            }
            return;
        }
        componentArray.setEnabled(bl);
    }

    public final void doLogConversion(int n) {
        new Thread(this, "convert", n){
            private /* synthetic */ int val$selectedFormat;
            private /* synthetic */ J2SEAppController this$0;
            {
                this.this$0 = j2SEAppController;
                this.val$selectedFormat = n;
                super(string);
            }

            public final void run() {
                switch (this.val$selectedFormat) {
                    case 12: {
                        TracksAndWayPoints tracksAndWayPoints = this.this$0.convertLogToTrackAndWayPoints();
                        if (tracksAndWayPoints != null) {
                            new PositionTablePanel().setGpsRecords(tracksAndWayPoints.getTrackPoints());
                            new PositionTablePanel().setGpsRecords(tracksAndWayPoints.getWayPoints());
                            this.this$0.m.getPositionData().setWayPoints(tracksAndWayPoints.getWayPoints());
                            Vector<List<GPSRecord>> vector = new Vector<List<GPSRecord>>(tracksAndWayPoints.tracks.size());
                            for (int i = 0; i < tracksAndWayPoints.tracks.size(); ++i) {
                                BT747Vector bT747Vector = (BT747Vector)tracksAndWayPoints.tracks.elementAt(i);
                                Vector<GPSRecord> vector2 = new Vector<GPSRecord>(bT747Vector.size());
                                for (int j = 0; j < bT747Vector.size(); ++j) {
                                    vector2.add((GPSRecord)bT747Vector.elementAt(j));
                                }
                                vector.add(vector2);
                            }
                            this.this$0.m.getPositionData().setTracks(vector);
                        } else {
                            this.this$0.m.getPositionData().setWayPoints(null);
                            this.this$0.m.getPositionData().setTracks(null);
                        }
                        if (!this.this$0.changeToMap) break;
                        this.this$0.m.postEvent(new ModelEvent(1003, null));
                        return;
                    }
                    default: {
                        this.this$0.convertLog(this.val$selectedFormat);
                    }
                }
            }
        }.start();
    }

    public final J2SEAppModel getAppModel() {
        return this.m;
    }

    public final void setStartTimeNoOffset(int n) {
        this.startTimeNoOffset = n;
    }

    public final void setEndTimeNoOffset(int n) {
        this.endTimeNoOffset = n;
    }

    public final void setTimeOffset(int n) {
        this.timeOffset = n;
    }

    public final void setChangeToMap(boolean bl) {
        this.changeToMap = bl;
    }

    static {
        URL uRL = BT747Main.class.getResource("/icons/bt747_16x16.gif");
        appIcon = uRL != null ? Toolkit.getDefaultToolkit().getImage(uRL) : Toolkit.getDefaultToolkit().getImage("icons/bt747_16x16.gif");
        uRL = BT747Main.class.getResource("/icons/bt747_128x128.gif");
        app128Icon = uRL != null ? Toolkit.getDefaultToolkit().getImage(uRL) : Toolkit.getDefaultToolkit().getImage("icons/bt747_128x128.gif");
        bundle = null;
        rootFrame = null;
        lookAndFeels = new String[]{"com.sun.java.swing.plaf.windows.WindowsLookAndFeel", "com.sun.java.swing.plaf.windows.WindowsClassicLookAndFeel", "com.sun.java.swing.plaf.nimbus.NimbusLookAndFeel", "com.sun.java.swing.plaf.gtk.GTKLookAndFeel", "com.sun.java.swing.plaf.motif.MotifLookAndFeel", "javax.swing.plaf.metal.MetalLookAndFeel", "com.apple.mrj.swing.MacLookAndFeel", "apple.laf.AquaLookAndFeel", "javax.swing.plaf.mac.MacLookAndFeel"};
        C_MAC_LOOKANDFEEL_IDX = 6;
        lookAndFeelMsg = "";
        IntVerifier = new InputVerifier(){

            public final boolean verify(JComponent jComponent) {
                boolean bl;
                jComponent = (JTextField)jComponent;
                try {
                    Integer.parseInt(((JTextComponent)jComponent).getText());
                    bl = true;
                }
                catch (NumberFormatException numberFormatException) {
                    bl = false;
                }
                return bl;
            }
        };
        FloatVerifier = new InputVerifier(){

            public final boolean verify(JComponent jComponent) {
                boolean bl;
                jComponent = (JTextField)jComponent;
                try {
                    Float.parseFloat(((JTextComponent)jComponent).getText());
                    bl = true;
                }
                catch (NumberFormatException numberFormatException) {
                    bl = false;
                }
                return bl;
            }
        };
    }
}

