/*
 * Decompiled with CFR 0.152.
 */
package dguitar.gui;

import common.ScrollText;
import common.SwingWorker;
import common.Util;
import dguitar.adaptors.guitarPro.GPAdaptor;
import dguitar.adaptors.song.Song;
import dguitar.codecs.CodecFormatException;
import dguitar.codecs.guitarPro.GPFormatException;
import dguitar.codecs.guitarPro.GPInputStream;
import dguitar.codecs.guitarPro.GPSong;
import dguitar.codecs.guitarPro.statistics.GPStatsPiece;
import dguitar.codecs.midi.MIDFileFilter;
import dguitar.codecs.midi.MidiOutputStream;
import dguitar.gui.ColorDialog;
import dguitar.gui.DGuitar;
import dguitar.gui.DisplayOptions;
import dguitar.gui.OptionsDisplay;
import dguitar.gui.PlayToolBar;
import dguitar.gui.Playable;
import dguitar.gui.ScoreInformationDialog;
import dguitar.gui.SongPanel;
import dguitar.players.gui.MusicCursorScroller;
import dguitar.players.sound.Arrangement;
import dguitar.players.sound.MasterPlayer;
import dguitar.players.sound.midi.MidiPlayer;
import i18n.Internationalized;
import java.awt.Component;
import java.awt.Container;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JInternalFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.border.SoftBevelBorder;
import javax.swing.event.InternalFrameEvent;
import javax.swing.event.InternalFrameListener;

public class SongInternalFrame
extends JInternalFrame
implements InternalFrameListener,
Internationalized,
OptionsDisplay,
Playable {
    private boolean closeIt = true;
    private String songName;
    private DGuitar parent;
    private JSeparator jSeparator1;
    private JScrollPane JSP;
    private JMenuBar menuChild;
    private JMenu menuFile;
    private JMenuItem menuFileClose;
    private JMenuItem menuFileExportMidi;
    private JMenuItem menuFilePrint;
    private JMenuItem menuFileScoreInformation;
    private JMenuItem menuFileStats;
    private JMenuItem menuFileTextView;
    private JMenu menuView;
    private JMenuItem menuViewColorOptions;
    private JCheckBoxMenuItem menuViewMinPiece;
    private JCheckBoxMenuItem menuViewMultiTrack;
    private JCheckBoxMenuItem menuViewMusicCursors;
    private JCheckBoxMenuItem menuViewSingleMusicCursorsColor;
    private JCheckBoxMenuItem menuViewUnsupportedEffects;
    private JFileChooser fileChooser;
    private GPSong gpSong;
    MasterPlayer player;
    private short status;
    private SongPanel songPanel;
    private ScoreInformationDialog SID;
    private Song song;
    private ScrollText STStats;
    private ScrollText STTextView;
    private SwingWorker workerPlay;
    private DisplayOptions displayOptions;
    private SwingWorker workerStats;
    private long start;
    private long finish;
    PlayToolBar playToolBar;

    public SongInternalFrame() {
        this.parent = null;
        this.displayOptions = new DisplayOptions();
    }

    public SongInternalFrame(String songName, DGuitar DG, DisplayOptions DO, PlayToolBar aPlayToolBar) {
        this.parent = DG;
        this.displayOptions = (DisplayOptions)DO.clone();
        this.playToolBar = aPlayToolBar;
        this.commonConstructor(songName, DG.fileChooser);
    }

    private void commonConstructor(String aSongName, JFileChooser aFileChooser) {
        this.player = null;
        this.song = null;
        this.status = 1;
        this.workerStats = null;
        this.songName = aSongName;
        this.setTitle(aSongName);
        this.STStats = null;
        this.STTextView = null;
        this.fileChooser = aFileChooser;
        this.initComponents();
        this.songPanel = new SongPanel();
        this.setDisplayOptions(this.displayOptions);
        this.getContentPane().add((Component)this.songPanel, "Center");
    }

    public void setDisplayOptions(DisplayOptions aDisplayOptions) {
        this.songPanel.setDisplayOptions(this.displayOptions);
        this.menuViewMultiTrack.setSelected(this.displayOptions.multiTrackView);
        this.menuViewMinPiece.setSelected(this.displayOptions.minPieceSpacing);
        this.menuViewMusicCursors.setSelected(this.displayOptions.displayMusicCursor);
        this.menuViewSingleMusicCursorsColor.setSelected(!this.displayOptions.singleMusicCursorColor);
        this.menuViewUnsupportedEffects.setSelected(this.displayOptions.displayUnsupportedEffects);
    }

    public DisplayOptions getDisplayOptions() {
        return this.displayOptions;
    }

    private void close() {
        if (this.workerStats != null) {
            this.workerStats.interrupt();
        }
        if (this.workerPlay != null && this.status == 2) {
            this.setStatus((short)1);
        }
        if (this.STTextView != null) {
            this.STTextView.dispose();
        }
        if (this.STStats != null) {
            this.STStats.dispose();
        }
        if (this.SID != null && this.SID.isVisible()) {
            this.SID.dispose();
        }
        this.closeIt = true;
        if (this.closeIt) {
            this.dispose();
        }
    }

    private void componentsCreate() {
        if (this.fileChooser == null && this.parent != null) {
            this.parent.createFileChooser();
            this.fileChooser = this.parent.fileChooser;
        }
        this.JSP = new JScrollPane();
        this.menuChild = new JMenuBar();
        this.menuFile = new JMenu();
        this.menuFileScoreInformation = new JMenuItem();
        this.menuFileTextView = new JMenuItem();
        this.menuFilePrint = new JMenuItem();
        this.menuFileStats = new JMenuItem();
        this.menuFileExportMidi = new JMenuItem();
        this.jSeparator1 = new JSeparator();
        this.menuFileClose = new JMenuItem();
        this.menuView = new JMenu();
        this.menuViewMinPiece = new JCheckBoxMenuItem();
        this.menuViewMultiTrack = new JCheckBoxMenuItem();
        this.menuViewColorOptions = new JMenuItem();
        this.menuViewUnsupportedEffects = new JCheckBoxMenuItem();
        this.menuViewMusicCursors = new JCheckBoxMenuItem();
        this.menuViewSingleMusicCursorsColor = new JCheckBoxMenuItem();
        this.setBorder(new SoftBevelBorder(0));
        this.setClosable(true);
        this.setDefaultCloseOperation(0);
        this.setIconifiable(true);
        this.setMaximizable(true);
        this.setResizable(true);
        this.addInternalFrameListener(this);
        this.getContentPane().add((Component)this.JSP, "Center");
        this.menuFileScoreInformation.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                SongInternalFrame.this.menuFileScoreInformationActionPerformed(evt);
            }
        });
        this.menuFile.add(this.menuFileScoreInformation);
        this.menuFileTextView.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                SongInternalFrame.this.menuFileTextViewActionPerformed(evt);
            }
        });
        this.menuFile.add(this.menuFileTextView);
        this.menuFilePrint.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                SongInternalFrame.this.menuFilePrintActionPerformed(evt);
            }
        });
        this.menuFile.add(this.menuFilePrint);
        this.menuFileStats.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                SongInternalFrame.this.menuFileStatsActionPerformed(evt);
            }
        });
        this.menuFile.add(this.menuFileStats);
        this.menuFileExportMidi.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                SongInternalFrame.this.menuFileExportMidiActionPerformed(evt);
            }
        });
        this.menuFile.add(this.menuFileExportMidi);
        this.menuFile.add(this.jSeparator1);
        this.menuFileClose.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                SongInternalFrame.this.menuFileCloseActionPerformed(evt);
            }
        });
        this.menuFile.add(this.menuFileClose);
        this.menuChild.add(this.menuFile);
        this.menuViewMinPiece.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                SongInternalFrame.this.viewMinPiece(evt);
            }
        });
        this.menuView.add(this.menuViewMinPiece);
        this.menuViewMultiTrack.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                SongInternalFrame.this.viewMultiTrack(evt);
            }
        });
        this.menuView.add(this.menuViewMultiTrack);
        this.menuViewColorOptions.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                SongInternalFrame.this.viewColorOptions(evt);
            }
        });
        this.menuView.add(this.menuViewColorOptions);
        this.menuViewUnsupportedEffects.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                SongInternalFrame.this.viewUnsupportedEffects(evt);
            }
        });
        this.menuView.add(this.menuViewUnsupportedEffects);
        this.menuViewMusicCursors.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                SongInternalFrame.this.viewMusicCursors(evt);
            }
        });
        this.menuView.add(this.menuViewMusicCursors);
        this.menuViewSingleMusicCursorsColor.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                SongInternalFrame.this.viewSingleMusicCursorsColor(evt);
            }
        });
        this.menuView.add(this.menuViewSingleMusicCursorsColor);
        this.menuChild.add(this.menuView);
        this.setJMenuBar(this.menuChild);
        this.setLocation(new Point(0, 0));
        this.setLangText();
    }

    private void viewDisplayColorDialog() {
        ColorDialog CP = new ColorDialog(this.parent);
        CP.fretColors.setColors(this.displayOptions.fretColors, this.displayOptions.coloringForFrets);
        CP.rhythmColors.setColors(this.displayOptions.rhythmColors, this.displayOptions.coloringForRhythm);
        CP.setVisible(true);
        if (CP.OKclicked()) {
            boolean changed = false;
            if (CP.fretColors.selectionChanged()) {
                this.displayOptions.fretColors = CP.fretColors.getColors();
                this.displayOptions.coloringForFrets = CP.fretColors.getTypeOfColoring();
                changed = true;
            }
            if (CP.rhythmColors.selectionChanged()) {
                this.displayOptions.rhythmColors = CP.rhythmColors.getColors();
                this.displayOptions.coloringForRhythm = CP.rhythmColors.getTypeOfColoring();
                changed = true;
            }
            if (changed) {
                this.songPanel.repaint();
            }
        }
    }

    public boolean equals(Object obj) {
        boolean equal = false;
        if (obj != null && obj.getClass().isInstance(this)) {
            SongInternalFrame cast = (SongInternalFrame)obj;
            equal = cast.title == null ? this.title == null : cast.title.equals(this.title);
        }
        return equal;
    }

    public boolean hasChanged() {
        return this.songPanel.hasChanged();
    }

    private void initComponents() {
        this.componentsCreate();
    }

    private void initSongAndPlayer() {
        if (this.parent.evaluate) {
            this.start = System.currentTimeMillis();
        }
        if (this.song == null) {
            try {
                DGuitar.LS.println(DGuitar.lang.getString("pleaseWait"));
                this.song = GPAdaptor.makeSong(this.gpSong);
                this.player = new MasterPlayer();
            }
            catch (GPFormatException e1) {
                e1.printStackTrace();
            }
        }
        this.player.setSoundPlayer(new MidiPlayer());
        this.player.setTimerFrequency(4);
        this.player.enableNoteEvents(true);
        this.player.addTimerListener(this.playToolBar.getPlayPanel());
        boolean multiTrack = this.songPanel.isMultiTrackView();
        int cont = 0;
        while (cont < this.songPanel.getNumTracks()) {
            boolean scrollTrack = !multiTrack || multiTrack && cont == 0;
            MusicCursorScroller musicCursorScroller = new MusicCursorScroller(this.songPanel.getTrackPanel(cont), scrollTrack);
            this.player.addTimerListener(musicCursorScroller);
            ++cont;
        }
        Arrangement arrangement = null;
        this.player.arrange(this.song, arrangement);
        this.finish = System.currentTimeMillis();
        if (this.parent.evaluate) {
            this.finish = System.currentTimeMillis();
            String aux = DGuitar.lang.getString("evaluateAdaptingProcessTook");
            aux = String.valueOf(aux) + (this.finish - this.start) / 1000L + " " + DGuitar.lang.getString("seconds");
            System.err.println(aux);
        }
        this.workerPlay = new SwingWorker(){

            public Object construct() {
                SongInternalFrame.this.player.start();
                SongInternalFrame.this.player.waitForCompletion();
                SongInternalFrame.this.setStatus((short)1);
                return null;
            }
        };
    }

    public void internalFrameActivated(InternalFrameEvent evt) {
    }

    public void internalFrameClosed(InternalFrameEvent evt) {
    }

    public void internalFrameClosing(InternalFrameEvent evt) {
        this.close();
    }

    public void internalFrameDeactivated(InternalFrameEvent evt) {
    }

    public void internalFrameDeiconified(InternalFrameEvent evt) {
    }

    public void internalFrameIconified(InternalFrameEvent evt) {
    }

    public void internalFrameOpened(InternalFrameEvent evt) {
    }

    private void menuFileCloseActionPerformed(ActionEvent evt) {
        this.close();
    }

    private void menuFileExportMidiActionPerformed(ActionEvent evt) {
        String aux;
        this.fileChooser.setFileSelectionMode(2);
        this.fileChooser.setApproveButtonText(DGuitar.lang.getString("menuExportMidi"));
        this.fileChooser.setSelectedFile(new File(String.valueOf(this.trimExtension()) + ".mid"));
        this.fileChooser.setFileFilter(new MIDFileFilter());
        int val = this.fileChooser.showSaveDialog(this);
        if (val == 1) {
            return;
        }
        if (val == -1) {
            return;
        }
        File MIDfile = this.fileChooser.getSelectedFile();
        String absolute = MIDfile.getAbsolutePath();
        boolean export = true;
        if (MIDfile.exists()) {
            String aux2;
            aux = String.valueOf(absolute) + " " + DGuitar.lang.getString("already_exists") + ".";
            val = JOptionPane.showConfirmDialog(this, aux = String.valueOf(aux) + DGuitar.lang.getString("doYouWantToReplaceIt"), aux2 = String.valueOf(DGuitar.lang.getString("File")) + " " + DGuitar.lang.getString("already_exists"), 0);
            boolean bl = export = val == 0;
        }
        if (export) {
            this.start = 99999L;
            if (this.parent.evaluate) {
                this.start = System.currentTimeMillis();
            }
            try {
                FileOutputStream FOS = new FileOutputStream(MIDfile);
                MidiOutputStream mos = new MidiOutputStream(FOS);
                mos.write(this.gpSong);
                mos.close();
                FOS.close();
            }
            catch (FileNotFoundException e) {
                e.printStackTrace();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            catch (CodecFormatException e) {
                e.printStackTrace();
            }
            if (this.parent.evaluate) {
                this.finish = System.currentTimeMillis();
                aux = String.valueOf(DGuitar.lang.getString("evaluateExportProcessTook")) + ":";
                aux = String.valueOf(aux) + (this.finish - this.start) / 1000L + " " + DGuitar.lang.getString("seconds");
                System.err.println(aux);
            }
            System.err.println(String.valueOf(MIDfile.getAbsolutePath()) + " has been created");
        }
    }

    private void menuFilePrintActionPerformed(ActionEvent evt) {
        this.print();
    }

    private void menuFileScoreInformationActionPerformed(ActionEvent evt) {
        if (this.SID == null) {
            Container c = this.getParent();
            this.SID = c.getClass().isInstance(new JFrame()) ? new ScoreInformationDialog((JFrame)c, false) : new ScoreInformationDialog(null, false);
            this.SID.setTitle(String.valueOf(this.songName) + "-" + this.SID.getTitle());
            this.SID.setPiece(this.gpSong);
        }
        this.SID.setVisible(true);
    }

    private void menuFileStatsActionPerformed(ActionEvent evt) {
        if (this.STStats == null) {
            this.STStats = new ScrollText();
            this.STStats.setClosable(true, false);
            this.STStats.setTitle(String.valueOf(this.songName) + "-" + DGuitar.lang.getString("Statistics"));
            this.STStats.setEditable(false);
            this.workerStats = new SwingWorker(){

                public Object construct() {
                    String aux = SongInternalFrame.this.menuFileStats.getText();
                    SongInternalFrame.this.menuFileStats.setEnabled(false);
                    SongInternalFrame.this.menuFileStats.setText(DGuitar.lang.getString("pleaseWait"));
                    GPStatsPiece GSP = new GPStatsPiece();
                    GSP.setDetailed(true);
                    GSP.getStats(SongInternalFrame.this.gpSong, SongInternalFrame.this.songName);
                    SongInternalFrame.this.STStats.setText(GSP.toString());
                    SongInternalFrame.this.menuFileStats.setText(aux);
                    SongInternalFrame.this.menuFileStats.setEnabled(true);
                    return null;
                }
            };
            this.workerStats.start();
        }
        this.STStats.setVisible(true);
    }

    private void menuFileTextViewActionPerformed(ActionEvent evt) {
        if (this.STTextView == null) {
            this.STTextView = new ScrollText();
            this.STTextView.setClosable(true, false);
            this.STTextView.setTitle(String.valueOf(this.songName) + "- " + DGuitar.lang.getString("Text_View"));
            this.gpSong.startDisplayString(this.STTextView.getScrollTextPanel());
            this.STTextView.addWindowListener(new WindowListener(){

                public void windowActivated(WindowEvent e) {
                }

                public void windowClosed(WindowEvent e) {
                }

                public void windowClosing(WindowEvent e) {
                    SongInternalFrame.this.gpSong.stopDisplayString();
                }

                public void windowDeactivated(WindowEvent e) {
                }

                public void windowDeiconified(WindowEvent e) {
                }

                public void windowIconified(WindowEvent e) {
                }

                public void windowOpened(WindowEvent e) {
                }
            });
            this.STTextView.setEditable(false);
        }
        this.STTextView.setVisible(true);
    }

    private void viewColorOptions(ActionEvent evt) {
        this.viewDisplayColorDialog();
    }

    private void viewMinPiece(ActionEvent evt) {
        this.songPanel.toggleMinPieceSpacing();
        this.songPanel.validate();
    }

    private void viewMultiTrack(ActionEvent evt) {
        this.songPanel.toggleMultiTrackView();
        this.songPanel.displayPiece();
        this.songPanel.validate();
        DGuitar.internalFrameOptSize(this);
    }

    private void viewMusicCursors(ActionEvent evt) {
        this.songPanel.toggleViewMusicCursors();
    }

    private void viewSingleMusicCursorsColor(ActionEvent evt) {
        this.songPanel.toggleSingleMusicCursorColor();
    }

    private void viewUnsupportedEffects(ActionEvent evt) {
        this.songPanel.toggleDisplayUnsupportedEffects();
        this.songPanel.repaint();
    }

    public void print() {
        Util.showDialogOk(this.getParent(), DGuitar.lang.getString("Print_option_under_work"), DGuitar.lang.getString("This_is_not_finished"));
    }

    public boolean readAndDisplay(GPInputStream GPis) {
        boolean success = this.songPanel.readPieceFrom(GPis);
        if (success) {
            this.gpSong = this.songPanel.getPiece();
            this.songPanel.displayPiece();
            this.songPanel.validate();
            this.playToolBar.getPlayPanel().setNumMeasures(this.gpSong.getNumMeasures());
        } else {
            DGuitar.msg = "PP.readPieceFrom(GPInputStream_gis)" + DGuitar.lang.getString("FAILED");
        }
        return success;
    }

    private void setEnableComponents(boolean enable) {
        this.songPanel.musicCursorsSetEnable(enable);
        this.menuViewMinPiece.setEnabled(enable);
        this.menuViewMultiTrack.setEnabled(enable);
        this.menuFileStats.setEnabled(enable);
        this.menuFileTextView.setEnabled(enable);
        this.menuFileExportMidi.setEnabled(enable);
    }

    public void setLangText() {
        this.menuFile.setText(DGuitar.lang.getString("File"));
        this.menuFileScoreInformation.setText(DGuitar.lang.getString("menuPIFScoreInformation"));
        this.menuFileTextView.setText(DGuitar.lang.getString("menuPIFTextView"));
        this.menuFilePrint.setText(DGuitar.lang.getString("menuPIFPrint"));
        this.menuFileStats.setText(DGuitar.lang.getString("Statistics"));
        this.menuFileExportMidi.setText(DGuitar.lang.getString("menuExportMidi"));
        this.menuFileClose.setText(DGuitar.lang.getString("menuClose"));
        this.menuView.setText(DGuitar.lang.getString("menuView"));
        this.menuViewMinPiece.setText(DGuitar.lang.getString("menuPIFMinDurPiece"));
        this.menuViewMultiTrack.setText(DGuitar.lang.getString("menuPIFMultiTrack"));
        this.menuViewColorOptions.setText(DGuitar.lang.getString("menuPIFColors"));
        this.menuViewMusicCursors.setText(DGuitar.lang.getString("menuViewMusicCursors"));
        this.menuViewUnsupportedEffects.setText(DGuitar.lang.getString("menuViewUnsupportedEffects"));
        this.menuViewSingleMusicCursorsColor.setText(DGuitar.lang.getString("menuSingleMusicCursorsColor"));
        if (this.STStats != null) {
            this.STStats.setTitle(String.valueOf(this.songName) + "-" + DGuitar.lang.getString("Statistics"));
        }
        if (this.SID != null) {
            this.SID.setLangText();
        }
    }

    private String trimExtension() {
        return this.songName.substring(0, this.songName.indexOf(46));
    }

    public void setStatus(short st) {
        this.status = st;
        if (st == 2) {
            this.setEnableComponents(false);
            this.initSongAndPlayer();
            this.workerPlay.start();
        } else if (st == 1) {
            this.player.stop();
            this.player.close();
            this.workerPlay.interrupt();
            this.setEnableComponents(true);
            this.playToolBar.setStatus((short)1);
        }
    }

    public short getStatus() {
        return this.status;
    }

    public void pause() {
    }
}

