/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.common.resources;

import java.lang.ref.WeakReference;
import java.net.URI;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.sf.freecol.common.resources.AudioResource;
import net.sf.freecol.common.resources.ColorResource;
import net.sf.freecol.common.resources.FAFileResource;
import net.sf.freecol.common.resources.FontResource;
import net.sf.freecol.common.resources.ImageResource;
import net.sf.freecol.common.resources.SZAResource;
import net.sf.freecol.common.resources.StringResource;
import net.sf.freecol.common.resources.VideoResource;

public class ResourceFactory {
    private static final Logger logger = Logger.getLogger(ResourceFactory.class.getName());
    private static final Map<URI, WeakReference<ColorResource>> colorResources = new WeakHashMap<URI, WeakReference<ColorResource>>();
    private static final Map<URI, WeakReference<FontResource>> fontResources = new WeakHashMap<URI, WeakReference<FontResource>>();
    private static final Map<URI, WeakReference<StringResource>> stringResources = new WeakHashMap<URI, WeakReference<StringResource>>();
    private static final Map<URI, WeakReference<FAFileResource>> fafResources = new WeakHashMap<URI, WeakReference<FAFileResource>>();
    private static final Map<URI, WeakReference<SZAResource>> szaResources = new WeakHashMap<URI, WeakReference<SZAResource>>();
    private static final Map<URI, WeakReference<AudioResource>> audioResources = new WeakHashMap<URI, WeakReference<AudioResource>>();
    private static final Map<URI, WeakReference<VideoResource>> videoResources = new WeakHashMap<URI, WeakReference<VideoResource>>();
    private static final Map<URI, WeakReference<ImageResource>> imageResources = new WeakHashMap<URI, WeakReference<ImageResource>>();

    private static boolean findResource(URI uri, ResourceSink output) {
        ImageResource ir;
        VideoResource vr;
        AudioResource ar;
        SZAResource szr;
        FAFileResource far;
        StringResource sr;
        FontResource fr;
        ColorResource cr;
        WeakReference<ColorResource> crwr = colorResources.get(uri);
        if (crwr != null && (cr = (ColorResource)crwr.get()) != null) {
            output.add(cr);
            return true;
        }
        WeakReference<FontResource> frwr = fontResources.get(uri);
        if (frwr != null && (fr = (FontResource)frwr.get()) != null) {
            output.add(fr);
            return true;
        }
        WeakReference<StringResource> srwr = stringResources.get(uri);
        if (srwr != null && (sr = (StringResource)srwr.get()) != null) {
            output.add(sr);
            return true;
        }
        WeakReference<FAFileResource> farwr = fafResources.get(uri);
        if (farwr != null && (far = (FAFileResource)farwr.get()) != null) {
            output.add(far);
            return true;
        }
        WeakReference<SZAResource> szrwr = szaResources.get(uri);
        if (szrwr != null && (szr = (SZAResource)szrwr.get()) != null) {
            output.add(szr);
            return true;
        }
        WeakReference<AudioResource> arwr = audioResources.get(uri);
        if (arwr != null && (ar = (AudioResource)arwr.get()) != null) {
            output.add(ar);
            return true;
        }
        WeakReference<VideoResource> vrwr = videoResources.get(uri);
        if (vrwr != null && (vr = (VideoResource)vrwr.get()) != null) {
            output.add(vr);
            return true;
        }
        WeakReference<ImageResource> irwr = imageResources.get(uri);
        if (irwr != null && (ir = (ImageResource)irwr.get()) != null) {
            output.add(ir);
            return true;
        }
        return false;
    }

    public static void createResource(URI uri, ResourceSink output) {
        if (ResourceFactory.findResource(uri, output)) {
            return;
        }
        try {
            if ("urn".equals(uri.getScheme())) {
                if (uri.getSchemeSpecificPart().startsWith("color:")) {
                    ColorResource cr = new ColorResource(uri);
                    output.add(cr);
                    colorResources.put(uri, new WeakReference<ColorResource>(cr));
                } else if (uri.getSchemeSpecificPart().startsWith("font:")) {
                    FontResource fr = new FontResource(uri);
                    output.add(fr);
                    fontResources.put(uri, new WeakReference<FontResource>(fr));
                }
            } else if (uri.getPath().endsWith("\"") && uri.getPath().lastIndexOf(34, uri.getPath().length() - 1) >= 0) {
                StringResource sr = new StringResource(uri);
                output.add(sr);
                stringResources.put(uri, new WeakReference<StringResource>(sr));
            } else if (uri.getPath().endsWith(".faf")) {
                FAFileResource far = new FAFileResource(uri);
                output.add(far);
                fafResources.put(uri, new WeakReference<FAFileResource>(far));
            } else if (uri.getPath().endsWith(".sza")) {
                SZAResource szr = new SZAResource(uri);
                output.add(szr);
                szaResources.put(uri, new WeakReference<SZAResource>(szr));
            } else if (uri.getPath().endsWith(".ttf")) {
                FontResource fr = new FontResource(uri);
                output.add(fr);
                fontResources.put(uri, new WeakReference<FontResource>(fr));
            } else if (uri.getPath().endsWith(".wav")) {
                AudioResource ar = new AudioResource(uri);
                output.add(ar);
                audioResources.put(uri, new WeakReference<AudioResource>(ar));
            } else if (uri.getPath().endsWith(".ogg")) {
                if (uri.getPath().endsWith(".video.ogg")) {
                    VideoResource vr = new VideoResource(uri);
                    output.add(vr);
                    videoResources.put(uri, new WeakReference<VideoResource>(vr));
                } else {
                    AudioResource ar = new AudioResource(uri);
                    output.add(ar);
                    audioResources.put(uri, new WeakReference<AudioResource>(ar));
                }
            } else {
                ImageResource ir = new ImageResource(uri);
                output.add(ir);
                imageResources.put(uri, new WeakReference<ImageResource>(ir));
            }
        }
        catch (Exception e) {
            logger.log(Level.WARNING, "Failed to create resource with URI: " + uri, e);
        }
    }

    public static interface ResourceSink {
        public void add(ColorResource var1);

        public void add(FontResource var1);

        public void add(StringResource var1);

        public void add(FAFileResource var1);

        public void add(SZAResource var1);

        public void add(AudioResource var1);

        public void add(VideoResource var1);

        public void add(ImageResource var1);
    }
}

