/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.svggen;

import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.awt.image.renderable.RenderableImage;
import java.io.File;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import org.apache.batik.svggen.DefaultImageHandler;
import org.apache.batik.svggen.SVGGeneratorContext;
import org.apache.batik.svggen.SVGGraphics2DIOException;
import org.apache.batik.svggen.SVGGraphics2DRuntimeException;
import org.w3c.dom.Element;

public abstract class AbstractImageHandlerEncoder
extends DefaultImageHandler {
    private static final AffineTransform IDENTITY = new AffineTransform();
    private String imageDir = "";
    private String urlRoot = "";
    private static Method createGraphics = null;
    private static boolean initDone = false;
    private static final Class[] paramc = new Class[]{BufferedImage.class};
    private static Object[] paramo = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Graphics2D createGraphics(BufferedImage bufferedImage) {
        Object object;
        if (!initDone) {
            try {
                object = Class.forName("org.apache.batik.ext.awt.image.GraphicsUtil");
                createGraphics = ((Class)object).getMethod("createGraphics", paramc);
                paramo = new Object[1];
            }
            catch (ThreadDeath threadDeath) {
                throw threadDeath;
            }
            catch (Throwable throwable) {
            }
            finally {
                initDone = true;
            }
        }
        if (createGraphics == null) {
            return bufferedImage.createGraphics();
        }
        AbstractImageHandlerEncoder.paramo[0] = bufferedImage;
        object = null;
        try {
            object = (Graphics2D)createGraphics.invoke(null, paramo);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return object;
    }

    public AbstractImageHandlerEncoder(String string, String string2) throws SVGGraphics2DIOException {
        if (string == null) {
            throw new SVGGraphics2DRuntimeException("imageDir should not be null");
        }
        File file = new File(string);
        if (!file.exists()) {
            throw new SVGGraphics2DRuntimeException("imageDir does not exist");
        }
        this.imageDir = string;
        if (string2 != null) {
            this.urlRoot = string2;
        } else {
            try {
                this.urlRoot = file.toURI().toURL().toString();
            }
            catch (MalformedURLException malformedURLException) {
                throw new SVGGraphics2DIOException("cannot convert imageDir to a URL value : " + malformedURLException.getMessage(), malformedURLException);
            }
        }
    }

    @Override
    protected void handleHREF(Image image, Element element, SVGGeneratorContext sVGGeneratorContext) throws SVGGraphics2DIOException {
        Dimension dimension = new Dimension(image.getWidth(null), image.getHeight(null));
        BufferedImage bufferedImage = this.buildBufferedImage(dimension);
        Graphics2D graphics2D = AbstractImageHandlerEncoder.createGraphics(bufferedImage);
        graphics2D.drawImage(image, 0, 0, null);
        graphics2D.dispose();
        this.saveBufferedImageToFile(element, bufferedImage, sVGGeneratorContext);
    }

    @Override
    protected void handleHREF(RenderedImage renderedImage, Element element, SVGGeneratorContext sVGGeneratorContext) throws SVGGraphics2DIOException {
        Dimension dimension = new Dimension(renderedImage.getWidth(), renderedImage.getHeight());
        BufferedImage bufferedImage = this.buildBufferedImage(dimension);
        Graphics2D graphics2D = AbstractImageHandlerEncoder.createGraphics(bufferedImage);
        graphics2D.drawRenderedImage(renderedImage, IDENTITY);
        graphics2D.dispose();
        this.saveBufferedImageToFile(element, bufferedImage, sVGGeneratorContext);
    }

    @Override
    protected void handleHREF(RenderableImage renderableImage, Element element, SVGGeneratorContext sVGGeneratorContext) throws SVGGraphics2DIOException {
        Dimension dimension = new Dimension((int)Math.ceil(renderableImage.getWidth()), (int)Math.ceil(renderableImage.getHeight()));
        BufferedImage bufferedImage = this.buildBufferedImage(dimension);
        Graphics2D graphics2D = AbstractImageHandlerEncoder.createGraphics(bufferedImage);
        graphics2D.drawRenderableImage(renderableImage, IDENTITY);
        graphics2D.dispose();
        this.saveBufferedImageToFile(element, bufferedImage, sVGGeneratorContext);
    }

    private void saveBufferedImageToFile(Element element, BufferedImage bufferedImage, SVGGeneratorContext sVGGeneratorContext) throws SVGGraphics2DIOException {
        if (sVGGeneratorContext == null) {
            throw new SVGGraphics2DRuntimeException("generatorContext should not be null");
        }
        File file = null;
        while (file == null) {
            String string = sVGGeneratorContext.idGenerator.generateID(this.getPrefix());
            file = new File(this.imageDir, string + this.getSuffix());
            if (!file.exists()) continue;
            file = null;
        }
        this.encodeImage(bufferedImage, file);
        element.setAttributeNS("http://www.w3.org/1999/xlink", "xlink:href", this.urlRoot + "/" + file.getName());
    }

    public abstract String getSuffix();

    public abstract String getPrefix();

    public abstract void encodeImage(BufferedImage var1, File var2) throws SVGGraphics2DIOException;

    public abstract BufferedImage buildBufferedImage(Dimension var1);
}

