/*
 * Decompiled with CFR 0.152.
 */
package javajs.util;

import javajs.util.T3;

public class Matrix
implements Cloneable {
    public double[][] a;
    protected int m;
    protected int n;

    public Matrix(double[][] a, int m, int n) {
        this.a = a == null ? new double[m][n] : a;
        this.m = m;
        this.n = n;
    }

    public int getRowDimension() {
        return this.m;
    }

    public int getColumnDimension() {
        return this.n;
    }

    public double[][] getArray() {
        return this.a;
    }

    public double[][] getArrayCopy() {
        double[][] x = new double[this.m][this.n];
        int i = this.m;
        while (--i >= 0) {
            int j = this.n;
            while (--j >= 0) {
                x[i][j] = this.a[i][j];
            }
        }
        return x;
    }

    public Matrix copy() {
        Matrix x = new Matrix(null, this.m, this.n);
        double[][] c = x.a;
        int i = this.m;
        while (--i >= 0) {
            int j = this.n;
            while (--j >= 0) {
                c[i][j] = this.a[i][j];
            }
        }
        return x;
    }

    public Object clone() {
        return this.copy();
    }

    public Matrix getSubmatrix(int i0, int j0, int nrows, int ncols) {
        Matrix x = new Matrix(null, nrows, ncols);
        double[][] xa = x.a;
        int i = nrows;
        while (--i >= 0) {
            int j = ncols;
            while (--j >= 0) {
                xa[i][j] = this.a[i0 + i][j0 + j];
            }
        }
        return x;
    }

    public Matrix getMatrixSelected(int[] r, int n) {
        Matrix x = new Matrix(null, r.length, n);
        double[][] xa = x.a;
        int i = r.length;
        while (--i >= 0) {
            double[] b = this.a[r[i]];
            int j = n;
            while (--j >= 0) {
                xa[i][j] = b[j];
            }
        }
        return x;
    }

    public Matrix transpose() {
        Matrix x = new Matrix(null, this.n, this.m);
        double[][] c = x.a;
        int i = this.m;
        while (--i >= 0) {
            int j = this.n;
            while (--j >= 0) {
                c[j][i] = this.a[i][j];
            }
        }
        return x;
    }

    public Matrix add(Matrix b) {
        return this.scaleAdd(b, 1.0);
    }

    public Matrix sub(Matrix b) {
        return this.scaleAdd(b, -1.0);
    }

    public Matrix scaleAdd(Matrix b, double scale) {
        Matrix x = new Matrix(null, this.m, this.n);
        double[][] xa = x.a;
        double[][] ba = b.a;
        int i = this.m;
        while (--i >= 0) {
            int j = this.n;
            while (--j >= 0) {
                xa[i][j] = ba[i][j] * scale + this.a[i][j];
            }
        }
        return x;
    }

    public Matrix mul(Matrix b) {
        if (b.m != this.n) {
            return null;
        }
        Matrix x = new Matrix(null, this.m, b.n);
        double[][] xa = x.a;
        double[][] ba = b.a;
        int j = b.n;
        while (--j >= 0) {
            int i = this.m;
            while (--i >= 0) {
                double[] arowi = this.a[i];
                double s = 0.0;
                int k = this.n;
                while (--k >= 0) {
                    s += arowi[k] * ba[k][j];
                }
                xa[i][j] = s;
            }
        }
        return x;
    }

    public Matrix inverse() {
        return new LUDecomp(this.m, this.n).solve(Matrix.identity(this.m, this.m), this.n);
    }

    public double trace() {
        double t = 0.0;
        int i = Math.min(this.m, this.n);
        while (--i >= 0) {
            t += this.a[i][i];
        }
        return t;
    }

    public static Matrix identity(int m, int n) {
        Matrix x = new Matrix(null, m, n);
        double[][] xa = x.a;
        int i = Math.min(m, n);
        while (--i >= 0) {
            xa[i][i] = 1.0;
        }
        return x;
    }

    public Matrix getRotation() {
        return this.getSubmatrix(0, 0, this.m - 1, this.n - 1);
    }

    public Matrix getTranslation() {
        return this.getSubmatrix(0, this.n - 1, this.m - 1, 1);
    }

    public static Matrix newT(T3 r, boolean asColumn) {
        return asColumn ? new Matrix(new double[][]{{r.x}, {r.y}, {r.z}}, 3, 1) : new Matrix(new double[][]{{r.x, r.y, r.z}}, 1, 3);
    }

    public String toString() {
        String s = "[\n";
        int i = 0;
        while (i < this.m) {
            s = String.valueOf(s) + "  [";
            int j = 0;
            while (j < this.n) {
                s = String.valueOf(s) + " " + this.a[i][j];
                ++j;
            }
            s = String.valueOf(s) + "]\n";
            ++i;
        }
        s = String.valueOf(s) + "]";
        return s;
    }

    private class LUDecomp {
        private double[][] LU;
        private int[] piv;
        private int pivsign;

        protected LUDecomp(int m, int n) {
            this.LU = Matrix.this.getArrayCopy();
            this.piv = new int[m];
            int i = m;
            while (--i >= 0) {
                this.piv[i] = i;
            }
            this.pivsign = 1;
            double[] LUcolj = new double[m];
            int j = 0;
            while (j < n) {
                int i2 = m;
                while (--i2 >= 0) {
                    LUcolj[i2] = this.LU[i2][j];
                }
                i2 = m;
                while (--i2 >= 0) {
                    double[] LUrowi = this.LU[i2];
                    int kmax = Math.min(i2, j);
                    double s = 0.0;
                    int k = kmax;
                    while (--k >= 0) {
                        s += LUrowi[k] * LUcolj[k];
                    }
                    int n2 = i2;
                    double d = LUcolj[n2] - s;
                    LUcolj[n2] = d;
                    LUrowi[j] = d;
                }
                int p = j;
                int i3 = m;
                while (--i3 > j) {
                    if (!(Math.abs(LUcolj[i3]) > Math.abs(LUcolj[p]))) continue;
                    p = i3;
                }
                if (p != j) {
                    int k = n;
                    while (--k >= 0) {
                        double t = this.LU[p][k];
                        this.LU[p][k] = this.LU[j][k];
                        this.LU[j][k] = t;
                    }
                    k = this.piv[p];
                    this.piv[p] = this.piv[j];
                    this.piv[j] = k;
                    this.pivsign = -this.pivsign;
                }
                if (j < m & this.LU[j][j] != 0.0) {
                    i3 = m;
                    while (--i3 > j) {
                        double[] dArray = this.LU[i3];
                        int n3 = j;
                        dArray[n3] = dArray[n3] / this.LU[j][j];
                    }
                }
                ++j;
            }
        }

        protected Matrix solve(Matrix b, int n) {
            int j;
            int i;
            int j2 = 0;
            while (j2 < n) {
                if (this.LU[j2][j2] == 0.0) {
                    return null;
                }
                ++j2;
            }
            int nx = b.n;
            Matrix x = b.getMatrixSelected(this.piv, nx);
            double[][] a = x.a;
            int k = 0;
            while (k < n) {
                i = k + 1;
                while (i < n) {
                    j = 0;
                    while (j < nx) {
                        double[] dArray = a[i];
                        int n2 = j;
                        dArray[n2] = dArray[n2] - a[k][j] * this.LU[i][k];
                        ++j;
                    }
                    ++i;
                }
                ++k;
            }
            k = n;
            while (--k >= 0) {
                int j3 = nx;
                while (--j3 >= 0) {
                    double[] dArray = a[k];
                    int n3 = j3;
                    dArray[n3] = dArray[n3] / this.LU[k][k];
                }
                i = k;
                while (--i >= 0) {
                    j = nx;
                    while (--j >= 0) {
                        double[] dArray = a[i];
                        int n4 = j;
                        dArray[n4] = dArray[n4] - a[k][j] * this.LU[i][k];
                    }
                }
            }
            return x;
        }
    }
}

