/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.data.osm.visitor.paint;

import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.stream.Collectors;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.gui.MapViewState;
import org.openstreetmap.josm.tools.Utils;

public class OffsetIterator
implements Iterator<MapViewState.MapViewPoint> {
    private final MapViewState mapState;
    private final List<Node> nodes;
    private final double offset;
    private int idx;
    private MapViewState.MapViewPoint prev;
    private double xPrev0;
    private double yPrev0;

    public OffsetIterator(MapViewState mapViewState, List<Node> list, double d) {
        this.mapState = mapViewState;
        this.nodes = list.stream().filter(Node::isLatLonKnown).collect(Collectors.toList());
        this.offset = d;
        this.idx = 0;
    }

    @Override
    public boolean hasNext() {
        return this.idx < this.nodes.size();
    }

    @Override
    public MapViewState.MapViewPoint next() {
        double d;
        double d2;
        double d3;
        double d4;
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        MapViewState.MapViewPoint mapViewPoint = this.getForIndex(this.idx);
        if (Math.abs(this.offset) < 0.1) {
            ++this.idx;
            return mapViewPoint;
        }
        double d5 = mapViewPoint.getInViewX();
        double d6 = mapViewPoint.getInViewY();
        if (this.idx == this.nodes.size() - 1) {
            ++this.idx;
            if (this.prev != null) {
                return this.mapState.getForView(this.xPrev0 + d5 - this.prev.getInViewX(), this.yPrev0 + d6 - this.prev.getInViewY());
            }
            return mapViewPoint;
        }
        MapViewState.MapViewPoint mapViewPoint2 = this.getForIndex(this.idx + 1);
        double d7 = mapViewPoint2.getInViewX() - d5;
        double d8 = Math.sqrt(d7 * d7 + (d4 = mapViewPoint2.getInViewY() - d6) * d4);
        if (d8 < 1.0E-11) {
            d8 = 1.0;
        }
        double d9 = this.offset / d8;
        double d10 = d5 + d9 * d4;
        double d11 = d6 - d9 * d7;
        if (this.idx == 0) {
            ++this.idx;
            this.prev = mapViewPoint;
            this.xPrev0 = d10;
            this.yPrev0 = d11;
            return this.mapState.getForView(d10, d11);
        }
        double d12 = d5 - this.prev.getInViewX();
        double d13 = d6 - this.prev.getInViewY();
        double d14 = d7 * d13 - d12 * d4;
        double d15 = d7 * (d11 - this.yPrev0) - d4 * (d10 - this.xPrev0);
        if (Utils.equalsEpsilon(d14, 0.0) || Math.signum(d14) != Math.signum(d15)) {
            ++this.idx;
            this.prev = mapViewPoint;
            this.xPrev0 = d10;
            this.yPrev0 = d11;
            return this.mapState.getForView(d10, d11);
        }
        double d16 = d15 / d14;
        if (d16 < 0.0) {
            ++this.idx;
            this.prev = mapViewPoint;
            this.xPrev0 = d10;
            this.yPrev0 = d11;
            return this.mapState.getForView(d10, d11);
        }
        double d17 = this.xPrev0 + d16 * d12;
        double d18 = this.yPrev0 + d16 * d13;
        if (d16 > 1.0 && (d3 = (d2 = d17 - d5) * d2 + (d = d18 - d6) * d) > Math.abs(2.0 * this.offset * this.offset)) {
            double d19 = d10 - this.xPrev0;
            double d20 = d11 - this.yPrev0;
            double d21 = Math.sqrt(d19 * d19 + d20 * d20);
            d16 = 1.0 + Math.abs(this.offset / d21);
            double d22 = this.xPrev0 + d16 * d12;
            double d23 = this.yPrev0 + d16 * d13;
            this.xPrev0 = d22;
            this.yPrev0 = d23;
            double d24 = Math.sqrt(d3);
            double d25 = d5 + d / d24;
            double d26 = d6 - d2 / d24;
            this.prev = this.mapState.getForView(d25, d26);
            return this.mapState.getForView(d22, d23);
        }
        ++this.idx;
        this.prev = mapViewPoint;
        this.xPrev0 = d10;
        this.yPrev0 = d11;
        return this.mapState.getForView(d17, d18);
    }

    private MapViewState.MapViewPoint getForIndex(int n) {
        return this.mapState.getPointFor(this.nodes.get(n));
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }
}

