/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.data.projection.datum;

import org.openstreetmap.josm.data.coor.LatLon;
import org.openstreetmap.josm.data.projection.Ellipsoid;
import org.openstreetmap.josm.data.projection.datum.AbstractDatum;
import org.openstreetmap.josm.tools.Utils;

public class SevenParameterDatum
extends AbstractDatum {
    protected double dx;
    protected double dy;
    protected double dz;
    protected double rx;
    protected double ry;
    protected double rz;
    protected double s;

    public SevenParameterDatum(String string, String string2, Ellipsoid ellipsoid, double d, double d2, double d3, double d4, double d5, double d6, double d7) {
        super(string, string2, ellipsoid);
        this.dx = d;
        this.dy = d2;
        this.dz = d3;
        this.rx = Utils.toRadians(d4 / 3600.0);
        this.ry = Utils.toRadians(d5 / 3600.0);
        this.rz = Utils.toRadians(d6 / 3600.0);
        this.s = d7 / 1000000.0;
    }

    @Override
    public LatLon toWGS84(LatLon latLon) {
        double[] dArray = this.ellps.latLon2Cart(latLon);
        double d = this.dx + dArray[0] * (1.0 + this.s) + dArray[2] * this.ry - dArray[1] * this.rz;
        double d2 = this.dy + dArray[1] * (1.0 + this.s) + dArray[0] * this.rz - dArray[2] * this.rx;
        double d3 = this.dz + dArray[2] * (1.0 + this.s) + dArray[1] * this.rx - dArray[0] * this.ry;
        return Ellipsoid.WGS84.cart2LatLon(d, d2, d3);
    }

    @Override
    public LatLon fromWGS84(LatLon latLon) {
        double[] dArray = Ellipsoid.WGS84.latLon2Cart(latLon);
        double d = (1.0 - this.s) * (-this.dx + dArray[0] + ((-this.dz + dArray[2]) * -this.ry - (-this.dy + dArray[1]) * -this.rz));
        double d2 = (1.0 - this.s) * (-this.dy + dArray[1] + ((-this.dx + dArray[0]) * -this.rz - (-this.dz + dArray[2]) * -this.rx));
        double d3 = (1.0 - this.s) * (-this.dz + dArray[2] + ((-this.dy + dArray[1]) * -this.rx - (-this.dx + dArray[0]) * -this.ry));
        return this.ellps.cart2LatLon(d, d2, d3);
    }
}

