/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.data.validation.tests;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.data.coor.LatLon;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.data.osm.WaySegment;
import org.openstreetmap.josm.data.validation.Severity;
import org.openstreetmap.josm.data.validation.Test;
import org.openstreetmap.josm.data.validation.TestError;
import org.openstreetmap.josm.gui.progress.ProgressMonitor;
import org.openstreetmap.josm.tools.I18n;

public class LongSegment
extends Test {
    protected static final int LONG_SEGMENT = 3501;
    protected int maxlength;
    private Set<Way> visitedWays;
    protected Set<WaySegment> reported;

    public LongSegment() {
        super(I18n.tr("Long segments", new Object[0]), I18n.tr("This tests for long way segments, which are usually errors.", new Object[0]));
    }

    @Override
    public void visit(Node node) {
        for (Way way : node.getParentWays()) {
            if (this.ignoreWay(way)) continue;
            for (int i = 0; i < way.getNodesCount(); ++i) {
                if (node != way.getNode(i)) continue;
                if (i > 0) {
                    this.visitWaySegment(way, i - 1);
                }
                if (i >= way.getNodesCount() - 1) continue;
                this.visitWaySegment(way, i);
            }
        }
    }

    @Override
    public void visit(Way way) {
        if (this.ignoreWay(way)) {
            return;
        }
        this.visitedWays.add(way);
        this.testWay(way);
    }

    private void testWay(Way way) {
        for (int i = 0; i < way.getNodesCount() - 1; ++i) {
            this.visitWaySegment(way, i);
        }
    }

    private boolean ignoreWay(Way way) {
        return this.visitedWays.contains(way) || way.hasTag("route", "ferry");
    }

    private void visitWaySegment(Way way, int n) {
        Double d;
        LatLon latLon = way.getNode(n).getCoor();
        LatLon latLon2 = way.getNode(n + 1).getCoor();
        if (latLon != null && latLon2 != null && (d = Double.valueOf(latLon.greatCircleDistance(latLon2))) > (double)this.maxlength) {
            this.addErrorForSegment(new WaySegment(way, n), d / 1000.0);
        }
    }

    private void addErrorForSegment(WaySegment waySegment, Double d) {
        if (this.reported.add(waySegment)) {
            this.errors.add(TestError.builder(this, Severity.WARNING, 3501).message(I18n.tr("Long segments", new Object[0]), I18n.marktr("Very long segment of {0} kilometers"), d.intValue()).primitives(waySegment.way).highlightWaySegments(Collections.singleton(waySegment)).build());
        }
    }

    @Override
    public void startTest(ProgressMonitor progressMonitor) {
        super.startTest(progressMonitor);
        this.maxlength = Main.pref.getInteger("validator.maximum.segment.length", 15000);
        this.reported = new HashSet<WaySegment>();
        this.visitedWays = new HashSet<Way>();
    }

    @Override
    public void endTest() {
        super.endTest();
        this.visitedWays = null;
        this.reported = null;
    }

    @Override
    public boolean isPrimitiveUsable(OsmPrimitive osmPrimitive) {
        if (!osmPrimitive.isUsable()) {
            return false;
        }
        if (osmPrimitive instanceof Way && ((Way)osmPrimitive).getNodesCount() > 1) {
            return true;
        }
        return osmPrimitive instanceof Node && osmPrimitive.isDrawable();
    }
}

