/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.dialogs.properties;

import java.awt.Color;
import java.awt.Component;
import java.util.Collection;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.UIManager;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellRenderer;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.preferences.BooleanProperty;
import org.openstreetmap.josm.data.preferences.CachingProperty;
import org.openstreetmap.josm.data.preferences.ColorProperty;
import org.openstreetmap.josm.tools.I18n;

public class PropertiesCellRenderer
extends DefaultTableCellRenderer {
    private static final CachingProperty<Color> SELECTED_FG = new ColorProperty(I18n.marktr("Discardable key: selection Foreground"), Color.GRAY).cached();
    private static final CachingProperty<Color> SELECTED_BG;
    private static final CachingProperty<Color> NORMAL_FG;
    private static final CachingProperty<Color> NORMAL_BG;
    private static final CachingProperty<Boolean> DISCARDABLE;
    private final Collection<TableCellRenderer> customRenderer = new CopyOnWriteArrayList<TableCellRenderer>();

    private static void setColors(Component component, String string, boolean bl) {
        if (OsmPrimitive.getDiscardableKeys().contains(string)) {
            component.setForeground((bl ? SELECTED_FG : NORMAL_FG).get());
            component.setBackground((bl ? SELECTED_BG : NORMAL_BG).get());
        } else {
            component.setForeground(UIManager.getColor("Table." + (bl ? "selectionF" : "f") + "oreground"));
            component.setBackground(UIManager.getColor("Table." + (bl ? "selectionB" : "b") + "ackground"));
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
        Object object2;
        for (TableCellRenderer object3 : this.customRenderer) {
            object2 = object3.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
            if (object2 == null) continue;
            return object2;
        }
        if (object == null) {
            return this;
        }
        Component component = super.getTableCellRendererComponent(jTable, object, bl, false, n, n2);
        if (component instanceof JLabel) {
            void var8_13;
            Object object3;
            Object var8_9 = null;
            if (object instanceof String) {
                String string = (String)object;
            } else if (object instanceof Map) {
                object2 = (Map)object;
                if (object2.size() != 1) {
                    Integer n3;
                    if (object2.get("") == null) {
                        object3 = 0;
                        n3 = object2.size();
                    } else {
                        object3 = (Integer)object2.get("");
                        n3 = object2.size() - 1;
                    }
                    StringBuilder stringBuilder = new StringBuilder("<");
                    if (n3 == 1) {
                        object2.entrySet().stream().filter(entry -> !Objects.equals(entry.getKey(), "")).findAny().ifPresent(entry -> stringBuilder.append(I18n.tr("{0} ''{1}''", entry.getValue().toString(), entry.getKey())));
                    } else {
                        stringBuilder.append(I18n.trn("{0} different", "{0} different", n3.intValue(), n3));
                    }
                    if ((Integer)object3 > 0) {
                        stringBuilder.append(I18n.trn(", {0} unset", ", {0} unset", ((Integer)object3).intValue(), object3));
                    }
                    stringBuilder.append('>');
                    String string = stringBuilder.toString();
                    component.setFont(component.getFont().deriveFont(2));
                } else {
                    object3 = object2.entrySet().iterator().next();
                    String string = (String)object3.getKey();
                }
            }
            ((JLabel)component).putClientProperty("html.disable", Boolean.TRUE);
            ((JLabel)component).setText((String)var8_13);
            if (DISCARDABLE.get().booleanValue()) {
                object2 = null;
                if (n2 == 0) {
                    object2 = var8_13;
                } else if (n2 == 1 && (object3 = jTable.getModel().getValueAt(n, 0)) instanceof String) {
                    object2 = (String)object3;
                }
                PropertiesCellRenderer.setColors(component, (String)object2, bl);
            }
        }
        return component;
    }

    public void addCustomRenderer(TableCellRenderer tableCellRenderer) {
        this.customRenderer.add(tableCellRenderer);
    }

    public void removeCustomRenderer(TableCellRenderer tableCellRenderer) {
        this.customRenderer.remove(tableCellRenderer);
    }

    static {
        NORMAL_FG = new ColorProperty(I18n.marktr("Discardable key: foreground"), Color.GRAY).cached();
        DISCARDABLE = new BooleanProperty("display.discardable-keys", false).cached();
        SELECTED_BG = new ColorProperty(I18n.marktr("Discardable key: selection Background"), Optional.ofNullable(UIManager.getColor("Table.selectionBackground")).orElse(Color.BLUE)).cached();
        NORMAL_BG = new ColorProperty(I18n.marktr("Discardable key: background"), Optional.ofNullable(UIManager.getColor("Table.background")).orElse(Color.WHITE)).cached();
    }
}

