/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.tools;

import java.awt.GraphicsEnvironment;
import java.io.IOException;
import java.net.URL;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.DataLine;
import javax.sound.sampled.LineUnavailableException;
import javax.sound.sampled.SourceDataLine;
import javax.sound.sampled.UnsupportedAudioFileException;
import javax.swing.JOptionPane;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.JosmRuntimeException;
import org.openstreetmap.josm.tools.Utils;

public final class AudioPlayer
extends Thread {
    private static volatile AudioPlayer audioPlayer;
    private State state = State.INITIALIZING;
    private URL playingUrl = null;
    private final double leadIn;
    private final double calibration;
    private double position;
    private double bytesPerSecond;
    private static long chunk;
    private double speed = 1.0;
    private final Execute command = new Execute();

    public static void play(URL uRL) throws InterruptedException, IOException {
        AudioPlayer audioPlayer = AudioPlayer.getInstance();
        if (audioPlayer != null) {
            audioPlayer.command.play(uRL, 0.0, 1.0);
        }
    }

    public static void play(URL uRL, double d) throws InterruptedException, IOException {
        AudioPlayer audioPlayer = AudioPlayer.getInstance();
        if (audioPlayer != null) {
            audioPlayer.command.play(uRL, d, 1.0);
        }
    }

    public static void play(URL uRL, double d, double d2) throws InterruptedException, IOException {
        AudioPlayer audioPlayer = AudioPlayer.getInstance();
        if (audioPlayer != null) {
            audioPlayer.command.play(uRL, d, d2);
        }
    }

    public static void pause() throws InterruptedException, IOException {
        AudioPlayer audioPlayer = AudioPlayer.getInstance();
        if (audioPlayer != null) {
            audioPlayer.command.pause();
        }
    }

    public static URL url() {
        AudioPlayer audioPlayer = AudioPlayer.getInstance();
        return audioPlayer == null ? null : audioPlayer.playingUrl;
    }

    public static boolean paused() {
        AudioPlayer audioPlayer = AudioPlayer.getInstance();
        return audioPlayer == null ? false : audioPlayer.state == State.PAUSED;
    }

    public static boolean playing() {
        AudioPlayer audioPlayer = AudioPlayer.getInstance();
        return audioPlayer == null ? false : audioPlayer.state == State.PLAYING;
    }

    public static double position() {
        AudioPlayer audioPlayer = AudioPlayer.getInstance();
        return audioPlayer == null ? -1.0 : audioPlayer.position;
    }

    public static double speed() {
        AudioPlayer audioPlayer = AudioPlayer.getInstance();
        return audioPlayer == null ? -1.0 : audioPlayer.speed;
    }

    private static AudioPlayer getInstance() {
        if (audioPlayer != null) {
            return audioPlayer;
        }
        try {
            audioPlayer = new AudioPlayer();
            return audioPlayer;
        }
        catch (IllegalArgumentException | IllegalStateException | JosmRuntimeException runtimeException) {
            Main.error(runtimeException);
            return null;
        }
    }

    public static void reset() {
        if (audioPlayer != null) {
            try {
                AudioPlayer.pause();
            }
            catch (IOException | InterruptedException exception) {
                Main.warn(exception);
            }
            AudioPlayer.audioPlayer.playingUrl = null;
        }
    }

    private AudioPlayer() {
        this.leadIn = Main.pref.getDouble("audio.leadin", 1.0);
        this.calibration = Main.pref.getDouble("audio.calibration", 1.0);
        this.start();
        while (this.state == State.INITIALIZING) {
            AudioPlayer.yield();
        }
    }

    @Override
    public void run() {
        this.playingUrl = null;
        AudioInputStream audioInputStream = null;
        DataLine dataLine = null;
        byte[] byArray = new byte[(int)chunk];
        while (true) {
            try {
                while (true) {
                    switch (this.state) {
                        case INITIALIZING: {
                            this.state = State.NOTPLAYING;
                            break;
                        }
                        case NOTPLAYING: 
                        case PAUSED: {
                            AudioPlayer.sleep(200L);
                            break;
                        }
                        case PLAYING: {
                            this.command.possiblyInterrupt();
                            while (true) {
                                int n = 0;
                                if (audioInputStream != null) {
                                    n = audioInputStream.read(byArray, 0, byArray.length);
                                    this.position += (double)n / this.bytesPerSecond;
                                }
                                this.command.possiblyInterrupt();
                                if (n < 0 || audioInputStream == null || dataLine == null) break;
                                dataLine.write(byArray, 0, n);
                                this.command.possiblyInterrupt();
                            }
                            if (dataLine != null) {
                                dataLine.drain();
                                dataLine.close();
                            }
                            dataLine = null;
                            Utils.close(audioInputStream);
                            audioInputStream = null;
                            this.playingUrl = null;
                            this.state = State.NOTPLAYING;
                            this.command.possiblyInterrupt();
                            break;
                        }
                    }
                }
            }
            catch (InterruptedException interruptedException) {
                AudioPlayer.interrupted();
                State state = this.state;
                this.state = State.INTERRUPTED;
                try {
                    switch (this.command.command()) {
                        case PLAY: {
                            double d = this.command.offset();
                            this.speed = this.command.speed();
                            if (this.playingUrl != this.command.url() || state != State.PAUSED || d != 0.0) {
                                if (audioInputStream != null) {
                                    Utils.close(audioInputStream);
                                }
                                this.playingUrl = this.command.url();
                                audioInputStream = AudioSystem.getAudioInputStream(this.playingUrl);
                                AudioFormat audioFormat = audioInputStream.getFormat();
                                this.position = 0.0;
                                double d2 = (d -= this.leadIn) * this.calibration;
                                this.bytesPerSecond = audioFormat.getFrameRate() * (float)audioFormat.getFrameSize();
                                if (this.speed * this.bytesPerSecond > 256000.0) {
                                    this.speed = 256000.0 / this.bytesPerSecond;
                                }
                                if (d2 > 0.0) {
                                    long l;
                                    long l2;
                                    for (l = (long)(d2 * this.bytesPerSecond); l > chunk; l -= l2) {
                                        l2 = audioInputStream.skip(chunk);
                                        if (l2 > 0L) continue;
                                        throw new IOException(I18n.tr("This is after the end of the recording", new Object[0]));
                                    }
                                    while (l > 0L) {
                                        long l3 = audioInputStream.skip(l);
                                        l -= l3;
                                        if (l3 != 0L) continue;
                                        Main.warn("Unable to skip bytes from audio input stream");
                                        l = 0L;
                                    }
                                    this.position = d;
                                }
                                if (dataLine != null) {
                                    dataLine.close();
                                }
                                audioFormat = new AudioFormat(audioFormat.getEncoding(), audioFormat.getSampleRate() * (float)(this.speed * this.calibration), audioFormat.getSampleSizeInBits(), audioFormat.getChannels(), audioFormat.getFrameSize(), audioFormat.getFrameRate() * (float)(this.speed * this.calibration), audioFormat.isBigEndian());
                                DataLine.Info info = new DataLine.Info(SourceDataLine.class, audioFormat);
                                dataLine = (SourceDataLine)AudioSystem.getLine(info);
                                dataLine.open(audioFormat);
                                dataLine.start();
                            }
                            state = State.PLAYING;
                            break;
                        }
                        case PAUSE: {
                            state = State.PAUSED;
                            break;
                        }
                    }
                    this.command.ok(state);
                }
                catch (IOException | IllegalArgumentException | SecurityException | LineUnavailableException | UnsupportedAudioFileException exception) {
                    Main.error(exception);
                    this.command.failed(exception);
                }
                continue;
            }
            catch (IOException iOException) {
                this.state = State.NOTPLAYING;
                Main.error(iOException);
                continue;
            }
            break;
        }
    }

    public static void audioMalfunction(Exception exception) {
        String string = exception.getMessage();
        string = string == null ? I18n.tr("unspecified reason", new Object[0]) : I18n.tr(string, new Object[0]);
        Main.error(string);
        if (!GraphicsEnvironment.isHeadless()) {
            JOptionPane.showMessageDialog(Main.parent, "<html><p>" + string + "</p></html>", I18n.tr("Error playing sound", new Object[0]), 0);
        }
    }

    static {
        chunk = 4000L;
    }

    private class Execute {
        private Command command;
        private Result result;
        private Exception exception;
        private URL url;
        private double offset;
        private double speed;

        private Execute() {
        }

        protected void play(URL uRL, double d, double d2) throws InterruptedException, IOException {
            this.url = uRL;
            this.offset = d;
            this.speed = d2;
            this.command = Command.PLAY;
            this.result = Result.WAITING;
            this.send();
        }

        protected void pause() throws InterruptedException, IOException {
            this.command = Command.PAUSE;
            this.send();
        }

        private void send() throws InterruptedException, IOException {
            this.result = Result.WAITING;
            AudioPlayer.this.interrupt();
            while (this.result == Result.WAITING) {
                Thread.sleep(10L);
            }
            if (this.result == Result.FAILED) {
                throw new IOException(this.exception);
            }
        }

        private void possiblyInterrupt() throws InterruptedException {
            if (Thread.interrupted() || this.result == Result.WAITING) {
                throw new InterruptedException();
            }
        }

        protected void failed(Exception exception) {
            this.exception = exception;
            this.result = Result.FAILED;
            AudioPlayer.this.state = State.NOTPLAYING;
        }

        protected void ok(State state) {
            this.result = Result.OK;
            AudioPlayer.this.state = state;
        }

        protected double offset() {
            return this.offset;
        }

        protected double speed() {
            return this.speed;
        }

        protected URL url() {
            return this.url;
        }

        protected Command command() {
            return this.command;
        }
    }

    private static enum Result {
        WAITING,
        OK,
        FAILED;

    }

    private static enum Command {
        PLAY,
        PAUSE;

    }

    private static enum State {
        INITIALIZING,
        NOTPLAYING,
        PLAYING,
        PAUSED,
        INTERRUPTED;

    }
}

