/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.tools;

import java.awt.GraphicsEnvironment;
import java.io.File;
import java.io.IOException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.List;
import org.openstreetmap.josm.io.CertificateAmendment;
import org.openstreetmap.josm.tools.Shortcut;

public interface PlatformHook {
    default public void preStartupHook() {
    }

    default public void afterPrefStartupHook() {
    }

    default public void startupHook() {
    }

    public void openUrl(String var1) throws IOException;

    public void initSystemShortcuts();

    default public String makeTooltip(String string, Shortcut shortcut) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("<html>").append(string);
        if (shortcut != null && !shortcut.getKeyText().isEmpty()) {
            stringBuilder.append(" <font size='-2'>(").append(shortcut.getKeyText()).append(")</font>");
        }
        return stringBuilder.append("&nbsp;</html>").toString();
    }

    public String getDefaultStyle();

    default public boolean canFullscreen() {
        return !GraphicsEnvironment.isHeadless() && GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice().isFullScreenSupported();
    }

    default public boolean rename(File file, File file2) {
        return file.renameTo(file2);
    }

    public String getOSDescription();

    default public boolean setupHttpsCertificate(String string, KeyStore.TrustedCertificateEntry trustedCertificateEntry) throws KeyStoreException, NoSuchAlgorithmException, CertificateException, IOException {
        return false;
    }

    default public X509Certificate getX509Certificate(CertificateAmendment.CertAmend certAmend) throws KeyStoreException, NoSuchAlgorithmException, CertificateException, IOException {
        return null;
    }

    public File getDefaultCacheDirectory();

    public File getDefaultPrefDirectory();

    public File getDefaultUserDataDirectory();

    public List<File> getDefaultProj4NadshiftDirectories();
}

