/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.rules.bitext;

import java.io.IOException;
import org.languagetool.AnalyzedSentence;
import org.languagetool.AnalyzedTokenReadings;
import org.languagetool.rules.ITSIssueType;
import org.languagetool.rules.RuleMatch;
import org.languagetool.rules.bitext.BitextRule;

public class DifferentLengthRule
extends BitextRule {
    private static final int MAX_SKEW = 250;
    private static final int MIN_SKEW = 30;

    public DifferentLengthRule() {
        this.setLocQualityIssueType(ITSIssueType.Length);
    }

    @Override
    public String getDescription() {
        return "Check if translation length is similar to source length";
    }

    @Override
    public String getId() {
        return "TRANSLATION_LENGTH";
    }

    @Override
    public String getMessage() {
        return "Source and target translation lengths are very different";
    }

    @Override
    public RuleMatch[] match(AnalyzedSentence sourceText, AnalyzedSentence targetText) throws IOException {
        if (this.isLengthDifferent(sourceText.getText(), targetText.getText())) {
            AnalyzedTokenReadings[] tokens = targetText.getTokens();
            int endPos = tokens[tokens.length - 1].getStartPos() + tokens[tokens.length - 1].getToken().length();
            return new RuleMatch[]{new RuleMatch(this, 0, endPos, this.getMessage())};
        }
        return new RuleMatch[0];
    }

    private boolean isLengthDifferent(String src, String trg) {
        double skew = (double)src.length() / (double)trg.length() * 100.0;
        return skew > 250.0 || skew < 30.0;
    }

    @Override
    public void reset() {
    }
}

