/*
 * Decompiled with CFR 0.152.
 */
package opennlp.tools.ml;

import java.util.HashMap;
import java.util.Map;
import opennlp.tools.util.TrainingParameters;

public abstract class AbstractTrainer {
    public static final String ALGORITHM_PARAM = "Algorithm";
    public static final String TRAINER_TYPE_PARAM = "TrainerType";
    public static final String CUTOFF_PARAM = "Cutoff";
    public static final int CUTOFF_DEFAULT = 5;
    public static final String ITERATIONS_PARAM = "Iterations";
    public static final int ITERATIONS_DEFAULT = 100;
    public static final String VERBOSE_PARAM = "PrintMessages";
    public static final boolean VERBOSE_DEFAULT = true;
    protected TrainingParameters trainingParameters;
    protected Map<String, String> reportMap;
    protected boolean printMessages;

    public AbstractTrainer() {
    }

    public AbstractTrainer(TrainingParameters parameters) {
        this.init(parameters, new HashMap<String, String>());
    }

    public void init(TrainingParameters trainingParameters, Map<String, String> reportMap) {
        this.trainingParameters = trainingParameters;
        if (reportMap == null) {
            reportMap = new HashMap<String, String>();
        }
        this.reportMap = reportMap;
        this.printMessages = trainingParameters.getBooleanParameter(VERBOSE_PARAM, true);
    }

    @Deprecated
    public void init(Map<String, String> trainParams, Map<String, String> reportMap) {
        this.init(new TrainingParameters(trainParams), reportMap);
    }

    public String getAlgorithm() {
        return this.trainingParameters.getStringParameter(ALGORITHM_PARAM, "MAXENT");
    }

    public int getCutoff() {
        return this.trainingParameters.getIntParameter(CUTOFF_PARAM, 5);
    }

    public int getIterations() {
        return this.trainingParameters.getIntParameter(ITERATIONS_PARAM, 100);
    }

    public boolean isValid() {
        try {
            this.trainingParameters.getIntParameter(CUTOFF_PARAM, 5);
            this.trainingParameters.getIntParameter(ITERATIONS_PARAM, 100);
        }
        catch (NumberFormatException e) {
            return false;
        }
        return true;
    }

    @Deprecated
    protected String getStringParam(String key, String defaultValue) {
        return this.trainingParameters.getStringParameter(key, defaultValue);
    }

    @Deprecated
    protected int TrainingParameters(String key, int defaultValue) {
        return this.trainingParameters.getIntParameter(key, defaultValue);
    }

    @Deprecated
    protected double getDoubleParam(String key, double defaultValue) {
        return this.trainingParameters.getDoubleParameter(key, defaultValue);
    }

    @Deprecated
    protected boolean getBooleanParam(String key, boolean defaultValue) {
        return this.trainingParameters.getBooleanParameter(key, defaultValue);
    }

    protected void addToReport(String key, String value) {
        this.reportMap.put(key, value);
    }

    protected void display(String s) {
        if (this.printMessages) {
            System.out.print(s);
        }
    }
}

