/*
 * Decompiled with CFR 0.152.
 */
package org.zaproxy.zap.extension.anticsrf;

import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import net.htmlparser.jericho.Element;
import net.htmlparser.jericho.Source;
import org.apache.log4j.Logger;
import org.parosproxy.paros.Constant;
import org.parosproxy.paros.control.Control;
import org.parosproxy.paros.db.DatabaseException;
import org.parosproxy.paros.extension.ExtensionAdaptor;
import org.parosproxy.paros.extension.ExtensionHook;
import org.parosproxy.paros.extension.SessionChangedListener;
import org.parosproxy.paros.extension.encoder.Encoder;
import org.parosproxy.paros.extension.history.ExtensionHistory;
import org.parosproxy.paros.extension.history.HistoryFilter;
import org.parosproxy.paros.model.HistoryReference;
import org.parosproxy.paros.model.Model;
import org.parosproxy.paros.model.Session;
import org.parosproxy.paros.network.HtmlParameter;
import org.parosproxy.paros.network.HttpMalformedHeaderException;
import org.parosproxy.paros.network.HttpMessage;
import org.zaproxy.zap.extension.anticsrf.AntiCsrfAPI;
import org.zaproxy.zap.extension.anticsrf.AntiCsrfDetectScanner;
import org.zaproxy.zap.extension.anticsrf.AntiCsrfParam;
import org.zaproxy.zap.extension.anticsrf.AntiCsrfToken;
import org.zaproxy.zap.extension.anticsrf.OptionsAntiCsrfPanel;
import org.zaproxy.zap.extension.anticsrf.PopupMenuGenerateForm;
import org.zaproxy.zap.extension.pscan.ExtensionPassiveScan;

public class ExtensionAntiCSRF
extends ExtensionAdaptor
implements SessionChangedListener {
    public static final String NAME = "ExtensionAntiCSRF";
    public static final String TAG = "AntiCSRF";
    private Map<String, AntiCsrfToken> valueToToken = new HashMap<String, AntiCsrfToken>();
    private OptionsAntiCsrfPanel optionsAntiCsrfPanel = null;
    private PopupMenuGenerateForm popupMenuGenerateForm = null;
    private Encoder encoder = new Encoder();
    private static Logger log = Logger.getLogger(ExtensionAntiCSRF.class);
    private AntiCsrfDetectScanner antiCsrfDetectScanner;
    private HistoryReferenceFactory historyReferenceFactory;

    public ExtensionAntiCSRF() {
        this.initialize();
    }

    private void initialize() {
        this.setName(NAME);
        this.setOrder(50);
    }

    @Override
    public void init() {
        this.antiCsrfDetectScanner = new AntiCsrfDetectScanner(this);
    }

    @Override
    public void hook(ExtensionHook extensionHook) {
        ExtensionPassiveScan extensionPassiveScan;
        super.hook(extensionHook);
        final ExtensionHistory extensionHistory = (ExtensionHistory)Control.getSingleton().getExtensionLoader().getExtension("ExtensionHistory");
        this.historyReferenceFactory = extensionHistory != null ? new HistoryReferenceFactory(){

            @Override
            public HistoryReference createHistoryReference(int n) {
                return extensionHistory.getHistoryReference(n);
            }
        } : new HistoryReferenceFactory(){

            @Override
            public HistoryReference createHistoryReference(int n) throws HttpMalformedHeaderException, DatabaseException {
                return new HistoryReference(n);
            }
        };
        AntiCsrfToken.setHistoryReferenceFactory(this.historyReferenceFactory);
        extensionHook.addSessionListener(this);
        if (this.getView() != null) {
            extensionHook.getHookView().addOptionPanel(this.getOptionsAntiCsrfPanel());
            extensionHook.getHookMenu().addPopupMenuItem(this.getPopupMenuGenerateForm());
        }
        if ((extensionPassiveScan = (ExtensionPassiveScan)Control.getSingleton().getExtensionLoader().getExtension("ExtensionPassiveScan")) != null) {
            extensionPassiveScan.addPassiveScanner(this.antiCsrfDetectScanner);
        }
        AntiCsrfAPI antiCsrfAPI = new AntiCsrfAPI(this);
        antiCsrfAPI.addApiOptions(this.getParam());
        extensionHook.addApiImplementor(antiCsrfAPI);
    }

    @Override
    public void unload() {
        ExtensionPassiveScan extensionPassiveScan = (ExtensionPassiveScan)Control.getSingleton().getExtensionLoader().getExtension("ExtensionPassiveScan");
        if (extensionPassiveScan != null) {
            extensionPassiveScan.removePassiveScanner(this.antiCsrfDetectScanner);
        }
        super.unload();
    }

    private PopupMenuGenerateForm getPopupMenuGenerateForm() {
        if (this.popupMenuGenerateForm == null) {
            this.popupMenuGenerateForm = new PopupMenuGenerateForm(Constant.messages.getString("anticsrf.genForm.popup"));
        }
        return this.popupMenuGenerateForm;
    }

    private OptionsAntiCsrfPanel getOptionsAntiCsrfPanel() {
        if (this.optionsAntiCsrfPanel == null) {
            this.optionsAntiCsrfPanel = new OptionsAntiCsrfPanel();
        }
        return this.optionsAntiCsrfPanel;
    }

    protected AntiCsrfParam getParam() {
        return Model.getSingleton().getOptionsParam().getAntiCsrfParam();
    }

    public List<String> getAntiCsrfTokenNames() {
        return this.getParam().getTokensNames();
    }

    public void addAntiCsrfTokenName(String string) {
        this.getParam().addToken(string);
    }

    public void removeAntiCsrfTokenName(String string) {
        this.getParam().removeToken(string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerAntiCsrfToken(AntiCsrfToken antiCsrfToken) {
        log.debug((Object)("registerAntiCsrfToken " + antiCsrfToken.getMsg().getRequestHeader().getURI().toString() + " " + antiCsrfToken.getValue()));
        Map<String, AntiCsrfToken> map = this.valueToToken;
        synchronized (map) {
            try {
                HistoryReference historyReference = antiCsrfToken.getMsg().getHistoryRef();
                if (historyReference == null) {
                    historyReference = new HistoryReference(this.getModel().getSession(), 0, antiCsrfToken.getMsg());
                    antiCsrfToken.getMsg().setHistoryRef(null);
                }
                antiCsrfToken.setHistoryReferenceId(historyReference.getHistoryId());
                this.valueToToken.put(this.encoder.getURLEncode(antiCsrfToken.getValue()), antiCsrfToken);
            }
            catch (DatabaseException | HttpMalformedHeaderException exception) {
                log.error((Object)"Failed to persist the message: ", (Throwable)exception);
            }
        }
    }

    public boolean requestHasToken(HttpMessage httpMessage) {
        return this.requestHasToken(httpMessage.getRequestBody().toString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean requestHasToken(String string) {
        Set<String> set;
        Map<String, AntiCsrfToken> map = this.valueToToken;
        synchronized (map) {
            set = Collections.unmodifiableSet(new HashSet<String>(this.valueToToken.keySet()));
        }
        for (String string2 : set) {
            if (string.indexOf(string2) < 0) continue;
            return true;
        }
        return false;
    }

    public List<AntiCsrfToken> getTokens(HttpMessage httpMessage) {
        return this.getTokens(httpMessage.getRequestBody().toString(), httpMessage.getRequestHeader().getURI().toString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<AntiCsrfToken> getTokens(String string, String string2) {
        Set<String> set;
        ArrayList<AntiCsrfToken> arrayList = new ArrayList<AntiCsrfToken>();
        Map<String, AntiCsrfToken> map = this.valueToToken;
        synchronized (map) {
            set = Collections.unmodifiableSet(new HashSet<String>(this.valueToToken.keySet()));
        }
        for (String string3 : set) {
            if (string.indexOf(string3) < 0) continue;
            AntiCsrfToken antiCsrfToken = this.valueToToken.get(string3).clone();
            antiCsrfToken.setTargetURL(string2);
            arrayList.add(antiCsrfToken);
        }
        return arrayList;
    }

    public String getTokenValue(HttpMessage httpMessage, String string) {
        String string2 = httpMessage.getResponseHeader().toString() + httpMessage.getResponseBody().toString();
        Source source = new Source((CharSequence)string2);
        List list = source.getAllElements("form");
        if (list != null && list.size() > 0) {
            for (Element element : list) {
                List list2 = element.getAllElements("input");
                if (list2 == null || list2.size() <= 0) continue;
                for (Element element2 : list2) {
                    String string3 = element2.getAttributeValue("ID");
                    if (string3 != null && string3.equalsIgnoreCase(string)) {
                        return element2.getAttributeValue("VALUE");
                    }
                    String string4 = element2.getAttributeValue("NAME");
                    if (string4 == null || !string4.equalsIgnoreCase(string)) continue;
                    return element2.getAttributeValue("VALUE");
                }
            }
        }
        return null;
    }

    public List<AntiCsrfToken> getTokensFromResponse(HttpMessage httpMessage, Source source) {
        ArrayList<AntiCsrfToken> arrayList = new ArrayList<AntiCsrfToken>();
        List list = source.getAllElements("form");
        if (list != null && list.size() > 0) {
            log.debug((Object)("Found " + list.size() + " forms"));
            int n = 0;
            for (Element element : list) {
                List list2 = element.getAllElements("input");
                if (list2 != null && list2.size() > 0) {
                    log.debug((Object)("Found " + list2.size() + " inputs"));
                    block1: for (Element element2 : list2) {
                        Object object;
                        String string = element2.getAttributeValue("VALUE");
                        if (string == null) continue;
                        String string2 = element2.getAttributeValue("ID");
                        boolean bl = false;
                        if (string2 != null) {
                            object = this.getAntiCsrfTokenNames().iterator();
                            while (object.hasNext()) {
                                String string3 = (String)object.next();
                                if (!string3.equalsIgnoreCase(string2)) continue;
                                arrayList.add(new AntiCsrfToken(httpMessage, string2, string, n));
                                bl = true;
                                break;
                            }
                        }
                        if (bl || (object = element2.getAttributeValue("NAME")) == null) continue;
                        for (String string4 : this.getAntiCsrfTokenNames()) {
                            if (!string4.equalsIgnoreCase((String)object)) continue;
                            arrayList.add(new AntiCsrfToken(httpMessage, (String)object, string, n));
                            continue block1;
                        }
                    }
                }
                ++n;
            }
        }
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void sessionChanged(Session session) {
        if (session == null) {
            return;
        }
        Object object = this.valueToToken;
        synchronized (object) {
            this.valueToToken.clear();
        }
        try {
            object = this.getModel().getDb().getTableHistory().getHistoryIdsOfHistType(session.getSessionId(), 1, 15);
            HistoryFilter historyFilter = new HistoryFilter();
            historyFilter.setTags(Arrays.asList(TAG));
            AntiCsrfDetectScanner antiCsrfDetectScanner = new AntiCsrfDetectScanner(this);
            Iterator iterator = object.iterator();
            while (iterator.hasNext()) {
                Integer n = (Integer)iterator.next();
                HistoryReference historyReference = this.historyReferenceFactory.createHistoryReference(n);
                if (!historyFilter.matches(historyReference)) continue;
                HttpMessage httpMessage = historyReference.getHttpMessage();
                String string = httpMessage.getResponseHeader().toString() + httpMessage.getResponseBody().toString();
                Source source = new Source((CharSequence)string);
                if (!httpMessage.isResponseFromTargetHost()) continue;
                antiCsrfDetectScanner.scanHttpResponseReceive(httpMessage, historyReference.getHistoryId(), source);
            }
        }
        catch (DatabaseException | HttpMalformedHeaderException exception) {
            log.error((Object)exception.getMessage(), (Throwable)exception);
        }
    }

    public boolean isAntiCsrfToken(String string) {
        if (string == null) {
            return false;
        }
        return this.getParam().getTokensNames().contains(string.toLowerCase());
    }

    @Override
    public void sessionAboutToChange(Session session) {
    }

    @Override
    public void sessionScopeChanged(Session session) {
    }

    @Override
    public String getAuthor() {
        return "ZAP Dev Team";
    }

    @Override
    public String getDescription() {
        return Constant.messages.getString("anticsrf.desc");
    }

    @Override
    public URL getURL() {
        try {
            return new URL("http://www.owasp.org/index.php/ZAP");
        }
        catch (MalformedURLException malformedURLException) {
            return null;
        }
    }

    @Override
    public void sessionModeChanged(Control.Mode mode) {
    }

    public String generateForm(int n) throws Exception {
        ExtensionHistory extensionHistory = (ExtensionHistory)Control.getSingleton().getExtensionLoader().getExtension("ExtensionHistory");
        if (extensionHistory != null) {
            HistoryReference historyReference = extensionHistory.getHistoryReference(n);
            if (historyReference == null) {
                return null;
            }
            HttpMessage httpMessage = historyReference.getHttpMessage();
            StringBuilder stringBuilder = new StringBuilder(300);
            stringBuilder.append("<html>\n");
            stringBuilder.append("<body>\n");
            stringBuilder.append("<h3>");
            stringBuilder.append(httpMessage.getRequestHeader().getURI());
            stringBuilder.append("</h3>");
            stringBuilder.append("<form id=\"f1\" method=\"POST\" action=\"" + historyReference.getURI() + "\">\n");
            stringBuilder.append("<table>\n");
            TreeSet<HtmlParameter> treeSet = httpMessage.getFormParams();
            httpMessage = null;
            for (HtmlParameter htmlParameter : treeSet) {
                String string = URLDecoder.decode(htmlParameter.getName(), "UTF-8");
                String string2 = URLDecoder.decode(htmlParameter.getValue(), "UTF-8");
                stringBuilder.append("<tr><td>\n");
                stringBuilder.append(string);
                stringBuilder.append("<td>");
                stringBuilder.append("<input name=\"");
                stringBuilder.append(string);
                stringBuilder.append("\" value=\"");
                stringBuilder.append(string2);
                stringBuilder.append("\" size=\"100\">");
                stringBuilder.append("</tr>\n");
            }
            stringBuilder.append("</table>\n");
            stringBuilder.append("<input id=\"submit\" type=\"submit\" value=\"Submit\"/>\n");
            stringBuilder.append("</form>\n");
            stringBuilder.append("</body>\n");
            stringBuilder.append("</html>\n");
            return stringBuilder.toString();
        }
        return null;
    }

    static interface HistoryReferenceFactory {
        public HistoryReference createHistoryReference(int var1) throws DatabaseException, HttpMalformedHeaderException;
    }
}

