/*
 * Decompiled with CFR 0.152.
 */
package org.zaproxy.zap.extension.api;

import java.util.ArrayList;
import java.util.List;
import net.sf.json.JSON;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;
import org.apache.commons.lang.StringEscapeUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.zaproxy.zap.extension.api.ApiResponse;
import org.zaproxy.zap.extension.api.ApiResponseElement;

public class ApiResponseList
extends ApiResponse {
    private List<ApiResponse> list = null;

    public ApiResponseList(String string) {
        super(string);
        this.list = new ArrayList<ApiResponse>();
    }

    public ApiResponseList(String string, ApiResponse[] apiResponseArray) {
        super(string);
        this.list = new ArrayList<ApiResponse>();
        for (ApiResponse apiResponse : apiResponseArray) {
            this.list.add(apiResponse);
        }
    }

    public ApiResponseList(String string, List<ApiResponse> list) {
        super(string);
        this.list = list;
    }

    public void addItem(ApiResponse apiResponse) {
        this.list.add(apiResponse);
    }

    public List<ApiResponse> getItems() {
        return this.list;
    }

    public Class<? extends ApiResponse> getItemsClass() {
        if (this.list == null || this.list.size() == 0) {
            return null;
        }
        return this.list.get(0).getClass();
    }

    @Override
    public JSON toJSON() {
        if (this.list == null) {
            return null;
        }
        JSONObject jSONObject = new JSONObject();
        JSONArray jSONArray = new JSONArray();
        for (ApiResponse apiResponse : this.list) {
            if (apiResponse instanceof ApiResponseElement) {
                jSONArray.add((Object)((ApiResponseElement)apiResponse).getValue());
                continue;
            }
            jSONArray.add((Object)apiResponse.toJSON());
        }
        jSONObject.put((Object)this.getName(), (Object)jSONArray);
        return jSONObject;
    }

    @Override
    public void toXML(Document document, Element element) {
        element.setAttribute("type", "list");
        for (ApiResponse apiResponse : this.list) {
            Element element2 = document.createElement(apiResponse.getName());
            apiResponse.toXML(document, element2);
            element.appendChild(element2);
        }
    }

    @Override
    public void toHTML(StringBuilder stringBuilder) {
        stringBuilder.append("<h2>" + StringEscapeUtils.escapeHtml((String)this.getName()) + "</h2>\n");
        stringBuilder.append("<table border=\"1\">\n");
        for (ApiResponse apiResponse : this.list) {
            stringBuilder.append("<tr><td>\n");
            apiResponse.toHTML(stringBuilder);
            stringBuilder.append("</td></tr>\n");
        }
        stringBuilder.append("</table>\n");
    }

    @Override
    public String toString(int n) {
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < n; ++i) {
            stringBuilder.append("\t");
        }
        stringBuilder.append("ApiResponseList ");
        stringBuilder.append(this.getName());
        stringBuilder.append(" : [\n");
        for (ApiResponse apiResponse : this.list) {
            stringBuilder.append(apiResponse.toString(n + 1));
        }
        for (int i = 0; i < n; ++i) {
            stringBuilder.append("\t");
        }
        stringBuilder.append("]\n");
        return stringBuilder.toString();
    }
}

