/*
 * Decompiled with CFR 0.152.
 */
package org.zaproxy.zap.extension.httppanel.view.util;

import javax.swing.JTextArea;
import javax.swing.text.BadLocationException;
import org.apache.log4j.Logger;

public final class HttpTextViewUtils {
    public static final int[] INVALID_POSITION = new int[0];
    private static final Logger LOGGER = Logger.getLogger(HttpTextViewUtils.class);

    private HttpTextViewUtils() {
    }

    public static int[] getHeaderToViewPosition(JTextArea jTextArea, String string, int n, int n2) {
        int n3;
        HttpTextViewUtils.validateView(jTextArea);
        HttpTextViewUtils.validateHeader(string);
        HttpTextViewUtils.validateStartEnd(n, n2);
        if (!HttpTextViewUtils.isValidStartEndForLength(n, n2, string.length())) {
            return INVALID_POSITION;
        }
        int n4 = 0;
        int n5 = 0;
        while ((n5 = string.indexOf("\r\n", n5)) != -1 && n5 < n) {
            n5 += 2;
            ++n4;
        }
        int n6 = n - n4;
        int n7 = jTextArea.getDocument().getLength();
        if (n6 > n7) {
            return INVALID_POSITION;
        }
        if (n5 != -1) {
            while ((n5 = string.indexOf("\r\n", n5)) != -1 && n5 < n2) {
                n5 += 2;
                ++n4;
            }
        }
        if ((n3 = n2 - n4) > n7) {
            return INVALID_POSITION;
        }
        return new int[]{n6, n3};
    }

    private static void validateView(JTextArea jTextArea) {
        if (jTextArea == null || jTextArea.getDocument() == null) {
            throw new IllegalArgumentException("Parameter view must not be null and must have a Document.");
        }
    }

    private static void validateHeader(String string) {
        if (string == null) {
            throw new IllegalArgumentException("Parameter header must not be null.");
        }
    }

    private static void validateStartEnd(int n, int n2) {
        if (n < 0) {
            throw new IllegalArgumentException("Parameter start must not be negative.");
        }
        if (n2 < 0) {
            throw new IllegalArgumentException("Parameter end must not be negative.");
        }
        if (n > n2) {
            throw new IllegalArgumentException("Parameter start must not be greater than end.");
        }
    }

    private static boolean isValidStartEndForLength(int n, int n2, int n3) {
        return n <= n3 && n2 <= n3;
    }

    public static int[] getBodyToViewPosition(JTextArea jTextArea, String string, int n, int n2) {
        HttpTextViewUtils.validateView(jTextArea);
        HttpTextViewUtils.validateHeader(string);
        HttpTextViewUtils.validateStartEnd(n, n2);
        if (!HttpTextViewUtils.isValidStartEndForLength(n, n2, jTextArea.getDocument().getLength())) {
            return INVALID_POSITION;
        }
        int n3 = 0;
        int n4 = 0;
        while ((n4 = string.indexOf("\r\n", n4)) != -1) {
            n4 += 2;
            ++n3;
        }
        int n5 = jTextArea.getDocument().getLength();
        int n6 = n5 - string.length() + n3;
        if (n6 < 0 || n > n6 || n2 > n6) {
            return INVALID_POSITION;
        }
        int n7 = n + string.length() - n3;
        int n8 = n2 + string.length() - n3;
        return new int[]{n7, n8};
    }

    public static int[] getViewToHeaderPosition(JTextArea jTextArea, int n, int n2) {
        HttpTextViewUtils.validateView(jTextArea);
        HttpTextViewUtils.validateStartEnd(n, n2);
        if (!HttpTextViewUtils.isValidStartEndForLength(n, n2, jTextArea.getDocument().getLength())) {
            return INVALID_POSITION;
        }
        return HttpTextViewUtils.getViewToHeaderPositionImpl(jTextArea, n, n2);
    }

    private static int[] getViewToHeaderPositionImpl(JTextArea jTextArea, int n, int n2) {
        int n3 = n;
        try {
            n3 += jTextArea.getLineOfOffset(n3);
        }
        catch (BadLocationException badLocationException) {
            LOGGER.error((Object)badLocationException.getMessage(), (Throwable)badLocationException);
            return INVALID_POSITION;
        }
        int n4 = n2;
        try {
            n4 += jTextArea.getLineOfOffset(n4);
        }
        catch (BadLocationException badLocationException) {
            LOGGER.error((Object)badLocationException.getMessage(), (Throwable)badLocationException);
            return INVALID_POSITION;
        }
        return new int[]{n3, n4};
    }

    public static int[] getViewToHeaderBodyPosition(JTextArea jTextArea, String string, int n, int n2) {
        HttpTextViewUtils.validateView(jTextArea);
        HttpTextViewUtils.validateHeader(string);
        HttpTextViewUtils.validateStartEnd(n, n2);
        if (!HttpTextViewUtils.isValidStartEndForLength(n, n2, jTextArea.getDocument().getLength())) {
            return INVALID_POSITION;
        }
        int n3 = 0;
        int n4 = 0;
        while ((n4 = string.indexOf("\r\n", n4)) != -1) {
            n4 += 2;
            ++n3;
        }
        if (n + n3 < string.length()) {
            int[] nArray = HttpTextViewUtils.getViewToHeaderPositionImpl(jTextArea, n, n2);
            if (nArray[1] > string.length()) {
                nArray[1] = string.length();
            }
            return nArray;
        }
        int n5 = n + n3 - string.length();
        int n6 = n2 + n3 - string.length();
        return new int[]{n5, n6, 0};
    }
}

