/*
 * Decompiled with CFR 0.152.
 */
package org.zaproxy.zap.extension.pscan;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.swing.ImageIcon;
import org.apache.commons.configuration.Configuration;
import org.apache.commons.configuration.FileConfiguration;
import org.apache.log4j.Logger;
import org.parosproxy.paros.Constant;
import org.parosproxy.paros.control.Control;
import org.parosproxy.paros.core.scanner.Plugin;
import org.parosproxy.paros.extension.ExtensionAdaptor;
import org.parosproxy.paros.extension.ExtensionHook;
import org.parosproxy.paros.extension.ExtensionLoader;
import org.parosproxy.paros.extension.SessionChangedListener;
import org.parosproxy.paros.extension.history.ExtensionHistory;
import org.parosproxy.paros.model.Session;
import org.parosproxy.paros.view.View;
import org.zaproxy.zap.ZAP;
import org.zaproxy.zap.control.CoreFunctionality;
import org.zaproxy.zap.control.ExtensionFactory;
import org.zaproxy.zap.extension.alert.ExtensionAlert;
import org.zaproxy.zap.extension.pscan.OptionsPassiveScan;
import org.zaproxy.zap.extension.pscan.PassiveScanAPI;
import org.zaproxy.zap.extension.pscan.PassiveScanParam;
import org.zaproxy.zap.extension.pscan.PassiveScanThread;
import org.zaproxy.zap.extension.pscan.PassiveScanner;
import org.zaproxy.zap.extension.pscan.PassiveScannerList;
import org.zaproxy.zap.extension.pscan.PassiveScannerOptionsPanel;
import org.zaproxy.zap.extension.pscan.PluginPassiveScanner;
import org.zaproxy.zap.extension.pscan.PolicyPassiveScanPanel;
import org.zaproxy.zap.extension.pscan.scanner.RegexAutoTagScanner;
import org.zaproxy.zap.extension.script.ExtensionScript;
import org.zaproxy.zap.extension.script.ScriptType;

public class ExtensionPassiveScan
extends ExtensionAdaptor
implements SessionChangedListener {
    public static final String NAME = "ExtensionPassiveScan";
    private static final ImageIcon SCRIPT_ICON = new ImageIcon(ZAP.class.getResource("/resource/icon/16/script-pscan.png"));
    public static final String SCRIPT_TYPE_PASSIVE = "passive";
    private static final Logger logger = Logger.getLogger(ExtensionPassiveScan.class);
    private PassiveScannerList scannerList;
    private OptionsPassiveScan optionsPassiveScan = null;
    private PolicyPassiveScanPanel policyPanel = null;
    private PassiveScanThread pst = null;
    private boolean passiveScanEnabled;
    private PassiveScanParam passiveScanParam;
    private static final List<Class<?>> DEPENDENCIES;
    private PassiveScannerOptionsPanel passiveScannerOptionsPanel;

    public ExtensionPassiveScan() {
        this.initialize();
    }

    private void initialize() {
        this.setOrder(26);
        this.setName(NAME);
    }

    @Override
    public void init() {
        super.init();
        this.passiveScanEnabled = true;
    }

    @Override
    public void hook(ExtensionHook extensionHook) {
        ExtensionScript extensionScript;
        super.hook(extensionHook);
        extensionHook.addOptionsParamSet(this.getPassiveScanParam());
        extensionHook.addProxyListener(this.getPassiveScanThread());
        extensionHook.addSessionListener(this);
        if (this.getView() != null) {
            extensionHook.getHookView().addOptionPanel(this.getPassiveScannerOptionsPanel());
            extensionHook.getHookView().addOptionPanel(this.getOptionsPassiveScan(this.getPassiveScanThread()));
            extensionHook.getHookView().addOptionPanel(this.getPolicyPanel());
        }
        if ((extensionScript = (ExtensionScript)Control.getSingleton().getExtensionLoader().getExtension("ExtensionScript")) != null) {
            extensionScript.registerScriptType(new ScriptType(SCRIPT_TYPE_PASSIVE, "pscan.scripts.type.passive", SCRIPT_ICON, true));
        }
        extensionHook.addApiImplementor(new PassiveScanAPI(this));
    }

    @Override
    public void optionsLoaded() {
        this.getPassiveScannerList().setAutoTagScanners(this.getPassiveScanParam().getAutoTagScanners());
    }

    @Deprecated
    public boolean addPassiveScanner(String string) {
        try {
            Class<?> clazz = ExtensionFactory.getAddOnLoader().loadClass(string);
            this.addPassiveScanner((PluginPassiveScanner)clazz.newInstance());
            return true;
        }
        catch (Exception exception) {
            logger.error((Object)exception.getMessage(), (Throwable)exception);
            return false;
        }
    }

    public boolean removePassiveScanner(String string) {
        PassiveScanner passiveScanner = this.getPassiveScannerList().removeScanner(string);
        if (passiveScanner != null && View.isInitialised() && passiveScanner instanceof PluginPassiveScanner) {
            this.getPolicyPanel().getPassiveScanTableModel().removeScanner((PluginPassiveScanner)passiveScanner);
        }
        return passiveScanner != null;
    }

    public boolean addPassiveScanner(PassiveScanner passiveScanner) {
        if (passiveScanner == null) {
            throw new IllegalArgumentException("Parameter passiveScanner must not be null.");
        }
        if (passiveScanner instanceof PluginPassiveScanner) {
            return this.addPluginPassiveScannerImpl((PluginPassiveScanner)passiveScanner);
        }
        return this.addPassiveScannerImpl(passiveScanner);
    }

    public boolean removePassiveScanner(PassiveScanner passiveScanner) {
        if (passiveScanner == null) {
            throw new IllegalArgumentException("Parameter passiveScanner must not be null.");
        }
        return this.removePassiveScanner(passiveScanner.getClass().getName());
    }

    public boolean addPluginPassiveScanner(PluginPassiveScanner pluginPassiveScanner) {
        if (pluginPassiveScanner == null) {
            throw new IllegalArgumentException("Parameter pluginPassiveScanner must not be null.");
        }
        return this.addPluginPassiveScannerImpl(pluginPassiveScanner);
    }

    public boolean removePluginPassiveScanner(PluginPassiveScanner pluginPassiveScanner) {
        if (pluginPassiveScanner == null) {
            throw new IllegalArgumentException("Parameter pluginPassiveScanner must not be null.");
        }
        return this.removePassiveScanner(pluginPassiveScanner.getClass().getName());
    }

    private boolean addPassiveScannerImpl(PassiveScanner passiveScanner) {
        return this.scannerList.add(passiveScanner);
    }

    private boolean addPluginPassiveScannerImpl(PluginPassiveScanner pluginPassiveScanner) {
        if (pluginPassiveScanner instanceof RegexAutoTagScanner) {
            return false;
        }
        boolean bl = false;
        try {
            FileConfiguration fileConfiguration = this.getModel().getOptionsParam().getConfig();
            pluginPassiveScanner.setConfig((Configuration)fileConfiguration);
            bl = this.addPassiveScannerImpl(pluginPassiveScanner);
            if (View.isInitialised()) {
                this.getPolicyPanel().getPassiveScanTableModel().addScanner(pluginPassiveScanner);
            }
            logger.info((Object)("loaded passive scan rule: " + pluginPassiveScanner.getName()));
            if (pluginPassiveScanner.getPluginId() == -1) {
                logger.error((Object)("The passive scan rule \"" + pluginPassiveScanner.getName() + "\" [" + pluginPassiveScanner.getClass().getCanonicalName() + "] does not have a defined ID."));
            }
        }
        catch (Exception exception) {
            logger.error((Object)("Failed to load passive scanner " + pluginPassiveScanner.getName()), (Throwable)exception);
        }
        return bl;
    }

    private PassiveScannerList getPassiveScannerList() {
        if (this.scannerList == null) {
            this.scannerList = new PassiveScannerList();
            this.scannerList.setAutoTagScanners(this.getPassiveScanParam().getAutoTagScanners());
            ArrayList<PluginPassiveScanner> arrayList = new ArrayList<PluginPassiveScanner>(CoreFunctionality.getBuiltInPassiveScanRules());
            arrayList.addAll(ExtensionFactory.getAddOnLoader().getPassiveScanRules());
            for (PluginPassiveScanner pluginPassiveScanner : arrayList) {
                this.addPluginPassiveScannerImpl(pluginPassiveScanner);
            }
        }
        return this.scannerList;
    }

    protected List<PluginPassiveScanner> getPluginPassiveScanners() {
        ArrayList<PluginPassiveScanner> arrayList = new ArrayList<PluginPassiveScanner>();
        for (PassiveScanner passiveScanner : this.getPassiveScannerList().list()) {
            if (!(passiveScanner instanceof PluginPassiveScanner) || passiveScanner instanceof RegexAutoTagScanner) continue;
            arrayList.add((PluginPassiveScanner)passiveScanner);
        }
        return arrayList;
    }

    void setAllPluginPassiveScannersEnabled(boolean bl) {
        for (PluginPassiveScanner pluginPassiveScanner : this.getPluginPassiveScanners()) {
            pluginPassiveScanner.setEnabled(bl);
            pluginPassiveScanner.save();
        }
    }

    void setPluginPassiveScannerEnabled(int n, boolean bl) {
        for (PluginPassiveScanner pluginPassiveScanner : this.getPluginPassiveScanners()) {
            if (n != pluginPassiveScanner.getPluginId()) continue;
            pluginPassiveScanner.setEnabled(bl);
            pluginPassiveScanner.save();
        }
    }

    boolean hasPluginPassiveScanner(int n) {
        for (PluginPassiveScanner pluginPassiveScanner : this.getPluginPassiveScanners()) {
            if (n != pluginPassiveScanner.getPluginId()) continue;
            return true;
        }
        return false;
    }

    void setPluginPassiveScannerAlertThreshold(int n, Plugin.AlertThreshold alertThreshold) {
        for (PluginPassiveScanner pluginPassiveScanner : this.getPluginPassiveScanners()) {
            if (n != pluginPassiveScanner.getPluginId()) continue;
            pluginPassiveScanner.setLevel(alertThreshold);
            pluginPassiveScanner.setEnabled(!Plugin.AlertThreshold.OFF.equals((Object)alertThreshold));
            pluginPassiveScanner.save();
        }
    }

    public void setAllScannerThreshold(Plugin.AlertThreshold alertThreshold) {
        for (PluginPassiveScanner pluginPassiveScanner : this.getPluginPassiveScanners()) {
            pluginPassiveScanner.setLevel(alertThreshold);
            pluginPassiveScanner.setEnabled(!Plugin.AlertThreshold.OFF.equals((Object)alertThreshold));
            pluginPassiveScanner.save();
        }
    }

    public Plugin.AlertThreshold getAllScannerThreshold() {
        Plugin.AlertThreshold alertThreshold = null;
        for (PluginPassiveScanner pluginPassiveScanner : this.getPluginPassiveScanners()) {
            if (alertThreshold == null) {
                alertThreshold = pluginPassiveScanner.getLevel();
                continue;
            }
            if (alertThreshold.equals((Object)pluginPassiveScanner.getLevel())) continue;
            return null;
        }
        return alertThreshold;
    }

    protected PolicyPassiveScanPanel getPolicyPanel() {
        if (this.policyPanel == null) {
            this.policyPanel = new PolicyPassiveScanPanel();
        }
        return this.policyPanel;
    }

    public int getRecordsToScan() {
        if (this.passiveScanEnabled) {
            return this.getPassiveScanThread().getRecordsToScan();
        }
        return 0;
    }

    private PassiveScanThread getPassiveScanThread() {
        if (this.pst == null) {
            ExtensionLoader extensionLoader = Control.getSingleton().getExtensionLoader();
            ExtensionHistory extensionHistory = (ExtensionHistory)extensionLoader.getExtension("ExtensionHistory");
            ExtensionAlert extensionAlert = (ExtensionAlert)extensionLoader.getExtension("ExtensionAlert");
            this.pst = new PassiveScanThread(this.getPassiveScannerList(), extensionHistory, extensionAlert, this.getPassiveScanParam());
            this.pst.start();
        }
        return this.pst;
    }

    PassiveScanParam getPassiveScanParam() {
        if (this.passiveScanParam == null) {
            this.passiveScanParam = new PassiveScanParam();
        }
        return this.passiveScanParam;
    }

    private PassiveScannerOptionsPanel getPassiveScannerOptionsPanel() {
        if (this.passiveScannerOptionsPanel == null) {
            this.passiveScannerOptionsPanel = new PassiveScannerOptionsPanel(Constant.messages);
        }
        return this.passiveScannerOptionsPanel;
    }

    private OptionsPassiveScan getOptionsPassiveScan(PassiveScanThread passiveScanThread) {
        if (this.optionsPassiveScan == null) {
            this.optionsPassiveScan = new OptionsPassiveScan(this.scannerList);
        }
        return this.optionsPassiveScan;
    }

    @Override
    public void sessionAboutToChange(Session session) {
        this.stopPassiveScanThread();
    }

    private void stopPassiveScanThread() {
        if (this.pst != null) {
            this.getPassiveScanThread().shutdown();
            this.pst = null;
        }
    }

    @Override
    public void sessionChanged(Session session) {
        this.startPassiveScanThread();
    }

    private void startPassiveScanThread() {
        if (this.passiveScanEnabled && this.pst == null) {
            this.getPassiveScanThread();
        }
    }

    @Override
    public void destroy() {
        super.destroy();
        this.stopPassiveScanThread();
    }

    @Override
    public List<Class<?>> getDependencies() {
        return DEPENDENCIES;
    }

    @Override
    public void sessionScopeChanged(Session session) {
    }

    @Override
    public String getAuthor() {
        return "ZAP Dev Team";
    }

    @Override
    public String getDescription() {
        return Constant.messages.getString("pscan.desc");
    }

    @Override
    public URL getURL() {
        try {
            return new URL("http://www.owasp.org/index.php/ZAP");
        }
        catch (MalformedURLException malformedURLException) {
            return null;
        }
    }

    @Override
    public void sessionModeChanged(Control.Mode mode) {
    }

    void setPassiveScanEnabled(boolean bl) {
        if (this.passiveScanEnabled != bl) {
            this.passiveScanEnabled = bl;
            if (bl) {
                this.startPassiveScanThread();
            } else {
                this.stopPassiveScanThread();
            }
        }
    }

    public void saveTo(Configuration configuration) {
        for (PassiveScanner passiveScanner : this.getPassiveScannerList().list()) {
            if (!(passiveScanner instanceof PluginPassiveScanner) || passiveScanner instanceof RegexAutoTagScanner) continue;
            ((PluginPassiveScanner)passiveScanner).saveTo(configuration);
        }
    }

    public void loadFrom(Configuration configuration) {
        for (PassiveScanner passiveScanner : this.getPassiveScannerList().list()) {
            if (!(passiveScanner instanceof PluginPassiveScanner) || passiveScanner instanceof RegexAutoTagScanner) continue;
            ((PluginPassiveScanner)passiveScanner).loadFrom(configuration);
        }
    }

    @Override
    public boolean supportsLowMemory() {
        return true;
    }

    @Override
    public boolean supportsDb(String string) {
        return true;
    }

    static {
        ArrayList<Class<ExtensionAlert>> arrayList = new ArrayList<Class<ExtensionAlert>>(1);
        arrayList.add(ExtensionAlert.class);
        DEPENDENCIES = Collections.unmodifiableList(arrayList);
    }
}

