/*
 * Decompiled with CFR 0.152.
 */
package org.zaproxy.zap.spider;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.htmlparser.jericho.Config;
import org.apache.commons.httpclient.URI;
import org.apache.commons.httpclient.URIException;
import org.apache.log4j.Logger;
import org.parosproxy.paros.network.HttpMessage;
import org.zaproxy.zap.spider.Spider;
import org.zaproxy.zap.spider.SpiderTask;
import org.zaproxy.zap.spider.URLCanonicalizer;
import org.zaproxy.zap.spider.filters.FetchFilter;
import org.zaproxy.zap.spider.filters.ParseFilter;
import org.zaproxy.zap.spider.parser.SpiderGitParser;
import org.zaproxy.zap.spider.parser.SpiderHtmlFormParser;
import org.zaproxy.zap.spider.parser.SpiderHtmlParser;
import org.zaproxy.zap.spider.parser.SpiderODataAtomParser;
import org.zaproxy.zap.spider.parser.SpiderParser;
import org.zaproxy.zap.spider.parser.SpiderParserListener;
import org.zaproxy.zap.spider.parser.SpiderRedirectParser;
import org.zaproxy.zap.spider.parser.SpiderRobotstxtParser;
import org.zaproxy.zap.spider.parser.SpiderSVNEntriesParser;
import org.zaproxy.zap.spider.parser.SpiderSitemapXMLParser;
import org.zaproxy.zap.spider.parser.SpiderTextParser;

public class SpiderController
implements SpiderParserListener {
    private LinkedList<FetchFilter> fetchFilters;
    private LinkedList<ParseFilter> parseFilters;
    private LinkedList<SpiderParser> parsers;
    private List<SpiderParser> parsersUnmodifiableView;
    private Spider spider;
    private Set<String> visitedGet;
    private Map<String, ArrayList<String>> visitedPost;
    private static final Logger log = Logger.getLogger(SpiderController.class);

    protected SpiderController(Spider spider, List<SpiderParser> list) {
        this.spider = spider;
        this.fetchFilters = new LinkedList();
        this.parseFilters = new LinkedList();
        this.visitedGet = new HashSet<String>();
        this.visitedPost = new HashMap<String, ArrayList<String>>();
        this.prepareDefaultParsers();
        for (SpiderParser spiderParser : list) {
            this.addSpiderParser(spiderParser);
        }
    }

    private void prepareDefaultParsers() {
        SpiderParser spiderParser;
        this.parsers = new LinkedList();
        if (this.spider.getSpiderParam().isParseRobotsTxt()) {
            spiderParser = new SpiderRobotstxtParser(this.spider.getSpiderParam());
            this.parsers.add(spiderParser);
        }
        if (this.spider.getSpiderParam().isParseSitemapXml()) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"Adding SpiderSitemapXMLParser");
            }
            spiderParser = new SpiderSitemapXMLParser(this.spider.getSpiderParam());
            this.parsers.add(spiderParser);
        } else if (log.isDebugEnabled()) {
            log.debug((Object)"NOT Adding SpiderSitemapXMLParser");
        }
        if (this.spider.getSpiderParam().isParseSVNEntries()) {
            spiderParser = new SpiderSVNEntriesParser(this.spider.getSpiderParam());
            this.parsers.add(spiderParser);
        }
        if (this.spider.getSpiderParam().isParseGit()) {
            spiderParser = new SpiderGitParser(this.spider.getSpiderParam());
            this.parsers.add(spiderParser);
        }
        spiderParser = new SpiderRedirectParser();
        this.parsers.add(spiderParser);
        spiderParser = new SpiderHtmlParser(this.spider.getSpiderParam());
        this.parsers.add(spiderParser);
        spiderParser = new SpiderHtmlFormParser(this.spider.getSpiderParam(), this.spider.getExtensionSpider().getValueGenerator());
        this.parsers.add(spiderParser);
        Config.CurrentCompatibilityMode.setFormFieldNameCaseInsensitive(false);
        spiderParser = new SpiderODataAtomParser();
        this.parsers.add(spiderParser);
        spiderParser = new SpiderTextParser();
        this.parsers.add(spiderParser);
        this.parsersUnmodifiableView = Collections.unmodifiableList(this.parsers);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addSeed(URI uRI, String string) {
        String string2;
        try {
            string2 = URLCanonicalizer.buildCleanedParametersURIRepresentation(uRI, this.spider.getSpiderParam().getHandleParameters(), this.spider.getSpiderParam().isHandleODataParametersVisited());
        }
        catch (URIException uRIException) {
            return;
        }
        Object object = this.visitedGet;
        synchronized (object) {
            if (this.visitedGet.contains(string2)) {
                log.debug((Object)("URI already visited: " + string2));
                return;
            }
            this.visitedGet.add(string2);
        }
        object = new SpiderTask(this.spider, null, uRI, 0, string);
        this.spider.submitTask((SpiderTask)object);
        this.spider.notifyListenersFoundURI(uRI.toString(), string, FetchFilter.FetchStatus.SEED);
    }

    protected LinkedList<FetchFilter> getFetchFilters() {
        return this.fetchFilters;
    }

    public void addFetchFilter(FetchFilter fetchFilter) {
        log.debug((Object)("Loading fetch filter: " + fetchFilter.getClass().getSimpleName()));
        this.fetchFilters.add(fetchFilter);
    }

    protected LinkedList<ParseFilter> getParseFilters() {
        return this.parseFilters;
    }

    public void addParseFilter(ParseFilter parseFilter) {
        log.debug((Object)("Loading parse filter: " + parseFilter.getClass().getSimpleName()));
        this.parseFilters.add(parseFilter);
    }

    public void init() {
        this.visitedGet.clear();
        this.visitedPost.clear();
        for (SpiderParser spiderParser : this.parsers) {
            spiderParser.addSpiderParserListener(this);
        }
    }

    public void reset() {
        this.visitedGet.clear();
        this.visitedPost.clear();
        for (SpiderParser spiderParser : this.parsers) {
            spiderParser.removeSpiderParserListener(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void resourceURIFound(HttpMessage httpMessage, int n, String string, boolean bl) {
        String string2;
        log.debug((Object)("New resource found: " + string));
        if (string == null) {
            return;
        }
        URI uRI = this.createURI(string);
        if (uRI == null) {
            return;
        }
        try {
            string2 = URLCanonicalizer.buildCleanedParametersURIRepresentation(uRI, this.spider.getSpiderParam().getHandleParameters(), this.spider.getSpiderParam().isHandleODataParametersVisited());
        }
        catch (URIException uRIException) {
            return;
        }
        Object object = this.visitedGet;
        synchronized (object) {
            if (this.visitedGet.contains(string2)) {
                return;
            }
            this.visitedGet.add(string2);
        }
        for (FetchFilter fetchFilter : this.fetchFilters) {
            FetchFilter.FetchStatus fetchStatus = fetchFilter.checkFilter(uRI);
            if (fetchStatus == FetchFilter.FetchStatus.VALID) continue;
            log.debug((Object)("URI: " + uRI + " was filtered by a filter with reason: " + (Object)((Object)fetchStatus)));
            this.spider.notifyListenersFoundURI(string, "GET", fetchStatus);
            return;
        }
        if (bl) {
            log.debug((Object)("URI: " + uRI + " is valid, but will not be fetched, by parser reccommendation."));
            this.spider.notifyListenersFoundURI(string, "GET", FetchFilter.FetchStatus.VALID);
            return;
        }
        this.spider.notifyListenersFoundURI(string, "GET", FetchFilter.FetchStatus.VALID);
        object = new SpiderTask(this.spider, httpMessage.getRequestHeader().getURI(), uRI, n, "GET");
        this.spider.submitTask((SpiderTask)object);
    }

    @Override
    public void resourceURIFound(HttpMessage httpMessage, int n, String string) {
        this.resourceURIFound(httpMessage, n, string, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void resourcePostURIFound(HttpMessage httpMessage, int n, String string, String string2) {
        Object object;
        log.debug((Object)("New POST resource found: " + string));
        URI uRI = this.visitedPost;
        synchronized (uRI) {
            if (this.arrayKeyValueExists(string, string2)) {
                log.debug((Object)("URI already visited: " + string));
                return;
            }
            if (this.visitedPost.containsKey(string)) {
                this.visitedPost.get(string).add(string2);
            } else {
                object = new ArrayList<String>();
                ((ArrayList)object).add(string2);
                this.visitedPost.put(string, (ArrayList<String>)object);
            }
        }
        uRI = this.createURI(string);
        if (uRI == null) {
            return;
        }
        for (FetchFilter fetchFilter : this.fetchFilters) {
            FetchFilter.FetchStatus fetchStatus = fetchFilter.checkFilter(uRI);
            if (fetchStatus == FetchFilter.FetchStatus.VALID) continue;
            log.debug((Object)("URI: " + uRI + " was filtered by a filter with reason: " + (Object)((Object)fetchStatus)));
            this.spider.notifyListenersFoundURI(string, "POST", fetchStatus);
            return;
        }
        this.spider.notifyListenersFoundURI(string, "POST", FetchFilter.FetchStatus.VALID);
        object = new SpiderTask(this.spider, httpMessage.getRequestHeader().getURI(), uRI, n, "POST", string2);
        this.spider.submitTask((SpiderTask)object);
    }

    private boolean arrayKeyValueExists(String string, String string2) {
        if (this.visitedPost.containsKey(string)) {
            for (String string3 : this.visitedPost.get(string)) {
                if (!string3.equals(string2)) continue;
                return true;
            }
        }
        return false;
    }

    private URI createURI(String string) {
        URI uRI = null;
        try {
            uRI = new URI(string, true);
        }
        catch (URIException uRIException) {
            try {
                log.debug((Object)"Second try...");
                uRI = new URI(string, false);
            }
            catch (Exception exception) {
                log.error((Object)("Error while converting to uri: " + string), (Throwable)exception);
                return null;
            }
        }
        catch (Exception exception) {
            log.error((Object)("Error while converting to uri: " + string), (Throwable)exception);
            return null;
        }
        return uRI;
    }

    public List<SpiderParser> getParsers() {
        return this.parsersUnmodifiableView;
    }

    public void addSpiderParser(SpiderParser spiderParser) {
        log.debug((Object)("Loading custom Spider Parser: " + spiderParser.getClass().getSimpleName()));
        this.parsers.addFirst(spiderParser);
    }
}

