// Generated by gmmproc 2.51.6 -- DO NOT MODIFY!
#ifndef _GDKMM_EVENT_H
#define _GDKMM_EVENT_H


#include <glibmm/ustring.h>
#include <sigc++/sigc++.h>

/* Copyright (C) 1998-2002 The gtkmm Development Team
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
 */


#include <gdkmm/types.h>
#include <gdkmm/screen.h>

/* Shadow DELETE macro (from winnt.h).
 */
#if defined(DELETE) && !defined(GTKMM_MACRO_SHADOW_DELETE)
enum { GTKMM_MACRO_DEFINITION_DELETE = DELETE };
#undef DELETE
enum { DELETE = GTKMM_MACRO_DEFINITION_DELETE };
#define DELETE DELETE
#define GTKMM_MACRO_SHADOW_DELETE 1
#endif

#ifndef DOXYGEN_SHOULD_SKIP_THIS
extern "C" { typedef union _GdkEvent GdkEvent; }
#endif /* DOXYGEN_SHOULD_SKIP_THIS */


namespace Gdk
{

/** @addtogroup gdkmmEnums gdkmm Enums and Flags */

/** 
 *  @var EventType NOTHING
 * A special code to indicate a null event.
 * 
 *  @var EventType DELETE
 * The window manager has requested that the toplevel window be
 * hidden or destroyed, usually when the user clicks on a special icon in the
 * title bar.
 * 
 *  @var EventType DESTROY
 * The window has been destroyed.
 * 
 *  @var EventType EXPOSE
 * All or part of the window has become visible and needs to be
 * redrawn.
 * 
 *  @var EventType MOTION_NOTIFY
 * The pointer (usually a mouse) has moved.
 * 
 *  @var EventType BUTTON_PRESS
 * A mouse button has been pressed.
 * 
 *  @var EventType DOUBLE_BUTTON_PRESS
 * A mouse button has been double-clicked (clicked twice
 * within a short period of time). Note that each click also generates a
 * Gdk::BUTTON_PRESS event.
 * 
 *  @var EventType TRIPLE_BUTTON_PRESS
 * A mouse button has been clicked 3 times in a short period
 * of time. Note that each click also generates a Gdk::BUTTON_PRESS event.
 * 
 *  @var EventType BUTTON_RELEASE
 * A mouse button has been released.
 * 
 *  @var EventType KEY_PRESS
 * A key has been pressed.
 * 
 *  @var EventType KEY_RELEASE
 * A key has been released.
 * 
 *  @var EventType ENTER_NOTIFY
 * The pointer has entered the window.
 * 
 *  @var EventType LEAVE_NOTIFY
 * The pointer has left the window.
 * 
 *  @var EventType FOCUS_CHANGE
 * The keyboard focus has entered or left the window.
 * 
 *  @var EventType CONFIGURE
 * The size, position or stacking order of the window has changed.
 * Note that GTK+ discards these events for Gdk::WINDOW_CHILD windows.
 * 
 *  @var EventType MAP
 * The window has been mapped.
 * 
 *  @var EventType UNMAP
 * The window has been unmapped.
 * 
 *  @var EventType PROPERTY_NOTIFY
 * A property on the window has been changed or deleted.
 * 
 *  @var EventType SELECTION_CLEAR
 * The application has lost ownership of a selection.
 * 
 *  @var EventType SELECTION_REQUEST
 * Another application has requested a selection.
 * 
 *  @var EventType SELECTION_NOTIFY
 * A selection has been received.
 * 
 *  @var EventType PROXIMITY_IN
 * An input device has moved into contact with a sensing
 * surface (e.g. a touchscreen or graphics tablet).
 * 
 *  @var EventType PROXIMITY_OUT
 * An input device has moved out of contact with a sensing
 * surface.
 * 
 *  @var EventType DRAG_ENTER
 * The mouse has entered the window while a drag is in progress.
 * 
 *  @var EventType DRAG_LEAVE
 * The mouse has left the window while a drag is in progress.
 * 
 *  @var EventType DRAG_MOTION
 * The mouse has moved in the window while a drag is in
 * progress.
 * 
 *  @var EventType DRAG_STATUS
 * The status of the drag operation initiated by the window
 * has changed.
 * 
 *  @var EventType DROP_START
 * A drop operation onto the window has started.
 * 
 *  @var EventType DROP_FINISHED
 * The drop operation initiated by the window has completed.
 * 
 *  @var EventType CLIENT_EVENT
 * A message has been received from another application.
 * 
 *  @var EventType VISIBILITY_NOTIFY
 * The window visibility status has changed.
 * 
 *  @var EventType SCROLL
 * The scroll wheel was turned.
 * 
 *  @var EventType WINDOW_STATE
 * The state of a window has changed. See Gdk::WindowState
 * for the possible window states.
 * 
 *  @var EventType SETTING
 * A setting has been modified.
 * 
 *  @var EventType OWNER_CHANGE
 * The owner of a selection has changed. This event type
 * was added in 2.6.
 * 
 *  @var EventType GRAB_BROKEN
 * A pointer or keyboard grab was broken. This event type
 * was added in 2.8.
 * 
 *  @var EventType DAMAGE
 * The content of the window has been changed. This event type
 * was added in 2.14.
 * 
 *  @var EventType TOUCH_BEGIN
 * A new touch event sequence has just started. This event
 * type was added in 3.4.
 * 
 *  @var EventType TOUCH_UPDATE
 * A touch event sequence has been updated. This event type
 * was added in 3.4.
 * 
 *  @var EventType TOUCH_END
 * A touch event sequence has finished. This event type
 * was added in 3.4.
 * 
 *  @var EventType TOUCH_CANCEL
 * A touch event sequence has been canceled. This event type
 * was added in 3.4.
 * 
 *  @var EventType TOUCHPAD_SWIPE
 * A touchpad swipe gesture event, the current state
 * is determined by its phase field. This event type was added in 3.18.
 * 
 *  @var EventType TOUCHPAD_PINCH
 * A touchpad pinch gesture event, the current state
 * is determined by its phase field. This event type was added in 3.18.
 * 
 *  @var EventType PAD_BUTTON_PRESS
 * A tablet pad button press event. This event type
 * was added in 3.22.
 * 
 *  @var EventType PAD_BUTTON_RELEASE
 * A tablet pad button release event. This event type
 * was added in 3.22.
 * 
 *  @var EventType PAD_RING
 * A tablet pad axis event from a "ring". This event type was
 * added in 3.22.
 * 
 *  @var EventType PAD_STRIP
 * A tablet pad axis event from a "strip". This event type was
 * added in 3.22.
 * 
 *  @var EventType PAD_GROUP_MODE
 * A tablet pad group mode change. This event type was
 * added in 3.22.
 * 
 *  @var EventType EVENT_LAST
 * Marks the end of the GdkEventType enumeration. Added in 2.18.
 * 
 *  @enum EventType
 * 
 * Specifies the type of the event.
 * 
 * Do not confuse these events with the signals that GTK+ widgets emit.
 * Although many of these events result in corresponding signals being emitted,
 * the events are often transformed or filtered along the way.
 * 
 * In some language bindings, the values Gdk::2BUTTON_PRESS and
 * Gdk::3BUTTON_PRESS would translate into something syntactically
 * invalid (eg `Gdk.EventType.2ButtonPress`, where a
 * symbol is not allowed to start with a number). In that case, the
 * aliases Gdk::DOUBLE_BUTTON_PRESS and Gdk::TRIPLE_BUTTON_PRESS can
 * be used instead.
 *
 * @ingroup gdkmmEnums
 */
enum EventType
{
  NOTHING = -1,
  DELETE = 0,
  DESTROY = 1,
  EXPOSE = 2,
  MOTION_NOTIFY = 3,
  BUTTON_PRESS = 4,
  DOUBLE_BUTTON_PRESS = 5,
  TRIPLE_BUTTON_PRESS = 6,
  BUTTON_RELEASE = 7,
  KEY_PRESS = 8,
  KEY_RELEASE = 9,
  ENTER_NOTIFY = 10,
  LEAVE_NOTIFY = 11,
  FOCUS_CHANGE = 12,
  CONFIGURE = 13,
  MAP = 14,
  UNMAP = 15,
  PROPERTY_NOTIFY = 16,
  SELECTION_CLEAR = 17,
  SELECTION_REQUEST = 18,
  SELECTION_NOTIFY = 19,
  PROXIMITY_IN = 20,
  PROXIMITY_OUT = 21,
  DRAG_ENTER = 22,
  DRAG_LEAVE = 23,
  DRAG_MOTION = 24,
  DRAG_STATUS = 25,
  DROP_START = 26,
  DROP_FINISHED = 27,
  CLIENT_EVENT = 28,
  VISIBILITY_NOTIFY = 29,
  SCROLL = 31,
  WINDOW_STATE = 32,
  SETTING = 33,
  OWNER_CHANGE = 34,
  GRAB_BROKEN = 35,
  DAMAGE = 36,
  TOUCH_BEGIN = 37,
  TOUCH_UPDATE = 38,
  TOUCH_END = 39,
  TOUCH_CANCEL = 40,
  TOUCHPAD_SWIPE = 41,
  TOUCHPAD_PINCH = 42,
  PAD_BUTTON_PRESS = 43,
  PAD_BUTTON_RELEASE = 44,
  PAD_RING = 45,
  PAD_STRIP = 46,
  PAD_GROUP_MODE = 47,
  EVENT_LAST = 48
};

} // namespace Gdk

#ifndef DOXYGEN_SHOULD_SKIP_THIS
namespace Glib
{

template <>
class Value<Gdk::EventType> : public Glib::Value_Enum<Gdk::EventType>
{
public:
  static GType value_type() G_GNUC_CONST;
};

} // namespace Glib
#endif /* DOXYGEN_SHOULD_SKIP_THIS */

namespace Gdk
{


/** 
 *  @var AxisUse AXIS_IGNORE
 * The axis is ignored.
 * 
 *  @var AxisUse AXIS_X
 * The axis is used as the x axis.
 * 
 *  @var AxisUse AXIS_Y
 * The axis is used as the y axis.
 * 
 *  @var AxisUse AXIS_PRESSURE
 * The axis is used for pressure information.
 * 
 *  @var AxisUse AXIS_XTILT
 * The axis is used for x tilt information.
 * 
 *  @var AxisUse AXIS_YTILT
 * The axis is used for y tilt information.
 * 
 *  @var AxisUse AXIS_WHEEL
 * The axis is used for wheel information.
 * 
 *  @var AxisUse AXIS_DISTANCE
 * The axis is used for pen/tablet distance information. (Since: 3.22).
 * 
 *  @var AxisUse AXIS_ROTATION
 * The axis is used for pen rotation information. (Since: 3.22).
 * 
 *  @var AxisUse AXIS_SLIDER
 * The axis is used for pen slider information. (Since: 3.22).
 * 
 *  @var AxisUse AXIS_LAST
 * A constant equal to the numerically highest axis value.
 * 
 *  @enum AxisUse
 * 
 * An enumeration describing the way in which a device
 * axis (valuator) maps onto the predefined valuator
 * types that GTK+ understands.
 * 
 * Note that the X and Y axes are not really needed; pointer devices
 * report their location via the x/y members of events regardless. Whether
 * X and Y are present as axes depends on the GDK backend.
 *
 * @ingroup gdkmmEnums
 */
enum AxisUse
{
  AXIS_IGNORE,
  AXIS_X,
  AXIS_Y,
  AXIS_PRESSURE,
  AXIS_XTILT,
  AXIS_YTILT,
  AXIS_WHEEL,
  AXIS_DISTANCE,
  AXIS_ROTATION,
  AXIS_SLIDER,
  AXIS_LAST
};

} // namespace Gdk

#ifndef DOXYGEN_SHOULD_SKIP_THIS
namespace Glib
{

template <>
class Value<Gdk::AxisUse> : public Glib::Value_Enum<Gdk::AxisUse>
{
public:
  static GType value_type() G_GNUC_CONST;
};

} // namespace Glib
#endif /* DOXYGEN_SHOULD_SKIP_THIS */

namespace Gdk
{

/** 
 *  @var AxisFlags AXIS_FLAG_X
 * X axis is present.
 * 
 *  @var AxisFlags AXIS_FLAG_Y
 * Y axis is present.
 * 
 *  @var AxisFlags AXIS_FLAG_PRESSURE
 * Pressure axis is present.
 * 
 *  @var AxisFlags AXIS_FLAG_XTILT
 * X tilt axis is present.
 * 
 *  @var AxisFlags AXIS_FLAG_YTILT
 * Y tilt axis is present.
 * 
 *  @var AxisFlags AXIS_FLAG_WHEEL
 * Wheel axis is present.
 * 
 *  @var AxisFlags AXIS_FLAG_DISTANCE
 * Distance axis is present.
 * 
 *  @var AxisFlags AXIS_FLAG_ROTATION
 * Z-axis rotation is present.
 * 
 *  @var AxisFlags AXIS_FLAG_SLIDER
 * Slider axis is present.
 * 
 *  @enum AxisFlags
 * 
 * Flags describing the current capabilities of a device/tool.
 * 
 * @newin{3,22}
 *
 * @ingroup gdkmmEnums
 * @par Bitwise operators:
 * <tt>%AxisFlags operator|(AxisFlags, AxisFlags)</tt><br>
 * <tt>%AxisFlags operator&(AxisFlags, AxisFlags)</tt><br>
 * <tt>%AxisFlags operator^(AxisFlags, AxisFlags)</tt><br>
 * <tt>%AxisFlags operator~(AxisFlags)</tt><br>
 * <tt>%AxisFlags& operator|=(AxisFlags&, AxisFlags)</tt><br>
 * <tt>%AxisFlags& operator&=(AxisFlags&, AxisFlags)</tt><br>
 * <tt>%AxisFlags& operator^=(AxisFlags&, AxisFlags)</tt><br>
 */
enum AxisFlags
{
  AXIS_FLAG_X = 1 << GDK_AXIS_X,
  AXIS_FLAG_Y = 1 << GDK_AXIS_Y,
  AXIS_FLAG_PRESSURE = 1 << GDK_AXIS_PRESSURE,
  AXIS_FLAG_XTILT = 1 << GDK_AXIS_XTILT,
  AXIS_FLAG_YTILT = 1 << GDK_AXIS_YTILT,
  AXIS_FLAG_WHEEL = 1 << GDK_AXIS_WHEEL,
  AXIS_FLAG_DISTANCE = 1 << GDK_AXIS_DISTANCE,
  AXIS_FLAG_ROTATION = 1 << GDK_AXIS_ROTATION,
  AXIS_FLAG_SLIDER = 1 << GDK_AXIS_SLIDER
};

/** @ingroup gdkmmEnums */
inline AxisFlags operator|(AxisFlags lhs, AxisFlags rhs)
  { return static_cast<AxisFlags>(static_cast<unsigned>(lhs) | static_cast<unsigned>(rhs)); }

/** @ingroup gdkmmEnums */
inline AxisFlags operator&(AxisFlags lhs, AxisFlags rhs)
  { return static_cast<AxisFlags>(static_cast<unsigned>(lhs) & static_cast<unsigned>(rhs)); }

/** @ingroup gdkmmEnums */
inline AxisFlags operator^(AxisFlags lhs, AxisFlags rhs)
  { return static_cast<AxisFlags>(static_cast<unsigned>(lhs) ^ static_cast<unsigned>(rhs)); }

/** @ingroup gdkmmEnums */
inline AxisFlags operator~(AxisFlags flags)
  { return static_cast<AxisFlags>(~static_cast<unsigned>(flags)); }

/** @ingroup gdkmmEnums */
inline AxisFlags& operator|=(AxisFlags& lhs, AxisFlags rhs)
  { return (lhs = static_cast<AxisFlags>(static_cast<unsigned>(lhs) | static_cast<unsigned>(rhs))); }

/** @ingroup gdkmmEnums */
inline AxisFlags& operator&=(AxisFlags& lhs, AxisFlags rhs)
  { return (lhs = static_cast<AxisFlags>(static_cast<unsigned>(lhs) & static_cast<unsigned>(rhs))); }

/** @ingroup gdkmmEnums */
inline AxisFlags& operator^=(AxisFlags& lhs, AxisFlags rhs)
  { return (lhs = static_cast<AxisFlags>(static_cast<unsigned>(lhs) ^ static_cast<unsigned>(rhs))); }

} // namespace Gdk

#ifndef DOXYGEN_SHOULD_SKIP_THIS
namespace Glib
{

template <>
class Value<Gdk::AxisFlags> : public Glib::Value_Flags<Gdk::AxisFlags>
{
public:
  static GType value_type() G_GNUC_CONST;
};

} // namespace Glib
#endif /* DOXYGEN_SHOULD_SKIP_THIS */

namespace Gdk
{


//TODO: Actually use this class instead of GdkEvent?
class Event
{
  public:
#ifndef DOXYGEN_SHOULD_SKIP_THIS
  using CppObjectType = Event;
  using BaseObjectType = GdkEvent;
#endif /* DOXYGEN_SHOULD_SKIP_THIS */

  /** Get the GType for this class, for use with the underlying GObject type system.
   */
  static GType get_type() G_GNUC_CONST;

  Event();

  explicit Event(GdkEvent* gobject, bool make_a_copy = true);

  Event(const Event& other);
  Event& operator=(const Event& other);

  Event(Event&& other) noexcept;
  Event& operator=(Event&& other) noexcept;

  ~Event() noexcept;

  void swap(Event& other) noexcept;

  ///Provides access to the underlying C instance.
  GdkEvent*       gobj()       { return gobject_; }

  ///Provides access to the underlying C instance.
  const GdkEvent* gobj() const { return gobject_; }

  ///Provides access to the underlying C instance. The caller is responsible for freeing it. Use when directly setting fields in structs.
  GdkEvent* gobj_copy() const;

protected:
  GdkEvent* gobject_;

private:

  
public:

  
  /** Checks all open displays for a Gdk::Event to process,to be processed
   * on, fetching events from the windowing system if necessary.
   * See Gdk::Display::get_event().
   * 
   * @return The next Gdk::Event to be processed, or <tt>nullptr</tt>
   * if no events are pending. The returned Gdk::Event should be freed
   * with free().
   */
  static Event get();
  
  /** If there is an event waiting in the event queue of some open
   * display, returns a copy of it. See Gdk::Display::peek_event().
   * 
   * @return A copy of the first Gdk::Event on some event
   * queue, or <tt>nullptr</tt> if no events are in any queues. The returned
   * Gdk::Event should be freed with free().
   */
  static Event peek();
  
  /** Appends a copy of the given event onto the front of the event
   * queue for event->any.window’s display, or the default event
   * queue if event->any.window is <tt>nullptr</tt>. See Gdk::Display::put_event().
   */
  void put();

  
  /** Checks if any events are ready to be processed for any display.
   * 
   * @return <tt>true</tt> if any events are pending.
   */
  static bool events_pending();

  
  /** Returns the time stamp from @a event, if there is one; otherwise
   * returns Gdk::CURRENT_TIME. If @a event is <tt>nullptr</tt>, returns Gdk::CURRENT_TIME.
   * 
   * @return Time stamp field from @a event.
   */
  guint32 get_time() const;
  
  /** If the event contains a “state” field, puts that field in @a state. Otherwise
   * stores an empty state (0). Returns <tt>true</tt> if there was a state field
   * in the event. @a event may be <tt>nullptr</tt>, in which case it’s treated
   * as if the event had no state field.
   * 
   * @param state Return location for state.
   * @return <tt>true</tt> if there was a state field in the event.
   */
  bool get_state(ModifierType& state) const;
  
  /** Extract the event window relative x/y coordinates from an event.
   * 
   * @param x_win Location to put event window x coordinate.
   * @param y_win Location to put event window y coordinate.
   * @return <tt>true</tt> if the event delivered event window coordinates.
   */
  bool get_coords(double& x_win, double& y_win) const;
  
  /** Extract the root window relative x/y coordinates from an event.
   * 
   * @param x_root Location to put root window x coordinate.
   * @param y_root Location to put root window y coordinate.
   * @return <tt>true</tt> if the event delivered root window coordinates.
   */
  bool get_root_coords(double& x_root, double& y_root) const;
  
  /** Extract the axis value for a particular axis use from
   * an event structure.
   * 
   * @param axis_use The axis use to look for.
   * @param value Location to store the value found.
   * @return <tt>true</tt> if the specified axis was found, otherwise <tt>false</tt>.
   */
  bool get_axis(AxisUse axis_use, double& value) const;
  //_WRAP_METHOD(void	gdk_event_handler_set(GdkEventFunc func, gpointer data, GDestroyNotify  notify), gdk_event_handler_set)

  
  /** Sets whether a trace of received events is output.
   * Note that GTK+ must be compiled with debugging (that is,
   * configured using the `--enable-debug` option)
   * to use this option.
   * 
   * @param show_events <tt>true</tt> to output event debugging information.
   */
  static void set_show_events(bool show_events);
  
  /** Gets whether event debugging output is enabled.
   * 
   * @return <tt>true</tt> if event debugging output is enabled.
   */
  static bool get_show_events();

   //deprecated
  
  /** Returns the screen for the event. The screen is
   * typically the screen for `event->any.window`, but
   * for events such as mouse events, it is the screen
   * where the pointer was when the event occurs -
   * that is, the screen which has the root window 
   * to which `event->motion.x_root` and
   * `event->motion.y_root` are relative.
   * 
   * @newin{2,2}
   * 
   * @return The screen for the event.
   */
  Glib::RefPtr<Screen> get_screen();
  
  /** Returns the screen for the event. The screen is
   * typically the screen for `event->any.window`, but
   * for events such as mouse events, it is the screen
   * where the pointer was when the event occurs -
   * that is, the screen which has the root window 
   * to which `event->motion.x_root` and
   * `event->motion.y_root` are relative.
   * 
   * @newin{2,2}
   * 
   * @return The screen for the event.
   */
  Glib::RefPtr<const Screen> get_screen() const;


};

} // namespace Gdk


namespace Gdk
{

/** @relates Gdk::Event
 * @param lhs The left-hand side
 * @param rhs The right-hand side
 */
inline void swap(Event& lhs, Event& rhs) noexcept
  { lhs.swap(rhs); }

} // namespace Gdk

namespace Glib
{

/** A Glib::wrap() method for this object.
 *
 * @param object The C instance.
 * @param take_copy False if the result should take ownership of the C instance. True if it should take a new copy or ref.
 * @result A C++ instance that wraps this C instance.
 *
 * @relates Gdk::Event
 */
Gdk::Event wrap(GdkEvent* object, bool take_copy = false);

#ifndef DOXYGEN_SHOULD_SKIP_THIS
template <>
class Value<Gdk::Event> : public Glib::Value_Boxed<Gdk::Event>
{};
#endif /* DOXYGEN_SHOULD_SKIP_THIS */

} // namespace Glib


#endif /* _GDKMM_EVENT_H */

