/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.ingest.common;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.elasticsearch.ingest.AbstractProcessor;
import org.elasticsearch.ingest.ConfigurationUtils;
import org.elasticsearch.ingest.IngestDocument;
import org.elasticsearch.ingest.Processor;

public final class KeyValueProcessor
extends AbstractProcessor {
    public static final String TYPE = "kv";
    private final String field;
    private final String fieldSplit;
    private final String valueSplit;
    private final List<String> includeKeys;
    private final String targetField;
    private final boolean ignoreMissing;

    KeyValueProcessor(String tag, String field, String fieldSplit, String valueSplit, List<String> includeKeys, String targetField, boolean ignoreMissing) {
        super(tag);
        this.field = field;
        this.targetField = targetField;
        this.fieldSplit = fieldSplit;
        this.valueSplit = valueSplit;
        this.includeKeys = includeKeys;
        this.ignoreMissing = ignoreMissing;
    }

    String getField() {
        return this.field;
    }

    String getFieldSplit() {
        return this.fieldSplit;
    }

    String getValueSplit() {
        return this.valueSplit;
    }

    List<String> getIncludeKeys() {
        return this.includeKeys;
    }

    String getTargetField() {
        return this.targetField;
    }

    boolean isIgnoreMissing() {
        return this.ignoreMissing;
    }

    public void append(IngestDocument document, String targetField, String value) {
        if (document.hasField(targetField)) {
            document.appendFieldValue(targetField, (Object)value);
        } else {
            document.setFieldValue(targetField, (Object)value);
        }
    }

    public void execute(IngestDocument document) {
        String oldVal = (String)document.getFieldValue(this.field, String.class, this.ignoreMissing);
        if (oldVal == null && this.ignoreMissing) {
            return;
        }
        if (oldVal == null) {
            throw new IllegalArgumentException("field [" + this.field + "] is null, cannot extract key-value pairs.");
        }
        String fieldPathPrefix = this.targetField == null ? "" : this.targetField + ".";
        Arrays.stream(oldVal.split(this.fieldSplit)).map(f -> {
            String[] kv = f.split(this.valueSplit, 2);
            if (kv.length != 2) {
                throw new IllegalArgumentException("field [" + this.field + "] does not contain value_split [" + this.valueSplit + "]");
            }
            return kv;
        }).filter(p -> this.includeKeys == null || this.includeKeys.contains(p[0])).forEach(p -> this.append(document, fieldPathPrefix + p[0], p[1]));
    }

    public String getType() {
        return TYPE;
    }

    public static class Factory
    implements Processor.Factory {
        public KeyValueProcessor create(Map<String, Processor.Factory> registry, String processorTag, Map<String, Object> config) throws Exception {
            String field = ConfigurationUtils.readStringProperty((String)KeyValueProcessor.TYPE, (String)processorTag, config, (String)"field");
            String targetField = ConfigurationUtils.readOptionalStringProperty((String)KeyValueProcessor.TYPE, (String)processorTag, config, (String)"target_field");
            String fieldSplit = ConfigurationUtils.readStringProperty((String)KeyValueProcessor.TYPE, (String)processorTag, config, (String)"field_split");
            String valueSplit = ConfigurationUtils.readStringProperty((String)KeyValueProcessor.TYPE, (String)processorTag, config, (String)"value_split");
            List<String> includeKeys = ConfigurationUtils.readOptionalList((String)KeyValueProcessor.TYPE, (String)processorTag, config, (String)"include_keys");
            if (includeKeys != null) {
                includeKeys = Collections.unmodifiableList(includeKeys);
            }
            boolean ignoreMissing = ConfigurationUtils.readBooleanProperty((String)KeyValueProcessor.TYPE, (String)processorTag, config, (String)"ignore_missing", (boolean)false);
            return new KeyValueProcessor(processorTag, field, fieldSplit, valueSplit, includeKeys, targetField, ignoreMissing);
        }
    }
}

