/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.blobstore.fs;

import java.io.BufferedInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.DirectoryStream;
import java.nio.file.FileAlreadyExistsException;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.NoSuchFileException;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.StandardCopyOption;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.lucene.util.IOUtils;
import org.elasticsearch.common.blobstore.BlobMetaData;
import org.elasticsearch.common.blobstore.BlobPath;
import org.elasticsearch.common.blobstore.fs.FsBlobStore;
import org.elasticsearch.common.blobstore.support.AbstractBlobContainer;
import org.elasticsearch.common.blobstore.support.PlainBlobMetaData;
import org.elasticsearch.common.io.Streams;

public class FsBlobContainer
extends AbstractBlobContainer {
    protected final FsBlobStore blobStore;
    protected final Path path;

    public FsBlobContainer(FsBlobStore blobStore, BlobPath blobPath, Path path) {
        super(blobPath);
        this.blobStore = blobStore;
        this.path = path;
    }

    @Override
    public Map<String, BlobMetaData> listBlobs() throws IOException {
        return this.listBlobsByPrefix(null);
    }

    @Override
    public Map<String, BlobMetaData> listBlobsByPrefix(String blobNamePrefix) throws IOException {
        HashMap<String, PlainBlobMetaData> builder = new HashMap<String, PlainBlobMetaData>();
        blobNamePrefix = blobNamePrefix == null ? "" : blobNamePrefix;
        try (DirectoryStream<Path> stream = Files.newDirectoryStream(this.path, blobNamePrefix + "*");){
            for (Path file : stream) {
                BasicFileAttributes attrs = Files.readAttributes(file, BasicFileAttributes.class, new LinkOption[0]);
                if (!attrs.isRegularFile()) continue;
                builder.put(file.getFileName().toString(), new PlainBlobMetaData(file.getFileName().toString(), attrs.size()));
            }
        }
        return Collections.unmodifiableMap(builder);
    }

    @Override
    public void deleteBlob(String blobName) throws IOException {
        Path blobPath = this.path.resolve(blobName);
        if (Files.isDirectory(blobPath, new LinkOption[0])) {
            Files.walkFileTree(blobPath, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                @Override
                public FileVisitResult postVisitDirectory(Path dir, IOException exc) throws IOException {
                    Files.delete(dir);
                    return FileVisitResult.CONTINUE;
                }
            });
        } else {
            Files.delete(blobPath);
        }
    }

    @Override
    public boolean blobExists(String blobName) {
        return Files.exists(this.path.resolve(blobName), new LinkOption[0]);
    }

    @Override
    public InputStream readBlob(String name) throws IOException {
        Path resolvedPath = this.path.resolve(name);
        try {
            return new BufferedInputStream(Files.newInputStream(resolvedPath, new OpenOption[0]), this.blobStore.bufferSizeInBytes());
        }
        catch (FileNotFoundException fnfe) {
            throw new NoSuchFileException("[" + name + "] blob not found");
        }
    }

    @Override
    public void writeBlob(String blobName, InputStream inputStream, long blobSize) throws IOException {
        if (this.blobExists(blobName)) {
            throw new FileAlreadyExistsException("blob [" + blobName + "] already exists, cannot overwrite");
        }
        Path file = this.path.resolve(blobName);
        try (OutputStream outputStream = Files.newOutputStream(file, StandardOpenOption.CREATE_NEW);){
            Streams.copy(inputStream, outputStream, new byte[this.blobStore.bufferSizeInBytes()]);
        }
        IOUtils.fsync((Path)file, (boolean)false);
        IOUtils.fsync((Path)this.path, (boolean)true);
    }

    @Override
    public void move(String source, String target) throws IOException {
        Path sourcePath = this.path.resolve(source);
        Path targetPath = this.path.resolve(target);
        assert (!Files.exists(targetPath, new LinkOption[0]));
        Files.move(sourcePath, targetPath, StandardCopyOption.ATOMIC_MOVE);
        IOUtils.fsync((Path)this.path, (boolean)true);
    }
}

