/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.intellij.psi;

import java.io.IOException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.com.intellij.ide.highlighter.JavaClassFileType;
import org.jetbrains.kotlin.com.intellij.lang.Language;
import org.jetbrains.kotlin.com.intellij.lang.java.JavaLanguage;
import org.jetbrains.kotlin.com.intellij.openapi.components.ServiceManager;
import org.jetbrains.kotlin.com.intellij.openapi.diagnostic.Logger;
import org.jetbrains.kotlin.com.intellij.openapi.fileTypes.FileType;
import org.jetbrains.kotlin.com.intellij.openapi.project.Project;
import org.jetbrains.kotlin.com.intellij.openapi.roots.FileIndexFacade;
import org.jetbrains.kotlin.com.intellij.openapi.util.Key;
import org.jetbrains.kotlin.com.intellij.openapi.util.Ref;
import org.jetbrains.kotlin.com.intellij.openapi.vfs.VirtualFile;
import org.jetbrains.kotlin.com.intellij.psi.PsiCompiledFile;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.com.intellij.psi.PsiFile;
import org.jetbrains.kotlin.com.intellij.psi.PsiManager;
import org.jetbrains.kotlin.com.intellij.psi.PsiReference;
import org.jetbrains.kotlin.com.intellij.psi.SingleRootFileViewProvider;
import org.jetbrains.kotlin.com.intellij.psi.impl.PsiManagerImpl;
import org.jetbrains.kotlin.com.intellij.psi.impl.compiled.ClsFileImpl;
import org.jetbrains.kotlin.com.intellij.psi.impl.file.PsiBinaryFileImpl;
import org.jetbrains.org.objectweb.asm.ClassReader;
import org.jetbrains.org.objectweb.asm.ClassVisitor;

public class ClassFileViewProvider
extends SingleRootFileViewProvider {
    private static final Key<Boolean> IS_INNER_CLASS = Key.create("java.is.inner.class.key");

    public ClassFileViewProvider(@NotNull PsiManager manager, @NotNull VirtualFile file2) {
        if (manager == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "manager", "org/jetbrains/kotlin/com/intellij/psi/ClassFileViewProvider", "<init>"));
        }
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "org/jetbrains/kotlin/com/intellij/psi/ClassFileViewProvider", "<init>"));
        }
        this(manager, file2, true);
    }

    public ClassFileViewProvider(@NotNull PsiManager manager, @NotNull VirtualFile file2, boolean eventSystemEnabled) {
        if (manager == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "manager", "org/jetbrains/kotlin/com/intellij/psi/ClassFileViewProvider", "<init>"));
        }
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "org/jetbrains/kotlin/com/intellij/psi/ClassFileViewProvider", "<init>"));
        }
        super(manager, file2, eventSystemEnabled, JavaLanguage.INSTANCE, JavaClassFileType.INSTANCE);
    }

    @Override
    protected PsiFile createFile(@NotNull Project project, @NotNull VirtualFile file2, @NotNull FileType fileType) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/kotlin/com/intellij/psi/ClassFileViewProvider", "createFile"));
        }
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "org/jetbrains/kotlin/com/intellij/psi/ClassFileViewProvider", "createFile"));
        }
        if (fileType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileType", "org/jetbrains/kotlin/com/intellij/psi/ClassFileViewProvider", "createFile"));
        }
        FileIndexFacade fileIndex = ServiceManager.getService(project, FileIndexFacade.class);
        if (!fileIndex.isInLibraryClasses(file2) && fileIndex.isInSource(file2)) {
            return new PsiBinaryFileImpl((PsiManagerImpl)this.getManager(), this);
        }
        try {
            if (!ClassFileViewProvider.isInnerClass(file2)) {
                return new ClsFileImpl(this);
            }
        }
        catch (Exception e) {
            Logger.getInstance(ClassFileViewProvider.class).debug(file2.getPath(), e);
        }
        return null;
    }

    public static boolean isInnerClass(@NotNull VirtualFile file2) {
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "org/jetbrains/kotlin/com/intellij/psi/ClassFileViewProvider", "isInnerClass"));
        }
        return ClassFileViewProvider.detectInnerClass(file2, null);
    }

    public static boolean isInnerClass(@NotNull VirtualFile file2, @NotNull byte[] content) {
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "org/jetbrains/kotlin/com/intellij/psi/ClassFileViewProvider", "isInnerClass"));
        }
        if (content == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "content", "org/jetbrains/kotlin/com/intellij/psi/ClassFileViewProvider", "isInnerClass"));
        }
        return ClassFileViewProvider.detectInnerClass(file2, content);
    }

    private static boolean detectInnerClass(VirtualFile file2, @Nullable byte[] content) {
        String name2 = file2.getNameWithoutExtension();
        int p = name2.lastIndexOf(36, name2.length() - 2);
        if (p <= 0) {
            return false;
        }
        Boolean isInner2 = IS_INNER_CLASS.get(file2);
        if (isInner2 != null) {
            return isInner2;
        }
        if (content == null) {
            try {
                content = file2.contentsToByteArray(false);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        ClassReader reader = new ClassReader(content);
        final Ref<Boolean> ref = Ref.create(Boolean.FALSE);
        final String className2 = reader.getClassName();
        reader.accept(new ClassVisitor(327680){

            @Override
            public void visitOuterClass(String owner, String name2, String desc) {
                ref.set(Boolean.TRUE);
            }

            @Override
            public void visitInnerClass(String name2, String outer, String inner, int access) {
                if (className2.equals(name2)) {
                    ref.set(Boolean.TRUE);
                }
            }
        }, ClsFileImpl.EMPTY_ATTRIBUTES, 7);
        isInner2 = ref.get();
        IS_INNER_CLASS.set(file2, isInner2);
        return isInner2;
    }

    @Override
    @NotNull
    public SingleRootFileViewProvider createCopy(@NotNull VirtualFile copy) {
        if (copy == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "copy", "org/jetbrains/kotlin/com/intellij/psi/ClassFileViewProvider", "createCopy"));
        }
        ClassFileViewProvider classFileViewProvider = new ClassFileViewProvider(this.getManager(), copy, false);
        if (classFileViewProvider == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/psi/ClassFileViewProvider", "createCopy"));
        }
        return classFileViewProvider;
    }

    @Override
    public PsiElement findElementAt(int offset2) {
        return this.findElementAt(offset2, this.getBaseLanguage());
    }

    @Override
    public PsiElement findElementAt(int offset2, @NotNull Language language) {
        if (language == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "language", "org/jetbrains/kotlin/com/intellij/psi/ClassFileViewProvider", "findElementAt"));
        }
        PsiFile file2 = this.getPsi(language);
        if (file2 instanceof PsiCompiledFile) {
            file2 = ((PsiCompiledFile)file2).getDecompiledPsiFile();
        }
        return ClassFileViewProvider.findElementAt(file2, offset2);
    }

    @Override
    public PsiReference findReferenceAt(int offset2) {
        return this.findReferenceAt(offset2, this.getBaseLanguage());
    }

    @Override
    @Nullable
    public PsiReference findReferenceAt(int offset2, @NotNull Language language) {
        if (language == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "language", "org/jetbrains/kotlin/com/intellij/psi/ClassFileViewProvider", "findReferenceAt"));
        }
        PsiFile file2 = this.getPsi(language);
        if (file2 instanceof PsiCompiledFile) {
            file2 = ((PsiCompiledFile)file2).getDecompiledPsiFile();
        }
        return ClassFileViewProvider.findReferenceAt(file2, offset2);
    }
}

