/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.js.translate.reference;

import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.com.google.gwt.dev.js.ThrowExceptionOnErrorReporter;
import org.jetbrains.kotlin.config.CommonConfigurationKeys;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.descriptors.ParameterDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyAccessorDescriptor;
import org.jetbrains.kotlin.descriptors.SimpleFunctionDescriptor;
import org.jetbrains.kotlin.descriptors.ValueParameterDescriptor;
import org.jetbrains.kotlin.descriptors.VariableDescriptor;
import org.jetbrains.kotlin.incremental.components.NoLookupLocation;
import org.jetbrains.kotlin.js.backend.ast.DelegatingJsFunctionScopeWithTemporaryParent;
import org.jetbrains.kotlin.js.backend.ast.JsBlock;
import org.jetbrains.kotlin.js.backend.ast.JsExpression;
import org.jetbrains.kotlin.js.backend.ast.JsExpressionStatement;
import org.jetbrains.kotlin.js.backend.ast.JsFunctionScope;
import org.jetbrains.kotlin.js.backend.ast.JsLiteral;
import org.jetbrains.kotlin.js.backend.ast.JsName;
import org.jetbrains.kotlin.js.backend.ast.JsNode;
import org.jetbrains.kotlin.js.backend.ast.JsProgram;
import org.jetbrains.kotlin.js.backend.ast.JsRootScope;
import org.jetbrains.kotlin.js.backend.ast.JsScope;
import org.jetbrains.kotlin.js.backend.ast.JsStatement;
import org.jetbrains.kotlin.js.inline.util.CollectUtilsKt;
import org.jetbrains.kotlin.js.inline.util.RewriteUtilsKt;
import org.jetbrains.kotlin.js.parser.ParserUtilsKt;
import org.jetbrains.kotlin.js.resolve.BindingContextSlicesJsKt;
import org.jetbrains.kotlin.js.resolve.diagnostics.JsCallChecker;
import org.jetbrains.kotlin.js.translate.callTranslator.CallTranslator;
import org.jetbrains.kotlin.js.translate.context.TranslationContext;
import org.jetbrains.kotlin.js.translate.reference.AbstractCallExpressionTranslator;
import org.jetbrains.kotlin.js.translate.reference.ReferenceTranslator;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.psi.KtCallExpression;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtValueArgument;
import org.jetbrains.kotlin.psi.ValueArgument;
import org.jetbrains.kotlin.resolve.FunctionImportedFromObject;
import org.jetbrains.kotlin.resolve.calls.callUtil.CallUtilKt;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCall;
import org.jetbrains.kotlin.resolve.constants.evaluate.ConstantExpressionEvaluator;
import org.jetbrains.kotlin.resolve.inline.InlineUtil;
import org.jetbrains.kotlin.resolve.scopes.LexicalScope;

public final class CallExpressionTranslator
extends AbstractCallExpressionTranslator {
    @NotNull
    public static JsNode translate(@NotNull KtCallExpression expression, @Nullable JsExpression receiver, @NotNull TranslationContext context) {
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/kotlin/js/translate/reference/CallExpressionTranslator", "translate"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/kotlin/js/translate/reference/CallExpressionTranslator", "translate"));
        }
        ResolvedCall<? extends FunctionDescriptor> resolvedCall2 = CallUtilKt.getFunctionResolvedCallWithAssert(expression, context.bindingContext());
        if (JsCallChecker.isJsCall(resolvedCall2)) {
            JsNode jsNode = new CallExpressionTranslator(expression, receiver, context).translateJsCode();
            if (jsNode == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/js/translate/reference/CallExpressionTranslator", "translate"));
            }
            return jsNode;
        }
        JsExpression jsExpression = new CallExpressionTranslator(expression, receiver, context).translate();
        if (jsExpression == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/js/translate/reference/CallExpressionTranslator", "translate"));
        }
        return jsExpression;
    }

    public static boolean shouldBeInlined(@NotNull CallableDescriptor descriptor2, @NotNull TranslationContext context) {
        if (descriptor2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "org/jetbrains/kotlin/js/translate/reference/CallExpressionTranslator", "shouldBeInlined"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/kotlin/js/translate/reference/CallExpressionTranslator", "shouldBeInlined"));
        }
        if (context.getConfig().getConfiguration().getBoolean(CommonConfigurationKeys.DISABLE_INLINE)) {
            return false;
        }
        return CallExpressionTranslator.shouldBeInlined(descriptor2);
    }

    public static boolean shouldBeInlined(@NotNull CallableDescriptor descriptor2) {
        if (descriptor2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "org/jetbrains/kotlin/js/translate/reference/CallExpressionTranslator", "shouldBeInlined"));
        }
        if (descriptor2 instanceof SimpleFunctionDescriptor || descriptor2 instanceof PropertyAccessorDescriptor || descriptor2 instanceof FunctionImportedFromObject) {
            return InlineUtil.isInline(descriptor2);
        }
        if (descriptor2 instanceof ValueParameterDescriptor) {
            return InlineUtil.isInline(descriptor2.getContainingDeclaration()) && InlineUtil.isInlineLambdaParameter((ParameterDescriptor)descriptor2) && !((ValueParameterDescriptor)descriptor2).isCrossinline();
        }
        return false;
    }

    private CallExpressionTranslator(@NotNull KtCallExpression expression, @Nullable JsExpression receiver, @NotNull TranslationContext context) {
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/kotlin/js/translate/reference/CallExpressionTranslator", "<init>"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/kotlin/js/translate/reference/CallExpressionTranslator", "<init>"));
        }
        super(expression, receiver, context);
    }

    @NotNull
    private JsExpression translate() {
        JsExpression jsExpression = CallTranslator.translate(this.context(), this.resolvedCall, this.receiver);
        if (jsExpression == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/js/translate/reference/CallExpressionTranslator", "translate"));
        }
        return jsExpression;
    }

    @NotNull
    private JsNode translateJsCode() {
        JsStatement resultStatement;
        List<KtValueArgument> arguments2 = this.expression.getValueArguments();
        KtExpression argumentExpression = ((ValueArgument)arguments2.get(0)).getArgumentExpression();
        assert (argumentExpression != null);
        List<JsStatement> statements = this.parseJsCode(argumentExpression);
        int size = statements.size();
        JsNode node = size == 0 ? JsLiteral.NULL : (size > 1 ? new JsBlock(statements) : ((resultStatement = statements.get(0)) instanceof JsExpressionStatement ? ((JsExpressionStatement)resultStatement).getExpression() : resultStatement));
        LexicalScope lexicalScope = this.context().bindingContext().get(BindingContextSlicesJsKt.LEXICAL_SCOPE_FOR_JS, this.resolvedCall);
        HashMap<JsName, JsExpression> replacements = new HashMap<JsName, JsExpression>();
        if (lexicalScope != null) {
            Set<JsName> references = CollectUtilsKt.collectUsedNames(node);
            references.removeAll(CollectUtilsKt.collectDefinedNames(node));
            for (JsName name2 : references) {
                VariableDescriptor variable = CallExpressionTranslator.getVariableByName(lexicalScope, Name.identifier(name2.getIdent()));
                if (variable == null) continue;
                replacements.put(name2, ReferenceTranslator.translateAsValueReference(variable, this.context()));
            }
            if (!replacements.isEmpty()) {
                node = RewriteUtilsKt.replaceNames(node, replacements);
            }
        }
        JsNode jsNode = node;
        if (jsNode == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/js/translate/reference/CallExpressionTranslator", "translateJsCode"));
        }
        return jsNode;
    }

    @Nullable
    private static VariableDescriptor getVariableByName(@NotNull LexicalScope scope, @NotNull Name name2) {
        if (scope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "org/jetbrains/kotlin/js/translate/reference/CallExpressionTranslator", "getVariableByName"));
        }
        if (name2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "org/jetbrains/kotlin/js/translate/reference/CallExpressionTranslator", "getVariableByName"));
        }
        while (true) {
            Collection<VariableDescriptor> variables;
            if (!(variables = scope.getContributedVariables(name2, NoLookupLocation.FROM_BACKEND)).isEmpty()) {
                return variables.size() == 1 ? variables.iterator().next() : null;
            }
            if (!(scope.getParent() instanceof LexicalScope)) break;
            LexicalScope parentScope = (LexicalScope)scope.getParent();
            if (scope.getOwnerDescriptor() != parentScope.getOwnerDescriptor()) break;
            scope = parentScope;
        }
        return null;
    }

    @NotNull
    private List<JsStatement> parseJsCode(@NotNull KtExpression jsCodeExpression) {
        if (jsCodeExpression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "jsCodeExpression", "org/jetbrains/kotlin/js/translate/reference/CallExpressionTranslator", "parseJsCode"));
        }
        String jsCode = JsCallChecker.extractStringValue(ConstantExpressionEvaluator.getConstant(jsCodeExpression, this.context().bindingContext()));
        assert (jsCode != null) : "jsCode must be compile time string " + jsCodeExpression.getText();
        JsScope currentScope2 = this.context().scope();
        assert (currentScope2 instanceof JsFunctionScope) : "Usage of js outside of function is unexpected";
        JsRootScope temporaryRootScope = new JsRootScope(new JsProgram());
        DelegatingJsFunctionScopeWithTemporaryParent scope = new DelegatingJsFunctionScopeWithTemporaryParent((JsFunctionScope)currentScope2, temporaryRootScope);
        List<JsStatement> list2 = ParserUtilsKt.parse(jsCode, ThrowExceptionOnErrorReporter.INSTANCE, scope);
        if (list2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/js/translate/reference/CallExpressionTranslator", "parseJsCode"));
        }
        return list2;
    }
}

