/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.js.translate.utils;

import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.builtins.KotlinBuiltIns;
import org.jetbrains.kotlin.com.intellij.openapi.util.Condition;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.com.intellij.util.containers.ContainerUtil;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.CallableMemberDescriptor;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.ClassKind;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.descriptors.Modality;
import org.jetbrains.kotlin.descriptors.ModalityKt;
import org.jetbrains.kotlin.descriptors.ModuleDescriptor;
import org.jetbrains.kotlin.descriptors.PackageFragmentDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyAccessorDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyDescriptor;
import org.jetbrains.kotlin.descriptors.ReceiverParameterDescriptor;
import org.jetbrains.kotlin.js.config.LibrarySourcesConfig;
import org.jetbrains.kotlin.js.translate.context.Namer;
import org.jetbrains.kotlin.js.translate.context.TranslationContext;
import org.jetbrains.kotlin.js.translate.utils.AnnotationsUtils;
import org.jetbrains.kotlin.js.translate.utils.TranslationUtils;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.resolve.DescriptorToSourceUtils;
import org.jetbrains.kotlin.resolve.DescriptorUtils;
import org.jetbrains.kotlin.resolve.calls.tasks.DynamicCallsKt;
import org.jetbrains.kotlin.resolve.descriptorUtil.DescriptorUtilsKt;
import org.jetbrains.kotlin.resolve.scopes.receivers.ImplicitReceiver;
import org.jetbrains.kotlin.resolve.scopes.receivers.ReceiverValue;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.typeUtil.TypeUtilsKt;
import org.jetbrains.kotlin.util.OperatorNameConventions;

public final class JsDescriptorUtils {
    private static final Set<String> FAKE_CLASSES = ContainerUtil.immutableSet(KotlinBuiltIns.FQ_NAMES.any.asString());

    private JsDescriptorUtils() {
    }

    private static int valueParametersCount(@NotNull FunctionDescriptor functionDescriptor) {
        if (functionDescriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "functionDescriptor", "org/jetbrains/kotlin/js/translate/utils/JsDescriptorUtils", "valueParametersCount"));
        }
        return functionDescriptor.getValueParameters().size();
    }

    public static boolean hasParameters(@NotNull FunctionDescriptor functionDescriptor) {
        if (functionDescriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "functionDescriptor", "org/jetbrains/kotlin/js/translate/utils/JsDescriptorUtils", "hasParameters"));
        }
        return JsDescriptorUtils.valueParametersCount(functionDescriptor) > 0;
    }

    public static boolean isCompareTo(@NotNull CallableDescriptor descriptor2) {
        if (descriptor2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "org/jetbrains/kotlin/js/translate/utils/JsDescriptorUtils", "isCompareTo"));
        }
        return descriptor2.getName().equals(OperatorNameConventions.COMPARE_TO);
    }

    @Nullable
    public static ClassDescriptor findAncestorClass(@NotNull List<ClassDescriptor> superclassDescriptors) {
        if (superclassDescriptors == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "superclassDescriptors", "org/jetbrains/kotlin/js/translate/utils/JsDescriptorUtils", "findAncestorClass"));
        }
        for (ClassDescriptor descriptor2 : superclassDescriptors) {
            if (descriptor2.getKind() != ClassKind.CLASS && descriptor2.getKind() != ClassKind.ENUM_CLASS) continue;
            return descriptor2;
        }
        return null;
    }

    @Nullable
    public static ClassDescriptor getSuperclass(@NotNull ClassDescriptor classDescriptor) {
        if (classDescriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "classDescriptor", "org/jetbrains/kotlin/js/translate/utils/JsDescriptorUtils", "getSuperclass"));
        }
        return JsDescriptorUtils.findAncestorClass(DescriptorUtils.getSuperclassDescriptors(classDescriptor));
    }

    @NotNull
    public static List<KotlinType> getSupertypesWithoutFakes(ClassDescriptor descriptor2) {
        Collection<KotlinType> supertypes2 = descriptor2.getTypeConstructor().getSupertypes();
        List<KotlinType> list2 = ContainerUtil.filter(supertypes2, new Condition<KotlinType>(){

            @Override
            public boolean value(KotlinType type2) {
                ClassDescriptor classDescriptor = DescriptorUtils.getClassDescriptorForType(type2);
                return !FAKE_CLASSES.contains(DescriptorUtils.getFqNameSafe(classDescriptor).asString()) && (classDescriptor.getKind() != ClassKind.INTERFACE || !AnnotationsUtils.isNativeObject(classDescriptor));
            }
        });
        if (list2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/js/translate/utils/JsDescriptorUtils", "getSupertypesWithoutFakes"));
        }
        return list2;
    }

    @NotNull
    public static DeclarationDescriptor getContainingDeclaration(@NotNull DeclarationDescriptor descriptor2) {
        if (descriptor2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "org/jetbrains/kotlin/js/translate/utils/JsDescriptorUtils", "getContainingDeclaration"));
        }
        DeclarationDescriptor containing = descriptor2.getContainingDeclaration();
        assert (containing != null) : "Should be called on objects that have containing declaration.";
        DeclarationDescriptor declarationDescriptor = containing;
        if (declarationDescriptor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/js/translate/utils/JsDescriptorUtils", "getContainingDeclaration"));
        }
        return declarationDescriptor;
    }

    @NotNull
    public static ReceiverParameterDescriptor getReceiverParameterForReceiver(@NotNull ReceiverValue receiverParameter) {
        if (receiverParameter == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "receiverParameter", "org/jetbrains/kotlin/js/translate/utils/JsDescriptorUtils", "getReceiverParameterForReceiver"));
        }
        DeclarationDescriptor declarationDescriptor = JsDescriptorUtils.getDeclarationDescriptorForReceiver(receiverParameter);
        ReceiverParameterDescriptor receiverParameterDescriptor = JsDescriptorUtils.getReceiverParameterForDeclaration(declarationDescriptor);
        if (receiverParameterDescriptor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/js/translate/utils/JsDescriptorUtils", "getReceiverParameterForReceiver"));
        }
        return receiverParameterDescriptor;
    }

    @NotNull
    private static DeclarationDescriptor getDeclarationDescriptorForReceiver(@NotNull ReceiverValue receiverParameter) {
        if (receiverParameter == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "receiverParameter", "org/jetbrains/kotlin/js/translate/utils/JsDescriptorUtils", "getDeclarationDescriptorForReceiver"));
        }
        if (receiverParameter instanceof ImplicitReceiver) {
            DeclarationDescriptor declarationDescriptor = ((ImplicitReceiver)receiverParameter).getDeclarationDescriptor();
            DeclarationDescriptor declarationDescriptor2 = declarationDescriptor.getOriginal();
            if (declarationDescriptor2 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/js/translate/utils/JsDescriptorUtils", "getDeclarationDescriptorForReceiver"));
            }
            return declarationDescriptor2;
        }
        throw new UnsupportedOperationException("Unsupported receiver type: " + receiverParameter.getClass() + ", receiverParameter = " + receiverParameter);
    }

    @NotNull
    public static ReceiverParameterDescriptor getReceiverParameterForDeclaration(DeclarationDescriptor declarationDescriptor) {
        if (declarationDescriptor instanceof ClassDescriptor) {
            ReceiverParameterDescriptor receiverParameterDescriptor = ((ClassDescriptor)declarationDescriptor).getThisAsReceiverParameter();
            if (receiverParameterDescriptor == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/js/translate/utils/JsDescriptorUtils", "getReceiverParameterForDeclaration"));
            }
            return receiverParameterDescriptor;
        }
        if (declarationDescriptor instanceof CallableMemberDescriptor) {
            ReceiverParameterDescriptor receiverDescriptor = ((CallableMemberDescriptor)declarationDescriptor).getExtensionReceiverParameter();
            assert (receiverDescriptor != null);
            ReceiverParameterDescriptor receiverParameterDescriptor = receiverDescriptor;
            if (receiverParameterDescriptor == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/js/translate/utils/JsDescriptorUtils", "getReceiverParameterForDeclaration"));
            }
            return receiverParameterDescriptor;
        }
        throw new UnsupportedOperationException("Unsupported declaration type: " + declarationDescriptor.getClass() + ", declarationDescriptor = " + declarationDescriptor);
    }

    private static boolean isDefaultAccessor(@Nullable PropertyAccessorDescriptor accessorDescriptor) {
        return accessorDescriptor == null || accessorDescriptor.isDefault();
    }

    public static boolean sideEffectsPossibleOnRead(@NotNull PropertyDescriptor property) {
        if (property == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "property", "org/jetbrains/kotlin/js/translate/utils/JsDescriptorUtils", "sideEffectsPossibleOnRead"));
        }
        return DynamicCallsKt.isDynamic(property) || !JsDescriptorUtils.isDefaultAccessor(property.getGetter()) || ModalityKt.isOverridableOrOverrides(property) || JsDescriptorUtils.isStaticInitializationPossible(property);
    }

    private static boolean isStaticInitializationPossible(PropertyDescriptor property) {
        DeclarationDescriptor container2 = property.getContainingDeclaration();
        return container2 instanceof PackageFragmentDescriptor || DescriptorUtils.isObject(container2);
    }

    public static boolean isSimpleFinalProperty(@NotNull PropertyDescriptor propertyDescriptor) {
        if (propertyDescriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "propertyDescriptor", "org/jetbrains/kotlin/js/translate/utils/JsDescriptorUtils", "isSimpleFinalProperty"));
        }
        return !DescriptorUtils.isExtension(propertyDescriptor) && JsDescriptorUtils.isDefaultAccessor(propertyDescriptor.getGetter()) && JsDescriptorUtils.isDefaultAccessor(propertyDescriptor.getSetter()) && !TranslationUtils.shouldAccessViaFunctions((CallableDescriptor)propertyDescriptor) && !ModalityKt.isOverridableOrOverrides(propertyDescriptor);
    }

    @Nullable
    public static Name getNameIfStandardType(@NotNull KtExpression expression, @NotNull TranslationContext context) {
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/kotlin/js/translate/utils/JsDescriptorUtils", "getNameIfStandardType"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/kotlin/js/translate/utils/JsDescriptorUtils", "getNameIfStandardType"));
        }
        KotlinType type2 = context.bindingContext().getType(expression);
        return type2 != null ? org.jetbrains.kotlin.js.descriptorUtils.DescriptorUtilsKt.getNameIfStandardType(type2) : null;
    }

    @NotNull
    public static String getModuleName(@NotNull DeclarationDescriptor descriptor2) {
        if (descriptor2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "org/jetbrains/kotlin/js/translate/utils/JsDescriptorUtils", "getModuleName"));
        }
        String externalModuleName = JsDescriptorUtils.getExternalModuleName(descriptor2);
        if (externalModuleName != null) {
            String string = externalModuleName;
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/js/translate/utils/JsDescriptorUtils", "getModuleName"));
            }
            return string;
        }
        String string = JsDescriptorUtils.getModuleNameFromDescriptorName(descriptor2);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/js/translate/utils/JsDescriptorUtils", "getModuleName"));
        }
        return string;
    }

    @Nullable
    public static String getExternalModuleName(@NotNull DeclarationDescriptor descriptor2) {
        if (descriptor2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "org/jetbrains/kotlin/js/translate/utils/JsDescriptorUtils", "getExternalModuleName"));
        }
        if (KotlinBuiltIns.isBuiltIn(descriptor2)) {
            return Namer.KOTLIN_LOWER_NAME;
        }
        PsiElement element = DescriptorToSourceUtils.descriptorToDeclaration(descriptor2);
        if (element == null && descriptor2 instanceof PropertyAccessorDescriptor) {
            element = DescriptorToSourceUtils.descriptorToDeclaration(((PropertyAccessorDescriptor)descriptor2).getCorrespondingProperty());
        }
        if (element == null) {
            return JsDescriptorUtils.getModuleNameFromDescriptorName(descriptor2);
        }
        return element.getContainingFile().getUserData(LibrarySourcesConfig.EXTERNAL_MODULE_NAME);
    }

    @NotNull
    public static DeclarationDescriptor findRealInlineDeclaration(@NotNull DeclarationDescriptor descriptor2) {
        if (descriptor2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "org/jetbrains/kotlin/js/translate/utils/JsDescriptorUtils", "findRealInlineDeclaration"));
        }
        if (descriptor2 instanceof FunctionDescriptor) {
            FunctionDescriptor d = (FunctionDescriptor)descriptor2;
            if (d.getKind().isReal() || !d.isInline()) {
                DeclarationDescriptor declarationDescriptor = descriptor2;
                if (declarationDescriptor == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/js/translate/utils/JsDescriptorUtils", "findRealInlineDeclaration"));
                }
                return declarationDescriptor;
            }
            FunctionDescriptor real = JsDescriptorUtils.findRealDeclaration(d);
            assert (real != null) : "Couldn't find definition of a fake inline descriptor " + descriptor2;
            FunctionDescriptor functionDescriptor = real;
            if (functionDescriptor == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/js/translate/utils/JsDescriptorUtils", "findRealInlineDeclaration"));
            }
            return functionDescriptor;
        }
        DeclarationDescriptor declarationDescriptor = descriptor2;
        if (declarationDescriptor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/js/translate/utils/JsDescriptorUtils", "findRealInlineDeclaration"));
        }
        return declarationDescriptor;
    }

    @Nullable
    private static FunctionDescriptor findRealDeclaration(FunctionDescriptor descriptor2) {
        if (descriptor2.getModality() == Modality.ABSTRACT) {
            return null;
        }
        if (descriptor2.getKind().isReal()) {
            return descriptor2;
        }
        for (FunctionDescriptor functionDescriptor : descriptor2.getOverriddenDescriptors()) {
            FunctionDescriptor child = JsDescriptorUtils.findRealDeclaration(functionDescriptor);
            if (child == null) continue;
            return child;
        }
        return null;
    }

    private static String getModuleNameFromDescriptorName(@NotNull DeclarationDescriptor descriptor2) {
        if (descriptor2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "org/jetbrains/kotlin/js/translate/utils/JsDescriptorUtils", "getModuleNameFromDescriptorName"));
        }
        ModuleDescriptor moduleDescriptor = DescriptorUtils.getContainingModule(JsDescriptorUtils.findRealInlineDeclaration(descriptor2));
        String moduleName = moduleDescriptor.getName().asString();
        return moduleName.substring(1, moduleName.length() - 1);
    }

    public static boolean isImmediateSubtypeOfError(@NotNull ClassDescriptor descriptor2) {
        if (descriptor2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "org/jetbrains/kotlin/js/translate/utils/JsDescriptorUtils", "isImmediateSubtypeOfError"));
        }
        if (!JsDescriptorUtils.isExceptionClass(descriptor2)) {
            return false;
        }
        ClassDescriptor superClass = DescriptorUtilsKt.getSuperClassOrAny(descriptor2);
        return TypeUtilsKt.isThrowable(superClass.getDefaultType()) || AnnotationsUtils.isNativeObject(superClass);
    }

    public static boolean isExceptionClass(@NotNull ClassDescriptor descriptor2) {
        if (descriptor2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "org/jetbrains/kotlin/js/translate/utils/JsDescriptorUtils", "isExceptionClass"));
        }
        ModuleDescriptor module = DescriptorUtils.getContainingModule(descriptor2);
        return TypeUtilsKt.isSubtypeOf(descriptor2.getDefaultType(), module.getBuiltIns().getThrowable().getDefaultType());
    }
}

