/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.js.translate.utils;

import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.com.intellij.psi.tree.IElementType;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.VariableDescriptor;
import org.jetbrains.kotlin.lexer.KtToken;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.psi.KtBinaryExpression;
import org.jetbrains.kotlin.psi.KtClass;
import org.jetbrains.kotlin.psi.KtClassOrObject;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtForExpression;
import org.jetbrains.kotlin.psi.KtOperationExpression;
import org.jetbrains.kotlin.psi.KtParameter;
import org.jetbrains.kotlin.psi.KtPrefixExpression;
import org.jetbrains.kotlin.psi.KtQualifiedExpression;
import org.jetbrains.kotlin.psi.KtSimpleNameExpression;
import org.jetbrains.kotlin.psi.KtUnaryExpression;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCall;
import org.jetbrains.kotlin.resolve.calls.model.VariableAsFunctionResolvedCall;

public final class PsiUtils {
    private PsiUtils() {
    }

    @Nullable
    public static KtSimpleNameExpression getSimpleName(@NotNull KtExpression expression) {
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/kotlin/js/translate/utils/PsiUtils", "getSimpleName"));
        }
        if (expression instanceof KtSimpleNameExpression) {
            return (KtSimpleNameExpression)expression;
        }
        if (expression instanceof KtQualifiedExpression) {
            return PsiUtils.getSelectorAsSimpleName((KtQualifiedExpression)expression);
        }
        return null;
    }

    @Nullable
    public static KtSimpleNameExpression getSelectorAsSimpleName(@NotNull KtQualifiedExpression expression) {
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/kotlin/js/translate/utils/PsiUtils", "getSelectorAsSimpleName"));
        }
        KtExpression selectorExpression = PsiUtils.getSelector(expression);
        if (!(selectorExpression instanceof KtSimpleNameExpression)) {
            return null;
        }
        return (KtSimpleNameExpression)selectorExpression;
    }

    @NotNull
    public static KtExpression getSelector(@NotNull KtQualifiedExpression expression) {
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/kotlin/js/translate/utils/PsiUtils", "getSelector"));
        }
        KtExpression selectorExpression = expression.getSelectorExpression();
        assert (selectorExpression != null) : "Selector should not be null.";
        KtExpression ktExpression = selectorExpression;
        if (ktExpression == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/js/translate/utils/PsiUtils", "getSelector"));
        }
        return ktExpression;
    }

    @NotNull
    public static KtSimpleNameExpression getNotNullSimpleNameSelector(@NotNull KtQualifiedExpression expression) {
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/kotlin/js/translate/utils/PsiUtils", "getNotNullSimpleNameSelector"));
        }
        KtSimpleNameExpression selectorAsSimpleName = PsiUtils.getSelectorAsSimpleName(expression);
        assert (selectorAsSimpleName != null);
        KtSimpleNameExpression ktSimpleNameExpression = selectorAsSimpleName;
        if (ktSimpleNameExpression == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/js/translate/utils/PsiUtils", "getNotNullSimpleNameSelector"));
        }
        return ktSimpleNameExpression;
    }

    @NotNull
    public static KtToken getOperationToken(@NotNull KtOperationExpression expression) {
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/kotlin/js/translate/utils/PsiUtils", "getOperationToken"));
        }
        KtSimpleNameExpression operationExpression = expression.getOperationReference();
        IElementType elementType = operationExpression.getReferencedNameElementType();
        assert (elementType instanceof KtToken) : "Expected KtToken type, but " + elementType.getClass() + ", expression: " + expression.getText();
        KtToken ktToken = (KtToken)elementType;
        if (ktToken == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/js/translate/utils/PsiUtils", "getOperationToken"));
        }
        return ktToken;
    }

    @NotNull
    public static KtExpression getBaseExpression(@NotNull KtUnaryExpression expression) {
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/kotlin/js/translate/utils/PsiUtils", "getBaseExpression"));
        }
        KtExpression baseExpression = expression.getBaseExpression();
        assert (baseExpression != null);
        KtExpression ktExpression = baseExpression;
        if (ktExpression == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/js/translate/utils/PsiUtils", "getBaseExpression"));
        }
        return ktExpression;
    }

    public static boolean isPrefix(@NotNull KtUnaryExpression expression) {
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/kotlin/js/translate/utils/PsiUtils", "isPrefix"));
        }
        return expression instanceof KtPrefixExpression;
    }

    public static boolean isAssignment(KtToken token) {
        return token == KtTokens.EQ;
    }

    public static boolean isInOrNotInOperation(@NotNull KtBinaryExpression binaryExpression) {
        if (binaryExpression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "binaryExpression", "org/jetbrains/kotlin/js/translate/utils/PsiUtils", "isInOrNotInOperation"));
        }
        return PsiUtils.isInOperation(binaryExpression) || PsiUtils.isNotInOperation(binaryExpression);
    }

    private static boolean isNotInOperation(@NotNull KtBinaryExpression binaryExpression) {
        if (binaryExpression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "binaryExpression", "org/jetbrains/kotlin/js/translate/utils/PsiUtils", "isNotInOperation"));
        }
        return binaryExpression.getOperationToken() == KtTokens.NOT_IN;
    }

    public static boolean isNegatedOperation(@NotNull KtBinaryExpression binaryExpression) {
        if (binaryExpression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "binaryExpression", "org/jetbrains/kotlin/js/translate/utils/PsiUtils", "isNegatedOperation"));
        }
        return binaryExpression.getOperationToken() == KtTokens.EXCLEQ || PsiUtils.isNotInOperation(binaryExpression);
    }

    private static boolean isInOperation(@NotNull KtBinaryExpression binaryExpression) {
        if (binaryExpression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "binaryExpression", "org/jetbrains/kotlin/js/translate/utils/PsiUtils", "isInOperation"));
        }
        return binaryExpression.getOperationToken() == KtTokens.IN_KEYWORD;
    }

    @NotNull
    public static List<KtParameter> getPrimaryConstructorParameters(@NotNull KtClassOrObject classDeclaration) {
        if (classDeclaration == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "classDeclaration", "org/jetbrains/kotlin/js/translate/utils/PsiUtils", "getPrimaryConstructorParameters"));
        }
        if (classDeclaration instanceof KtClass) {
            List<KtParameter> list2 = classDeclaration.getPrimaryConstructorParameters();
            if (list2 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/js/translate/utils/PsiUtils", "getPrimaryConstructorParameters"));
            }
            return list2;
        }
        List<KtParameter> list3 = Collections.emptyList();
        if (list3 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/js/translate/utils/PsiUtils", "getPrimaryConstructorParameters"));
        }
        return list3;
    }

    @NotNull
    public static KtExpression getLoopRange(@NotNull KtForExpression expression) {
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/kotlin/js/translate/utils/PsiUtils", "getLoopRange"));
        }
        KtExpression rangeExpression = expression.getLoopRange();
        assert (rangeExpression != null);
        KtExpression ktExpression = rangeExpression;
        if (ktExpression == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/js/translate/utils/PsiUtils", "getLoopRange"));
        }
        return ktExpression;
    }

    @NotNull
    public static CallableDescriptor getFunctionDescriptor(ResolvedCall<?> resolvedCall2) {
        if (resolvedCall2 instanceof VariableAsFunctionResolvedCall) {
            VariableDescriptor variableDescriptor = ((VariableAsFunctionResolvedCall)((Object)resolvedCall2)).getVariableCall().getCandidateDescriptor();
            if (variableDescriptor == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/js/translate/utils/PsiUtils", "getFunctionDescriptor"));
            }
            return variableDescriptor;
        }
        Object obj = resolvedCall2.getCandidateDescriptor();
        if (obj == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/js/translate/utils/PsiUtils", "getFunctionDescriptor"));
        }
        return obj;
    }
}

