/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.workers.internal;

import java.io.File;
import org.gradle.StartParameter;
import org.gradle.api.logging.Logger;
import org.gradle.api.logging.Logging;
import org.gradle.internal.progress.BuildOperationExecutor;
import org.gradle.internal.time.Timer;
import org.gradle.internal.time.Timers;
import org.gradle.process.internal.JavaExecHandleBuilder;
import org.gradle.process.internal.worker.MultiRequestWorkerProcessBuilder;
import org.gradle.process.internal.worker.WorkerProcess;
import org.gradle.process.internal.worker.WorkerProcessFactory;
import org.gradle.workers.internal.DaemonForkOptions;
import org.gradle.workers.internal.WorkerDaemonClient;
import org.gradle.workers.internal.WorkerDaemonProtocol;
import org.gradle.workers.internal.WorkerDaemonWorker;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WorkerDaemonStarter {
    private static final Logger LOG = Logging.getLogger(WorkerDaemonStarter.class);
    private final WorkerProcessFactory workerFactory;
    private final StartParameter startParameter;
    private final BuildOperationExecutor buildOperationExecutor;

    public WorkerDaemonStarter(WorkerProcessFactory workerFactory, StartParameter startParameter, BuildOperationExecutor buildOperationExecutor) {
        this.workerFactory = workerFactory;
        this.startParameter = startParameter;
        this.buildOperationExecutor = buildOperationExecutor;
    }

    public WorkerDaemonClient startDaemon(Class<? extends WorkerDaemonProtocol> serverImplementationClass, File workingDir, DaemonForkOptions forkOptions) {
        LOG.debug("Starting Gradle worker daemon with fork options {}.", (Object)forkOptions);
        Timer clock = Timers.startTimer();
        MultiRequestWorkerProcessBuilder builder = this.workerFactory.multiRequestWorker(WorkerDaemonWorker.class, WorkerDaemonProtocol.class, serverImplementationClass);
        builder.setBaseName("Gradle Worker Daemon");
        builder.setLogLevel(this.startParameter.getLogLevel());
        builder.applicationClasspath(forkOptions.getClasspath());
        builder.sharedPackages(forkOptions.getSharedPackages());
        JavaExecHandleBuilder javaCommand = builder.getJavaCommand();
        javaCommand.setMinHeapSize(forkOptions.getMinHeapSize());
        javaCommand.setMaxHeapSize(forkOptions.getMaxHeapSize());
        javaCommand.setJvmArgs(forkOptions.getJvmArgs());
        javaCommand.setWorkingDir((Object)workingDir);
        WorkerDaemonWorker worker = (WorkerDaemonWorker)builder.build();
        WorkerProcess workerProcess = worker.start();
        WorkerDaemonClient client = new WorkerDaemonClient(forkOptions, worker, workerProcess, this.buildOperationExecutor);
        LOG.info("Started Gradle worker daemon ({}) with fork options {}.", (Object)clock.getElapsed(), (Object)forkOptions);
        return client;
    }
}

