/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.gradleplugin.userinterface.swing.generic;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Font;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JTabbedPane;
import javax.swing.UIManager;
import org.gradle.foundation.common.ObserverLord;
import org.gradle.foundation.output.FileLinkDefinitionLord;
import org.gradle.foundation.queue.ExecutionQueue;
import org.gradle.gradleplugin.foundation.GradlePluginLord;
import org.gradle.gradleplugin.foundation.request.ExecutionRequest;
import org.gradle.gradleplugin.foundation.request.RefreshTaskListRequest;
import org.gradle.gradleplugin.foundation.request.Request;
import org.gradle.gradleplugin.userinterface.AlternateUIInteraction;
import org.gradle.gradleplugin.userinterface.swing.generic.OutputPanel;
import org.gradle.gradleplugin.userinterface.swing.generic.OutputTab;
import org.gradle.gradleplugin.userinterface.swing.generic.OutputUILord;
import org.gradle.gradleplugin.userinterface.swing.generic.Utility;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OutputPanelLord
implements OutputUILord,
GradlePluginLord.RequestObserver,
OutputPanel.OutputPanelParent {
    private JPanel mainPanel;
    private JTabbedPane tabbedPane;
    private JPopupMenu popupMenu;
    private boolean onlyShowOutputOnErrors;
    private JMenuItem closeMenuItem;
    private JMenuItem closeAllMenuItem;
    private JMenuItem closeAllButThisMenuItem;
    private JMenuItem togglePinStateMenuItem;
    private ObserverLord<OutputUILord.OutputObserver> observerLord = new ObserverLord();
    private GradlePluginLord gradlePluginLord;
    private AlternateUIInteraction alternateUIInteraction;
    private Font font;
    private FileLinkDefinitionLord fileLinkDefinitionLord;
    private ExecutionRequest lastExecutionRequest;

    public OutputPanelLord(GradlePluginLord gradlePluginLord, AlternateUIInteraction alternateUIInteraction) {
        this.gradlePluginLord = gradlePluginLord;
        this.alternateUIInteraction = alternateUIInteraction;
        this.fileLinkDefinitionLord = new FileLinkDefinitionLord();
        gradlePluginLord.addRequestObserver(this, true);
        this.setupUI();
        Font font = new Font("Monospaced", 0, UIManager.getDefaults().getFont("Label.font").getSize());
        this.setOutputTextFont(font);
    }

    public JPanel getMainPanel() {
        return this.mainPanel;
    }

    private void setupUI() {
        this.mainPanel = new JPanel(new BorderLayout());
        this.tabbedPane = new JTabbedPane();
        this.mainPanel.add((Component)this.tabbedPane, "Center");
        this.setupPopupMenu();
    }

    private void setupPopupMenu() {
        this.popupMenu = new JPopupMenu();
        this.closeMenuItem = new JMenuItem(new AbstractAction("Close"){

            public void actionPerformed(ActionEvent e) {
                OutputPanelLord.this.closeSelectedTab();
            }
        });
        this.popupMenu.add(this.closeMenuItem);
        this.closeAllMenuItem = new JMenuItem(new AbstractAction("Close All"){

            public void actionPerformed(ActionEvent e) {
                OutputPanelLord.this.closeAllTabs();
            }
        });
        this.popupMenu.add(this.closeAllMenuItem);
        this.closeAllButThisMenuItem = new JMenuItem(new AbstractAction("Close All But This"){

            public void actionPerformed(ActionEvent e) {
                OutputPanelLord.this.closeAllButSelectedTab();
            }
        });
        this.popupMenu.add(this.closeAllButThisMenuItem);
        this.popupMenu.addSeparator();
        this.togglePinStateMenuItem = new JMenuItem(new AbstractAction("Pin"){

            public void actionPerformed(ActionEvent e) {
                OutputPanelLord.this.togglePinSelectedTab();
            }
        });
        this.popupMenu.add(this.togglePinStateMenuItem);
        this.tabbedPane.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == 1 && e.getButton() == 3) {
                    OutputPanelLord.this.enablePopupMenuAppropriately();
                    Point point = e.getPoint();
                    OutputPanelLord.this.popupMenu.show(OutputPanelLord.this.tabbedPane, point.x, e.getPoint().y);
                }
            }
        });
    }

    private void enablePopupMenuAppropriately() {
        OutputTab panel = this.getSelectedOutputPanel();
        if (panel == null) {
            this.closeMenuItem.setEnabled(false);
            this.togglePinStateMenuItem.setEnabled(false);
        } else {
            this.closeMenuItem.setEnabled(true);
            if (panel.isPinned()) {
                this.togglePinStateMenuItem.setText("Unpin");
            } else {
                this.togglePinStateMenuItem.setText("Pin");
            }
        }
    }

    private OutputPanel getOutputPanelForExecution(String description, boolean selectOutputPanel, boolean reuseSelectedOutputPanelFirst) {
        OutputTab outputPanel = this.findExistingOutputPanelForExecution(reuseSelectedOutputPanelFirst);
        if (outputPanel != null) {
            outputPanel.setTabHeaderText(description);
            outputPanel.reset();
        } else {
            outputPanel = new OutputTab(this.gradlePluginLord, this, description, this.alternateUIInteraction);
            outputPanel.setFont(this.font);
            outputPanel.initialize();
            outputPanel.reset();
            this.tabbedPane.addTab(description, outputPanel);
            if (selectOutputPanel) {
                this.tabbedPane.setSelectedComponent(outputPanel);
            }
            Utility.setTabComponent15Compatible(this.tabbedPane, this.tabbedPane.getTabCount() - 1, outputPanel.getTabHeader());
        }
        return outputPanel;
    }

    private OutputTab findExistingOutputPanelForExecution(boolean considerSelectedTabFirst) {
        OutputTab outputTab;
        Object var2_2 = null;
        if (considerSelectedTabFirst && (outputTab = (OutputTab)this.tabbedPane.getSelectedComponent()) != null && outputTab.canBeReusedNow()) {
            return outputTab;
        }
        for (OutputTab outputTab2 : this.getOutputPanels()) {
            if (!outputTab2.canBeReusedNow()) continue;
            return outputTab2;
        }
        return null;
    }

    private List<OutputPanel> getOutputPanels() {
        ArrayList<OutputPanel> panels = new ArrayList<OutputPanel>();
        for (int index = 0; index < this.tabbedPane.getTabCount(); ++index) {
            OutputPanel outputPanel = (OutputPanel)this.tabbedPane.getComponentAt(index);
            panels.add(outputPanel);
        }
        return panels;
    }

    private String reformatDisplayName(String displayName) {
        if (displayName.length() <= 20) {
            return displayName;
        }
        return displayName.substring(0, 14) + "...";
    }

    public boolean isBusy() {
        for (OutputPanel outputPanel : this.getOutputPanels()) {
            if (!outputPanel.isBusy()) continue;
            return true;
        }
        return false;
    }

    @Override
    public void setOnlyShowOutputOnErrors(boolean value) {
        this.onlyShowOutputOnErrors = value;
    }

    @Override
    public boolean getOnlyShowOutputOnErrors() {
        return this.onlyShowOutputOnErrors;
    }

    private void closeSelectedTab() {
        OutputTab component = this.getSelectedOutputPanel();
        if (component != null) {
            component.close();
        }
    }

    private void closeAllTabs() {
        for (OutputPanel outputPanel : this.getOutputPanels()) {
            outputPanel.close();
        }
    }

    private void closeAllButSelectedTab() {
        OutputTab component = this.getSelectedOutputPanel();
        for (OutputPanel outputPanel : this.getOutputPanels()) {
            if (outputPanel == component) continue;
            outputPanel.close();
        }
    }

    private void togglePinSelectedTab() {
        OutputTab component = this.getSelectedOutputPanel();
        if (component != null) {
            component.setPinned(!component.isPinned());
        }
    }

    private OutputTab getSelectedOutputPanel() {
        return (OutputTab)this.tabbedPane.getSelectedComponent();
    }

    private OutputPanel getOutputPanel(ExecutionQueue.Request request) {
        for (OutputPanel outputPanel : this.getOutputPanels()) {
            if (outputPanel.getRequest() != request) continue;
            return outputPanel;
        }
        return null;
    }

    @Override
    public void executeAgain(Request request, OutputPanel outputPanel) {
        request.executeAgain(this.gradlePluginLord);
    }

    @Override
    public void reportExecuteFinished(final Request request, final boolean wasSuccessful) {
        this.observerLord.notifyObservers(new ObserverLord.ObserverNotification<OutputUILord.OutputObserver>(){

            @Override
            public void notify(OutputUILord.OutputObserver observer) {
                observer.reportExecuteFinished(request, wasSuccessful);
            }
        });
    }

    @Override
    public void removeOutputPanel(final OutputPanel outputPanel) {
        this.tabbedPane.remove(outputPanel);
        this.observerLord.notifyObservers(new ObserverLord.ObserverNotification<OutputUILord.OutputObserver>(){

            @Override
            public void notify(OutputUILord.OutputObserver observer) {
                observer.outputTabClosed(outputPanel.getRequest());
            }
        });
    }

    @Override
    public void executionRequestAdded(final ExecutionRequest request) {
        this.lastExecutionRequest = request;
        String displayName = this.reformatDisplayName(request.getDisplayName());
        this.requestAdded(request, "Execute '" + displayName + "'");
        this.observerLord.notifyObservers(new ObserverLord.ObserverNotification<OutputUILord.OutputObserver>(){

            @Override
            public void notify(OutputUILord.OutputObserver observer) {
                observer.executionRequestAdded(request);
            }
        });
    }

    @Override
    public void refreshRequestAdded(final RefreshTaskListRequest request) {
        this.requestAdded(request, "Refresh");
        this.observerLord.notifyObservers(new ObserverLord.ObserverNotification<OutputUILord.OutputObserver>(){

            @Override
            public void notify(OutputUILord.OutputObserver observer) {
                observer.refreshRequestAdded(request);
            }
        });
    }

    private void requestAdded(Request request, String name) {
        OutputPanel outputPanel = this.getOutputPanelForExecution(name, false, true);
        outputPanel.setRequest(request, this.onlyShowOutputOnErrors);
        request.setExecutionInteraction(outputPanel);
    }

    @Override
    public void aboutToExecuteRequest(Request request) {
    }

    @Override
    public void requestExecutionComplete(Request request, int result, String output) {
    }

    @Override
    public void addOutputObserver(OutputUILord.OutputObserver observer, boolean inEventQueue) {
        this.observerLord.addObserver(observer, inEventQueue);
    }

    @Override
    public void removeOutputObserver(OutputUILord.OutputObserver observer) {
        this.observerLord.removeObserver(observer);
    }

    @Override
    public int getTabCount() {
        return this.tabbedPane.getTabCount();
    }

    @Override
    public void setOutputTextFont(Font font) {
        this.font = font;
        for (OutputPanel outputPanel : this.getOutputPanels()) {
            outputPanel.setFont(font);
        }
    }

    @Override
    public Font getOutputTextFont() {
        return this.font;
    }

    @Override
    public FileLinkDefinitionLord getFileLinkDefinitionLord() {
        return this.fileLinkDefinitionLord;
    }

    @Override
    public void reExecuteLastCommand() {
        ExecutionRequest executionRequest = this.lastExecutionRequest;
        if (executionRequest != null) {
            this.gradlePluginLord.addExecutionRequestToQueue(executionRequest.getFullCommandLine(), executionRequest.getDisplayName(), executionRequest.forceOutputToBeShown());
        }
    }
}

