/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.caching.http;

import com.google.common.base.Strings;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import org.gradle.api.Action;
import org.gradle.api.Incubating;
import org.gradle.api.Nullable;
import org.gradle.caching.configuration.AbstractBuildCache;
import org.gradle.caching.http.HttpBuildCacheCredentials;
import org.gradle.util.SingleMessageLogger;

@Incubating
public class HttpBuildCache
extends AbstractBuildCache {
    private static final String HTTP_URI_PROPERTY = "org.gradle.cache.tasks.http.uri";
    private final HttpBuildCacheCredentials credentials;
    private URI url;

    public HttpBuildCache() {
        String defaultUrl = System.getProperty(HTTP_URI_PROPERTY);
        if (defaultUrl != null) {
            SingleMessageLogger.nagUserOfDiscontinuedProperty((String)HTTP_URI_PROPERTY, (String)"Use the build cache DSL instead.");
        }
        this.credentials = new HttpBuildCacheCredentials();
        this.url = Strings.isNullOrEmpty((String)defaultUrl) ? null : URI.create(defaultUrl);
    }

    @Nullable
    public URI getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.setUrl(URI.create(url));
    }

    public void setUrl(URL url) throws URISyntaxException {
        this.setUrl(url.toURI());
    }

    public void setUrl(URI url) {
        this.url = url;
    }

    public HttpBuildCacheCredentials getCredentials() {
        return this.credentials;
    }

    public void credentials(Action<? super HttpBuildCacheCredentials> configuration) {
        configuration.execute((Object)this.credentials);
    }
}

