/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.dsl.dependencies;

import groovy.lang.Closure;
import groovy.lang.GroovyObjectSupport;
import java.util.List;
import java.util.Map;
import org.gradle.api.Action;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.ConfigurationContainer;
import org.gradle.api.artifacts.Dependency;
import org.gradle.api.artifacts.dsl.ComponentMetadataHandler;
import org.gradle.api.artifacts.dsl.ComponentModuleMetadataHandler;
import org.gradle.api.artifacts.dsl.DependencyHandler;
import org.gradle.api.artifacts.query.ArtifactResolutionQuery;
import org.gradle.api.artifacts.transform.VariantTransform;
import org.gradle.api.attributes.AttributeMatchingStrategy;
import org.gradle.api.attributes.AttributesSchema;
import org.gradle.api.attributes.CompatibilityRuleChain;
import org.gradle.api.internal.artifacts.ArtifactAttributes;
import org.gradle.api.internal.artifacts.VariantTransformRegistry;
import org.gradle.api.internal.artifacts.dsl.dependencies.DependencyFactory;
import org.gradle.api.internal.artifacts.dsl.dependencies.ProjectFinder;
import org.gradle.api.internal.artifacts.query.ArtifactResolutionQueryFactory;
import org.gradle.internal.metaobject.InvokeMethodResult;
import org.gradle.internal.metaobject.MethodAccess;
import org.gradle.internal.metaobject.MethodMixIn;
import org.gradle.util.CollectionUtils;
import org.gradle.util.ConfigureUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultDependencyHandler
extends GroovyObjectSupport
implements DependencyHandler,
MethodMixIn {
    private static final Action<AttributeMatchingStrategy<String>> ARTIFACT_ATTRIBUTE_CONFIG = new Action<AttributeMatchingStrategy<String>>(){

        public void execute(AttributeMatchingStrategy<String> stringAttributeMatchingStrategy) {
            CompatibilityRuleChain<String> compatibilityRules = stringAttributeMatchingStrategy.getCompatibilityRules();
            compatibilityRules.assumeCompatibleWhenMissing();
        }
    };
    private static final Action<AttributesSchema> CONFIGURE_DEFAULT_SCHEMA_ACTION = new Action<AttributesSchema>(){

        public void execute(AttributesSchema attributesSchema) {
            attributesSchema.attribute(ArtifactAttributes.ARTIFACT_FORMAT, ARTIFACT_ATTRIBUTE_CONFIG);
        }
    };
    private final ConfigurationContainer configurationContainer;
    private final DependencyFactory dependencyFactory;
    private final ProjectFinder projectFinder;
    private final ComponentMetadataHandler componentMetadataHandler;
    private final ComponentModuleMetadataHandler componentModuleMetadataHandler;
    private final ArtifactResolutionQueryFactory resolutionQueryFactory;
    private final AttributesSchema attributesSchema;
    private final VariantTransformRegistry transforms;
    private final DynamicMethods dynamicMethods;

    public DefaultDependencyHandler(ConfigurationContainer configurationContainer, DependencyFactory dependencyFactory, ProjectFinder projectFinder, ComponentMetadataHandler componentMetadataHandler, ComponentModuleMetadataHandler componentModuleMetadataHandler, ArtifactResolutionQueryFactory resolutionQueryFactory, AttributesSchema attributesSchema, VariantTransformRegistry transforms) {
        this.configurationContainer = configurationContainer;
        this.dependencyFactory = dependencyFactory;
        this.projectFinder = projectFinder;
        this.componentMetadataHandler = componentMetadataHandler;
        this.componentModuleMetadataHandler = componentModuleMetadataHandler;
        this.resolutionQueryFactory = resolutionQueryFactory;
        this.attributesSchema = attributesSchema;
        this.transforms = transforms;
        this.configureSchema();
        this.dynamicMethods = new DynamicMethods();
    }

    @Override
    public Dependency add(String configurationName, Object dependencyNotation) {
        return this.add(configurationName, dependencyNotation, null);
    }

    @Override
    public Dependency add(String configurationName, Object dependencyNotation, Closure configureClosure) {
        return this.doAdd((Configuration)this.configurationContainer.findByName(configurationName), dependencyNotation, configureClosure);
    }

    @Override
    public Dependency create(Object dependencyNotation) {
        return this.create(dependencyNotation, null);
    }

    @Override
    public Dependency create(Object dependencyNotation, Closure configureClosure) {
        Dependency dependency = this.dependencyFactory.createDependency(dependencyNotation);
        return ConfigureUtil.configure(configureClosure, dependency);
    }

    private Dependency doAdd(Configuration configuration, Object dependencyNotation, Closure configureClosure) {
        if (dependencyNotation instanceof Configuration) {
            Configuration other = (Configuration)dependencyNotation;
            if (!this.configurationContainer.contains(other)) {
                throw new UnsupportedOperationException("Currently you can only declare dependencies on configurations from the same project.");
            }
            configuration.extendsFrom(other);
            return null;
        }
        Dependency dependency = this.create(dependencyNotation, configureClosure);
        configuration.getDependencies().add(dependency);
        return dependency;
    }

    @Override
    public Dependency module(Object notation) {
        return this.module(notation, null);
    }

    @Override
    public Dependency project(Map<String, ?> notation) {
        return this.dependencyFactory.createProjectDependencyFromMap(this.projectFinder, notation);
    }

    @Override
    public Dependency module(Object notation, Closure configureClosure) {
        return this.dependencyFactory.createModule(notation, configureClosure);
    }

    @Override
    public Dependency gradleApi() {
        return this.dependencyFactory.createDependency((Object)DependencyFactory.ClassPathNotation.GRADLE_API);
    }

    @Override
    public Dependency gradleTestKit() {
        return this.dependencyFactory.createDependency((Object)DependencyFactory.ClassPathNotation.GRADLE_TEST_KIT);
    }

    @Override
    public Dependency localGroovy() {
        return this.dependencyFactory.createDependency((Object)DependencyFactory.ClassPathNotation.LOCAL_GROOVY);
    }

    @Override
    public MethodAccess getAdditionalMethods() {
        return this.dynamicMethods;
    }

    @Override
    public void components(Action<? super ComponentMetadataHandler> configureAction) {
        configureAction.execute((Object)this.getComponents());
    }

    @Override
    public ComponentMetadataHandler getComponents() {
        return this.componentMetadataHandler;
    }

    @Override
    public void modules(Action<? super ComponentModuleMetadataHandler> configureAction) {
        configureAction.execute((Object)this.getModules());
    }

    @Override
    public ComponentModuleMetadataHandler getModules() {
        return this.componentModuleMetadataHandler;
    }

    @Override
    public ArtifactResolutionQuery createArtifactResolutionQuery() {
        return this.resolutionQueryFactory.createArtifactResolutionQuery();
    }

    @Override
    public AttributesSchema attributesSchema(Action<? super AttributesSchema> configureAction) {
        configureAction.execute((Object)this.attributesSchema);
        return this.attributesSchema;
    }

    @Override
    public AttributesSchema getAttributesSchema() {
        return this.attributesSchema;
    }

    private void configureSchema() {
        this.attributesSchema(CONFIGURE_DEFAULT_SCHEMA_ACTION);
    }

    @Override
    public void registerTransform(Action<? super VariantTransform> registrationAction) {
        this.transforms.registerTransform(registrationAction);
    }

    private class DynamicMethods
    implements MethodAccess {
        private DynamicMethods() {
        }

        public boolean hasMethod(String name, Object ... arguments) {
            return arguments.length != 0 && DefaultDependencyHandler.this.configurationContainer.findByName(name) != null;
        }

        public void invokeMethod(String name, InvokeMethodResult result, Object ... arguments) {
            if (arguments.length == 0) {
                return;
            }
            Configuration configuration = (Configuration)DefaultDependencyHandler.this.configurationContainer.findByName(name);
            if (configuration == null) {
                return;
            }
            List normalizedArgs = CollectionUtils.flattenCollections((Object[])arguments);
            if (normalizedArgs.size() == 2 && normalizedArgs.get(1) instanceof Closure) {
                result.result(DefaultDependencyHandler.this.doAdd(configuration, normalizedArgs.get(0), (Closure)normalizedArgs.get(1)));
            } else if (normalizedArgs.size() == 1) {
                result.result(DefaultDependencyHandler.this.doAdd(configuration, normalizedArgs.get(0), null));
            } else {
                for (Object arg : normalizedArgs) {
                    DefaultDependencyHandler.this.doAdd(configuration, arg, null);
                }
                result.result(null);
            }
        }
    }
}

