/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.changedetection.rules;

import com.google.common.collect.ImmutableSortedMap;
import com.google.common.collect.Maps;
import java.util.SortedMap;
import org.gradle.api.Nullable;
import org.gradle.api.internal.TaskInternal;
import org.gradle.api.internal.changedetection.rules.AbstractNamedFileSnapshotTaskStateChanges;
import org.gradle.api.internal.changedetection.state.FileCollectionSnapshot;
import org.gradle.api.internal.changedetection.state.FileCollectionSnapshotterRegistry;
import org.gradle.api.internal.changedetection.state.OutputFilesSnapshotter;
import org.gradle.api.internal.changedetection.state.TaskExecution;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OutputFilesTaskStateChanges
extends AbstractNamedFileSnapshotTaskStateChanges {
    private final OutputFilesSnapshotter outputSnapshotter;

    public OutputFilesTaskStateChanges(@Nullable TaskExecution previous, TaskExecution current, TaskInternal task, FileCollectionSnapshotterRegistry snapshotterRegistry, OutputFilesSnapshotter outputSnapshotter) {
        super(task.getName(), previous, current, snapshotterRegistry, "Output", task.getOutputs().getFileProperties());
        this.outputSnapshotter = outputSnapshotter;
    }

    @Override
    public ImmutableSortedMap<String, FileCollectionSnapshot> getPrevious() {
        return this.previous.getOutputFilesSnapshot();
    }

    @Override
    public void saveCurrent() {
        final ImmutableSortedMap<String, FileCollectionSnapshot> outputFilesAfter = OutputFilesTaskStateChanges.buildSnapshots(this.getTaskName(), this.getSnapshotterRegistry(), this.getTitle(), this.getFileProperties());
        ImmutableSortedMap results = ImmutableSortedMap.copyOfSorted((SortedMap)Maps.transformEntries(this.getCurrent(), (Maps.EntryTransformer)new Maps.EntryTransformer<String, FileCollectionSnapshot, FileCollectionSnapshot>(){

            public FileCollectionSnapshot transformEntry(String propertyName, FileCollectionSnapshot beforeExecution) {
                FileCollectionSnapshot afterExecution = (FileCollectionSnapshot)outputFilesAfter.get((Object)propertyName);
                FileCollectionSnapshot afterPreviousExecution = OutputFilesTaskStateChanges.this.getSnapshotAfterPreviousExecution(propertyName);
                return OutputFilesTaskStateChanges.this.outputSnapshotter.createOutputSnapshot(afterPreviousExecution, beforeExecution, afterExecution);
            }
        }));
        this.current.setOutputFilesSnapshot((ImmutableSortedMap<String, FileCollectionSnapshot>)results);
    }

    private FileCollectionSnapshot getSnapshotAfterPreviousExecution(String propertyName) {
        FileCollectionSnapshot afterPreviousExecution;
        ImmutableSortedMap<String, FileCollectionSnapshot> previousSnapshots;
        if (this.previous != null && (previousSnapshots = this.previous.getOutputFilesSnapshot()) != null && (afterPreviousExecution = (FileCollectionSnapshot)previousSnapshots.get(propertyName)) != null) {
            return afterPreviousExecution;
        }
        return FileCollectionSnapshot.EMPTY;
    }
}

