/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.changedetection.rules;

import com.google.common.collect.Lists;
import com.google.common.hash.HashCode;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.gradle.api.Nullable;
import org.gradle.api.internal.TaskInternal;
import org.gradle.api.internal.changedetection.rules.DescriptiveChange;
import org.gradle.api.internal.changedetection.rules.SimpleTaskStateChanges;
import org.gradle.api.internal.changedetection.rules.TaskStateChange;
import org.gradle.api.internal.changedetection.state.TaskExecution;
import org.gradle.internal.classloader.ClassLoaderHierarchyHasher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class TaskTypeTaskStateChanges
extends SimpleTaskStateChanges {
    private static final Logger LOGGER = LoggerFactory.getLogger(TaskTypeTaskStateChanges.class);
    private final String taskPath;
    private final String taskClass;
    private final HashCode taskClassLoaderHash;
    private final List<HashCode> taskActionsClassLoaderHashes;
    private final TaskExecution previousExecution;

    public TaskTypeTaskStateChanges(@Nullable TaskExecution previousExecution, TaskExecution currentExecution, String taskPath, Class<? extends TaskInternal> taskClass, Collection<ClassLoader> taskActionClassLoaders, ClassLoaderHierarchyHasher classLoaderHierarchyHasher) {
        String taskClassName = taskClass.getName();
        currentExecution.setTaskClass(taskClassName);
        HashCode taskClassLoaderHash = classLoaderHierarchyHasher.getClassLoaderHash(taskClass.getClassLoader());
        currentExecution.setTaskClassLoaderHash(taskClassLoaderHash);
        List<HashCode> taskActionsClassLoaderHashes = TaskTypeTaskStateChanges.collectActionClassLoaderHashes(taskActionClassLoaders, classLoaderHierarchyHasher);
        currentExecution.setTaskActionsClassLoaderHashes(taskActionsClassLoaderHashes);
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info("Task {} class loader hash: {}", (Object)taskPath, (Object)taskClassLoaderHash);
            LOGGER.info("Task {} actions class loader hashes: {}", (Object)taskPath, taskActionsClassLoaderHashes);
        }
        this.taskPath = taskPath;
        this.taskClass = taskClassName;
        this.taskClassLoaderHash = taskClassLoaderHash;
        this.taskActionsClassLoaderHashes = taskActionsClassLoaderHashes;
        this.previousExecution = previousExecution;
    }

    private static List<HashCode> collectActionClassLoaderHashes(Collection<ClassLoader> taskActionClassLoaders, ClassLoaderHierarchyHasher classLoaderHierarchyHasher) {
        if (taskActionClassLoaders.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList hashCodes = Lists.newArrayListWithCapacity((int)taskActionClassLoaders.size());
        for (ClassLoader taskActionClassLoader : taskActionClassLoaders) {
            HashCode actionLoaderHash = classLoaderHierarchyHasher.getClassLoaderHash(taskActionClassLoader);
            hashCodes.add(actionLoaderHash);
        }
        return Collections.unmodifiableList(hashCodes);
    }

    @Override
    protected void addAllChanges(List<TaskStateChange> changes) {
        if (!this.taskClass.equals(this.previousExecution.getTaskClass())) {
            changes.add(new DescriptiveChange("Task '%s' has changed type from '%s' to '%s'.", this.taskPath, this.previousExecution.getTaskClass(), this.taskClass));
            return;
        }
        if (this.taskClassLoaderHash == null) {
            changes.add(new DescriptiveChange("Task '%s' was loaded with an unknown classloader", this.taskPath));
            return;
        }
        if (this.previousExecution.getTaskClassLoaderHash() == null) {
            changes.add(new DescriptiveChange("Task '%s' was loaded with an unknown classloader during the previous execution", this.taskPath));
            return;
        }
        if (this.taskActionsClassLoaderHashes.contains(null)) {
            changes.add(new DescriptiveChange("Task '%s' has a custom action that was loaded with an unknown classloader", this.taskPath));
            return;
        }
        if (this.previousExecution.getTaskActionsClassLoaderHashes().contains(null)) {
            changes.add(new DescriptiveChange("Task '%s' had a custom action that was loaded with an unknown classloader during the previous execution", this.taskPath));
            return;
        }
        if (!this.taskClassLoaderHash.equals((Object)this.previousExecution.getTaskClassLoaderHash())) {
            changes.add(new DescriptiveChange("Task '%s' class path has changed from %s to %s.", this.taskPath, this.previousExecution.getTaskClassLoaderHash(), this.taskClassLoaderHash));
            return;
        }
        if (!this.taskActionsClassLoaderHashes.equals(this.previousExecution.getTaskActionsClassLoaderHashes())) {
            changes.add(new DescriptiveChange("Task '%s' additional action class paths have changed from %s to %s.", this.taskPath, this.previousExecution.getTaskActionsClassLoaderHashes(), this.taskActionsClassLoaderHashes));
        }
    }
}

