/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.changedetection.state;

import com.google.common.base.Charsets;
import com.google.common.hash.HashCode;
import com.google.common.hash.Hashing;
import org.gradle.api.internal.changedetection.state.ClasspathEntryHasher;
import org.gradle.api.internal.changedetection.state.FileDetails;
import org.gradle.cache.PersistentIndexedCache;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CachingClasspathEntryHasher
implements ClasspathEntryHasher {
    private static final HashCode NO_SIGNATURE = Hashing.md5().hashString((CharSequence)(CachingClasspathEntryHasher.class.getName() + " : no signature"), Charsets.UTF_8);
    private final ClasspathEntryHasher delegate;
    private final PersistentIndexedCache<HashCode, HashCode> persistentCache;

    public CachingClasspathEntryHasher(ClasspathEntryHasher delegate, PersistentIndexedCache<HashCode, HashCode> persistentCache) {
        this.delegate = delegate;
        this.persistentCache = persistentCache;
    }

    @Override
    public HashCode hash(FileDetails fileDetails) {
        HashCode contentMd5 = fileDetails.getContent().getContentMd5();
        HashCode signature = this.persistentCache.get(contentMd5);
        if (signature != null) {
            if (signature.equals((Object)NO_SIGNATURE)) {
                return null;
            }
            return signature;
        }
        signature = this.delegate.hash(fileDetails);
        if (signature != null) {
            this.persistentCache.put(contentMd5, signature);
        } else {
            this.persistentCache.put(contentMd5, NO_SIGNATURE);
        }
        return signature;
    }
}

