/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.changedetection.state;

import org.gradle.api.internal.cache.StringInterner;
import org.gradle.api.internal.changedetection.state.FileDetails;
import org.gradle.api.internal.changedetection.state.IgnoredPathFileSnapshot;
import org.gradle.api.internal.changedetection.state.NormalizedFileSnapshot;
import org.gradle.api.internal.changedetection.state.SnapshotNormalizationStrategy;
import org.gradle.api.internal.changedetection.state.TaskFilePropertySnapshotNormalizationStrategy;

public class ClasspathSnapshotNormalizationStrategy
implements SnapshotNormalizationStrategy {
    public static final SnapshotNormalizationStrategy INSTANCE = new ClasspathSnapshotNormalizationStrategy();

    private ClasspathSnapshotNormalizationStrategy() {
    }

    public boolean isPathAbsolute() {
        return false;
    }

    public NormalizedFileSnapshot getNormalizedSnapshot(FileDetails fileDetails, StringInterner stringInterner) {
        if (fileDetails.isRoot()) {
            return new IgnoredPathFileSnapshot(fileDetails.getContent());
        }
        return TaskFilePropertySnapshotNormalizationStrategy.getRelativeSnapshot(fileDetails, fileDetails.getContent(), stringInterner);
    }

    public String toString() {
        return "CLASSPATH";
    }
}

