/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.changedetection.state;

import com.google.common.hash.HashCode;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.gradle.api.internal.cache.StringInterner;
import org.gradle.api.internal.changedetection.state.AbstractFileCollectionSnapshotter;
import org.gradle.api.internal.changedetection.state.ClasspathEntryHasher;
import org.gradle.api.internal.changedetection.state.CompileClasspathSnapshotter;
import org.gradle.api.internal.changedetection.state.FileCollectionSnapshotter;
import org.gradle.api.internal.changedetection.state.FileDetails;
import org.gradle.api.internal.changedetection.state.FileSystemMirror;
import org.gradle.api.internal.file.collections.DirectoryFileTreeFactory;
import org.gradle.api.internal.hash.FileHasher;
import org.gradle.internal.FileUtils;
import org.gradle.internal.nativeintegration.filesystem.FileSystem;
import org.gradle.internal.nativeintegration.filesystem.FileType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultCompileClasspathSnapshotter
extends AbstractFileCollectionSnapshotter
implements CompileClasspathSnapshotter {
    private static final Comparator<FileDetails> FILE_DETAILS_COMPARATOR = new Comparator<FileDetails>(){

        @Override
        public int compare(FileDetails o1, FileDetails o2) {
            return o1.getPath().compareTo(o2.getPath());
        }
    };
    private static final HashCode IGNORED = HashCode.fromInt((int)(DefaultCompileClasspathSnapshotter.class.getName() + " : ignored").hashCode());
    private final ClasspathEntryHasher classpathEntryHasher;

    public DefaultCompileClasspathSnapshotter(FileHasher hasher, StringInterner stringInterner, FileSystem fileSystem, DirectoryFileTreeFactory directoryFileTreeFactory, FileSystemMirror fileSystemMirror, ClasspathEntryHasher classpathEntryHasher) {
        super(hasher, stringInterner, fileSystem, directoryFileTreeFactory, fileSystemMirror);
        this.classpathEntryHasher = classpathEntryHasher;
    }

    @Override
    public Class<? extends FileCollectionSnapshotter> getRegisteredType() {
        return CompileClasspathSnapshotter.class;
    }

    @Override
    protected List<FileDetails> normaliseTreeElements(List<FileDetails> fileDetails) {
        ArrayList<FileDetails> sorted = new ArrayList<FileDetails>(fileDetails.size());
        for (FileDetails details : fileDetails) {
            HashCode signatureForClass;
            if (details.getType() != FileType.RegularFile || (signatureForClass = this.classpathEntryHasher.hash(details)) == null) continue;
            sorted.add(details.withContentHash(signatureForClass));
        }
        Collections.sort(sorted, FILE_DETAILS_COMPARATOR);
        return sorted;
    }

    @Override
    protected FileDetails normaliseFileElement(FileDetails details) {
        HashCode signature;
        if (FileUtils.isJar((String)details.getName()) && (signature = this.classpathEntryHasher.hash(details)) != null) {
            return details.withContentHash(signature);
        }
        return details.withContentHash(IGNORED);
    }
}

