/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.tasks.execution;

import org.gradle.api.GradleException;
import org.gradle.api.internal.TaskInternal;
import org.gradle.api.internal.TaskOutputCachingState;
import org.gradle.api.internal.tasks.TaskExecuter;
import org.gradle.api.internal.tasks.TaskExecutionContext;
import org.gradle.api.internal.tasks.TaskStateInternal;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ResolveTaskOutputCachingStateExecuter
implements TaskExecuter {
    private static final Logger LOGGER = LoggerFactory.getLogger(ResolveTaskOutputCachingStateExecuter.class);
    private final TaskExecuter delegate;

    public ResolveTaskOutputCachingStateExecuter(TaskExecuter delegate) {
        this.delegate = delegate;
    }

    public void execute(TaskInternal task, TaskStateInternal state, TaskExecutionContext context) {
        try {
            TaskOutputCachingState taskOutputCachingState = task.getOutputs().getCachingState();
            state.setTaskOutputCaching(taskOutputCachingState);
            if (!taskOutputCachingState.isEnabled()) {
                LOGGER.info("Caching disabled for {}: {}", (Object)task, (Object)taskOutputCachingState.getDisabledReason());
            }
        }
        catch (Exception t) {
            throw new GradleException(String.format("Could not evaluate TaskOutputs.getCachingState().isEnabled() for %s.", task), (Throwable)t);
        }
        this.delegate.execute(task, state, context);
    }
}

