/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.caching.internal;

import com.google.common.base.Charsets;
import com.google.common.hash.HashCode;
import com.google.common.hash.Hasher;
import com.google.common.hash.Hashing;
import org.gradle.caching.internal.BuildCacheHasher;

public class DefaultBuildCacheHasher
implements BuildCacheHasher {
    private final Hasher hasher = Hashing.md5().newHasher();

    public DefaultBuildCacheHasher putByte(byte b) {
        this.hasher.putInt(1);
        this.hasher.putByte(b);
        return this;
    }

    public DefaultBuildCacheHasher putBytes(byte[] bytes) {
        this.hasher.putInt(bytes.length);
        this.hasher.putBytes(bytes);
        return this;
    }

    public DefaultBuildCacheHasher putBytes(byte[] bytes, int off, int len) {
        this.hasher.putInt(len);
        this.hasher.putBytes(bytes, off, len);
        return this;
    }

    public DefaultBuildCacheHasher putInt(int i) {
        this.hasher.putInt(4);
        this.hasher.putInt(i);
        return this;
    }

    public DefaultBuildCacheHasher putLong(long l) {
        this.hasher.putInt(8);
        this.hasher.putLong(l);
        return this;
    }

    public DefaultBuildCacheHasher putDouble(double d) {
        this.hasher.putInt(8);
        this.hasher.putDouble(d);
        return this;
    }

    public DefaultBuildCacheHasher putBoolean(boolean b) {
        this.hasher.putInt(1);
        this.hasher.putBoolean(b);
        return this;
    }

    public DefaultBuildCacheHasher putString(CharSequence charSequence) {
        this.hasher.putInt(charSequence.length());
        this.hasher.putString(charSequence, Charsets.UTF_8);
        return this;
    }

    public DefaultBuildCacheHasher putNull() {
        this.putInt(0);
        return this;
    }

    public HashCode hash() {
        return this.hasher.hash();
    }
}

