/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.initialization;

import com.google.common.collect.ImmutableList;
import java.util.List;
import org.gradle.StartParameter;
import org.gradle.api.internal.ExceptionAnalyser;
import org.gradle.api.internal.GradleInternal;
import org.gradle.api.internal.changedetection.state.GlobalScopeFileTimeStampInspector;
import org.gradle.api.logging.Logging;
import org.gradle.api.logging.StandardOutputListener;
import org.gradle.api.logging.configuration.ShowStacktrace;
import org.gradle.caching.internal.tasks.TaskExecutionStatisticsEventAdapter;
import org.gradle.configuration.BuildConfigurer;
import org.gradle.deployment.internal.DeploymentRegistry;
import org.gradle.execution.BuildConfigurationActionExecuter;
import org.gradle.execution.BuildExecuter;
import org.gradle.initialization.BuildCancellationToken;
import org.gradle.initialization.BuildClientMetaData;
import org.gradle.initialization.BuildCompletionListener;
import org.gradle.initialization.BuildEventConsumer;
import org.gradle.initialization.BuildRequestContext;
import org.gradle.initialization.BuildRequestMetaData;
import org.gradle.initialization.DefaultBuildRequestMetaData;
import org.gradle.initialization.DefaultGradleLauncher;
import org.gradle.initialization.DependencyResolutionLogger;
import org.gradle.initialization.GradleLauncher;
import org.gradle.initialization.GradleLauncherFactory;
import org.gradle.initialization.InitScriptHandler;
import org.gradle.initialization.ModelConfigurationListener;
import org.gradle.initialization.NestedBuildFactory;
import org.gradle.initialization.SettingsLoader;
import org.gradle.initialization.SettingsLoaderFactory;
import org.gradle.internal.buildevents.BuildLogger;
import org.gradle.internal.buildevents.CacheStatisticsReporter;
import org.gradle.internal.buildevents.ProjectEvaluationLogger;
import org.gradle.internal.buildevents.TaskExecutionLogger;
import org.gradle.internal.classpath.ClassPath;
import org.gradle.internal.cleanup.BuildOutputCleanupListener;
import org.gradle.internal.concurrent.Stoppable;
import org.gradle.internal.event.ListenerManager;
import org.gradle.internal.featurelifecycle.LoggingDeprecatedFeatureHandler;
import org.gradle.internal.featurelifecycle.ScriptUsageLocationReporter;
import org.gradle.internal.featurelifecycle.UsageLocationReporter;
import org.gradle.internal.logging.LoggingManagerInternal;
import org.gradle.internal.logging.progress.ProgressLoggerFactory;
import org.gradle.internal.logging.text.StyledTextOutputFactory;
import org.gradle.internal.progress.BuildOperationExecutor;
import org.gradle.internal.progress.BuildProgressFilter;
import org.gradle.internal.progress.BuildProgressLogger;
import org.gradle.internal.progress.LoggerProvider;
import org.gradle.internal.reflect.Instantiator;
import org.gradle.internal.scan.BuildScanRequest;
import org.gradle.internal.scan.BuildScanRequestListener;
import org.gradle.internal.service.ServiceRegistry;
import org.gradle.internal.service.scopes.BuildScopeServices;
import org.gradle.internal.service.scopes.BuildSessionScopeServices;
import org.gradle.internal.service.scopes.GradleUserHomeScopeServiceRegistry;
import org.gradle.internal.service.scopes.ServiceRegistryFactory;
import org.gradle.invocation.DefaultGradle;
import org.gradle.profile.ProfileEventAdapter;
import org.gradle.profile.ReportGeneratingProfileListener;
import org.gradle.util.DeprecationLogger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultGradleLauncherFactory
implements GradleLauncherFactory {
    private final GradleUserHomeScopeServiceRegistry userHomeDirServiceRegistry;
    private final BuildProgressLogger buildProgressLogger;
    private DefaultGradleLauncher rootBuild;

    public DefaultGradleLauncherFactory(ListenerManager listenerManager, ProgressLoggerFactory progressLoggerFactory, GradleUserHomeScopeServiceRegistry userHomeDirServiceRegistry) {
        this.userHomeDirServiceRegistry = userHomeDirServiceRegistry;
        this.buildProgressLogger = new BuildProgressLogger(progressLoggerFactory);
        listenerManager.addListener((Object)new BuildProgressFilter(this.buildProgressLogger));
        listenerManager.useLogger((Object)new ProjectEvaluationLogger(progressLoggerFactory));
        listenerManager.useLogger((Object)new DependencyResolutionLogger(progressLoggerFactory));
    }

    private GradleLauncher createChildInstance(StartParameter startParameter, GradleLauncher parent, BuildSessionScopeServices buildSessionScopeServices, List<?> servicesToStop) {
        ServiceRegistry services = parent.getGradle().getServices();
        DefaultBuildRequestMetaData requestMetaData = new DefaultBuildRequestMetaData((BuildClientMetaData)services.get(BuildClientMetaData.class));
        BuildCancellationToken cancellationToken = (BuildCancellationToken)services.get(BuildCancellationToken.class);
        BuildEventConsumer buildEventConsumer = (BuildEventConsumer)services.get(BuildEventConsumer.class);
        return this.doNewInstance(startParameter, parent, cancellationToken, requestMetaData, buildEventConsumer, buildSessionScopeServices, servicesToStop);
    }

    @Override
    public GradleLauncher newInstance(StartParameter startParameter, BuildRequestContext requestContext, ServiceRegistry parentRegistry) {
        DefaultGradleLauncher launcher;
        if (this.rootBuild != null) {
            throw new IllegalStateException("Cannot have a current build");
        }
        if (!(parentRegistry instanceof BuildSessionScopeServices)) {
            throw new IllegalArgumentException("Service registry must be of build session scope");
        }
        BuildSessionScopeServices sessionScopeServices = (BuildSessionScopeServices)parentRegistry;
        this.rootBuild = launcher = this.doNewInstance(startParameter, null, requestContext.getCancellationToken(), requestContext, requestContext.getEventConsumer(), sessionScopeServices, (List<?>)ImmutableList.of((Object)new Stoppable(){

            public void stop() {
                DefaultGradleLauncherFactory.this.rootBuild = null;
            }
        }));
        DeploymentRegistry deploymentRegistry = (DeploymentRegistry)parentRegistry.get(DeploymentRegistry.class);
        deploymentRegistry.onNewBuild(launcher.getGradle());
        GlobalScopeFileTimeStampInspector timeStampInspector = (GlobalScopeFileTimeStampInspector)sessionScopeServices.get(GlobalScopeFileTimeStampInspector.class);
        launcher.addListener(timeStampInspector);
        return launcher;
    }

    private DefaultGradleLauncher doNewInstance(StartParameter startParameter, GradleLauncher parent, BuildCancellationToken cancellationToken, BuildRequestMetaData requestMetaData, BuildEventConsumer buildEventConsumer, BuildSessionScopeServices sessionScopeServices, List<?> servicesToStop) {
        BuildScopeServices serviceRegistry = BuildScopeServices.forSession(sessionScopeServices);
        serviceRegistry.add(BuildRequestMetaData.class, requestMetaData);
        serviceRegistry.add(BuildClientMetaData.class, requestMetaData.getClient());
        serviceRegistry.add(BuildEventConsumer.class, buildEventConsumer);
        serviceRegistry.add(BuildCancellationToken.class, cancellationToken);
        NestedBuildFactoryImpl nestedBuildFactory = new NestedBuildFactoryImpl(sessionScopeServices);
        serviceRegistry.add(NestedBuildFactory.class, nestedBuildFactory);
        ListenerManager listenerManager = (ListenerManager)serviceRegistry.get(ListenerManager.class);
        LoggingManagerInternal loggingManager = (LoggingManagerInternal)serviceRegistry.newInstance(LoggingManagerInternal.class);
        loggingManager.setLevelInternal(startParameter.getLogLevel());
        if (startParameter.isParallelProjectExecutionEnabled()) {
            loggingManager.setMaxWorkerCount(startParameter.getMaxWorkerCount());
        } else {
            loggingManager.setMaxWorkerCount(1);
        }
        loggingManager.addStandardOutputListener((StandardOutputListener)listenerManager.getBroadcaster(StandardOutputListener.class));
        loggingManager.addStandardErrorListener((StandardOutputListener)listenerManager.getBroadcaster(StandardOutputListener.class));
        LoggerProvider loggerProvider = parent == null ? this.buildProgressLogger : LoggerProvider.NO_OP;
        listenerManager.useLogger((Object)new TaskExecutionLogger((ProgressLoggerFactory)serviceRegistry.get(ProgressLoggerFactory.class), loggerProvider));
        if (parent == null) {
            listenerManager.useLogger((Object)new BuildLogger(Logging.getLogger(BuildLogger.class), (StyledTextOutputFactory)serviceRegistry.get(StyledTextOutputFactory.class), startParameter, requestMetaData));
        }
        if (startParameter.isBuildCacheEnabled()) {
            listenerManager.addListener(serviceRegistry.get(TaskExecutionStatisticsEventAdapter.class));
            listenerManager.addListener((Object)new CacheStatisticsReporter((StyledTextOutputFactory)serviceRegistry.get(StyledTextOutputFactory.class)));
        }
        listenerManager.addListener(serviceRegistry.get(ProfileEventAdapter.class));
        if (startParameter.isProfile()) {
            listenerManager.addListener((Object)new ReportGeneratingProfileListener((StyledTextOutputFactory)serviceRegistry.get(StyledTextOutputFactory.class)));
        }
        BuildScanRequest buildScanRequest = (BuildScanRequest)serviceRegistry.get(BuildScanRequest.class);
        if (startParameter.isBuildScan()) {
            if (!startParameter.getSystemPropertiesArgs().containsKey("scan")) {
                startParameter.getSystemPropertiesArgs().put("scan", "true");
            }
            buildScanRequest.markRequested();
            listenerManager.addListener((Object)new BuildScanRequestListener());
        }
        if (startParameter.isNoBuildScan()) {
            if (!startParameter.getSystemPropertiesArgs().containsKey("scan")) {
                startParameter.getSystemPropertiesArgs().put("scan", "false");
            }
            buildScanRequest.markDisabled();
        }
        ScriptUsageLocationReporter usageLocationReporter = new ScriptUsageLocationReporter();
        listenerManager.addListener((Object)usageLocationReporter);
        BuildOutputCleanupListener buildOutputCleanupListener = (BuildOutputCleanupListener)serviceRegistry.get(BuildOutputCleanupListener.class);
        listenerManager.addListener((Object)buildOutputCleanupListener);
        ShowStacktrace showStacktrace = startParameter.getShowStacktrace();
        switch (showStacktrace) {
            case ALWAYS: 
            case ALWAYS_FULL: {
                LoggingDeprecatedFeatureHandler.setTraceLoggingEnabled((boolean)true);
                break;
            }
            default: {
                LoggingDeprecatedFeatureHandler.setTraceLoggingEnabled((boolean)false);
            }
        }
        DeprecationLogger.useLocationReporter((UsageLocationReporter)usageLocationReporter);
        SettingsLoaderFactory settingsLoaderFactory = (SettingsLoaderFactory)serviceRegistry.get(SettingsLoaderFactory.class);
        SettingsLoader settingsLoader = parent != null ? settingsLoaderFactory.forNestedBuild() : settingsLoaderFactory.forTopLevelBuild();
        GradleInternal parentBuild = parent == null ? null : parent.getGradle();
        GradleInternal gradle = (GradleInternal)((Instantiator)serviceRegistry.get(Instantiator.class)).newInstance(DefaultGradle.class, new Object[]{parentBuild, startParameter, serviceRegistry.get(ServiceRegistryFactory.class)});
        DefaultGradleLauncher gradleLauncher = new DefaultGradleLauncher(gradle, (InitScriptHandler)serviceRegistry.get(InitScriptHandler.class), settingsLoader, (BuildConfigurer)serviceRegistry.get(BuildConfigurer.class), (ExceptionAnalyser)serviceRegistry.get(ExceptionAnalyser.class), loggingManager, gradle.getBuildListenerBroadcaster(), (ModelConfigurationListener)listenerManager.getBroadcaster(ModelConfigurationListener.class), (BuildCompletionListener)listenerManager.getBroadcaster(BuildCompletionListener.class), (BuildOperationExecutor)serviceRegistry.get(BuildOperationExecutor.class), (BuildConfigurationActionExecuter)gradle.getServices().get(BuildConfigurationActionExecuter.class), (BuildExecuter)gradle.getServices().get(BuildExecuter.class), serviceRegistry, servicesToStop);
        nestedBuildFactory.setParent(gradleLauncher);
        return gradleLauncher;
    }

    private class NestedBuildFactoryImpl
    implements NestedBuildFactory {
        private final BuildSessionScopeServices sessionScopeServices;
        private DefaultGradleLauncher parent;

        public NestedBuildFactoryImpl(BuildSessionScopeServices sessionScopeServices) {
            this.sessionScopeServices = sessionScopeServices;
        }

        public GradleLauncher nestedInstance(StartParameter startParameter) {
            return DefaultGradleLauncherFactory.this.createChildInstance(startParameter, this.parent, this.sessionScopeServices, (List)ImmutableList.of());
        }

        public GradleLauncher nestedInstanceWithNewSession(StartParameter startParameter) {
            final ServiceRegistry userHomeServices = DefaultGradleLauncherFactory.this.userHomeDirServiceRegistry.getServicesFor(startParameter.getGradleUserHomeDir());
            BuildSessionScopeServices sessionScopeServices = new BuildSessionScopeServices(userHomeServices, startParameter, ClassPath.EMPTY);
            return DefaultGradleLauncherFactory.this.createChildInstance(startParameter, this.parent, sessionScopeServices, (List)ImmutableList.of((Object)((Object)sessionScopeServices), (Object)new Stoppable(){

                public void stop() {
                    DefaultGradleLauncherFactory.this.userHomeDirServiceRegistry.release(userHomeServices);
                }
            }));
        }

        public void setParent(DefaultGradleLauncher parent) {
            this.parent = parent;
        }
    }
}

