/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.configurations;

import java.util.LinkedHashSet;
import java.util.Set;
import org.gradle.api.Action;
import org.gradle.api.NamedDomainObjectContainer;
import org.gradle.api.NamedDomainObjectFactory;
import org.gradle.api.artifacts.ConfigurablePublishArtifact;
import org.gradle.api.artifacts.ConfigurationPublications;
import org.gradle.api.artifacts.ConfigurationVariant;
import org.gradle.api.artifacts.PublishArtifact;
import org.gradle.api.artifacts.PublishArtifactSet;
import org.gradle.api.attributes.AttributeContainer;
import org.gradle.api.internal.FactoryNamedDomainObjectContainer;
import org.gradle.api.internal.artifacts.configurations.DefaultVariant;
import org.gradle.api.internal.artifacts.configurations.LeafOutgoingVariant;
import org.gradle.api.internal.artifacts.configurations.OutgoingVariant;
import org.gradle.api.internal.attributes.AttributeContainerInternal;
import org.gradle.api.internal.attributes.DefaultMutableAttributeContainer;
import org.gradle.api.internal.attributes.ImmutableAttributesFactory;
import org.gradle.api.internal.file.FileCollectionFactory;
import org.gradle.internal.reflect.Instantiator;
import org.gradle.internal.typeconversion.NotationParser;

public class DefaultConfigurationPublications
implements ConfigurationPublications {
    private final PublishArtifactSet artifacts;
    private final PublishArtifactSet allArtifacts;
    private final AttributeContainerInternal parentAttributes;
    private final AttributeContainerInternal attributes;
    private final Instantiator instantiator;
    private final NotationParser<Object, ConfigurablePublishArtifact> artifactNotationParser;
    private final FileCollectionFactory fileCollectionFactory;
    private final ImmutableAttributesFactory attributesFactory;
    private FactoryNamedDomainObjectContainer<ConfigurationVariant> variants;

    public DefaultConfigurationPublications(PublishArtifactSet artifacts, PublishArtifactSet allArtifacts, AttributeContainerInternal parentAttributes, Instantiator instantiator, NotationParser<Object, ConfigurablePublishArtifact> artifactNotationParser, FileCollectionFactory fileCollectionFactory, ImmutableAttributesFactory attributesFactory) {
        this.artifacts = artifacts;
        this.allArtifacts = allArtifacts;
        this.parentAttributes = parentAttributes;
        this.instantiator = instantiator;
        this.artifactNotationParser = artifactNotationParser;
        this.fileCollectionFactory = fileCollectionFactory;
        this.attributesFactory = attributesFactory;
        this.attributes = new DefaultMutableAttributeContainer(attributesFactory, parentAttributes);
    }

    public OutgoingVariant convertToOutgoingVariant() {
        return new OutgoingVariant(){

            @Override
            public AttributeContainerInternal getAttributes() {
                return DefaultConfigurationPublications.this.attributes;
            }

            @Override
            public Set<? extends PublishArtifact> getArtifacts() {
                return DefaultConfigurationPublications.this.artifacts;
            }

            @Override
            public Set<? extends OutgoingVariant> getChildren() {
                LinkedHashSet<OutgoingVariant> result = new LinkedHashSet<OutgoingVariant>();
                if (DefaultConfigurationPublications.this.allArtifacts.size() > 0 || DefaultConfigurationPublications.this.variants == null) {
                    result.add(new LeafOutgoingVariant(DefaultConfigurationPublications.this.attributes, (Set<? extends PublishArtifact>)DefaultConfigurationPublications.this.allArtifacts));
                }
                if (DefaultConfigurationPublications.this.variants != null) {
                    for (DefaultVariant variant : DefaultConfigurationPublications.this.variants.withType(DefaultVariant.class)) {
                        result.add(variant.convertToOutgoingVariant());
                    }
                }
                return result;
            }
        };
    }

    public AttributeContainer getAttributes() {
        return this.attributes;
    }

    public ConfigurationPublications attributes(Action<? super AttributeContainer> action) {
        action.execute((Object)this.attributes);
        return this;
    }

    public PublishArtifactSet getArtifacts() {
        return this.artifacts;
    }

    public void artifact(Object notation) {
        this.artifacts.add(this.artifactNotationParser.parseNotation(notation));
    }

    public void artifact(Object notation, Action<? super ConfigurablePublishArtifact> configureAction) {
        ConfigurablePublishArtifact publishArtifact = (ConfigurablePublishArtifact)this.artifactNotationParser.parseNotation(notation);
        this.artifacts.add((Object)publishArtifact);
        configureAction.execute((Object)publishArtifact);
    }

    public NamedDomainObjectContainer<ConfigurationVariant> getVariants() {
        if (this.variants == null) {
            this.variants = new FactoryNamedDomainObjectContainer(ConfigurationVariant.class, this.instantiator, (NamedDomainObjectFactory)new NamedDomainObjectFactory<ConfigurationVariant>(){

                public ConfigurationVariant create(String name) {
                    return (ConfigurationVariant)DefaultConfigurationPublications.this.instantiator.newInstance(DefaultVariant.class, new Object[]{name, DefaultConfigurationPublications.this.parentAttributes, DefaultConfigurationPublications.this.artifactNotationParser, DefaultConfigurationPublications.this.fileCollectionFactory, DefaultConfigurationPublications.this.attributesFactory});
                }
            });
        }
        return this.variants;
    }

    public void variants(Action<? super NamedDomainObjectContainer<ConfigurationVariant>> configureAction) {
        configureAction.execute(this.getVariants());
    }
}

