/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.ivyservice.ivyresolve.strategy;

import com.google.common.collect.ImmutableMap;
import java.util.Comparator;
import java.util.Locale;
import java.util.Map;
import org.gradle.api.internal.artifacts.ivyservice.ivyresolve.strategy.Version;

class StaticVersionComparator
implements Comparator<Version> {
    private static final Map<String, Integer> SPECIAL_MEANINGS = ImmutableMap.of((Object)"dev", (Object)-1, (Object)"rc", (Object)1, (Object)"release", (Object)2, (Object)"final", (Object)3);

    StaticVersionComparator() {
    }

    @Override
    public int compare(Version version1, Version version2) {
        int i;
        if (version1.equals(version2)) {
            return 0;
        }
        String[] parts1 = version1.getParts();
        String[] parts2 = version2.getParts();
        for (i = 0; i < parts1.length && i < parts2.length; ++i) {
            if (parts1[i].equals(parts2[i])) continue;
            boolean is1Number = this.isNumber(parts1[i]);
            boolean is2Number = this.isNumber(parts2[i]);
            if (is1Number && !is2Number) {
                return 1;
            }
            if (is2Number && !is1Number) {
                return -1;
            }
            if (is1Number && is2Number) {
                return Long.valueOf(parts1[i]).compareTo(Long.valueOf(parts2[i]));
            }
            Integer sm1 = SPECIAL_MEANINGS.get(parts1[i].toLowerCase(Locale.US));
            Integer sm2 = SPECIAL_MEANINGS.get(parts2[i].toLowerCase(Locale.US));
            if (sm1 != null) {
                sm2 = sm2 == null ? 0 : sm2;
                return sm1 - sm2;
            }
            if (sm2 != null) {
                return -sm2.intValue();
            }
            return parts1[i].compareTo(parts2[i]);
        }
        if (i < parts1.length) {
            return this.isNumber(parts1[i]) ? 1 : -1;
        }
        if (i < parts2.length) {
            return this.isNumber(parts2[i]) ? -1 : 1;
        }
        return 0;
    }

    private boolean isNumber(String str) {
        return str.matches("\\d+");
    }
}

