/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.ivyservice.resolveengine.result;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.gradle.api.artifacts.component.ComponentSelector;
import org.gradle.api.artifacts.result.ResolutionResult;
import org.gradle.api.artifacts.result.ResolvedComponentResult;
import org.gradle.api.internal.artifacts.ImmutableModuleIdentifierFactory;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.graph.ComponentResult;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.graph.DependencyGraphComponent;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.graph.DependencyGraphEdge;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.graph.DependencyGraphNode;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.graph.DependencyGraphSelector;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.graph.DependencyGraphVisitor;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.graph.DependencyResult;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.result.ComponentResultSerializer;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.result.ComponentSelectorSerializer;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.result.DefaultResolutionResultBuilder;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.result.DependencyResultSerializer;
import org.gradle.api.internal.artifacts.result.DefaultResolutionResult;
import org.gradle.api.internal.cache.BinaryStore;
import org.gradle.api.internal.cache.Store;
import org.gradle.api.logging.Logger;
import org.gradle.api.logging.Logging;
import org.gradle.internal.Factory;
import org.gradle.internal.UncheckedException;
import org.gradle.internal.resolve.ModuleVersionResolveException;
import org.gradle.internal.serialize.Decoder;
import org.gradle.internal.serialize.Encoder;
import org.gradle.internal.time.Timer;
import org.gradle.internal.time.Timers;

public class StreamingResolutionResultBuilder
implements DependencyGraphVisitor {
    private static final byte ROOT = 1;
    private static final byte COMPONENT = 2;
    private static final byte SELECTOR = 4;
    private static final byte DEPENDENCY = 5;
    private final Map<ComponentSelector, ModuleVersionResolveException> failures = new HashMap<ComponentSelector, ModuleVersionResolveException>();
    private final BinaryStore store;
    private final ComponentResultSerializer componentResultSerializer;
    private final Store<ResolvedComponentResult> cache;
    private final ComponentSelectorSerializer componentSelectorSerializer = new ComponentSelectorSerializer();
    private final DependencyResultSerializer dependencyResultSerializer = new DependencyResultSerializer();
    private final Set<Long> visitedComponents = new HashSet<Long>();

    public StreamingResolutionResultBuilder(BinaryStore store, Store<ResolvedComponentResult> cache, ImmutableModuleIdentifierFactory moduleIdentifierFactory) {
        this.componentResultSerializer = new ComponentResultSerializer(moduleIdentifierFactory);
        this.store = store;
        this.cache = cache;
    }

    public ResolutionResult complete() {
        BinaryStore.BinaryData data = this.store.done();
        RootFactory rootSource = new RootFactory(data, this.failures, this.cache, this.componentSelectorSerializer, this.dependencyResultSerializer, this.componentResultSerializer);
        return new DefaultResolutionResult(rootSource);
    }

    @Override
    public void start(DependencyGraphNode root) {
    }

    @Override
    public void finish(final DependencyGraphNode root) {
        this.store.write(new BinaryStore.WriteAction(){

            public void write(Encoder encoder) throws IOException {
                encoder.writeByte((byte)1);
                encoder.writeSmallLong(root.getOwner().getResultId().longValue());
            }
        });
    }

    @Override
    public void visitNode(DependencyGraphNode resolvedConfiguration) {
        final DependencyGraphComponent component = resolvedConfiguration.getOwner();
        if (this.visitedComponents.add(component.getResultId())) {
            this.store.write(new BinaryStore.WriteAction(){

                public void write(Encoder encoder) throws IOException {
                    encoder.writeByte((byte)2);
                    StreamingResolutionResultBuilder.this.componentResultSerializer.write(encoder, component);
                }
            });
        }
    }

    @Override
    public void visitSelector(final DependencyGraphSelector selector) {
        this.store.write(new BinaryStore.WriteAction(){

            public void write(Encoder encoder) throws IOException {
                encoder.writeByte((byte)4);
                encoder.writeSmallLong(selector.getResultId().longValue());
                StreamingResolutionResultBuilder.this.componentSelectorSerializer.write(encoder, selector.getRequested());
            }
        });
    }

    @Override
    public void visitEdges(DependencyGraphNode resolvedConfiguration) {
        final Long fromComponent = resolvedConfiguration.getOwner().getResultId();
        final Set<? extends DependencyGraphEdge> dependencies = resolvedConfiguration.getOutgoingEdges();
        if (!dependencies.isEmpty()) {
            this.store.write(new BinaryStore.WriteAction(){

                public void write(Encoder encoder) throws IOException {
                    encoder.writeByte((byte)5);
                    encoder.writeSmallLong(fromComponent.longValue());
                    encoder.writeSmallInt(dependencies.size());
                    for (DependencyGraphEdge dependency : dependencies) {
                        StreamingResolutionResultBuilder.this.dependencyResultSerializer.write(encoder, dependency);
                        if (dependency.getFailure() == null) continue;
                        StreamingResolutionResultBuilder.this.failures.put(dependency.getRequested(), dependency.getFailure());
                    }
                }
            });
        }
    }

    private static class RootFactory
    implements Factory<ResolvedComponentResult> {
        private static final Logger LOG = Logging.getLogger(RootFactory.class);
        private final ComponentResultSerializer componentResultSerializer;
        private final BinaryStore.BinaryData data;
        private final Map<ComponentSelector, ModuleVersionResolveException> failures;
        private final Store<ResolvedComponentResult> cache;
        private final Object lock = new Object();
        private final ComponentSelectorSerializer componentSelectorSerializer;
        private final DependencyResultSerializer dependencyResultSerializer;

        RootFactory(BinaryStore.BinaryData data, Map<ComponentSelector, ModuleVersionResolveException> failures, Store<ResolvedComponentResult> cache, ComponentSelectorSerializer componentSelectorSerializer, DependencyResultSerializer dependencyResultSerializer, ComponentResultSerializer componentResultSerializer) {
            this.data = data;
            this.failures = failures;
            this.cache = cache;
            this.componentResultSerializer = componentResultSerializer;
            this.componentSelectorSerializer = componentSelectorSerializer;
            this.dependencyResultSerializer = dependencyResultSerializer;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public ResolvedComponentResult create() {
            Object object = this.lock;
            synchronized (object) {
                return (ResolvedComponentResult)this.cache.load((Factory)new Factory<ResolvedComponentResult>(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public ResolvedComponentResult create() {
                        try {
                            ResolvedComponentResult resolvedComponentResult = (ResolvedComponentResult)RootFactory.this.data.read((BinaryStore.ReadAction)new BinaryStore.ReadAction<ResolvedComponentResult>(){

                                public ResolvedComponentResult read(Decoder decoder) throws IOException {
                                    return RootFactory.this.deserialize(decoder);
                                }
                            });
                            return resolvedComponentResult;
                        }
                        finally {
                            try {
                                RootFactory.this.data.close();
                            }
                            catch (IOException e) {
                                throw UncheckedException.throwAsUncheckedException((Throwable)e);
                            }
                        }
                    }
                });
            }
        }

        private ResolvedComponentResult deserialize(Decoder decoder) {
            int valuesRead = 0;
            int type = -1;
            Timer clock = Timers.startTimer();
            try {
                DefaultResolutionResultBuilder builder = new DefaultResolutionResultBuilder();
                HashMap<Long, ComponentSelector> selectors = new HashMap<Long, ComponentSelector>();
                block8: while (true) {
                    type = decoder.readByte();
                    ++valuesRead;
                    switch (type) {
                        case 1: {
                            Long rootId = decoder.readSmallLong();
                            ResolvedComponentResult root = builder.complete(rootId).getRoot();
                            LOG.debug("Loaded resolution results ({}) from {}", (Object)clock.getElapsed(), (Object)this.data);
                            return root;
                        }
                        case 2: {
                            ComponentResult component = this.componentResultSerializer.read(decoder);
                            builder.visitComponent(component);
                            continue block8;
                        }
                        case 4: {
                            Long id = decoder.readSmallLong();
                            ComponentSelector selector = this.componentSelectorSerializer.read(decoder);
                            selectors.put(id, selector);
                            continue block8;
                        }
                        case 5: {
                            Long fromId = decoder.readSmallLong();
                            int size = decoder.readSmallInt();
                            ArrayList<DependencyResult> deps = new ArrayList<DependencyResult>(size);
                            for (int i = 0; i < size; ++i) {
                                deps.add(this.dependencyResultSerializer.read(decoder, selectors, this.failures));
                            }
                            builder.visitOutgoingEdges(fromId, deps);
                            continue block8;
                        }
                    }
                    break;
                }
                throw new IOException("Unknown value type read from stream: " + type);
            }
            catch (IOException e) {
                throw new RuntimeException("Problems loading the resolution results (" + clock.getElapsed() + "). " + "Read " + valuesRead + " values, last was: " + type, e);
            }
        }
    }
}

