/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.transform;

import com.google.common.collect.Lists;
import java.util.Collections;
import java.util.List;
import org.gradle.api.Action;
import org.gradle.api.artifacts.transform.ArtifactTransform;
import org.gradle.api.artifacts.transform.ArtifactTransformConfiguration;
import org.gradle.api.artifacts.transform.VariantTransform;
import org.gradle.api.artifacts.transform.VariantTransformConfigurationException;
import org.gradle.api.attributes.AttributeContainer;
import org.gradle.api.internal.artifacts.VariantTransformRegistry;
import org.gradle.api.internal.artifacts.transform.DefaultVariantTransformRegistration;
import org.gradle.api.internal.artifacts.transform.TransformedFileCache;
import org.gradle.api.internal.attributes.AttributeContainerInternal;
import org.gradle.api.internal.attributes.DefaultMutableAttributeContainer;
import org.gradle.api.internal.attributes.ImmutableAttributes;
import org.gradle.api.internal.attributes.ImmutableAttributesFactory;
import org.gradle.api.internal.changedetection.state.GenericFileCollectionSnapshotter;
import org.gradle.api.internal.changedetection.state.ValueSnapshotter;
import org.gradle.internal.classloader.ClassLoaderHierarchyHasher;
import org.gradle.internal.reflect.Instantiator;

public class DefaultVariantTransformRegistry
implements VariantTransformRegistry {
    private static final Object[] NO_PARAMETERS = new Object[0];
    private final List<VariantTransformRegistry.Registration> transforms = Lists.newArrayList();
    private final ImmutableAttributesFactory immutableAttributesFactory;
    private final GenericFileCollectionSnapshotter fileCollectionSnapshotter;
    private final TransformedFileCache transformedFileCache;
    private final ValueSnapshotter valueSnapshotter;
    private final ClassLoaderHierarchyHasher classLoaderHierarchyHasher;
    private final Instantiator instantiator;

    public DefaultVariantTransformRegistry(Instantiator instantiator, ImmutableAttributesFactory immutableAttributesFactory, TransformedFileCache transformedFileCache, GenericFileCollectionSnapshotter fileCollectionSnapshotter, ValueSnapshotter valueSnapshotter, ClassLoaderHierarchyHasher classLoaderHierarchyHasher) {
        this.instantiator = instantiator;
        this.immutableAttributesFactory = immutableAttributesFactory;
        this.fileCollectionSnapshotter = fileCollectionSnapshotter;
        this.transformedFileCache = transformedFileCache;
        this.valueSnapshotter = valueSnapshotter;
        this.classLoaderHierarchyHasher = classLoaderHierarchyHasher;
    }

    public void registerTransform(Action<? super VariantTransform> registrationAction) {
        RecordingRegistration reg = (RecordingRegistration)this.instantiator.newInstance(RecordingRegistration.class, new Object[]{this.immutableAttributesFactory});
        registrationAction.execute((Object)reg);
        if (reg.type == null) {
            throw new VariantTransformConfigurationException("Could not register transform: ArtifactTransform must be provided for registration.");
        }
        Object[] parameters = this.getTransformParameters((Action<ArtifactTransformConfiguration>)reg.config);
        DefaultVariantTransformRegistration registration = new DefaultVariantTransformRegistration((AttributeContainerInternal)ImmutableAttributes.of((AttributeContainer)reg.from), (AttributeContainerInternal)ImmutableAttributes.of((AttributeContainer)reg.to), reg.type, parameters, this.transformedFileCache, this.fileCollectionSnapshotter, this.valueSnapshotter, this.classLoaderHierarchyHasher);
        this.transforms.add(registration);
    }

    public Iterable<VariantTransformRegistry.Registration> getTransforms() {
        return this.transforms;
    }

    private Object[] getTransformParameters(Action<ArtifactTransformConfiguration> configAction) {
        if (configAction == null) {
            return NO_PARAMETERS;
        }
        DefaultArtifactTransformConfiguration config = new DefaultArtifactTransformConfiguration();
        configAction.execute((Object)config);
        return config.getParams();
    }

    private static class DefaultArtifactTransformConfiguration
    implements ArtifactTransformConfiguration {
        private final List<Object> params = Lists.newArrayList();

        private DefaultArtifactTransformConfiguration() {
        }

        public void params(Object ... params) {
            Collections.addAll(this.params, params);
        }

        public void setParams(Object ... params) {
            this.params.clear();
            Collections.addAll(this.params, params);
        }

        public Object[] getParams() {
            return this.params.toArray();
        }
    }

    public static class RecordingRegistration
    implements VariantTransform {
        final AttributeContainerInternal from;
        final AttributeContainerInternal to;
        private Class<? extends ArtifactTransform> type;
        private Action<ArtifactTransformConfiguration> config;

        public RecordingRegistration(ImmutableAttributesFactory immutableAttributesFactory) {
            this.from = new DefaultMutableAttributeContainer(immutableAttributesFactory);
            this.to = new DefaultMutableAttributeContainer(immutableAttributesFactory);
        }

        public AttributeContainer getFrom() {
            return this.from;
        }

        public AttributeContainer getTo() {
            return this.to;
        }

        public void artifactTransform(Class<? extends ArtifactTransform> type) {
            this.artifactTransform(type, null);
        }

        public void artifactTransform(Class<? extends ArtifactTransform> type, Action<ArtifactTransformConfiguration> config) {
            if (this.type != null) {
                throw new VariantTransformConfigurationException("Could not register transform: only one ArtifactTransform may be provided for registration.");
            }
            this.type = type;
            this.config = config;
        }
    }
}

