/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.plugins;

import org.gradle.api.Incubating;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.ConfigurationContainer;
import org.gradle.api.internal.artifacts.ArtifactAttributes;
import org.gradle.api.plugins.JavaPlugin;
import org.gradle.api.plugins.JavaPluginConvention;
import org.gradle.api.tasks.SourceSet;

@Incubating
public class JavaLibraryPlugin
implements Plugin<Project> {
    public void apply(Project project) {
        project.getPluginManager().apply(JavaPlugin.class);
        JavaPluginConvention convention = (JavaPluginConvention)project.getConvention().getPlugins().get("java");
        ConfigurationContainer configurations = project.getConfigurations();
        this.addApiToMainSourceSet(convention, configurations);
    }

    private void addApiToMainSourceSet(JavaPluginConvention convention, ConfigurationContainer configurations) {
        SourceSet sourceSet = (SourceSet)convention.getSourceSets().getByName("main");
        Configuration apiConfiguration = (Configuration)configurations.maybeCreate(sourceSet.getApiConfigurationName());
        apiConfiguration.setVisible(false);
        apiConfiguration.setDescription("API dependencies for " + sourceSet + ".");
        apiConfiguration.setCanBeResolved(false);
        apiConfiguration.setCanBeConsumed(false);
        Configuration apiElementsConfiguration = configurations.getByName(sourceSet.getApiElementsConfigurationName());
        apiElementsConfiguration.extendsFrom(new Configuration[]{apiConfiguration});
        apiElementsConfiguration.getOutgoing().getAttributes().attribute(ArtifactAttributes.ARTIFACT_FORMAT, (Object)"org.gradle.java.implicit");
        Configuration implementationConfiguration = configurations.getByName(sourceSet.getImplementationConfigurationName());
        implementationConfiguration.extendsFrom(new Configuration[]{apiConfiguration});
        Configuration compileConfiguration = configurations.getByName(sourceSet.getCompileConfigurationName());
        apiConfiguration.extendsFrom(new Configuration[]{compileConfiguration});
    }
}

