/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.tooling.internal.provider.runner;

import java.util.ArrayList;
import java.util.List;
import org.gradle.api.internal.GradleInternal;
import org.gradle.initialization.BuildEventConsumer;
import org.gradle.internal.invocation.BuildAction;
import org.gradle.internal.invocation.BuildActionRunner;
import org.gradle.internal.invocation.BuildController;
import org.gradle.internal.progress.BuildOperationInternal;
import org.gradle.internal.progress.BuildOperationListener;
import org.gradle.internal.progress.BuildOperationService;
import org.gradle.internal.progress.OperationResult;
import org.gradle.internal.progress.OperationStartEvent;
import org.gradle.tooling.internal.provider.BuildClientSubscriptions;
import org.gradle.tooling.internal.provider.SubscribableBuildAction;
import org.gradle.tooling.internal.provider.runner.ClientForwardingBuildOperationListener;
import org.gradle.tooling.internal.provider.runner.ClientForwardingTaskOperationListener;
import org.gradle.tooling.internal.provider.runner.ClientForwardingTestOperationListener;

public class SubscribableBuildActionRunner
implements BuildActionRunner {
    private static final BuildOperationListener NO_OP = new BuildOperationListener(){

        public void started(BuildOperationInternal buildOperation, OperationStartEvent startEvent) {
        }

        public void finished(BuildOperationInternal buildOperation, OperationResult finishEvent) {
        }
    };
    private final BuildActionRunner delegate;
    private final BuildOperationService buildOperationService;
    private final List<BuildOperationListener> listeners = new ArrayList<BuildOperationListener>();

    public SubscribableBuildActionRunner(BuildActionRunner delegate, BuildOperationService buildOperationService) {
        this.delegate = delegate;
        this.buildOperationService = buildOperationService;
    }

    private void registerListenersForClientSubscriptions(BuildClientSubscriptions clientSubscriptions, GradleInternal gradle) {
        BuildEventConsumer eventConsumer = (BuildEventConsumer)gradle.getServices().get(BuildEventConsumer.class);
        if (clientSubscriptions.isSendTestProgressEvents()) {
            this.registerListener(new ClientForwardingTestOperationListener(eventConsumer, clientSubscriptions));
        }
        if (!clientSubscriptions.isSendBuildProgressEvents() && !clientSubscriptions.isSendTaskProgressEvents()) {
            return;
        }
        BuildOperationListener buildListener = NO_OP;
        if (clientSubscriptions.isSendBuildProgressEvents()) {
            buildListener = new ClientForwardingBuildOperationListener(eventConsumer);
        }
        buildListener = new ClientForwardingTaskOperationListener(eventConsumer, clientSubscriptions, buildListener);
        this.registerListener(buildListener);
    }

    private void registerListener(BuildOperationListener listener) {
        this.listeners.add(listener);
        this.buildOperationService.addListener(listener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run(BuildAction action, BuildController buildController) {
        if (!(action instanceof SubscribableBuildAction)) {
            return;
        }
        GradleInternal gradle = buildController.getGradle();
        SubscribableBuildAction subscribableBuildAction = (SubscribableBuildAction)action;
        this.registerListenersForClientSubscriptions(subscribableBuildAction.getClientSubscriptions(), gradle);
        try {
            this.delegate.run(action, buildController);
        }
        finally {
            for (BuildOperationListener listener : this.listeners) {
                this.buildOperationService.removeListener(listener);
            }
        }
    }
}

