/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.tasks.compile;

import org.gradle.api.internal.tasks.compile.JavaCompileSpec;
import org.gradle.api.tasks.compile.CompileOptions;
import org.gradle.internal.Factory;
import org.gradle.util.DeprecationLogger;

public abstract class AbstractJavaCompileSpecFactory<T extends JavaCompileSpec>
implements Factory<T> {
    private final CompileOptions compileOptions;

    public AbstractJavaCompileSpecFactory(CompileOptions compileOptions) {
        this.compileOptions = compileOptions;
    }

    public T create() {
        if (this.compileOptions.isFork()) {
            if (this.getExecutable() != null || this.compileOptions.getForkOptions().getJavaHome() != null) {
                return this.getCommandLineSpec();
            }
            return this.getForkingSpec();
        }
        return this.getDefaultSpec();
    }

    private String getExecutable() {
        return (String)DeprecationLogger.whileDisabled((Factory)new Factory<String>(){

            public String create() {
                return AbstractJavaCompileSpecFactory.this.compileOptions.getForkOptions().getExecutable();
            }
        });
    }

    protected abstract T getCommandLineSpec();

    protected abstract T getForkingSpec();

    protected abstract T getDefaultSpec();
}

