/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.tasks.compile;

import org.gradle.api.AntBuilder;
import org.gradle.api.internal.TaskOutputsInternal;
import org.gradle.api.internal.tasks.compile.AntDependsStaleClassCleaner;
import org.gradle.api.internal.tasks.compile.CleaningJavaCompilerSupport;
import org.gradle.api.internal.tasks.compile.JavaCompileSpec;
import org.gradle.internal.Factory;
import org.gradle.language.base.internal.compile.Compiler;
import org.gradle.language.base.internal.tasks.SimpleStaleClassCleaner;
import org.gradle.language.base.internal.tasks.StaleClassCleaner;
import org.gradle.util.DeprecationLogger;

public class CleaningJavaCompiler
extends CleaningJavaCompilerSupport<JavaCompileSpec>
implements Compiler<JavaCompileSpec> {
    private final Compiler<JavaCompileSpec> compiler;
    private final Factory<AntBuilder> antBuilderFactory;
    private final TaskOutputsInternal taskOutputs;

    public CleaningJavaCompiler(Compiler<JavaCompileSpec> compiler, Factory<AntBuilder> antBuilderFactory, TaskOutputsInternal taskOutputs) {
        this.compiler = compiler;
        this.antBuilderFactory = antBuilderFactory;
        this.taskOutputs = taskOutputs;
    }

    @Override
    public Compiler<JavaCompileSpec> getCompiler() {
        return this.compiler;
    }

    @Override
    protected StaleClassCleaner createCleaner(final JavaCompileSpec spec) {
        boolean useDepend = (Boolean)DeprecationLogger.whileDisabled((Factory)new Factory<Boolean>(){

            public Boolean create() {
                return spec.getCompileOptions().isUseDepend();
            }
        });
        if (useDepend) {
            AntDependsStaleClassCleaner cleaner = new AntDependsStaleClassCleaner(this.antBuilderFactory, spec.getCompileOptions());
            cleaner.setDependencyCacheDir(spec.getDependencyCacheDir());
            return cleaner;
        }
        return new SimpleStaleClassCleaner(this.taskOutputs);
    }
}

