/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.language.java.plugins;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import java.io.File;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.gradle.api.DefaultTask;
import org.gradle.api.Incubating;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.Transformer;
import org.gradle.api.artifacts.dsl.RepositoryHandler;
import org.gradle.api.attributes.AttributesSchema;
import org.gradle.api.file.FileCollection;
import org.gradle.api.internal.artifacts.ArtifactDependencyResolver;
import org.gradle.api.internal.artifacts.ImmutableModuleIdentifierFactory;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.excludes.ModuleExclusions;
import org.gradle.api.internal.artifacts.repositories.ResolutionAwareRepository;
import org.gradle.internal.Transformers;
import org.gradle.internal.service.ServiceRegistry;
import org.gradle.jvm.JvmByteCode;
import org.gradle.jvm.internal.JarBinarySpecInternal;
import org.gradle.jvm.internal.JvmAssembly;
import org.gradle.jvm.internal.WithDependencies;
import org.gradle.jvm.internal.WithJvmAssembly;
import org.gradle.jvm.internal.resolve.DefaultVariantsMetaData;
import org.gradle.jvm.internal.resolve.SourceSetDependencyResolvingClasspath;
import org.gradle.jvm.internal.resolve.VariantsMetaData;
import org.gradle.jvm.platform.JavaPlatform;
import org.gradle.language.base.DependentSourceSet;
import org.gradle.language.base.LanguageSourceSet;
import org.gradle.language.base.internal.SourceTransformTaskConfig;
import org.gradle.language.base.internal.registry.LanguageTransform;
import org.gradle.language.base.internal.registry.LanguageTransformContainer;
import org.gradle.language.base.plugins.ComponentModelBasePlugin;
import org.gradle.language.java.JavaSourceSet;
import org.gradle.language.java.internal.DefaultJavaLanguageSourceSet;
import org.gradle.language.java.tasks.PlatformJavaCompile;
import org.gradle.language.jvm.plugins.JvmResourcesPlugin;
import org.gradle.model.Mutate;
import org.gradle.model.RuleSource;
import org.gradle.model.internal.manage.schema.ModelSchema;
import org.gradle.model.internal.manage.schema.ModelSchemaStore;
import org.gradle.platform.base.BinarySpec;
import org.gradle.platform.base.ComponentType;
import org.gradle.platform.base.DependencySpec;
import org.gradle.platform.base.TypeBuilder;
import org.gradle.platform.base.internal.BinarySpecInternal;
import org.gradle.util.CollectionUtils;
import org.gradle.util.DeprecationLogger;

@Incubating
public class JavaLanguagePlugin
implements Plugin<Project> {
    public void apply(Project project) {
        project.getPluginManager().apply(ComponentModelBasePlugin.class);
        project.getPluginManager().apply(JvmResourcesPlugin.class);
    }

    private static class Java
    implements LanguageTransform<JavaSourceSet, JvmByteCode> {
        private final JavaSourceTransformTaskConfig config;

        public Java(ModelSchemaStore schemaStore) {
            this.config = new JavaSourceTransformTaskConfig(schemaStore);
        }

        public String getLanguageName() {
            return "java";
        }

        public Class<JavaSourceSet> getSourceSetType() {
            return JavaSourceSet.class;
        }

        public Map<String, Class<?>> getBinaryTools() {
            return Collections.emptyMap();
        }

        public Class<JvmByteCode> getOutputType() {
            return JvmByteCode.class;
        }

        public SourceTransformTaskConfig getTransformTask() {
            return this.config;
        }

        public boolean applyToBinary(BinarySpec binary) {
            return binary instanceof WithJvmAssembly;
        }

        private static class JavaSourceTransformTaskConfig
        implements SourceTransformTaskConfig {
            private final ModelSchemaStore schemaStore;
            private static final Iterable<DependencySpec> NO_DEPENDENCIES = ImmutableSet.of();

            private JavaSourceTransformTaskConfig(ModelSchemaStore schemaStore) {
                this.schemaStore = schemaStore;
            }

            public String getTaskPrefix() {
                return "compile";
            }

            public Class<? extends DefaultTask> getTaskType() {
                return PlatformJavaCompile.class;
            }

            public void configureTask(Task task, BinarySpec binary, LanguageSourceSet sourceSet, ServiceRegistry serviceRegistry) {
                final PlatformJavaCompile compile = (PlatformJavaCompile)task;
                JavaSourceSet javaSourceSet = (JavaSourceSet)sourceSet;
                JvmAssembly assembly = ((WithJvmAssembly)binary).getAssembly();
                assembly.builtBy(new Object[]{compile});
                compile.setDescription("Compiles " + javaSourceSet + ".");
                compile.setDestinationDir(JavaSourceTransformTaskConfig.conventionalCompilationOutputDirFor(assembly));
                DeprecationLogger.whileDisabled((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        compile.setDependencyCacheDir(new File(compile.getProject().getBuildDir(), "jvm-dep-cache"));
                    }
                });
                compile.dependsOn(new Object[]{javaSourceSet});
                compile.setSource(javaSourceSet.getSource());
                JavaPlatform targetPlatform = assembly.getTargetPlatform();
                String targetCompatibility = targetPlatform.getTargetCompatibility().toString();
                compile.setPlatform(targetPlatform);
                compile.setToolChain(assembly.getToolChain());
                compile.setTargetCompatibility(targetCompatibility);
                compile.setSourceCompatibility(targetCompatibility);
                SourceSetDependencyResolvingClasspath classpath = JavaSourceTransformTaskConfig.classpathFor(binary, javaSourceSet, serviceRegistry, this.schemaStore);
                compile.setClasspath((FileCollection)classpath);
            }

            private static File conventionalCompilationOutputDirFor(JvmAssembly assembly) {
                return (File)CollectionUtils.first((Iterable)assembly.getClassDirectories());
            }

            private static SourceSetDependencyResolvingClasspath classpathFor(BinarySpec binary, JavaSourceSet javaSourceSet, ServiceRegistry serviceRegistry, ModelSchemaStore schemaStore) {
                Iterable<DependencySpec> dependencies = JavaSourceTransformTaskConfig.compileDependencies(binary, javaSourceSet);
                ArtifactDependencyResolver dependencyResolver = (ArtifactDependencyResolver)serviceRegistry.get(ArtifactDependencyResolver.class);
                RepositoryHandler repositories = (RepositoryHandler)serviceRegistry.get(RepositoryHandler.class);
                List resolutionAwareRepositories = CollectionUtils.collect((List)repositories, (Transformer)Transformers.cast(ResolutionAwareRepository.class));
                ModelSchema schema = schemaStore.getSchema(((BinarySpecInternal)binary).getPublicType());
                VariantsMetaData variantsMetaData = DefaultVariantsMetaData.extractFrom((BinarySpec)binary, (ModelSchema)schema);
                AttributesSchema attributesSchema = (AttributesSchema)serviceRegistry.get(AttributesSchema.class);
                ImmutableModuleIdentifierFactory moduleIdentifierFactory = (ImmutableModuleIdentifierFactory)serviceRegistry.get(ImmutableModuleIdentifierFactory.class);
                ModuleExclusions moduleExclusions = (ModuleExclusions)serviceRegistry.get(ModuleExclusions.class);
                return new SourceSetDependencyResolvingClasspath((BinarySpecInternal)binary, (LanguageSourceSet)javaSourceSet, dependencies, dependencyResolver, variantsMetaData, resolutionAwareRepositories, attributesSchema, moduleIdentifierFactory, moduleExclusions);
            }

            private static Iterable<DependencySpec> compileDependencies(BinarySpec binary, DependentSourceSet sourceSet) {
                return Iterables.concat((Iterable)sourceSet.getDependencies().getDependencies(), JavaSourceTransformTaskConfig.componentDependenciesOf(binary), JavaSourceTransformTaskConfig.apiDependenciesOf(binary));
            }

            private static Iterable<DependencySpec> componentDependenciesOf(BinarySpec binary) {
                return binary instanceof WithDependencies ? ((WithDependencies)binary).getDependencies() : NO_DEPENDENCIES;
            }

            private static Iterable<DependencySpec> apiDependenciesOf(BinarySpec binary) {
                return binary instanceof JarBinarySpecInternal ? ((JarBinarySpecInternal)binary).getApiDependencies() : NO_DEPENDENCIES;
            }
        }
    }

    static class Rules
    extends RuleSource {
        Rules() {
        }

        @ComponentType
        void registerLanguage(TypeBuilder<JavaSourceSet> builder) {
            builder.defaultImplementation(DefaultJavaLanguageSourceSet.class);
        }

        @Mutate
        void registerLanguageTransform(LanguageTransformContainer languages, ServiceRegistry serviceRegistry) {
            ModelSchemaStore schemaStore = (ModelSchemaStore)serviceRegistry.get(ModelSchemaStore.class);
            languages.add((Object)new Java(schemaStore));
        }
    }
}

