package os_test
import (
	πg "grumpy"
	π_grumpyΓlibΓos "grumpy/lib/os"
	π_grumpyΓlibΓstat "grumpy/lib/stat"
	π_grumpyΓlibΓtempfile "grumpy/lib/tempfile"
	π_grumpyΓlibΓtime "grumpy/lib/time"
	π_grumpyΓlibΓweetest "grumpy/lib/weetest"
)
func initModule(πF *πg.Frame, _ []*πg.Object) (*πg.Object, *πg.BaseException) {
	ßAssertionError := πg.InternStr("AssertionError")
	ßHOME := πg.InternStr("HOME")
	ßOSError := πg.InternStr("OSError")
	ßRunTests := πg.InternStr("RunTests")
	ßS_IMODE := πg.InternStr("S_IMODE")
	ßS_ISDIR := πg.InternStr("S_ISDIR")
	ßTestChdirAndGetCwd := πg.InternStr("TestChdirAndGetCwd")
	ßTestChmod := πg.InternStr("TestChmod")
	ßTestChmodOSError := πg.InternStr("TestChmodOSError")
	ßTestClose := πg.InternStr("TestClose")
	ßTestCloseOSError := πg.InternStr("TestCloseOSError")
	ßTestEnviron := πg.InternStr("TestEnviron")
	ßTestFDOpen := πg.InternStr("TestFDOpen")
	ßTestFDOpenOSError := πg.InternStr("TestFDOpenOSError")
	ßTestRemove := πg.InternStr("TestRemove")
	ßTestRemoveDir := πg.InternStr("TestRemoveDir")
	ßTestRemoveNoExist := πg.InternStr("TestRemoveNoExist")
	ßTestRmDir := πg.InternStr("TestRmDir")
	ßTestRmDirFile := πg.InternStr("TestRmDirFile")
	ßTestRmDirNoExist := πg.InternStr("TestRmDirNoExist")
	ßTestStatDir := πg.InternStr("TestStatDir")
	ßTestStatFile := πg.InternStr("TestStatFile")
	ßTestStatNoExist := πg.InternStr("TestStatNoExist")
	ß__main__ := πg.InternStr("__main__")
	ß__name__ := πg.InternStr("__name__")
	ßchdir := πg.InternStr("chdir")
	ßchmod := πg.InternStr("chmod")
	ßclose := πg.InternStr("close")
	ßenviron := πg.InternStr("environ")
	ßfdopen := πg.InternStr("fdopen")
	ßfoobar := πg.InternStr("foobar")
	ßgetcwd := πg.InternStr("getcwd")
	ßmkdtemp := πg.InternStr("mkdtemp")
	ßmkstemp := πg.InternStr("mkstemp")
	ßopen := πg.InternStr("open")
	ßos := πg.InternStr("os")
	ßread := πg.InternStr("read")
	ßremove := πg.InternStr("remove")
	ßrmdir := πg.InternStr("rmdir")
	ßst_mode := πg.InternStr("st_mode")
	ßst_mtime := πg.InternStr("st_mtime")
	ßst_size := πg.InternStr("st_size")
	ßstat := πg.InternStr("stat")
	ßtempfile := πg.InternStr("tempfile")
	ßtime := πg.InternStr("time")
	ßw := πg.InternStr("w")
	ßweetest := πg.InternStr("weetest")
	ßwrite := πg.InternStr("write")
	var πTemp001 *πg.Object
	_ = πTemp001
	var πTemp002 []*πg.Object
	_ = πTemp002
	var πTemp003 []πg.FunctionArg
	_ = πTemp003
	var πTemp004 *πg.Object
	_ = πTemp004
	var πTemp005 *πg.Object
	_ = πTemp005
	var πTemp006 *πg.Object
	_ = πTemp006
	var πTemp007 *πg.Object
	_ = πTemp007
	var πTemp008 *πg.Object
	_ = πTemp008
	var πTemp009 *πg.Object
	_ = πTemp009
	var πTemp010 *πg.Object
	_ = πTemp010
	var πTemp011 *πg.Object
	_ = πTemp011
	var πTemp012 *πg.Object
	_ = πTemp012
	var πTemp013 *πg.Object
	_ = πTemp013
	var πTemp014 *πg.Object
	_ = πTemp014
	var πTemp015 *πg.Object
	_ = πTemp015
	var πTemp016 *πg.Object
	_ = πTemp016
	var πTemp017 *πg.Object
	_ = πTemp017
	var πTemp018 *πg.Object
	_ = πTemp018
	var πTemp019 *πg.Object
	_ = πTemp019
	var πTemp020 *πg.Object
	_ = πTemp020
	var πTemp021 *πg.Object
	_ = πTemp021
	var πTemp022 bool
	_ = πTemp022
	var πE *πg.BaseException; _ = πE
	for ; πF.State() >= 0; πF.PopCheckpoint() {
		switch πF.State() {
		case 0:
		default: panic("unexpected function state")
		}
		// line 15: import os
		πF.SetLineno(15)
		if πTemp002, πE = πg.ImportModule(πF, "os", []*πg.Code{π_grumpyΓlibΓos.Code}); πE != nil {
			continue
		}
		πTemp001 = πTemp002[0]
		if πE = πF.Globals().SetItem(πF, ßos.ToObject(), πTemp001); πE != nil {
			continue
		}
		// line 16: import stat
		πF.SetLineno(16)
		if πTemp002, πE = πg.ImportModule(πF, "stat", []*πg.Code{π_grumpyΓlibΓstat.Code}); πE != nil {
			continue
		}
		πTemp001 = πTemp002[0]
		if πE = πF.Globals().SetItem(πF, ßstat.ToObject(), πTemp001); πE != nil {
			continue
		}
		// line 17: import time
		πF.SetLineno(17)
		if πTemp002, πE = πg.ImportModule(πF, "time", []*πg.Code{π_grumpyΓlibΓtime.Code}); πE != nil {
			continue
		}
		πTemp001 = πTemp002[0]
		if πE = πF.Globals().SetItem(πF, ßtime.ToObject(), πTemp001); πE != nil {
			continue
		}
		// line 18: import tempfile
		πF.SetLineno(18)
		if πTemp002, πE = πg.ImportModule(πF, "tempfile", []*πg.Code{π_grumpyΓlibΓtempfile.Code}); πE != nil {
			continue
		}
		πTemp001 = πTemp002[0]
		if πE = πF.Globals().SetItem(πF, ßtempfile.ToObject(), πTemp001); πE != nil {
			continue
		}
		// line 20: import weetest
		πF.SetLineno(20)
		if πTemp002, πE = πg.ImportModule(πF, "weetest", []*πg.Code{π_grumpyΓlibΓweetest.Code}); πE != nil {
			continue
		}
		πTemp001 = πTemp002[0]
		if πE = πF.Globals().SetItem(πF, ßweetest.ToObject(), πTemp001); πE != nil {
			continue
		}
		// line 23: def TestChdirAndGetCwd():
		πF.SetLineno(23)
		πTemp003 = make([]πg.FunctionArg, 0)
		πTemp001 = πg.NewFunction(πg.NewCode("TestChdirAndGetCwd", "lib/os_test.py", πTemp003, 0, func(πF *πg.Frame, πArgs []*πg.Object) (*πg.Object, *πg.BaseException) {
			var µpath *πg.Object = πg.UnboundLocal; _ = µpath
			var µtempdir *πg.Object = πg.UnboundLocal; _ = µtempdir
			var πTemp001 *πg.Object
			_ = πTemp001
			var πTemp002 *πg.Object
			_ = πTemp002
			var πTemp003 []*πg.Object
			_ = πTemp003
			var πTemp004 *πg.Object
			_ = πTemp004
			var πTemp005 bool
			_ = πTemp005
			var πTemp006 *πg.BaseException
			_ = πTemp006
			var πTemp007 *πg.Traceback
			_ = πTemp007
			var πE *πg.BaseException; _ = πE
			for ; πF.State() >= 0; πF.PopCheckpoint() {
				switch πF.State() {
				case 0:
				case 1: goto Label1
				default: panic("unexpected function state")
				}
				// line 24: path = os.getcwd()
				πF.SetLineno(24)
				if πTemp001, πE = πg.ResolveGlobal(πF, ßos); πE != nil {
					continue
				}
				if πTemp002, πE = πg.GetAttr(πF, πTemp001, ßgetcwd, nil); πE != nil {
					continue
				}
				if πTemp001, πE = πTemp002.Call(πF, nil, nil); πE != nil {
					continue
				}
				µpath = πTemp001
				// line 25: os.chdir('.')
				πF.SetLineno(25)
				πTemp003 = πF.MakeArgs(1)
				πTemp003[0] = πg.NewStr(".").ToObject()
				if πTemp001, πE = πg.ResolveGlobal(πF, ßos); πE != nil {
					continue
				}
				if πTemp002, πE = πg.GetAttr(πF, πTemp001, ßchdir, nil); πE != nil {
					continue
				}
				if πTemp001, πE = πTemp002.Call(πF, πTemp003, nil); πE != nil {
					continue
				}
				πF.FreeArgs(πTemp003)
				// line 26: assert os.getcwd() == path
				πF.SetLineno(26)
				if πTemp002, πE = πg.ResolveGlobal(πF, ßos); πE != nil {
					continue
				}
				if πTemp004, πE = πg.GetAttr(πF, πTemp002, ßgetcwd, nil); πE != nil {
					continue
				}
				if πTemp002, πE = πTemp004.Call(πF, nil, nil); πE != nil {
					continue
				}
				if πE = πg.CheckLocal(πF, µpath, "path"); πE != nil {
					continue
				}
				if πTemp001, πE = πg.Eq(πF, πTemp002, µpath); πE != nil {
					continue
				}
				if πE = πg.Assert(πF, πTemp001, nil); πE != nil {
					continue
				}
				// line 27: tempdir = tempfile.mkdtemp()
				πF.SetLineno(27)
				if πTemp001, πE = πg.ResolveGlobal(πF, ßtempfile); πE != nil {
					continue
				}
				if πTemp002, πE = πg.GetAttr(πF, πTemp001, ßmkdtemp, nil); πE != nil {
					continue
				}
				if πTemp001, πE = πTemp002.Call(πF, nil, nil); πE != nil {
					continue
				}
				µtempdir = πTemp001
				// line 28: try:
				πF.SetLineno(28)
				πF.PushCheckpoint(1)
				// line 29: os.chdir(tempdir)
				πF.SetLineno(29)
				πTemp003 = πF.MakeArgs(1)
				if πE = πg.CheckLocal(πF, µtempdir, "tempdir"); πE != nil {
					continue
				}
				πTemp003[0] = µtempdir
				if πTemp001, πE = πg.ResolveGlobal(πF, ßos); πE != nil {
					continue
				}
				if πTemp002, πE = πg.GetAttr(πF, πTemp001, ßchdir, nil); πE != nil {
					continue
				}
				if πTemp001, πE = πTemp002.Call(πF, πTemp003, nil); πE != nil {
					continue
				}
				πF.FreeArgs(πTemp003)
				// line 30: assert tempdir in os.getcwd()
				πF.SetLineno(30)
				if πE = πg.CheckLocal(πF, µtempdir, "tempdir"); πE != nil {
					continue
				}
				if πTemp002, πE = πg.ResolveGlobal(πF, ßos); πE != nil {
					continue
				}
				if πTemp004, πE = πg.GetAttr(πF, πTemp002, ßgetcwd, nil); πE != nil {
					continue
				}
				if πTemp002, πE = πTemp004.Call(πF, nil, nil); πE != nil {
					continue
				}
				if πTemp005, πE = πg.Contains(πF, πTemp002, µtempdir); πE != nil {
					continue
				}
				πTemp001 = πg.GetBool(πTemp005).ToObject()
				if πE = πg.Assert(πF, πTemp001, nil); πE != nil {
					continue
				}
				πF.PopCheckpoint()
			Label1:
				πE = nil
				πTemp006, πTemp007 = πF.RestoreExc(nil, nil)
				// line 32: os.chdir(path)
				πF.SetLineno(32)
				πTemp003 = πF.MakeArgs(1)
				if πE = πg.CheckLocal(πF, µpath, "path"); πE != nil {
					continue
				}
				πTemp003[0] = µpath
				if πTemp001, πE = πg.ResolveGlobal(πF, ßos); πE != nil {
					continue
				}
				if πTemp002, πE = πg.GetAttr(πF, πTemp001, ßchdir, nil); πE != nil {
					continue
				}
				if πTemp001, πE = πTemp002.Call(πF, πTemp003, nil); πE != nil {
					continue
				}
				πF.FreeArgs(πTemp003)
				// line 33: os.rmdir(tempdir)
				πF.SetLineno(33)
				πTemp003 = πF.MakeArgs(1)
				if πE = πg.CheckLocal(πF, µtempdir, "tempdir"); πE != nil {
					continue
				}
				πTemp003[0] = µtempdir
				if πTemp001, πE = πg.ResolveGlobal(πF, ßos); πE != nil {
					continue
				}
				if πTemp002, πE = πg.GetAttr(πF, πTemp001, ßrmdir, nil); πE != nil {
					continue
				}
				if πTemp001, πE = πTemp002.Call(πF, πTemp003, nil); πE != nil {
					continue
				}
				πF.FreeArgs(πTemp003)
				// line 34: assert os.getcwd() == path
				πF.SetLineno(34)
				if πTemp002, πE = πg.ResolveGlobal(πF, ßos); πE != nil {
					continue
				}
				if πTemp004, πE = πg.GetAttr(πF, πTemp002, ßgetcwd, nil); πE != nil {
					continue
				}
				if πTemp002, πE = πTemp004.Call(πF, nil, nil); πE != nil {
					continue
				}
				if πE = πg.CheckLocal(πF, µpath, "path"); πE != nil {
					continue
				}
				if πTemp001, πE = πg.Eq(πF, πTemp002, µpath); πE != nil {
					continue
				}
				if πE = πg.Assert(πF, πTemp001, nil); πE != nil {
					continue
				}
				if πTemp006 != nil {
					πE = πF.Raise(πTemp006.ToObject(), nil, πTemp007.ToObject())
					continue
				}
				return nil, nil
			}
			return nil, πE
		}), πF.Globals()).ToObject()
		if πE = πF.Globals().SetItem(πF, ßTestChdirAndGetCwd.ToObject(), πTemp001); πE != nil {
			continue
		}
		// line 37: def TestChmod():
		πF.SetLineno(37)
		πTemp003 = make([]πg.FunctionArg, 0)
		πTemp004 = πg.NewFunction(πg.NewCode("TestChmod", "lib/os_test.py", πTemp003, 0, func(πF *πg.Frame, πArgs []*πg.Object) (*πg.Object, *πg.BaseException) {
			var µfd *πg.Object = πg.UnboundLocal; _ = µfd
			var µpath *πg.Object = πg.UnboundLocal; _ = µpath
			var µmode *πg.Object = πg.UnboundLocal; _ = µmode
			var πTemp001 *πg.Object
			_ = πTemp001
			var πTemp002 *πg.Object
			_ = πTemp002
			var πTemp003 *πg.Object
			_ = πTemp003
			var πTemp004 []*πg.Object
			_ = πTemp004
			var πE *πg.BaseException; _ = πE
			for ; πF.State() >= 0; πF.PopCheckpoint() {
				switch πF.State() {
				case 0:
				default: panic("unexpected function state")
				}
				// line 38: fd, path = tempfile.mkstemp()
				πF.SetLineno(38)
				if πTemp001, πE = πg.ResolveGlobal(πF, ßtempfile); πE != nil {
					continue
				}
				if πTemp002, πE = πg.GetAttr(πF, πTemp001, ßmkstemp, nil); πE != nil {
					continue
				}
				if πTemp001, πE = πTemp002.Call(πF, nil, nil); πE != nil {
					continue
				}
				if πE = πg.Tie(πF, πg.TieTarget{Children: []πg.TieTarget{πg.TieTarget{Target: &πTemp002}, πg.TieTarget{Target: &πTemp003}}}, πTemp001); πE != nil {
					continue
				}
				µfd = πTemp002
				µpath = πTemp003
				// line 39: os.close(fd)
				πF.SetLineno(39)
				πTemp004 = πF.MakeArgs(1)
				if πE = πg.CheckLocal(πF, µfd, "fd"); πE != nil {
					continue
				}
				πTemp004[0] = µfd
				if πTemp001, πE = πg.ResolveGlobal(πF, ßos); πE != nil {
					continue
				}
				if πTemp002, πE = πg.GetAttr(πF, πTemp001, ßclose, nil); πE != nil {
					continue
				}
				if πTemp001, πE = πTemp002.Call(πF, πTemp004, nil); πE != nil {
					continue
				}
				πF.FreeArgs(πTemp004)
				// line 40: os.chmod(path, 0o644)
				πF.SetLineno(40)
				πTemp004 = πF.MakeArgs(2)
				if πE = πg.CheckLocal(πF, µpath, "path"); πE != nil {
					continue
				}
				πTemp004[0] = µpath
				πTemp004[1] = πg.NewInt(420).ToObject()
				if πTemp001, πE = πg.ResolveGlobal(πF, ßos); πE != nil {
					continue
				}
				if πTemp002, πE = πg.GetAttr(πF, πTemp001, ßchmod, nil); πE != nil {
					continue
				}
				if πTemp001, πE = πTemp002.Call(πF, πTemp004, nil); πE != nil {
					continue
				}
				πF.FreeArgs(πTemp004)
				// line 41: mode = os.stat(path).st_mode & 0o777
				πF.SetLineno(41)
				πTemp004 = πF.MakeArgs(1)
				if πE = πg.CheckLocal(πF, µpath, "path"); πE != nil {
					continue
				}
				πTemp004[0] = µpath
				if πTemp002, πE = πg.ResolveGlobal(πF, ßos); πE != nil {
					continue
				}
				if πTemp003, πE = πg.GetAttr(πF, πTemp002, ßstat, nil); πE != nil {
					continue
				}
				if πTemp002, πE = πTemp003.Call(πF, πTemp004, nil); πE != nil {
					continue
				}
				πF.FreeArgs(πTemp004)
				if πTemp003, πE = πg.GetAttr(πF, πTemp002, ßst_mode, nil); πE != nil {
					continue
				}
				if πTemp001, πE = πg.And(πF, πTemp003, πg.NewInt(511).ToObject()); πE != nil {
					continue
				}
				µmode = πTemp001
				// line 42: os.remove(path)
				πF.SetLineno(42)
				πTemp004 = πF.MakeArgs(1)
				if πE = πg.CheckLocal(πF, µpath, "path"); πE != nil {
					continue
				}
				πTemp004[0] = µpath
				if πTemp001, πE = πg.ResolveGlobal(πF, ßos); πE != nil {
					continue
				}
				if πTemp002, πE = πg.GetAttr(πF, πTemp001, ßremove, nil); πE != nil {
					continue
				}
				if πTemp001, πE = πTemp002.Call(πF, πTemp004, nil); πE != nil {
					continue
				}
				πF.FreeArgs(πTemp004)
				// line 43: assert mode == 0o644
				πF.SetLineno(43)
				if πE = πg.CheckLocal(πF, µmode, "mode"); πE != nil {
					continue
				}
				if πTemp001, πE = πg.Eq(πF, µmode, πg.NewInt(420).ToObject()); πE != nil {
					continue
				}
				if πE = πg.Assert(πF, πTemp001, nil); πE != nil {
					continue
				}
				return nil, nil
			}
			return nil, πE
		}), πF.Globals()).ToObject()
		if πE = πF.Globals().SetItem(πF, ßTestChmod.ToObject(), πTemp004); πE != nil {
			continue
		}
		// line 46: def TestChmodOSError():
		πF.SetLineno(46)
		πTemp003 = make([]πg.FunctionArg, 0)
		πTemp005 = πg.NewFunction(πg.NewCode("TestChmodOSError", "lib/os_test.py", πTemp003, 0, func(πF *πg.Frame, πArgs []*πg.Object) (*πg.Object, *πg.BaseException) {
			var µtempdir *πg.Object = πg.UnboundLocal; _ = µtempdir
			var πTemp001 *πg.Object
			_ = πTemp001
			var πTemp002 *πg.Object
			_ = πTemp002
			var πTemp003 []*πg.Object
			_ = πTemp003
			var πTemp004 *πg.BaseException
			_ = πTemp004
			var πTemp005 *πg.Traceback
			_ = πTemp005
			var πTemp006 bool
			_ = πTemp006
			var πE *πg.BaseException; _ = πE
			for ; πF.State() >= 0; πF.PopCheckpoint() {
				switch πF.State() {
				case 0:
				case 1: goto Label1
				default: panic("unexpected function state")
				}
				// line 47: tempdir = tempfile.mkdtemp()
				πF.SetLineno(47)
				if πTemp001, πE = πg.ResolveGlobal(πF, ßtempfile); πE != nil {
					continue
				}
				if πTemp002, πE = πg.GetAttr(πF, πTemp001, ßmkdtemp, nil); πE != nil {
					continue
				}
				if πTemp001, πE = πTemp002.Call(πF, nil, nil); πE != nil {
					continue
				}
				µtempdir = πTemp001
				// line 48: try:
				πF.SetLineno(48)
				πF.PushCheckpoint(1)
				// line 49: os.chmod(tempdir + '/DoesNotExist', 0o644)
				πF.SetLineno(49)
				πTemp003 = πF.MakeArgs(2)
				if πE = πg.CheckLocal(πF, µtempdir, "tempdir"); πE != nil {
					continue
				}
				if πTemp001, πE = πg.Add(πF, µtempdir, πg.NewStr("/DoesNotExist").ToObject()); πE != nil {
					continue
				}
				πTemp003[0] = πTemp001
				πTemp003[1] = πg.NewInt(420).ToObject()
				if πTemp001, πE = πg.ResolveGlobal(πF, ßos); πE != nil {
					continue
				}
				if πTemp002, πE = πg.GetAttr(πF, πTemp001, ßchmod, nil); πE != nil {
					continue
				}
				if πTemp001, πE = πTemp002.Call(πF, πTemp003, nil); πE != nil {
					continue
				}
				πF.FreeArgs(πTemp003)
				πF.PopCheckpoint()
				if πTemp001, πE = πg.ResolveGlobal(πF, ßAssertionError); πE != nil {
					continue
				}
				// line 53: raise AssertionError
				πF.SetLineno(53)
				πE = πF.Raise(πTemp001, nil, nil)
				continue
				goto Label2
			Label1:
				πTemp004, πTemp005 = πF.ExcInfo()
				if πTemp001, πE = πg.ResolveGlobal(πF, ßOSError); πE != nil {
					continue
				}
				if πTemp006, πE = πg.IsInstance(πF, πTemp004.ToObject(), πTemp001); πE != nil {
					continue
				}
				if πTemp006 {
					goto Label3
				}
				πE = πF.Raise(πTemp004.ToObject(), nil, πTemp005.ToObject())
				continue
				// line 50: except OSError:
				πF.SetLineno(50)
			Label3:
				// line 51: pass
				πF.SetLineno(51)
				πE = nil
				πF.RestoreExc(nil, nil)
				goto Label2
			Label2:
				return nil, nil
			}
			return nil, πE
		}), πF.Globals()).ToObject()
		if πE = πF.Globals().SetItem(πF, ßTestChmodOSError.ToObject(), πTemp005); πE != nil {
			continue
		}
		// line 56: def TestClose():
		πF.SetLineno(56)
		πTemp003 = make([]πg.FunctionArg, 0)
		πTemp006 = πg.NewFunction(πg.NewCode("TestClose", "lib/os_test.py", πTemp003, 0, func(πF *πg.Frame, πArgs []*πg.Object) (*πg.Object, *πg.BaseException) {
			var µfd *πg.Object = πg.UnboundLocal; _ = µfd
			var µ_ *πg.Object = πg.UnboundLocal; _ = µ_
			var πTemp001 *πg.Object
			_ = πTemp001
			var πTemp002 *πg.Object
			_ = πTemp002
			var πTemp003 *πg.Object
			_ = πTemp003
			var πTemp004 []*πg.Object
			_ = πTemp004
			var πTemp005 *πg.BaseException
			_ = πTemp005
			var πTemp006 *πg.Traceback
			_ = πTemp006
			var πTemp007 bool
			_ = πTemp007
			var πE *πg.BaseException; _ = πE
			for ; πF.State() >= 0; πF.PopCheckpoint() {
				switch πF.State() {
				case 0:
				case 1: goto Label1
				default: panic("unexpected function state")
				}
				// line 57: fd, _ = tempfile.mkstemp()
				πF.SetLineno(57)
				if πTemp001, πE = πg.ResolveGlobal(πF, ßtempfile); πE != nil {
					continue
				}
				if πTemp002, πE = πg.GetAttr(πF, πTemp001, ßmkstemp, nil); πE != nil {
					continue
				}
				if πTemp001, πE = πTemp002.Call(πF, nil, nil); πE != nil {
					continue
				}
				if πE = πg.Tie(πF, πg.TieTarget{Children: []πg.TieTarget{πg.TieTarget{Target: &πTemp002}, πg.TieTarget{Target: &πTemp003}}}, πTemp001); πE != nil {
					continue
				}
				µfd = πTemp002
				µ_ = πTemp003
				// line 58: os.close(fd)
				πF.SetLineno(58)
				πTemp004 = πF.MakeArgs(1)
				if πE = πg.CheckLocal(πF, µfd, "fd"); πE != nil {
					continue
				}
				πTemp004[0] = µfd
				if πTemp001, πE = πg.ResolveGlobal(πF, ßos); πE != nil {
					continue
				}
				if πTemp002, πE = πg.GetAttr(πF, πTemp001, ßclose, nil); πE != nil {
					continue
				}
				if πTemp001, πE = πTemp002.Call(πF, πTemp004, nil); πE != nil {
					continue
				}
				πF.FreeArgs(πTemp004)
				// line 59: try:
				πF.SetLineno(59)
				πF.PushCheckpoint(1)
				// line 60: os.fdopen(fd)
				πF.SetLineno(60)
				πTemp004 = πF.MakeArgs(1)
				if πE = πg.CheckLocal(πF, µfd, "fd"); πE != nil {
					continue
				}
				πTemp004[0] = µfd
				if πTemp001, πE = πg.ResolveGlobal(πF, ßos); πE != nil {
					continue
				}
				if πTemp002, πE = πg.GetAttr(πF, πTemp001, ßfdopen, nil); πE != nil {
					continue
				}
				if πTemp001, πE = πTemp002.Call(πF, πTemp004, nil); πE != nil {
					continue
				}
				πF.FreeArgs(πTemp004)
				πF.PopCheckpoint()
				if πTemp001, πE = πg.ResolveGlobal(πF, ßAssertionError); πE != nil {
					continue
				}
				// line 64: raise AssertionError
				πF.SetLineno(64)
				πE = πF.Raise(πTemp001, nil, nil)
				continue
				goto Label2
			Label1:
				πTemp005, πTemp006 = πF.ExcInfo()
				if πTemp001, πE = πg.ResolveGlobal(πF, ßOSError); πE != nil {
					continue
				}
				if πTemp007, πE = πg.IsInstance(πF, πTemp005.ToObject(), πTemp001); πE != nil {
					continue
				}
				if πTemp007 {
					goto Label3
				}
				πE = πF.Raise(πTemp005.ToObject(), nil, πTemp006.ToObject())
				continue
				// line 61: except OSError:
				πF.SetLineno(61)
			Label3:
				// line 62: pass
				πF.SetLineno(62)
				πE = nil
				πF.RestoreExc(nil, nil)
				goto Label2
			Label2:
				return nil, nil
			}
			return nil, πE
		}), πF.Globals()).ToObject()
		if πE = πF.Globals().SetItem(πF, ßTestClose.ToObject(), πTemp006); πE != nil {
			continue
		}
		// line 67: def TestCloseOSError():
		πF.SetLineno(67)
		πTemp003 = make([]πg.FunctionArg, 0)
		πTemp007 = πg.NewFunction(πg.NewCode("TestCloseOSError", "lib/os_test.py", πTemp003, 0, func(πF *πg.Frame, πArgs []*πg.Object) (*πg.Object, *πg.BaseException) {
			var µfd *πg.Object = πg.UnboundLocal; _ = µfd
			var µ_ *πg.Object = πg.UnboundLocal; _ = µ_
			var πTemp001 *πg.Object
			_ = πTemp001
			var πTemp002 *πg.Object
			_ = πTemp002
			var πTemp003 *πg.Object
			_ = πTemp003
			var πTemp004 []*πg.Object
			_ = πTemp004
			var πTemp005 *πg.BaseException
			_ = πTemp005
			var πTemp006 *πg.Traceback
			_ = πTemp006
			var πTemp007 bool
			_ = πTemp007
			var πE *πg.BaseException; _ = πE
			for ; πF.State() >= 0; πF.PopCheckpoint() {
				switch πF.State() {
				case 0:
				case 1: goto Label1
				default: panic("unexpected function state")
				}
				// line 68: fd, _ = tempfile.mkstemp()
				πF.SetLineno(68)
				if πTemp001, πE = πg.ResolveGlobal(πF, ßtempfile); πE != nil {
					continue
				}
				if πTemp002, πE = πg.GetAttr(πF, πTemp001, ßmkstemp, nil); πE != nil {
					continue
				}
				if πTemp001, πE = πTemp002.Call(πF, nil, nil); πE != nil {
					continue
				}
				if πE = πg.Tie(πF, πg.TieTarget{Children: []πg.TieTarget{πg.TieTarget{Target: &πTemp002}, πg.TieTarget{Target: &πTemp003}}}, πTemp001); πE != nil {
					continue
				}
				µfd = πTemp002
				µ_ = πTemp003
				// line 69: os.close(fd)
				πF.SetLineno(69)
				πTemp004 = πF.MakeArgs(1)
				if πE = πg.CheckLocal(πF, µfd, "fd"); πE != nil {
					continue
				}
				πTemp004[0] = µfd
				if πTemp001, πE = πg.ResolveGlobal(πF, ßos); πE != nil {
					continue
				}
				if πTemp002, πE = πg.GetAttr(πF, πTemp001, ßclose, nil); πE != nil {
					continue
				}
				if πTemp001, πE = πTemp002.Call(πF, πTemp004, nil); πE != nil {
					continue
				}
				πF.FreeArgs(πTemp004)
				// line 70: try:
				πF.SetLineno(70)
				πF.PushCheckpoint(1)
				// line 71: os.close(fd)
				πF.SetLineno(71)
				πTemp004 = πF.MakeArgs(1)
				if πE = πg.CheckLocal(πF, µfd, "fd"); πE != nil {
					continue
				}
				πTemp004[0] = µfd
				if πTemp001, πE = πg.ResolveGlobal(πF, ßos); πE != nil {
					continue
				}
				if πTemp002, πE = πg.GetAttr(πF, πTemp001, ßclose, nil); πE != nil {
					continue
				}
				if πTemp001, πE = πTemp002.Call(πF, πTemp004, nil); πE != nil {
					continue
				}
				πF.FreeArgs(πTemp004)
				πF.PopCheckpoint()
				if πTemp001, πE = πg.ResolveGlobal(πF, ßAssertionError); πE != nil {
					continue
				}
				// line 75: raise AssertionError
				πF.SetLineno(75)
				πE = πF.Raise(πTemp001, nil, nil)
				continue
				goto Label2
			Label1:
				πTemp005, πTemp006 = πF.ExcInfo()
				if πTemp001, πE = πg.ResolveGlobal(πF, ßOSError); πE != nil {
					continue
				}
				if πTemp007, πE = πg.IsInstance(πF, πTemp005.ToObject(), πTemp001); πE != nil {
					continue
				}
				if πTemp007 {
					goto Label3
				}
				πE = πF.Raise(πTemp005.ToObject(), nil, πTemp006.ToObject())
				continue
				// line 72: except OSError:
				πF.SetLineno(72)
			Label3:
				// line 73: pass
				πF.SetLineno(73)
				πE = nil
				πF.RestoreExc(nil, nil)
				goto Label2
			Label2:
				return nil, nil
			}
			return nil, πE
		}), πF.Globals()).ToObject()
		if πE = πF.Globals().SetItem(πF, ßTestCloseOSError.ToObject(), πTemp007); πE != nil {
			continue
		}
		// line 78: def TestEnviron():
		πF.SetLineno(78)
		πTemp003 = make([]πg.FunctionArg, 0)
		πTemp008 = πg.NewFunction(πg.NewCode("TestEnviron", "lib/os_test.py", πTemp003, 0, func(πF *πg.Frame, πArgs []*πg.Object) (*πg.Object, *πg.BaseException) {
			var πTemp001 *πg.Object
			_ = πTemp001
			var πTemp002 *πg.Object
			_ = πTemp002
			var πTemp003 *πg.Object
			_ = πTemp003
			var πTemp004 bool
			_ = πTemp004
			var πE *πg.BaseException; _ = πE
			for ; πF.State() >= 0; πF.PopCheckpoint() {
				switch πF.State() {
				case 0:
				default: panic("unexpected function state")
				}
				// line 79: assert 'HOME' in os.environ
				πF.SetLineno(79)
				if πTemp002, πE = πg.ResolveGlobal(πF, ßos); πE != nil {
					continue
				}
				if πTemp003, πE = πg.GetAttr(πF, πTemp002, ßenviron, nil); πE != nil {
					continue
				}
				if πTemp004, πE = πg.Contains(πF, πTemp003, ßHOME.ToObject()); πE != nil {
					continue
				}
				πTemp001 = πg.GetBool(πTemp004).ToObject()
				if πE = πg.Assert(πF, πTemp001, nil); πE != nil {
					continue
				}
				return nil, nil
			}
			return nil, πE
		}), πF.Globals()).ToObject()
		if πE = πF.Globals().SetItem(πF, ßTestEnviron.ToObject(), πTemp008); πE != nil {
			continue
		}
		// line 82: def TestFDOpen():
		πF.SetLineno(82)
		πTemp003 = make([]πg.FunctionArg, 0)
		πTemp009 = πg.NewFunction(πg.NewCode("TestFDOpen", "lib/os_test.py", πTemp003, 0, func(πF *πg.Frame, πArgs []*πg.Object) (*πg.Object, *πg.BaseException) {
			var µfd *πg.Object = πg.UnboundLocal; _ = µfd
			var µpath *πg.Object = πg.UnboundLocal; _ = µpath
			var µf *πg.Object = πg.UnboundLocal; _ = µf
			var µcontents *πg.Object = πg.UnboundLocal; _ = µcontents
			var πTemp001 *πg.Object
			_ = πTemp001
			var πTemp002 *πg.Object
			_ = πTemp002
			var πTemp003 *πg.Object
			_ = πTemp003
			var πTemp004 []*πg.Object
			_ = πTemp004
			var πE *πg.BaseException; _ = πE
			for ; πF.State() >= 0; πF.PopCheckpoint() {
				switch πF.State() {
				case 0:
				default: panic("unexpected function state")
				}
				// line 83: fd, path = tempfile.mkstemp()
				πF.SetLineno(83)
				if πTemp001, πE = πg.ResolveGlobal(πF, ßtempfile); πE != nil {
					continue
				}
				if πTemp002, πE = πg.GetAttr(πF, πTemp001, ßmkstemp, nil); πE != nil {
					continue
				}
				if πTemp001, πE = πTemp002.Call(πF, nil, nil); πE != nil {
					continue
				}
				if πE = πg.Tie(πF, πg.TieTarget{Children: []πg.TieTarget{πg.TieTarget{Target: &πTemp002}, πg.TieTarget{Target: &πTemp003}}}, πTemp001); πE != nil {
					continue
				}
				µfd = πTemp002
				µpath = πTemp003
				// line 84: f = os.fdopen(fd, 'w')
				πF.SetLineno(84)
				πTemp004 = πF.MakeArgs(2)
				if πE = πg.CheckLocal(πF, µfd, "fd"); πE != nil {
					continue
				}
				πTemp004[0] = µfd
				πTemp004[1] = ßw.ToObject()
				if πTemp001, πE = πg.ResolveGlobal(πF, ßos); πE != nil {
					continue
				}
				if πTemp002, πE = πg.GetAttr(πF, πTemp001, ßfdopen, nil); πE != nil {
					continue
				}
				if πTemp001, πE = πTemp002.Call(πF, πTemp004, nil); πE != nil {
					continue
				}
				πF.FreeArgs(πTemp004)
				µf = πTemp001
				// line 85: f.write('foobar')
				πF.SetLineno(85)
				πTemp004 = πF.MakeArgs(1)
				πTemp004[0] = ßfoobar.ToObject()
				if πE = πg.CheckLocal(πF, µf, "f"); πE != nil {
					continue
				}
				if πTemp001, πE = πg.GetAttr(πF, µf, ßwrite, nil); πE != nil {
					continue
				}
				if πTemp002, πE = πTemp001.Call(πF, πTemp004, nil); πE != nil {
					continue
				}
				πF.FreeArgs(πTemp004)
				// line 86: f.close()
				πF.SetLineno(86)
				if πE = πg.CheckLocal(πF, µf, "f"); πE != nil {
					continue
				}
				if πTemp001, πE = πg.GetAttr(πF, µf, ßclose, nil); πE != nil {
					continue
				}
				if πTemp002, πE = πTemp001.Call(πF, nil, nil); πE != nil {
					continue
				}
				// line 87: f = open(path)
				πF.SetLineno(87)
				πTemp004 = πF.MakeArgs(1)
				if πE = πg.CheckLocal(πF, µpath, "path"); πE != nil {
					continue
				}
				πTemp004[0] = µpath
				if πTemp001, πE = πg.ResolveGlobal(πF, ßopen); πE != nil {
					continue
				}
				if πTemp002, πE = πTemp001.Call(πF, πTemp004, nil); πE != nil {
					continue
				}
				πF.FreeArgs(πTemp004)
				µf = πTemp002
				// line 88: contents = f.read()
				πF.SetLineno(88)
				if πE = πg.CheckLocal(πF, µf, "f"); πE != nil {
					continue
				}
				if πTemp001, πE = πg.GetAttr(πF, µf, ßread, nil); πE != nil {
					continue
				}
				if πTemp002, πE = πTemp001.Call(πF, nil, nil); πE != nil {
					continue
				}
				µcontents = πTemp002
				// line 89: f.close()
				πF.SetLineno(89)
				if πE = πg.CheckLocal(πF, µf, "f"); πE != nil {
					continue
				}
				if πTemp001, πE = πg.GetAttr(πF, µf, ßclose, nil); πE != nil {
					continue
				}
				if πTemp002, πE = πTemp001.Call(πF, nil, nil); πE != nil {
					continue
				}
				// line 90: assert contents == 'foobar', contents
				πF.SetLineno(90)
				if πE = πg.CheckLocal(πF, µcontents, "contents"); πE != nil {
					continue
				}
				if πE = πg.CheckLocal(πF, µcontents, "contents"); πE != nil {
					continue
				}
				if πTemp001, πE = πg.Eq(πF, µcontents, ßfoobar.ToObject()); πE != nil {
					continue
				}
				if πE = πg.Assert(πF, πTemp001, µcontents); πE != nil {
					continue
				}
				return nil, nil
			}
			return nil, πE
		}), πF.Globals()).ToObject()
		if πE = πF.Globals().SetItem(πF, ßTestFDOpen.ToObject(), πTemp009); πE != nil {
			continue
		}
		// line 93: def TestFDOpenOSError():
		πF.SetLineno(93)
		πTemp003 = make([]πg.FunctionArg, 0)
		πTemp010 = πg.NewFunction(πg.NewCode("TestFDOpenOSError", "lib/os_test.py", πTemp003, 0, func(πF *πg.Frame, πArgs []*πg.Object) (*πg.Object, *πg.BaseException) {
			var µfd *πg.Object = πg.UnboundLocal; _ = µfd
			var µ_ *πg.Object = πg.UnboundLocal; _ = µ_
			var πTemp001 *πg.Object
			_ = πTemp001
			var πTemp002 *πg.Object
			_ = πTemp002
			var πTemp003 *πg.Object
			_ = πTemp003
			var πTemp004 []*πg.Object
			_ = πTemp004
			var πTemp005 *πg.BaseException
			_ = πTemp005
			var πTemp006 *πg.Traceback
			_ = πTemp006
			var πTemp007 bool
			_ = πTemp007
			var πE *πg.BaseException; _ = πE
			for ; πF.State() >= 0; πF.PopCheckpoint() {
				switch πF.State() {
				case 0:
				case 1: goto Label1
				default: panic("unexpected function state")
				}
				// line 94: fd, _ = tempfile.mkstemp()
				πF.SetLineno(94)
				if πTemp001, πE = πg.ResolveGlobal(πF, ßtempfile); πE != nil {
					continue
				}
				if πTemp002, πE = πg.GetAttr(πF, πTemp001, ßmkstemp, nil); πE != nil {
					continue
				}
				if πTemp001, πE = πTemp002.Call(πF, nil, nil); πE != nil {
					continue
				}
				if πE = πg.Tie(πF, πg.TieTarget{Children: []πg.TieTarget{πg.TieTarget{Target: &πTemp002}, πg.TieTarget{Target: &πTemp003}}}, πTemp001); πE != nil {
					continue
				}
				µfd = πTemp002
				µ_ = πTemp003
				// line 95: os.close(fd)
				πF.SetLineno(95)
				πTemp004 = πF.MakeArgs(1)
				if πE = πg.CheckLocal(πF, µfd, "fd"); πE != nil {
					continue
				}
				πTemp004[0] = µfd
				if πTemp001, πE = πg.ResolveGlobal(πF, ßos); πE != nil {
					continue
				}
				if πTemp002, πE = πg.GetAttr(πF, πTemp001, ßclose, nil); πE != nil {
					continue
				}
				if πTemp001, πE = πTemp002.Call(πF, πTemp004, nil); πE != nil {
					continue
				}
				πF.FreeArgs(πTemp004)
				// line 96: try:
				πF.SetLineno(96)
				πF.PushCheckpoint(1)
				// line 97: os.fdopen(fd)
				πF.SetLineno(97)
				πTemp004 = πF.MakeArgs(1)
				if πE = πg.CheckLocal(πF, µfd, "fd"); πE != nil {
					continue
				}
				πTemp004[0] = µfd
				if πTemp001, πE = πg.ResolveGlobal(πF, ßos); πE != nil {
					continue
				}
				if πTemp002, πE = πg.GetAttr(πF, πTemp001, ßfdopen, nil); πE != nil {
					continue
				}
				if πTemp001, πE = πTemp002.Call(πF, πTemp004, nil); πE != nil {
					continue
				}
				πF.FreeArgs(πTemp004)
				πF.PopCheckpoint()
				if πTemp001, πE = πg.ResolveGlobal(πF, ßAssertionError); πE != nil {
					continue
				}
				// line 101: raise AssertionError
				πF.SetLineno(101)
				πE = πF.Raise(πTemp001, nil, nil)
				continue
				goto Label2
			Label1:
				πTemp005, πTemp006 = πF.ExcInfo()
				if πTemp001, πE = πg.ResolveGlobal(πF, ßOSError); πE != nil {
					continue
				}
				if πTemp007, πE = πg.IsInstance(πF, πTemp005.ToObject(), πTemp001); πE != nil {
					continue
				}
				if πTemp007 {
					goto Label3
				}
				πE = πF.Raise(πTemp005.ToObject(), nil, πTemp006.ToObject())
				continue
				// line 98: except OSError:
				πF.SetLineno(98)
			Label3:
				// line 99: pass
				πF.SetLineno(99)
				πE = nil
				πF.RestoreExc(nil, nil)
				goto Label2
			Label2:
				return nil, nil
			}
			return nil, πE
		}), πF.Globals()).ToObject()
		if πE = πF.Globals().SetItem(πF, ßTestFDOpenOSError.ToObject(), πTemp010); πE != nil {
			continue
		}
		// line 104: def TestRemove():
		πF.SetLineno(104)
		πTemp003 = make([]πg.FunctionArg, 0)
		πTemp011 = πg.NewFunction(πg.NewCode("TestRemove", "lib/os_test.py", πTemp003, 0, func(πF *πg.Frame, πArgs []*πg.Object) (*πg.Object, *πg.BaseException) {
			var µfd *πg.Object = πg.UnboundLocal; _ = µfd
			var µpath *πg.Object = πg.UnboundLocal; _ = µpath
			var πTemp001 *πg.Object
			_ = πTemp001
			var πTemp002 *πg.Object
			_ = πTemp002
			var πTemp003 *πg.Object
			_ = πTemp003
			var πTemp004 []*πg.Object
			_ = πTemp004
			var πTemp005 *πg.BaseException
			_ = πTemp005
			var πTemp006 *πg.Traceback
			_ = πTemp006
			var πTemp007 bool
			_ = πTemp007
			var πE *πg.BaseException; _ = πE
			for ; πF.State() >= 0; πF.PopCheckpoint() {
				switch πF.State() {
				case 0:
				case 1: goto Label1
				default: panic("unexpected function state")
				}
				// line 105: fd, path = tempfile.mkstemp()
				πF.SetLineno(105)
				if πTemp001, πE = πg.ResolveGlobal(πF, ßtempfile); πE != nil {
					continue
				}
				if πTemp002, πE = πg.GetAttr(πF, πTemp001, ßmkstemp, nil); πE != nil {
					continue
				}
				if πTemp001, πE = πTemp002.Call(πF, nil, nil); πE != nil {
					continue
				}
				if πE = πg.Tie(πF, πg.TieTarget{Children: []πg.TieTarget{πg.TieTarget{Target: &πTemp002}, πg.TieTarget{Target: &πTemp003}}}, πTemp001); πE != nil {
					continue
				}
				µfd = πTemp002
				µpath = πTemp003
				// line 106: os.close(fd)
				πF.SetLineno(106)
				πTemp004 = πF.MakeArgs(1)
				if πE = πg.CheckLocal(πF, µfd, "fd"); πE != nil {
					continue
				}
				πTemp004[0] = µfd
				if πTemp001, πE = πg.ResolveGlobal(πF, ßos); πE != nil {
					continue
				}
				if πTemp002, πE = πg.GetAttr(πF, πTemp001, ßclose, nil); πE != nil {
					continue
				}
				if πTemp001, πE = πTemp002.Call(πF, πTemp004, nil); πE != nil {
					continue
				}
				πF.FreeArgs(πTemp004)
				// line 107: os.stat(path)
				πF.SetLineno(107)
				πTemp004 = πF.MakeArgs(1)
				if πE = πg.CheckLocal(πF, µpath, "path"); πE != nil {
					continue
				}
				πTemp004[0] = µpath
				if πTemp001, πE = πg.ResolveGlobal(πF, ßos); πE != nil {
					continue
				}
				if πTemp002, πE = πg.GetAttr(πF, πTemp001, ßstat, nil); πE != nil {
					continue
				}
				if πTemp001, πE = πTemp002.Call(πF, πTemp004, nil); πE != nil {
					continue
				}
				πF.FreeArgs(πTemp004)
				// line 108: os.remove(path)
				πF.SetLineno(108)
				πTemp004 = πF.MakeArgs(1)
				if πE = πg.CheckLocal(πF, µpath, "path"); πE != nil {
					continue
				}
				πTemp004[0] = µpath
				if πTemp001, πE = πg.ResolveGlobal(πF, ßos); πE != nil {
					continue
				}
				if πTemp002, πE = πg.GetAttr(πF, πTemp001, ßremove, nil); πE != nil {
					continue
				}
				if πTemp001, πE = πTemp002.Call(πF, πTemp004, nil); πE != nil {
					continue
				}
				πF.FreeArgs(πTemp004)
				// line 109: try:
				πF.SetLineno(109)
				πF.PushCheckpoint(1)
				// line 110: os.stat(path)
				πF.SetLineno(110)
				πTemp004 = πF.MakeArgs(1)
				if πE = πg.CheckLocal(πF, µpath, "path"); πE != nil {
					continue
				}
				πTemp004[0] = µpath
				if πTemp001, πE = πg.ResolveGlobal(πF, ßos); πE != nil {
					continue
				}
				if πTemp002, πE = πg.GetAttr(πF, πTemp001, ßstat, nil); πE != nil {
					continue
				}
				if πTemp001, πE = πTemp002.Call(πF, πTemp004, nil); πE != nil {
					continue
				}
				πF.FreeArgs(πTemp004)
				πF.PopCheckpoint()
				if πTemp001, πE = πg.ResolveGlobal(πF, ßAssertionError); πE != nil {
					continue
				}
				// line 114: raise AssertionError
				πF.SetLineno(114)
				πE = πF.Raise(πTemp001, nil, nil)
				continue
				goto Label2
			Label1:
				πTemp005, πTemp006 = πF.ExcInfo()
				if πTemp001, πE = πg.ResolveGlobal(πF, ßOSError); πE != nil {
					continue
				}
				if πTemp007, πE = πg.IsInstance(πF, πTemp005.ToObject(), πTemp001); πE != nil {
					continue
				}
				if πTemp007 {
					goto Label3
				}
				πE = πF.Raise(πTemp005.ToObject(), nil, πTemp006.ToObject())
				continue
				// line 111: except OSError:
				πF.SetLineno(111)
			Label3:
				// line 112: pass
				πF.SetLineno(112)
				πE = nil
				πF.RestoreExc(nil, nil)
				goto Label2
			Label2:
				return nil, nil
			}
			return nil, πE
		}), πF.Globals()).ToObject()
		if πE = πF.Globals().SetItem(πF, ßTestRemove.ToObject(), πTemp011); πE != nil {
			continue
		}
		// line 117: def TestRemoveNoExist():
		πF.SetLineno(117)
		πTemp003 = make([]πg.FunctionArg, 0)
		πTemp012 = πg.NewFunction(πg.NewCode("TestRemoveNoExist", "lib/os_test.py", πTemp003, 0, func(πF *πg.Frame, πArgs []*πg.Object) (*πg.Object, *πg.BaseException) {
			var µpath *πg.Object = πg.UnboundLocal; _ = µpath
			var πTemp001 *πg.Object
			_ = πTemp001
			var πTemp002 *πg.Object
			_ = πTemp002
			var πTemp003 []*πg.Object
			_ = πTemp003
			var πTemp004 *πg.BaseException
			_ = πTemp004
			var πTemp005 *πg.Traceback
			_ = πTemp005
			var πTemp006 bool
			_ = πTemp006
			var πE *πg.BaseException; _ = πE
			for ; πF.State() >= 0; πF.PopCheckpoint() {
				switch πF.State() {
				case 0:
				case 1: goto Label1
				case 2: goto Label2
				default: panic("unexpected function state")
				}
				// line 118: path = tempfile.mkdtemp()
				πF.SetLineno(118)
				if πTemp001, πE = πg.ResolveGlobal(πF, ßtempfile); πE != nil {
					continue
				}
				if πTemp002, πE = πg.GetAttr(πF, πTemp001, ßmkdtemp, nil); πE != nil {
					continue
				}
				if πTemp001, πE = πTemp002.Call(πF, nil, nil); πE != nil {
					continue
				}
				µpath = πTemp001
				// line 119: try:
				πF.SetLineno(119)
				πF.PushCheckpoint(1)
				// line 119: try:
				πF.SetLineno(119)
				πF.PushCheckpoint(2)
				// line 120: os.remove(path + '/nonexistent')
				πF.SetLineno(120)
				πTemp003 = πF.MakeArgs(1)
				if πE = πg.CheckLocal(πF, µpath, "path"); πE != nil {
					continue
				}
				if πTemp001, πE = πg.Add(πF, µpath, πg.NewStr("/nonexistent").ToObject()); πE != nil {
					continue
				}
				πTemp003[0] = πTemp001
				if πTemp001, πE = πg.ResolveGlobal(πF, ßos); πE != nil {
					continue
				}
				if πTemp002, πE = πg.GetAttr(πF, πTemp001, ßremove, nil); πE != nil {
					continue
				}
				if πTemp001, πE = πTemp002.Call(πF, πTemp003, nil); πE != nil {
					continue
				}
				πF.FreeArgs(πTemp003)
				πF.PopCheckpoint()
				if πTemp001, πE = πg.ResolveGlobal(πF, ßAssertionError); πE != nil {
					continue
				}
				// line 124: raise AssertionError
				πF.SetLineno(124)
				πE = πF.Raise(πTemp001, nil, nil)
				continue
				goto Label3
			Label2:
				πTemp004, πTemp005 = πF.ExcInfo()
				if πTemp001, πE = πg.ResolveGlobal(πF, ßOSError); πE != nil {
					continue
				}
				if πTemp006, πE = πg.IsInstance(πF, πTemp004.ToObject(), πTemp001); πE != nil {
					continue
				}
				if πTemp006 {
					goto Label4
				}
				πE = πF.Raise(πTemp004.ToObject(), nil, πTemp005.ToObject())
				continue
				// line 121: except OSError:
				πF.SetLineno(121)
			Label4:
				// line 122: pass
				πF.SetLineno(122)
				πE = nil
				πF.RestoreExc(nil, nil)
				goto Label3
			Label3:
				πF.PopCheckpoint()
			Label1:
				πE = nil
				πTemp004, πTemp005 = πF.RestoreExc(nil, nil)
				// line 126: os.rmdir(path)
				πF.SetLineno(126)
				πTemp003 = πF.MakeArgs(1)
				if πE = πg.CheckLocal(πF, µpath, "path"); πE != nil {
					continue
				}
				πTemp003[0] = µpath
				if πTemp001, πE = πg.ResolveGlobal(πF, ßos); πE != nil {
					continue
				}
				if πTemp002, πE = πg.GetAttr(πF, πTemp001, ßrmdir, nil); πE != nil {
					continue
				}
				if πTemp001, πE = πTemp002.Call(πF, πTemp003, nil); πE != nil {
					continue
				}
				πF.FreeArgs(πTemp003)
				if πTemp004 != nil {
					πE = πF.Raise(πTemp004.ToObject(), nil, πTemp005.ToObject())
					continue
				}
				return nil, nil
			}
			return nil, πE
		}), πF.Globals()).ToObject()
		if πE = πF.Globals().SetItem(πF, ßTestRemoveNoExist.ToObject(), πTemp012); πE != nil {
			continue
		}
		// line 129: def TestRemoveDir():
		πF.SetLineno(129)
		πTemp003 = make([]πg.FunctionArg, 0)
		πTemp013 = πg.NewFunction(πg.NewCode("TestRemoveDir", "lib/os_test.py", πTemp003, 0, func(πF *πg.Frame, πArgs []*πg.Object) (*πg.Object, *πg.BaseException) {
			var µpath *πg.Object = πg.UnboundLocal; _ = µpath
			var πTemp001 *πg.Object
			_ = πTemp001
			var πTemp002 *πg.Object
			_ = πTemp002
			var πTemp003 []*πg.Object
			_ = πTemp003
			var πTemp004 *πg.BaseException
			_ = πTemp004
			var πTemp005 *πg.Traceback
			_ = πTemp005
			var πTemp006 bool
			_ = πTemp006
			var πE *πg.BaseException; _ = πE
			for ; πF.State() >= 0; πF.PopCheckpoint() {
				switch πF.State() {
				case 0:
				case 1: goto Label1
				case 2: goto Label2
				default: panic("unexpected function state")
				}
				// line 130: path = tempfile.mkdtemp()
				πF.SetLineno(130)
				if πTemp001, πE = πg.ResolveGlobal(πF, ßtempfile); πE != nil {
					continue
				}
				if πTemp002, πE = πg.GetAttr(πF, πTemp001, ßmkdtemp, nil); πE != nil {
					continue
				}
				if πTemp001, πE = πTemp002.Call(πF, nil, nil); πE != nil {
					continue
				}
				µpath = πTemp001
				// line 131: try:
				πF.SetLineno(131)
				πF.PushCheckpoint(1)
				// line 131: try:
				πF.SetLineno(131)
				πF.PushCheckpoint(2)
				// line 132: os.remove(path)
				πF.SetLineno(132)
				πTemp003 = πF.MakeArgs(1)
				if πE = πg.CheckLocal(πF, µpath, "path"); πE != nil {
					continue
				}
				πTemp003[0] = µpath
				if πTemp001, πE = πg.ResolveGlobal(πF, ßos); πE != nil {
					continue
				}
				if πTemp002, πE = πg.GetAttr(πF, πTemp001, ßremove, nil); πE != nil {
					continue
				}
				if πTemp001, πE = πTemp002.Call(πF, πTemp003, nil); πE != nil {
					continue
				}
				πF.FreeArgs(πTemp003)
				πF.PopCheckpoint()
				if πTemp001, πE = πg.ResolveGlobal(πF, ßAssertionError); πE != nil {
					continue
				}
				// line 136: raise AssertionError
				πF.SetLineno(136)
				πE = πF.Raise(πTemp001, nil, nil)
				continue
				goto Label3
			Label2:
				πTemp004, πTemp005 = πF.ExcInfo()
				if πTemp001, πE = πg.ResolveGlobal(πF, ßOSError); πE != nil {
					continue
				}
				if πTemp006, πE = πg.IsInstance(πF, πTemp004.ToObject(), πTemp001); πE != nil {
					continue
				}
				if πTemp006 {
					goto Label4
				}
				πE = πF.Raise(πTemp004.ToObject(), nil, πTemp005.ToObject())
				continue
				// line 133: except OSError:
				πF.SetLineno(133)
			Label4:
				// line 134: pass
				πF.SetLineno(134)
				πE = nil
				πF.RestoreExc(nil, nil)
				goto Label3
			Label3:
				πF.PopCheckpoint()
			Label1:
				πE = nil
				πTemp004, πTemp005 = πF.RestoreExc(nil, nil)
				// line 138: os.rmdir(path)
				πF.SetLineno(138)
				πTemp003 = πF.MakeArgs(1)
				if πE = πg.CheckLocal(πF, µpath, "path"); πE != nil {
					continue
				}
				πTemp003[0] = µpath
				if πTemp001, πE = πg.ResolveGlobal(πF, ßos); πE != nil {
					continue
				}
				if πTemp002, πE = πg.GetAttr(πF, πTemp001, ßrmdir, nil); πE != nil {
					continue
				}
				if πTemp001, πE = πTemp002.Call(πF, πTemp003, nil); πE != nil {
					continue
				}
				πF.FreeArgs(πTemp003)
				if πTemp004 != nil {
					πE = πF.Raise(πTemp004.ToObject(), nil, πTemp005.ToObject())
					continue
				}
				return nil, nil
			}
			return nil, πE
		}), πF.Globals()).ToObject()
		if πE = πF.Globals().SetItem(πF, ßTestRemoveDir.ToObject(), πTemp013); πE != nil {
			continue
		}
		// line 141: def TestRmDir():
		πF.SetLineno(141)
		πTemp003 = make([]πg.FunctionArg, 0)
		πTemp014 = πg.NewFunction(πg.NewCode("TestRmDir", "lib/os_test.py", πTemp003, 0, func(πF *πg.Frame, πArgs []*πg.Object) (*πg.Object, *πg.BaseException) {
			var µpath *πg.Object = πg.UnboundLocal; _ = µpath
			var πTemp001 *πg.Object
			_ = πTemp001
			var πTemp002 *πg.Object
			_ = πTemp002
			var πTemp003 []*πg.Object
			_ = πTemp003
			var πTemp004 []*πg.Object
			_ = πTemp004
			var πTemp005 *πg.BaseException
			_ = πTemp005
			var πTemp006 *πg.Traceback
			_ = πTemp006
			var πTemp007 bool
			_ = πTemp007
			var πE *πg.BaseException; _ = πE
			for ; πF.State() >= 0; πF.PopCheckpoint() {
				switch πF.State() {
				case 0:
				case 1: goto Label1
				default: panic("unexpected function state")
				}
				// line 142: path = tempfile.mkdtemp()
				πF.SetLineno(142)
				if πTemp001, πE = πg.ResolveGlobal(πF, ßtempfile); πE != nil {
					continue
				}
				if πTemp002, πE = πg.GetAttr(πF, πTemp001, ßmkdtemp, nil); πE != nil {
					continue
				}
				if πTemp001, πE = πTemp002.Call(πF, nil, nil); πE != nil {
					continue
				}
				µpath = πTemp001
				// line 143: assert stat.S_ISDIR(os.stat(path).st_mode)
				πF.SetLineno(143)
				πTemp003 = πF.MakeArgs(1)
				πTemp004 = πF.MakeArgs(1)
				if πE = πg.CheckLocal(πF, µpath, "path"); πE != nil {
					continue
				}
				πTemp004[0] = µpath
				if πTemp001, πE = πg.ResolveGlobal(πF, ßos); πE != nil {
					continue
				}
				if πTemp002, πE = πg.GetAttr(πF, πTemp001, ßstat, nil); πE != nil {
					continue
				}
				if πTemp001, πE = πTemp002.Call(πF, πTemp004, nil); πE != nil {
					continue
				}
				πF.FreeArgs(πTemp004)
				if πTemp002, πE = πg.GetAttr(πF, πTemp001, ßst_mode, nil); πE != nil {
					continue
				}
				πTemp003[0] = πTemp002
				if πTemp001, πE = πg.ResolveGlobal(πF, ßstat); πE != nil {
					continue
				}
				if πTemp002, πE = πg.GetAttr(πF, πTemp001, ßS_ISDIR, nil); πE != nil {
					continue
				}
				if πTemp001, πE = πTemp002.Call(πF, πTemp003, nil); πE != nil {
					continue
				}
				πF.FreeArgs(πTemp003)
				if πE = πg.Assert(πF, πTemp001, nil); πE != nil {
					continue
				}
				// line 144: os.rmdir(path)
				πF.SetLineno(144)
				πTemp003 = πF.MakeArgs(1)
				if πE = πg.CheckLocal(πF, µpath, "path"); πE != nil {
					continue
				}
				πTemp003[0] = µpath
				if πTemp001, πE = πg.ResolveGlobal(πF, ßos); πE != nil {
					continue
				}
				if πTemp002, πE = πg.GetAttr(πF, πTemp001, ßrmdir, nil); πE != nil {
					continue
				}
				if πTemp001, πE = πTemp002.Call(πF, πTemp003, nil); πE != nil {
					continue
				}
				πF.FreeArgs(πTemp003)
				// line 145: try:
				πF.SetLineno(145)
				πF.PushCheckpoint(1)
				// line 146: os.stat(path)
				πF.SetLineno(146)
				πTemp003 = πF.MakeArgs(1)
				if πE = πg.CheckLocal(πF, µpath, "path"); πE != nil {
					continue
				}
				πTemp003[0] = µpath
				if πTemp001, πE = πg.ResolveGlobal(πF, ßos); πE != nil {
					continue
				}
				if πTemp002, πE = πg.GetAttr(πF, πTemp001, ßstat, nil); πE != nil {
					continue
				}
				if πTemp001, πE = πTemp002.Call(πF, πTemp003, nil); πE != nil {
					continue
				}
				πF.FreeArgs(πTemp003)
				πF.PopCheckpoint()
				if πTemp001, πE = πg.ResolveGlobal(πF, ßAssertionError); πE != nil {
					continue
				}
				// line 150: raise AssertionError
				πF.SetLineno(150)
				πE = πF.Raise(πTemp001, nil, nil)
				continue
				goto Label2
			Label1:
				πTemp005, πTemp006 = πF.ExcInfo()
				if πTemp001, πE = πg.ResolveGlobal(πF, ßOSError); πE != nil {
					continue
				}
				if πTemp007, πE = πg.IsInstance(πF, πTemp005.ToObject(), πTemp001); πE != nil {
					continue
				}
				if πTemp007 {
					goto Label3
				}
				πE = πF.Raise(πTemp005.ToObject(), nil, πTemp006.ToObject())
				continue
				// line 147: except OSError:
				πF.SetLineno(147)
			Label3:
				// line 148: pass
				πF.SetLineno(148)
				πE = nil
				πF.RestoreExc(nil, nil)
				goto Label2
			Label2:
				return nil, nil
			}
			return nil, πE
		}), πF.Globals()).ToObject()
		if πE = πF.Globals().SetItem(πF, ßTestRmDir.ToObject(), πTemp014); πE != nil {
			continue
		}
		// line 153: def TestRmDirNoExist():
		πF.SetLineno(153)
		πTemp003 = make([]πg.FunctionArg, 0)
		πTemp015 = πg.NewFunction(πg.NewCode("TestRmDirNoExist", "lib/os_test.py", πTemp003, 0, func(πF *πg.Frame, πArgs []*πg.Object) (*πg.Object, *πg.BaseException) {
			var µpath *πg.Object = πg.UnboundLocal; _ = µpath
			var πTemp001 *πg.Object
			_ = πTemp001
			var πTemp002 *πg.Object
			_ = πTemp002
			var πTemp003 []*πg.Object
			_ = πTemp003
			var πTemp004 *πg.BaseException
			_ = πTemp004
			var πTemp005 *πg.Traceback
			_ = πTemp005
			var πTemp006 bool
			_ = πTemp006
			var πE *πg.BaseException; _ = πE
			for ; πF.State() >= 0; πF.PopCheckpoint() {
				switch πF.State() {
				case 0:
				case 1: goto Label1
				case 2: goto Label2
				default: panic("unexpected function state")
				}
				// line 154: path = tempfile.mkdtemp()
				πF.SetLineno(154)
				if πTemp001, πE = πg.ResolveGlobal(πF, ßtempfile); πE != nil {
					continue
				}
				if πTemp002, πE = πg.GetAttr(πF, πTemp001, ßmkdtemp, nil); πE != nil {
					continue
				}
				if πTemp001, πE = πTemp002.Call(πF, nil, nil); πE != nil {
					continue
				}
				µpath = πTemp001
				// line 155: try:
				πF.SetLineno(155)
				πF.PushCheckpoint(1)
				// line 155: try:
				πF.SetLineno(155)
				πF.PushCheckpoint(2)
				// line 156: os.rmdir(path + '/nonexistent')
				πF.SetLineno(156)
				πTemp003 = πF.MakeArgs(1)
				if πE = πg.CheckLocal(πF, µpath, "path"); πE != nil {
					continue
				}
				if πTemp001, πE = πg.Add(πF, µpath, πg.NewStr("/nonexistent").ToObject()); πE != nil {
					continue
				}
				πTemp003[0] = πTemp001
				if πTemp001, πE = πg.ResolveGlobal(πF, ßos); πE != nil {
					continue
				}
				if πTemp002, πE = πg.GetAttr(πF, πTemp001, ßrmdir, nil); πE != nil {
					continue
				}
				if πTemp001, πE = πTemp002.Call(πF, πTemp003, nil); πE != nil {
					continue
				}
				πF.FreeArgs(πTemp003)
				πF.PopCheckpoint()
				if πTemp001, πE = πg.ResolveGlobal(πF, ßAssertionError); πE != nil {
					continue
				}
				// line 160: raise AssertionError
				πF.SetLineno(160)
				πE = πF.Raise(πTemp001, nil, nil)
				continue
				goto Label3
			Label2:
				πTemp004, πTemp005 = πF.ExcInfo()
				if πTemp001, πE = πg.ResolveGlobal(πF, ßOSError); πE != nil {
					continue
				}
				if πTemp006, πE = πg.IsInstance(πF, πTemp004.ToObject(), πTemp001); πE != nil {
					continue
				}
				if πTemp006 {
					goto Label4
				}
				πE = πF.Raise(πTemp004.ToObject(), nil, πTemp005.ToObject())
				continue
				// line 157: except OSError:
				πF.SetLineno(157)
			Label4:
				// line 158: pass
				πF.SetLineno(158)
				πE = nil
				πF.RestoreExc(nil, nil)
				goto Label3
			Label3:
				πF.PopCheckpoint()
			Label1:
				πE = nil
				πTemp004, πTemp005 = πF.RestoreExc(nil, nil)
				// line 162: os.rmdir(path)
				πF.SetLineno(162)
				πTemp003 = πF.MakeArgs(1)
				if πE = πg.CheckLocal(πF, µpath, "path"); πE != nil {
					continue
				}
				πTemp003[0] = µpath
				if πTemp001, πE = πg.ResolveGlobal(πF, ßos); πE != nil {
					continue
				}
				if πTemp002, πE = πg.GetAttr(πF, πTemp001, ßrmdir, nil); πE != nil {
					continue
				}
				if πTemp001, πE = πTemp002.Call(πF, πTemp003, nil); πE != nil {
					continue
				}
				πF.FreeArgs(πTemp003)
				if πTemp004 != nil {
					πE = πF.Raise(πTemp004.ToObject(), nil, πTemp005.ToObject())
					continue
				}
				return nil, nil
			}
			return nil, πE
		}), πF.Globals()).ToObject()
		if πE = πF.Globals().SetItem(πF, ßTestRmDirNoExist.ToObject(), πTemp015); πE != nil {
			continue
		}
		// line 165: def TestRmDirFile():
		πF.SetLineno(165)
		πTemp003 = make([]πg.FunctionArg, 0)
		πTemp016 = πg.NewFunction(πg.NewCode("TestRmDirFile", "lib/os_test.py", πTemp003, 0, func(πF *πg.Frame, πArgs []*πg.Object) (*πg.Object, *πg.BaseException) {
			var µfd *πg.Object = πg.UnboundLocal; _ = µfd
			var µpath *πg.Object = πg.UnboundLocal; _ = µpath
			var πTemp001 *πg.Object
			_ = πTemp001
			var πTemp002 *πg.Object
			_ = πTemp002
			var πTemp003 *πg.Object
			_ = πTemp003
			var πTemp004 []*πg.Object
			_ = πTemp004
			var πTemp005 *πg.BaseException
			_ = πTemp005
			var πTemp006 *πg.Traceback
			_ = πTemp006
			var πTemp007 bool
			_ = πTemp007
			var πE *πg.BaseException; _ = πE
			for ; πF.State() >= 0; πF.PopCheckpoint() {
				switch πF.State() {
				case 0:
				case 1: goto Label1
				case 2: goto Label2
				default: panic("unexpected function state")
				}
				// line 166: fd, path = tempfile.mkstemp()
				πF.SetLineno(166)
				if πTemp001, πE = πg.ResolveGlobal(πF, ßtempfile); πE != nil {
					continue
				}
				if πTemp002, πE = πg.GetAttr(πF, πTemp001, ßmkstemp, nil); πE != nil {
					continue
				}
				if πTemp001, πE = πTemp002.Call(πF, nil, nil); πE != nil {
					continue
				}
				if πE = πg.Tie(πF, πg.TieTarget{Children: []πg.TieTarget{πg.TieTarget{Target: &πTemp002}, πg.TieTarget{Target: &πTemp003}}}, πTemp001); πE != nil {
					continue
				}
				µfd = πTemp002
				µpath = πTemp003
				// line 167: os.close(fd)
				πF.SetLineno(167)
				πTemp004 = πF.MakeArgs(1)
				if πE = πg.CheckLocal(πF, µfd, "fd"); πE != nil {
					continue
				}
				πTemp004[0] = µfd
				if πTemp001, πE = πg.ResolveGlobal(πF, ßos); πE != nil {
					continue
				}
				if πTemp002, πE = πg.GetAttr(πF, πTemp001, ßclose, nil); πE != nil {
					continue
				}
				if πTemp001, πE = πTemp002.Call(πF, πTemp004, nil); πE != nil {
					continue
				}
				πF.FreeArgs(πTemp004)
				// line 168: try:
				πF.SetLineno(168)
				πF.PushCheckpoint(1)
				// line 168: try:
				πF.SetLineno(168)
				πF.PushCheckpoint(2)
				// line 169: os.rmdir(path)
				πF.SetLineno(169)
				πTemp004 = πF.MakeArgs(1)
				if πE = πg.CheckLocal(πF, µpath, "path"); πE != nil {
					continue
				}
				πTemp004[0] = µpath
				if πTemp001, πE = πg.ResolveGlobal(πF, ßos); πE != nil {
					continue
				}
				if πTemp002, πE = πg.GetAttr(πF, πTemp001, ßrmdir, nil); πE != nil {
					continue
				}
				if πTemp001, πE = πTemp002.Call(πF, πTemp004, nil); πE != nil {
					continue
				}
				πF.FreeArgs(πTemp004)
				πF.PopCheckpoint()
				if πTemp001, πE = πg.ResolveGlobal(πF, ßAssertionError); πE != nil {
					continue
				}
				// line 173: raise AssertionError
				πF.SetLineno(173)
				πE = πF.Raise(πTemp001, nil, nil)
				continue
				goto Label3
			Label2:
				πTemp005, πTemp006 = πF.ExcInfo()
				if πTemp001, πE = πg.ResolveGlobal(πF, ßOSError); πE != nil {
					continue
				}
				if πTemp007, πE = πg.IsInstance(πF, πTemp005.ToObject(), πTemp001); πE != nil {
					continue
				}
				if πTemp007 {
					goto Label4
				}
				πE = πF.Raise(πTemp005.ToObject(), nil, πTemp006.ToObject())
				continue
				// line 170: except OSError:
				πF.SetLineno(170)
			Label4:
				// line 171: pass
				πF.SetLineno(171)
				πE = nil
				πF.RestoreExc(nil, nil)
				goto Label3
			Label3:
				πF.PopCheckpoint()
			Label1:
				πE = nil
				πTemp005, πTemp006 = πF.RestoreExc(nil, nil)
				// line 175: os.remove(path)
				πF.SetLineno(175)
				πTemp004 = πF.MakeArgs(1)
				if πE = πg.CheckLocal(πF, µpath, "path"); πE != nil {
					continue
				}
				πTemp004[0] = µpath
				if πTemp001, πE = πg.ResolveGlobal(πF, ßos); πE != nil {
					continue
				}
				if πTemp002, πE = πg.GetAttr(πF, πTemp001, ßremove, nil); πE != nil {
					continue
				}
				if πTemp001, πE = πTemp002.Call(πF, πTemp004, nil); πE != nil {
					continue
				}
				πF.FreeArgs(πTemp004)
				if πTemp005 != nil {
					πE = πF.Raise(πTemp005.ToObject(), nil, πTemp006.ToObject())
					continue
				}
				return nil, nil
			}
			return nil, πE
		}), πF.Globals()).ToObject()
		if πE = πF.Globals().SetItem(πF, ßTestRmDirFile.ToObject(), πTemp016); πE != nil {
			continue
		}
		// line 178: def TestStatFile():
		πF.SetLineno(178)
		πTemp003 = make([]πg.FunctionArg, 0)
		πTemp017 = πg.NewFunction(πg.NewCode("TestStatFile", "lib/os_test.py", πTemp003, 0, func(πF *πg.Frame, πArgs []*πg.Object) (*πg.Object, *πg.BaseException) {
			var µt *πg.Object = πg.UnboundLocal; _ = µt
			var µfd *πg.Object = πg.UnboundLocal; _ = µfd
			var µpath *πg.Object = πg.UnboundLocal; _ = µpath
			var µst *πg.Object = πg.UnboundLocal; _ = µst
			var πTemp001 *πg.Object
			_ = πTemp001
			var πTemp002 *πg.Object
			_ = πTemp002
			var πTemp003 *πg.Object
			_ = πTemp003
			var πTemp004 []*πg.Object
			_ = πTemp004
			var πTemp005 bool
			_ = πTemp005
			var πE *πg.BaseException; _ = πE
			for ; πF.State() >= 0; πF.PopCheckpoint() {
				switch πF.State() {
				case 0:
				default: panic("unexpected function state")
				}
				// line 179: t = time.time()
				πF.SetLineno(179)
				if πTemp001, πE = πg.ResolveGlobal(πF, ßtime); πE != nil {
					continue
				}
				if πTemp002, πE = πg.GetAttr(πF, πTemp001, ßtime, nil); πE != nil {
					continue
				}
				if πTemp001, πE = πTemp002.Call(πF, nil, nil); πE != nil {
					continue
				}
				µt = πTemp001
				// line 180: fd, path = tempfile.mkstemp()
				πF.SetLineno(180)
				if πTemp001, πE = πg.ResolveGlobal(πF, ßtempfile); πE != nil {
					continue
				}
				if πTemp002, πE = πg.GetAttr(πF, πTemp001, ßmkstemp, nil); πE != nil {
					continue
				}
				if πTemp001, πE = πTemp002.Call(πF, nil, nil); πE != nil {
					continue
				}
				if πE = πg.Tie(πF, πg.TieTarget{Children: []πg.TieTarget{πg.TieTarget{Target: &πTemp002}, πg.TieTarget{Target: &πTemp003}}}, πTemp001); πE != nil {
					continue
				}
				µfd = πTemp002
				µpath = πTemp003
				// line 181: os.close(fd)
				πF.SetLineno(181)
				πTemp004 = πF.MakeArgs(1)
				if πE = πg.CheckLocal(πF, µfd, "fd"); πE != nil {
					continue
				}
				πTemp004[0] = µfd
				if πTemp001, πE = πg.ResolveGlobal(πF, ßos); πE != nil {
					continue
				}
				if πTemp002, πE = πg.GetAttr(πF, πTemp001, ßclose, nil); πE != nil {
					continue
				}
				if πTemp001, πE = πTemp002.Call(πF, πTemp004, nil); πE != nil {
					continue
				}
				πF.FreeArgs(πTemp004)
				// line 182: st = os.stat(path)
				πF.SetLineno(182)
				πTemp004 = πF.MakeArgs(1)
				if πE = πg.CheckLocal(πF, µpath, "path"); πE != nil {
					continue
				}
				πTemp004[0] = µpath
				if πTemp001, πE = πg.ResolveGlobal(πF, ßos); πE != nil {
					continue
				}
				if πTemp002, πE = πg.GetAttr(πF, πTemp001, ßstat, nil); πE != nil {
					continue
				}
				if πTemp001, πE = πTemp002.Call(πF, πTemp004, nil); πE != nil {
					continue
				}
				πF.FreeArgs(πTemp004)
				µst = πTemp001
				// line 183: os.remove(path)
				πF.SetLineno(183)
				πTemp004 = πF.MakeArgs(1)
				if πE = πg.CheckLocal(πF, µpath, "path"); πE != nil {
					continue
				}
				πTemp004[0] = µpath
				if πTemp001, πE = πg.ResolveGlobal(πF, ßos); πE != nil {
					continue
				}
				if πTemp002, πE = πg.GetAttr(πF, πTemp001, ßremove, nil); πE != nil {
					continue
				}
				if πTemp001, πE = πTemp002.Call(πF, πTemp004, nil); πE != nil {
					continue
				}
				πF.FreeArgs(πTemp004)
				// line 184: assert not stat.S_ISDIR(st.st_mode)
				πF.SetLineno(184)
				πTemp004 = πF.MakeArgs(1)
				if πE = πg.CheckLocal(πF, µst, "st"); πE != nil {
					continue
				}
				if πTemp002, πE = πg.GetAttr(πF, µst, ßst_mode, nil); πE != nil {
					continue
				}
				πTemp004[0] = πTemp002
				if πTemp002, πE = πg.ResolveGlobal(πF, ßstat); πE != nil {
					continue
				}
				if πTemp003, πE = πg.GetAttr(πF, πTemp002, ßS_ISDIR, nil); πE != nil {
					continue
				}
				if πTemp002, πE = πTemp003.Call(πF, πTemp004, nil); πE != nil {
					continue
				}
				πF.FreeArgs(πTemp004)
				if πTemp005, πE = πg.IsTrue(πF, πTemp002); πE != nil {
					continue
				}
				πTemp001 = πg.GetBool(!πTemp005).ToObject()
				if πE = πg.Assert(πF, πTemp001, nil); πE != nil {
					continue
				}
				// line 185: assert stat.S_IMODE(st.st_mode) == 0o600
				πF.SetLineno(185)
				πTemp004 = πF.MakeArgs(1)
				if πE = πg.CheckLocal(πF, µst, "st"); πE != nil {
					continue
				}
				if πTemp002, πE = πg.GetAttr(πF, µst, ßst_mode, nil); πE != nil {
					continue
				}
				πTemp004[0] = πTemp002
				if πTemp002, πE = πg.ResolveGlobal(πF, ßstat); πE != nil {
					continue
				}
				if πTemp003, πE = πg.GetAttr(πF, πTemp002, ßS_IMODE, nil); πE != nil {
					continue
				}
				if πTemp002, πE = πTemp003.Call(πF, πTemp004, nil); πE != nil {
					continue
				}
				πF.FreeArgs(πTemp004)
				if πTemp001, πE = πg.Eq(πF, πTemp002, πg.NewInt(384).ToObject()); πE != nil {
					continue
				}
				if πE = πg.Assert(πF, πTemp001, nil); πE != nil {
					continue
				}
				// line 187: assert st.st_mtime + 10 > t
				πF.SetLineno(187)
				if πE = πg.CheckLocal(πF, µst, "st"); πE != nil {
					continue
				}
				if πTemp003, πE = πg.GetAttr(πF, µst, ßst_mtime, nil); πE != nil {
					continue
				}
				if πTemp002, πE = πg.Add(πF, πTemp003, πg.NewInt(10).ToObject()); πE != nil {
					continue
				}
				if πE = πg.CheckLocal(πF, µt, "t"); πE != nil {
					continue
				}
				if πTemp001, πE = πg.GT(πF, πTemp002, µt); πE != nil {
					continue
				}
				if πE = πg.Assert(πF, πTemp001, nil); πE != nil {
					continue
				}
				// line 188: assert st.st_size == 0
				πF.SetLineno(188)
				if πE = πg.CheckLocal(πF, µst, "st"); πE != nil {
					continue
				}
				if πTemp002, πE = πg.GetAttr(πF, µst, ßst_size, nil); πE != nil {
					continue
				}
				if πTemp001, πE = πg.Eq(πF, πTemp002, πg.NewInt(0).ToObject()); πE != nil {
					continue
				}
				if πE = πg.Assert(πF, πTemp001, nil); πE != nil {
					continue
				}
				return nil, nil
			}
			return nil, πE
		}), πF.Globals()).ToObject()
		if πE = πF.Globals().SetItem(πF, ßTestStatFile.ToObject(), πTemp017); πE != nil {
			continue
		}
		// line 191: def TestStatDir():
		πF.SetLineno(191)
		πTemp003 = make([]πg.FunctionArg, 0)
		πTemp018 = πg.NewFunction(πg.NewCode("TestStatDir", "lib/os_test.py", πTemp003, 0, func(πF *πg.Frame, πArgs []*πg.Object) (*πg.Object, *πg.BaseException) {
			var µpath *πg.Object = πg.UnboundLocal; _ = µpath
			var µmode *πg.Object = πg.UnboundLocal; _ = µmode
			var πTemp001 *πg.Object
			_ = πTemp001
			var πTemp002 *πg.Object
			_ = πTemp002
			var πTemp003 []*πg.Object
			_ = πTemp003
			var πTemp004 *πg.Object
			_ = πTemp004
			var πE *πg.BaseException; _ = πE
			for ; πF.State() >= 0; πF.PopCheckpoint() {
				switch πF.State() {
				case 0:
				default: panic("unexpected function state")
				}
				// line 192: path = tempfile.mkdtemp()
				πF.SetLineno(192)
				if πTemp001, πE = πg.ResolveGlobal(πF, ßtempfile); πE != nil {
					continue
				}
				if πTemp002, πE = πg.GetAttr(πF, πTemp001, ßmkdtemp, nil); πE != nil {
					continue
				}
				if πTemp001, πE = πTemp002.Call(πF, nil, nil); πE != nil {
					continue
				}
				µpath = πTemp001
				// line 193: mode = os.stat(path).st_mode
				πF.SetLineno(193)
				πTemp003 = πF.MakeArgs(1)
				if πE = πg.CheckLocal(πF, µpath, "path"); πE != nil {
					continue
				}
				πTemp003[0] = µpath
				if πTemp001, πE = πg.ResolveGlobal(πF, ßos); πE != nil {
					continue
				}
				if πTemp002, πE = πg.GetAttr(πF, πTemp001, ßstat, nil); πE != nil {
					continue
				}
				if πTemp001, πE = πTemp002.Call(πF, πTemp003, nil); πE != nil {
					continue
				}
				πF.FreeArgs(πTemp003)
				if πTemp002, πE = πg.GetAttr(πF, πTemp001, ßst_mode, nil); πE != nil {
					continue
				}
				µmode = πTemp002
				// line 194: os.rmdir(path)
				πF.SetLineno(194)
				πTemp003 = πF.MakeArgs(1)
				if πE = πg.CheckLocal(πF, µpath, "path"); πE != nil {
					continue
				}
				πTemp003[0] = µpath
				if πTemp001, πE = πg.ResolveGlobal(πF, ßos); πE != nil {
					continue
				}
				if πTemp002, πE = πg.GetAttr(πF, πTemp001, ßrmdir, nil); πE != nil {
					continue
				}
				if πTemp001, πE = πTemp002.Call(πF, πTemp003, nil); πE != nil {
					continue
				}
				πF.FreeArgs(πTemp003)
				// line 195: assert stat.S_ISDIR(mode)
				πF.SetLineno(195)
				πTemp003 = πF.MakeArgs(1)
				if πE = πg.CheckLocal(πF, µmode, "mode"); πE != nil {
					continue
				}
				πTemp003[0] = µmode
				if πTemp001, πE = πg.ResolveGlobal(πF, ßstat); πE != nil {
					continue
				}
				if πTemp002, πE = πg.GetAttr(πF, πTemp001, ßS_ISDIR, nil); πE != nil {
					continue
				}
				if πTemp001, πE = πTemp002.Call(πF, πTemp003, nil); πE != nil {
					continue
				}
				πF.FreeArgs(πTemp003)
				if πE = πg.Assert(πF, πTemp001, nil); πE != nil {
					continue
				}
				// line 196: assert stat.S_IMODE(mode) == 0o700
				πF.SetLineno(196)
				πTemp003 = πF.MakeArgs(1)
				if πE = πg.CheckLocal(πF, µmode, "mode"); πE != nil {
					continue
				}
				πTemp003[0] = µmode
				if πTemp002, πE = πg.ResolveGlobal(πF, ßstat); πE != nil {
					continue
				}
				if πTemp004, πE = πg.GetAttr(πF, πTemp002, ßS_IMODE, nil); πE != nil {
					continue
				}
				if πTemp002, πE = πTemp004.Call(πF, πTemp003, nil); πE != nil {
					continue
				}
				πF.FreeArgs(πTemp003)
				if πTemp001, πE = πg.Eq(πF, πTemp002, πg.NewInt(448).ToObject()); πE != nil {
					continue
				}
				if πE = πg.Assert(πF, πTemp001, nil); πE != nil {
					continue
				}
				return nil, nil
			}
			return nil, πE
		}), πF.Globals()).ToObject()
		if πE = πF.Globals().SetItem(πF, ßTestStatDir.ToObject(), πTemp018); πE != nil {
			continue
		}
		// line 199: def TestStatNoExist():
		πF.SetLineno(199)
		πTemp003 = make([]πg.FunctionArg, 0)
		πTemp019 = πg.NewFunction(πg.NewCode("TestStatNoExist", "lib/os_test.py", πTemp003, 0, func(πF *πg.Frame, πArgs []*πg.Object) (*πg.Object, *πg.BaseException) {
			var µpath *πg.Object = πg.UnboundLocal; _ = µpath
			var πTemp001 *πg.Object
			_ = πTemp001
			var πTemp002 *πg.Object
			_ = πTemp002
			var πTemp003 []*πg.Object
			_ = πTemp003
			var πTemp004 *πg.BaseException
			_ = πTemp004
			var πTemp005 *πg.Traceback
			_ = πTemp005
			var πTemp006 bool
			_ = πTemp006
			var πE *πg.BaseException; _ = πE
			for ; πF.State() >= 0; πF.PopCheckpoint() {
				switch πF.State() {
				case 0:
				case 1: goto Label1
				case 2: goto Label2
				default: panic("unexpected function state")
				}
				// line 200: path = tempfile.mkdtemp()
				πF.SetLineno(200)
				if πTemp001, πE = πg.ResolveGlobal(πF, ßtempfile); πE != nil {
					continue
				}
				if πTemp002, πE = πg.GetAttr(πF, πTemp001, ßmkdtemp, nil); πE != nil {
					continue
				}
				if πTemp001, πE = πTemp002.Call(πF, nil, nil); πE != nil {
					continue
				}
				µpath = πTemp001
				// line 201: try:
				πF.SetLineno(201)
				πF.PushCheckpoint(1)
				// line 201: try:
				πF.SetLineno(201)
				πF.PushCheckpoint(2)
				// line 202: os.stat(path + '/nonexistent')
				πF.SetLineno(202)
				πTemp003 = πF.MakeArgs(1)
				if πE = πg.CheckLocal(πF, µpath, "path"); πE != nil {
					continue
				}
				if πTemp001, πE = πg.Add(πF, µpath, πg.NewStr("/nonexistent").ToObject()); πE != nil {
					continue
				}
				πTemp003[0] = πTemp001
				if πTemp001, πE = πg.ResolveGlobal(πF, ßos); πE != nil {
					continue
				}
				if πTemp002, πE = πg.GetAttr(πF, πTemp001, ßstat, nil); πE != nil {
					continue
				}
				if πTemp001, πE = πTemp002.Call(πF, πTemp003, nil); πE != nil {
					continue
				}
				πF.FreeArgs(πTemp003)
				πF.PopCheckpoint()
				if πTemp001, πE = πg.ResolveGlobal(πF, ßAssertionError); πE != nil {
					continue
				}
				// line 206: raise AssertionError
				πF.SetLineno(206)
				πE = πF.Raise(πTemp001, nil, nil)
				continue
				goto Label3
			Label2:
				πTemp004, πTemp005 = πF.ExcInfo()
				if πTemp001, πE = πg.ResolveGlobal(πF, ßOSError); πE != nil {
					continue
				}
				if πTemp006, πE = πg.IsInstance(πF, πTemp004.ToObject(), πTemp001); πE != nil {
					continue
				}
				if πTemp006 {
					goto Label4
				}
				πE = πF.Raise(πTemp004.ToObject(), nil, πTemp005.ToObject())
				continue
				// line 203: except OSError:
				πF.SetLineno(203)
			Label4:
				// line 204: pass
				πF.SetLineno(204)
				πE = nil
				πF.RestoreExc(nil, nil)
				goto Label3
			Label3:
				πF.PopCheckpoint()
			Label1:
				πE = nil
				πTemp004, πTemp005 = πF.RestoreExc(nil, nil)
				// line 208: os.rmdir(path)
				πF.SetLineno(208)
				πTemp003 = πF.MakeArgs(1)
				if πE = πg.CheckLocal(πF, µpath, "path"); πE != nil {
					continue
				}
				πTemp003[0] = µpath
				if πTemp001, πE = πg.ResolveGlobal(πF, ßos); πE != nil {
					continue
				}
				if πTemp002, πE = πg.GetAttr(πF, πTemp001, ßrmdir, nil); πE != nil {
					continue
				}
				if πTemp001, πE = πTemp002.Call(πF, πTemp003, nil); πE != nil {
					continue
				}
				πF.FreeArgs(πTemp003)
				if πTemp004 != nil {
					πE = πF.Raise(πTemp004.ToObject(), nil, πTemp005.ToObject())
					continue
				}
				return nil, nil
			}
			return nil, πE
		}), πF.Globals()).ToObject()
		if πE = πF.Globals().SetItem(πF, ßTestStatNoExist.ToObject(), πTemp019); πE != nil {
			continue
		}
		if πTemp021, πE = πg.ResolveGlobal(πF, ß__name__); πE != nil {
			continue
		}
		if πTemp020, πE = πg.Eq(πF, πTemp021, ß__main__.ToObject()); πE != nil {
			continue
		}
		if πTemp022, πE = πg.IsTrue(πF, πTemp020); πE != nil {
			return nil, πE
		}
		if πTemp022 {
			goto Label1
		}
		goto Label2
		// line 211: if __name__ == '__main__':
		πF.SetLineno(211)
	Label1:
		// line 212: weetest.RunTests()
		πF.SetLineno(212)
		if πTemp020, πE = πg.ResolveGlobal(πF, ßweetest); πE != nil {
			continue
		}
		if πTemp021, πE = πg.GetAttr(πF, πTemp020, ßRunTests, nil); πE != nil {
			continue
		}
		if πTemp020, πE = πTemp021.Call(πF, nil, nil); πE != nil {
			continue
		}
		goto Label2
	Label2:
		return nil, nil
	}
	return nil, πE
}
var Code *πg.Code
func init() {
	Code = πg.NewCode("<module>", "lib/os_test.py", nil, 0, initModule)
}
